/*************************************************************************/
/* This is a small example program that uses the UART lib to communicate */
/* with my modem on COM4. Use two computers and this small program for a */
/* small talk via a null-modem cable (define CREXPAND then).             */
/*************************************************************************/

/* NON_INTERRUPT VERSION */
/* Please note the low bps rate I've chosen! It doesn't work at 57600 bps
	on my 486DX33! That's why you shouldn't use this style of UART service
	except if you know what you're doing... Even at 9600 bps I'm losing
	characters during screen scroll. */

#include <stdio.h>
#include <conio.h>
#include <uart.h>

#define BASE 	BASE_COM4	/* whatever you like ... */
#define RATE   BPS_9600		/* dito */
#define LINE	(LP_8BITS|LP_NO_PARITY|LP_1STOP)

#undef CREXPAND				/* define this if you want CRs to be expanded */


void main()
{
	int x;

	uart_set_bps_rate(BASE,RATE);
	uart_set_line_params(BASE,LINE);

	while (1) {
		if (kbhit()) {
			x=getch();
			if (x==27) break;
#ifdef CREXPAND
			if (x==0xd) {
				uart_poll_send_byte(BASE,0xd);
				uart_poll_send_byte(BASE,0xa);
				}
			else
#endif
				uart_poll_send_byte(BASE,x);
			}
		while (1) {
			x=uart_poll_receive_byte(BASE);
			if (x==UE_ERROR) break;
			putchar(x);
			}
		}
}

