% Libreboot 10-year anniversary and history
% Leah Rowe
% 12 December 2023

I'm very proud of the work done in Libreboot, both by myself and by others
who I work with. Many people make Libreboot possible, be it direct contributors
to the project, or the countless individuals and companies that work on all
the upstream projects used in Libreboot, projects like coreboot. I'm *very*
pleased now to announce the 10-year anniversary of the project.

I've decided to celebrate this event, by reflecting on the history of the
project during all these years. This article will go into depth about Libreboot
history. This article complements the pre-existing [contrib](../contrib.md)
page, which attempts to list the numerous contributions made by people to
Libreboot, over the years.

Ten years of Free Software
-----------------------

The *Libreboot* project provides
[free, open source](https://writefreesoftware.org/) (*libre*) boot
firmware based on coreboot, replacing proprietary BIOS/UEFI firmware
on [specific Intel/AMD x86 and ARM based motherboards](../docs/install/),
including laptop and desktop computers. It initialises the hardware (e.g. memory
controller, CPU, peripherals) and starts a bootloader for your operating
system. [Linux](../docs/linux/) and [BSD](../docs/bsd/) are well-supported. The
goal of Libreboot is to provide well-tested binary releases of coreboot, along
with a fully automated build system, so as to make coreboot *easy to use* for
non-technical users, who believe in the principles of the [Free
Software](https://writefreesoftware.org/) movement - Libreboot is also more
secure and generally works more reliably than most vendor firmware.

As of today, Libreboot is 10 years old. The very first release was
Libreboot 20131212, released on 12 December 2013, and today
is 12 December 2023, exactly 10 years after that first release.

I actually wasn't sure what to do for this day, and I contemplated doing
nothing at all. In the end, I've decided to simply acknowledge it, and
reflect on the last 10 years of history. So, I spent all of today writing this
article, which is being published just before midnight, in the final hour
of 12 December 2023, relative to UK timezone which is (on this day) UTC+0000.

You can otherwise read the Libreboot git repositories, the contrib page, and
you can find historical articles all over the internet pertaining to the
subject. This article, that you are reading now, is written solely from my
own perspective, through my eyes, describing project history the way I see it,
since I've been here all this time.

Let's get started!

How did Libreboot start?
------------------

### *Why* did it start?

I'm a free software activist. First and foremost, my focus is on using as much
Free Software *myself*, and I want to help other people achieve a level of
software freedom themselves. Many people reading this article today will know
that Libreboot no longer strictly aligns to FSF policy, but I still very much
believe in the ideology behind it. I merely apply it in different, more
[pragmatic](policy.md) ways - but this page is about the history of the project,
so I have to put myself in the headspace I was in, during each development year
relative to when Libreboot started. Libreboot originally started very much as
an FSF-endorsed project, created specifically for the purpose of adhering to
their standards.

### Early history

The name *Libreboot* actually existed from about February 2014 onward.
The *libreboot.org* domain name was registered on 26 January 2014. I initially
started Libreboot as a commercial project, then unnamed, hosted on my company
website (nowadays called [Minifree Ltd](https://minifree.org/)). I sell
computers with Libreboot preinstalled, but I started providing coreboot-based
services in mid-2013. People started noticing what I was doing around August
or so, in 2013. Back then, Libreboot did not exist, not even anything that I
later referred to as Libreboot, I just provided coreboot pre-compiled
and pre-flashed.

One of the people who noticed me, reported my company to the Free Software
Foundation who were, at that time, interested in providing a Libreboot-like
project. They approached *me*, asking if I'd like my company to be promoted,
if I complied with certain policies of theirs. Long story short, I was interested
and turned my work into a formalised project. I still remember who told the
FSF, but I won't say his name, for the sake of his privacy. It was Joshua Gay,
FSF's licensing and compliance manager, who initially contacted me, expressing
his own excitement about the prospect. Joshua is the one who initially reviewed
Libreboot for compliance, and worked with me on getting Minifree products to be
RYF-endorsed; RYF is the FSF's certification program, for companies selling
free software oriented hardware. Joshua also taught me a *lot* about licensing,
especially the pitfalls of the GPL when it comes to compliance. He taught me
what to watch out for. Many of Libreboot's practises today are still inspired
by his initial guidance, for which I remain grateful; he was an excellent
teacher.

When I first started this work, coreboot had already existed for 14 years,
having been founded in the year 1999 as LinuxBIOS, renaming to coreboot in
the mid-2000s. However, coreboot wasn't (and still isn't) made for end users.
Coreboot's infrastructure is intended for use by other developers, who work on
boot firmware. Nothing user-friendly (for regular non-technical users) existed.

When Libreboot started, the first goal was to solve *this* problem. Libreboot's
mission today is exactly the same as it was then: to provide free boot firmware
that normal people can easily use. Something that normal users don't have to
think about, that *Just Works*, with regular updates. Clean, simple
and professional, with clear documentation. Coreboot documentation today is
much better, but it was very poor quality in 2013 (MediaWiki site with lots
of errant pages, poorly organised).

It came with a twist: Libreboot initially only permitted libre code. Under this
policy, no binary blobs are allowed. I believed in it then, because in practise
it seemed like a good idea and didn't do any harm. It would later become a
liability, for reasons laid out in Libreboot's modern [Binary Blob Reduction
Policy](policy.md) - a policy that was enacted during November 2022, in the
Libreboot project. This meant that Libreboot could only support a small subset
of hardware from coreboot because, although it is nominally a free software
project, coreboot does require binary blobs on some boards. More on this later!

Since the project was nameless until February 2014, early promotion of my work
was talking only about my company and about the FSF endorsement of it; Minifree
used to be called Gluglug, hosted at `gluglug.org.uk` (you can check it
in the Wayback Machine. The shop itself was on `shop.gluglug.org.uk`). For
example, [this video](https://www.youtube.com/watch?v=08HKcH2GguE&t=1565s)
talked about the ThinkPad X60 running Libreboot 20131212, but I only
retroactively named that to Libreboot in February 2014, so that video is
talking about my company, which is where you could download my source tarballs
at the time.

2013-2014: early days
--------------------

When Libreboot first started, it *only* provided very basic releases: pre
compiled ROM images, with source code, but there was no automated build system.
The [build system](../docs/maintain/) evolved over time.

The first releases of Libreboot supported only the ThinkPad X60. Later, T60
support and MacBook 2,1 support were added. This first year of the project
was spent on building solid infrastructure, specifically documentation and an
automated build system. The design of Libreboot revolves around scripts that
automatically download, patch, configure and then compile various codebases,
so you can think of it like a *[coreboot distribution](../docs/maintain/)*;
Libreboot's build
system is essentially a source-based package manager, for coreboot components.

The very first Libreboot releases only provided a *GRUB* bootloader payload. The
GRUB bootloader had been adapted for coreboot many years before then, but there
weren't any ready-made coreboot images available that used it, and it wasn't
very well-developed for end users. GRUB is a lot more complex than many people
realise, containing a small kernel, shell, utilities, even its own subset of a
standard libc. It even has its own malloc functions, and it's quite decent. Then
there are *modules*, basically small programs that run inside GRUB. The GRUB
shell even has things like `cat` and `ls`, adapted for it. GRUB configuration
files behave similarly to BASH scripts, with similar syntax and overall logic
flow/style. It is an extremely configurable bootloader.

GRUB revolves around the shell, which is basically an extension of the Bash
shell, adapted for use in a Multiboot context. GRUB is the reference Multiboot
implementation, which boots Linux. Libreboot provides GRUB so that it can
directly boot Linux kernels. GRUB has many advanced features, such as GPG and
LUKS support, and it has support for virtually all of the major file systems in
use today.

### Libreboot logo

Marcus Moeller designed the Libreboot logo in 2014, after I publicly requested
that samples be prepared for my review. Marcus's logo was the one I chose.

### Why GRUB?

Libreboot has always, at least on x86, preferred *GRUB* as a coreboot payload.

Libreboot's initial no-binary-blob policy meant that SeaBIOS could not be used.
SeaBIOS then was the most popular payload, and the default one in coreboot, at
least on x86. Although SeaBIOS is free software, it did not have a free video
BIOS back then. Coreboot's native video initialisation was developed at around
that time, for Intel video chipsets, providing a basic framebuffer, but no
video BIOS services, so operating systems like Windows could not boot (and they
still cannot, on most Libreboot setups).

Nowadays, SeaBIOS comes with a feature called SeaVGABIOS, which piggybacks off
of the coreboot framebuffer, providing a basic video BIOS and initialisation
on top of the coreboot framebuffer, but this capability did not exist
in 2013 when Libreboot started. So, SeaBIOS could not be used in Libreboot
then. Libreboot provided just the coreboot framebuffer, then loaded GRUB, which
then loaded Linux; Linux itself could interact with the coreboot framebuffer,
and the Intel video driver (`i915`) sets modes directly, so it doesn't need
BIOS INT10H or UEFI GOP services for video-related functions. In Linux, your
video drivers just write to a framebuffer directly in memory. No abstractions.
This feature, called KMS (Kernel Mode Setting) was later ported to the BSDs,
first made stable in 2016; that means, that when Libreboot first started, it
could only boot Linux.

Linux as a payload wasn't very well developed in practise, even though Linux
in flash was the original aim of the coreboot project, and the systems that
Libreboot supported in 2013 only had 2MB of flash, which could not fit Linux;
the Heads project did not exist either! However, GRUB could (and still can) fit
in such a tiny space. In fact, even to this day, a compressed GRUB payload
can be optimised to fit within 512KB, though the Libreboot version adds a few
additional modules so the compressed size in flash is about 600KB (at least for
configurations that were provided on 12 December 2023).

Tianocore did exist then, but Tianocore is bloat. It has always been policy not
to provide Tianocore, because of this. Code==bugs, and Tianocore is
extremely over-engineered; the UEFI specification is completely redundant,
because BSD and Linux kernels run on bare metal anyway (without making use of
any BIOS or UEFI services). Linux/BSD video drivers set modes directly, without
needing to use BIOS/UEFI-based services e.g. BIOS INT10H or UEFI GOP.

Other payloads weren't really suitable either, so: Libreboot provided GRUB
right from the start. GRUB provides a special build target for coreboot, where
GRUB provides all of its own drivers and runs on the bare metal, without relying
on abstractions such as BIOS or UEFI.

*GRUB* wasn't very useable either. Back then, it was basically assumed that if
you used the GRUB payload, you just had to reconfigure it in flash, every time
you wanted to boot another Linux distro, or otherwise manually boot from the
GRUB shell. This was in fact how GRUB was used. However, GRUB otherwise worked
perfectly, and had (still has) support for the coreboot framebuffer, and text
mode. It is the preferred payload, for our purposes. It was there and just
worked. Libreboot then spent a lot of time tweaking GRUB, configuring it so
that it is as user-friendly as possible, roughly matching the user experience
that is found on most BIOS/UEFI systems, at least for booting Linux and BSD.

Libreboot's innovation was that it made GRUB *user-friendly* as a payload.
Over time, GRUB was configured in clever ways. These days, Libreboot's GRUB
is well-configured and can auto-boot almost any Linux distribution. The way
it works is by systematically scanning for GRUB configurations on many different
partition layouts, including encrypted (LUKS), to then load a GRUB config
provided by the installed distro. GRUB also has a parser in it, that lets you
show ISOLINUX/SYSLINUX menus, converted on the fly for use with GRUB.
Nowadays, many UEFI-based distros also provide GRUB on installation media,
which means that many Linux distro installers come with GRUB, making
installers even easier to boot from Libreboot.

Libreboot's GRUB configuration is unique. Even with coreboot's earlier work,
nothing quite like Libreboot's GRUB config exists that pre-dated it. The way
Libreboot configures GRUB is extremely unique. Several other projects now exist
inspired by it, such as [Canoeboot](https://canoeboot.org/). GRUB also has
several flaws, but it mostly *Just Works*. Libreboot made it work *well*, for
the casual coreboot user.

With the Libreboot version of GRUB, you can normally use it intuitively, where
most users who are used to UEFI/BIOS systems can just use the GRUB payload,
without knowing much about it. In fact, many users are (to this day) still
surprised that they have GRUB in the flash. They install their favourite Linux
distro, unmodified, and it just boots, needing no manual intervention or
customisation whatsoever, so long as the distro provided a GRUB configuration
during installation. Libreboot did that!

The only real downside is that GRUB isn't very good at booting BSD systems,
though it does have BSD partition support and it has code tailed to specific
types of BSD kernels, but it usually cannot be relied upon; that said, GRUB
does have GELI support and can load a FreeBSD kernel. If configured properly,
it might work. However, Libreboot provides SeaBIOS these days and SeaBIOS is
what is recommended to boot BSD systems in Libreboot, where you would then
execute the bootloader provided by your BSD system.

Another benefit of using GRUB (as a payload) is that, when installing Linux,
you no longer need to install anything bootloader-related on your HDD/SSD.
Although excluding this usually requires re-configuring `grub.cfg` in flash,
Libreboot does provide this capability.

### Automatic build system

One of Libreboot's other main innovations, in addition to providing binary
releases, was to provide an automated *build system* interface. With it, the
user could run a few simple commands, to build entire sets of ROM images.

By contrast, configuring coreboot on your own has always been quite complicated.
The average user would look at coreboot and become overwhelmed. It's easy to
just run `make menuconfig` in coreboot, pick a board, come out of that and
type `make`, but this only gets you a very basic setup (with SeaBIOS), and this
assumes that no other components are needed e.g. extra firmware that coreboot
does not provide. Especially for more modern systems, there are *many* moving
parts that the user otherwise has to deal with, whereas Libreboot automates all
of it. Such automation *did not exist* anywhere, prior to Libreboot. The only
noteworthy exception would have been the Chromebook products, where Google
did(does) provide updates, but without so much community focus as Libreboot and
without quite the same user-accessible build system automation; their
infrastructure is designed so that vendors can sell more Chromebooks.

Libreboot takes everything needed for each board, auto-downloading,
auto-patching, auto-configuring and auto-building the various software
components. Nowadays, this automation is very sophisticated, and can be done
with only a single command per board.

During 2014, this automation was already established, though it wasn't as
well-developed then, and a lot of manual user intervention was still required;
in other words, it wasn't full automation. It was more like 5 commands instead
of 1; but coreboot was (still is) like 15+ commands, depending.

A lot of Libreboot users today can't easily appreciate how much easier Libreboot
makes everything for them, because of how entrenched it is, at least on what it
supports. There are *many* coreboot users today, who have only ever set it up
by way of Libreboot installation. Many such users are people who would never use
coreboot on their own. Libreboot's build system *just works*, to the extent
that people today even take it for granted. It works so well that you forget
it exists, which is the essence of all good user interface design.

Before 2014, nothing like Libreboot ever existed. Coreboot existed, but nothing
that is easy to use based on it. Nothing quite as developed as Libreboot, for
end users. Libreboot's main innovation was (and is) precisely this, that it
automates the process of building ROM images, and then provides releases.

*Everything* in Libreboot is automated, and that is the entire purpose of it, to
provide such automation. It's the same concept as a *Linux distribution*, but
in the context of boot firmware. A project like *Debian* automatically builds
many codebases from all over the internet, putting it all together to provide
an operating system that users can simply install. Libreboot applies that same
concept to *coreboot*, so it is a *[coreboot distribution](../docs/maintain/)*.

Libreboot was the *first* coreboot distro ever, and today is still the most
popular one. Several similar projects now exist, inspired by the example that
Libreboot had set, all those years ago!

You can learn more about the build system by reading [lbmk
documentation](../docs/maintain/).

late 2014-2016: expansion
-------------------------

Libreboot up until late 2014 was mainly a proof of concept. It *worked*, but
not well. The precursor of what became Libreboot's automated build system,
began development from early 2014 onward.

Almost all of 2014 was spent entirely on the build system, and on documentation,
without much additional focus on hardware support; I always knew then that it
would later expand, so I focused solely on the infrastructure.

### GM45 hardware (e.g. ThinkPad X200)

I was approached by another developer, named Steve Shenton, around October
of 2014. I'd expressed interest in the ThinkPad X200, as an upgrade to the X60
offering in Libreboot. Coreboot supported the X200 at that time, done by
coreboot developer Vladimir Serbinenko based on Nico Huber's work on the Roda
RK9.

The Intel Management Engine was the only issue. At that time, nothing
like `me_cleaner` (which strips out code from the ME, usually leaving only
the bringup code intact) existed. On the GM45 machines,
[Intel ME](https://en.wikipedia.org/wiki/Intel_Management_Engine)
is usually disabled on most vendors, but Lenovo provided it because their
machines came with Intel Gigabit Ethernet, which requires an Intel Flash
Descriptor and Gigabit Ethernet config in the flash; Intel's standard setup
here is to then provide the Intel ME, in two separate versions: a 1.5MB version
without [AMT](https://en.wikipedia.org/wiki/Intel_Active_Management_Technology),
and a 5MB version with AMT.

The X200 was always possible to use without Intel ME, because the ME only
handled AMT and [TPM](https://en.wikipedia.org/wiki/Trusted_Platform_Module) on
that platform, which are not required for boot, but
the only known way at that time was to flash a *descriptorless* setup, which
meant that you would lose use of the Intel Gigabit Ethernet. This didn't seem
all that useful for Libreboot users, who expect everything to just work.

Steve reverse engineered the Intel Flash Descriptor, finding disable bits in it
that put the Intel ME into a permanent reset loop. In this configuration, the
ME bootrom does not load any firmware from the flash. The full ME firmware
otherwise goes in the main boot flash, alongside the BIOS software (e.g.
coreboot). In Libreboot, the Intel ME firmware is excluded on GM45 hardware.

I worked with Steve between October 2014 to mid-January 2015. Steve provided
instructions for disabling the Intel ME in the ICH9M flash descriptor, and
wrote a proof of concept utility that would take a *factory* ROM image dump,
for instance X200 LenovoBIOS dump, and create a file containing just
the descriptor and Gigabit Ethernet config, but without the Intel ME. That
utility was called *ich9deblob*.

Under Steve's guidance, I wrote a utility that would *generate* an ICH9M
descriptor from scratch. I then studied the datasheets for Intel's gigabit NIC,
writing a tool to generate the Ethernet config from scratch. I had a new program
written by around mid-January 2015, and I called it *ich9gen*. You can
read about ich9gen and ich9deblob on
the [ich9utils](../docs/install/ich9utils.md) page. The ich9gen utility was
used to provide blobless configurations on the ThinkPad X200 machines.

Based on this, and extensive amounts of documentation was written during the
same period, I then provided the Libreboot 20150124 release on 24 January 2015.
It added ThinkPad X200, X200S and X200 Tablet support.

### 2015: T400, T500, W500... R400

Coreboot lacked supported for other GM45 thinkpads at this time, when X200
support was first added to Libreboot. Testing was later done on these other
machines. In particular, Timothy Pearson (of Raptor Engineering) added support
for switchable graphics, enabling video initialisation on versions of these
boards that have both Intel and AMD graphics. Without such support, no video
init was available unless you used a board that only had the Intel GPU. A
hardware mux is present on the ones with AMD graphics, enabling you to still
use just the Intel one, or switch to the AMD one.

So, during 2015, Libreboot added support for many newer laptops. ASUS KCMA-D8
and KGPE-D16 support was also first added to Libreboot during this year,
worked on by Timothy Pearson and integrated into Libreboot.

### 2015-2016: Major build system improvements

The build system was heavily improved during this period, improving the
automation and greatly expanding the supported features.

During this time, Paul Kocialkowski got involved with the project and used
his expertise to integrate Depthcharge as a payload. This is the bootloader
used on Google Chromebooks; he has previously worked on Replicant and several
other projects. The ASUS Chromebook C201 was added during this time
as a proof of concept, which is a Rockchip RK3288-based machine (ARM). SeaBIOS
wasn't available, nor was GRUB(at that time, for ARM). Libreboot today uses
U-Boot (adapted for use as a coreboot payload) on ARM machines, but that work
hadn't been done in 2016.

In general, Libreboot's first years (2014-2016) were spent writing extensive
amounts of end user documentation, and implementing the automated build system,
so as to support many machines. Libreboot's design is kept as efficient as
possible, so that it can run on very inexpensive infrastructure, with many more
releases; the main focus has always been to further extend the number of
machines that are supported, and to reduce the amount of maintenance required,
so I try to keep everything very simple.

Several other desktop boards were also added during this period, such as
the Gigabyte GA-G41M-ES2L board that was ported to coreboot by Damien Zammit.
He was compensated for his work; I paid him 4000 AUD for the trouble. Arthur
Heymans contributed several ports as well, and today still does extensive work
on coreboot - both Damien and Arthur left the Libreboot project, after Libreboot
became independent again.

This period was a watershed moment in general, for the Libreboot project. Many
people contributed to the project, during this period. You can check
the [contrib](../contrib.md) page for a list of people, and check git logs.

2016: GNU Libreboot
--------------------

Yes. *That* is also covered here. Naturally, Libreboot was becoming very
popular and I looked for ways to extend that. Back in 2015 and most of 2016,
I saw GNU membership as a natural step for the project to take. Libreboot had
a mailing list at that time, hosted on the GNU Savannah infrastructure, so it
seemed only logical to give it a go.

### Evaluation and accession

Libreboot was briefly a GNU project, between 14 April 2016 to 15 September 2016.
I had proposed this during the summer of 2015, and worked with the GNU Eval
team lead by Mike Gerwitz.

Libreboot's build system and documentation used a very peculiar design, which
did not fit well into GNU's design policies. GNU had several technical
requirements for projects, such as use of Texinfo files for documentation, to
be generated into HTML by a static site generator. At that time, Libreboot's
website was written in static HTML, manually. It did not use a static site
generator of any kind.

On the coding side of things, many GNU programs use things like GNU Autoconf
for configuration, in build systems, and GNU has a certain *coding style* that
is preferred. To speed up entry into GNU, many of the requirements were
overlooked since, ideologically speaking, Libreboot was otherwise entirely free.
We joined GNU on 14 April 2016, under the assumption that it would gradually
start integrating with the GNU infrastructure.

*Three* Libreboot releases were released, during its GNU membership, namely:
Libreboot 20160818, 20160902 and 20160907.

### Initial outcomes

Libreboot's popularity reached great heights during this time, greatly expanding
and attracting many new developers. Joining GNU accelerated this further,
though it came with certain drawbacks.

I later realised otherwise, regarding the ideology; more on this later, in
the sections about osboot, and the osboot/libreboot merge, and events after
that.

### Regret

Anyway: during Libreboot's membership, I started to realise that many of the
technical requirements imposed on Libreboot were unworkable, especially the
GNU coding standards, and in general how a GNU project is supposed to be run,
which turned out to be quite inflexible for the Libreboot project. GNU projects
tend to be highly collaborative, with decisions taken on a collective level,
and not just on behalf of the given project, but with thought also given to
how it integrates with the rest of GNU; the assumption is that there would be a
complete GNU system, everything all integrated very tightly together. Libreboot
wasn't (and isn't) like that, because the knowledge is highly specialised and
it pertains to a lower level than GNU (that of the boot firmware).

RMS, a man who had no technical merit to lead the Libreboot project, began
trying to *tell me what to do*. I started noticing that the GNU project was not
run very democratically, or transparently either; as a maintainer, I had access
to the `gnu-prog-discuss` mailing list, which is otherwise unavailable to the
public, and I saw the true nature of it. Individual projects, even maintainers,
had little to no oversight or say in how RMS or the GNU Advisory Committee made
decisions, but they could impose policy on projects. In practise, *many*
projects ignore the leadership of RMS and the committee, and they don't use GNU's
stagnant infrastructure such as Savannah. Most modern GNU projects have their
own management, their own infrastructure and their own practises, where their
only connection to GNU is the prestige of the GNU brand name itself. However,
that mailing list existed, and RMS (plus others) used it to leverage other
GNU projects. Prior to joining, I saw it as a great and noble organisation, but
my experience as a maintainer within it showed me that it was actually just the
personal fiefdom of a very small group of people, lead by RMS.

I could begin to see a future very clearly where I was no longer
in control of the Libreboot project. I'll provide an example: one of the last
threads I saw, before being kicked off of the list due to Libreboot's
departure, was a thread started by RMS where he told all the GNU projects
that they should start implementing reproducible builds, in all of their build
systems; this is a noble goal in and of itself, but it was started based on the
whim of one man, who would not implement the policy himself. RMS has no coding
experience anymore, because he mostly stopped doing any real programming ever
since the 90s, yet he had the audacity to try to claim authority over my
project? [He does not even know how to install
Linux!](https://www.youtube.com/watch?v=umQL37AC_YM) - Libreboot's membership
was a gift to GNU, and I don't try to rub things in people's faces, but he
owned me a debt of gratitude. Instead, he showed me contempt. However, I cannot
reveal the emails due to privacy concerns (I would never publish without
consent).

Libreboot is a lifelong passion of mine. It's one of the best things I've ever
done, and I have no intention of ever letting it go, something I realise could
happen with GNU membership. There is *another* freedom that exists, namely the
freedom to say no. I reclaimed this freedom, by removing Libreboot from GNU.

I realised that if Libreboot stayed in GNU for too long, then I would start to
lose control over the project as it became more associated. I had been deciding
already, early into Libreboot's membership, whether to reverse the decision
and take Libreboot out of GNU, thereby making it an independent project again.
You could try to assert control by doing good work, but eventually everything
grows, and who will the other people who join answer to; you? No, I saw
definite coup possibility in the future. RMS could have put someone else in
charge, and I'd seem ungrateful if I resisted or challenged it, people would
side with him.

I know I'm right, and I don't regret the fact that Libreboot left GNU; I do
regret how it left, and I'll have more to say on this in the next section. I had
the wisdom then to know what might happen in the future. I'd seen it before,
with other projects (for example GnuTLS, whose founder and author did all the
work and later took it out of GNU - something that RMS tried to prevent, and
only failed by chance). I *did* initially offer for Libreboot to re-join GNU,
mostly because I felt regret about the *manner* in which it left, but not the
fact alone that it did leave. Again, more on this will be written in the next
sections. My re-join proposal was neither accepted nor rejected; RMS simply
ignored it, and did not respond. I offered for it to re-join because I felt bad
about everyone else I'd affected during its later departure, but I'd hoped RMS
would say no. So I gambled on it; making such an offer reliably absolved me of
any guilt, mitigating my past actions entirely, but he didn't have to accept
it, and he didn't. If he had accepted it, Libreboot in 2023 would be unrecognisable
today, at least compared to the Libreboot project that does now exist, in 2023.

So I thought at that point: was Libreboot's membership really worth it? I
concluded that it wasn't necessarily a bad idea, not a liability for the project,
at least in the short term. I basically continued running the project the same
way I always did, but under the GNU name, while being wary of my decision. I had
begun to contemplate whether I should remove Libreboot from the GNU orbit.

In retrospect, I believe Libreboot's membership was always doomed from the
start. The way I operate, and the way I think, is incompatible with their style
of leadership, and with the expectations put upon GNU projects. Actually, I
only half-expected that they'd even accept Libreboot, at the time. I didn't
even know it had become a GNU project, on the day it became one, which was 14
April 2016; I was quite preoccupied with many other things during that month,
and I only *noticed* RMS's acceptance email on the 18th of April in that year.
He just sent the email on a whim, and Libreboot had become part of GNU, just
like that - even in the days after the 14th, but before 18th, I had been
thinking about the changes that Mike Gerwitz wanted me to make first, which had
even been discussed during that time, only for RMS to sidestep all of it and
accept Libreboot early; yet another example of the power that he held.

Needless to say, I was stunned. And now, I will write about Libreboot's
subsequent exit from the GNU project:

### Exit

Later, a member of the FSF staff got fired, who happened to be transgender, and
I had been friends with that person. I myself had only recently come out
as trans (I came out publicly as trans during May 2016), and I wasn't very
secure about myself at that time. Needless to stay, I wasn't very stable, and
I took the friend's firing personally. I publicly accused the FSF of firing
the person on discriminatory grounds, accusations which later turned out to be
false, for which I apologised, but this went on for about 6 months.

That incident alone wasn't solely my reason for removing Libreboot from GNU,
and I probably would have done so anyway, but it served as a sufficient
catalyst that motivated me into action, though the way I handled it was
regrettable. Rather regrettably, I went on an angry tirade against the entire
apparatus of the FSF and the GNU project, denouncing them both, an act which I
know now made no sense whatsoever, because only one person was responsible for
the firing; and even if my diatribes were justified, they did not belong on
the Libreboot website. I should have put them on a personal blog, not the
homepage of a major free/opensource software project that I'd poured 3 years
of blood, sweat and tears into. What I did, nearly destroyed the Libreboot
project.

Because of that incident, I announced on 16 September 2016 that Libreboot is
no longer part of GNU. GNU did not officially have a mechanism for projects
to *leave*, and that's still true to this day. It has an evaluation process
for projects to join, and then integrate with the GNU infrastructure. They *do*
have a tendency to list projects as *unmaintained* or *decommissioned* if no
longer developed within GNU, but they do not have language pertaining
to *active* projects that leave, that stay active.

### GNU's response

Libreboot's decision to leave was not without precedent. GnuTLS also left, as
did Nano (Nano later re-joined), though GnuTLS's departure was never officially
acknowledged; it's still non-GNU to this day, but the GNU project still lists it
as an official member project. GNU initially did not accept Libreboot's
departure. The GNU Advisory Committee, under Stallman's leadership, went
around trying to find people who could take my place as leader of the project.
In other words: they had the goal of keeping GNU Libreboot going, despite my
intentions as leader of the project. I regarded this as their intent to create a
hostile fork of Libreboot, under the same name, and I still hold them to account
for it today, even if other actions that I did take were regrettable in the way
that I did them. They had no moral or technical authority over the project.

In the event, nobody else wanted to take my place under GNU auspices, and RMS
finally acknowledged Libreboot's departure, during January of 2017. At the time,
I wore this badge with pride. GnuTLS had left, but their leaving was never
officially acknowledged, and was in fact opposed by the GNU Advisory Committee;
it is even still listed today as a GNU project, when it has de facto not been
that way for many years. RMS published this acknowledgement, on the GNU
mailing lists, for everyone to see.

I still, to this day, believe that Libreboot's membership was flawed. It did not
need to join in the first place, regardless of ideology. It was already
thriving as an independent project, but GNU membership made no sense due
to the very nature of the project: as an aggregate of other codebases, it could
be *anything* at any given time, which would make auditing very difficult. It'd
be like Debian joining GNU, to become GNU Debian. GNU Debian GNU/Linux. This
may seem hilarious, in fact, but consider that Libreboot provides a modified
version of GRUB, which itself is a GNU project.

GNU Libreboot just didn't quite feel right, on any level, but this realisation
was only made after the fact. If there are infinite universes, ours is the only
one that had GNU Libreboot.

An *alternative* might have been to just provide a deblobbed coreboot in GNU,
which is something I also considered at the time, but that would have required
maintaining a full coreboot repository, merging and overseeing a lot more
patches from upstream, and diverging heavily. The way Libreboot's deblobbing
worked was that it just deleted the blobs, and (by way of configuration) avoided
all boards except those that could be booted entirely blob-free in the flash.
This method required far less maintenance - the original blob-free policy of
Libreboot has been continued, as of 2023, in a new project I maintain
called [Canoeboot](https://canoeboot.org/) - I'll have more to say about this,
and Libreboot's newer [Binary Blob Reduction Policy](policy.md), later in the
article.

2017-2021: Post-GNU years
---------------------

### GNU cuts Libreboot loose

Libreboot's departure from GNU came about 1 week after a big stable release,
the Libreboot 20160907 release. I pretty much burned out after that release,
especially during the *Librexit* saga (which is what I called Libreboot's
departure from GNU, in my head, at the time).

The Libreboot project pretty much ground to a halt, until around April or
May of 2017. I had a lot of other things going on in my life at the time,
especially transition-related (I was preparing financially for gender
reassignment surgery in Thailand, which was to be performed on me on 1
August 2018 - I did in fact go there and get it done, on that day, but I will
not talk about it further in this article).

In any case: tensions calmed, after January 2017 and the dust settled. I
remained angry, bitter in fact, but I did calm down after a while. I can look
back at these years now with pride; I did the right thing, even if I caused a
lot of trouble while doing it, trouble that I had to later correct, and atone
for. It's a bittersweet realisation, but it is what it is.

### Apology to GNU

Alyssa Rosenzweig, who later founded the Panfrost project and nowadays works
on free graphics drivers for Asahi Linux, briefly joined the Libreboot project
during mid-2017. She had a stern talk with me, telling me the folly of my ways.
I'd already been reconsidering my actions, but her talks with me made me finally
see sense.

I learned by April 2017 that my allegations against the FSF were false. The
employee was fired on other grounds. Even if my allegations were true, my
public reaction to it was wholly inappropriate. I used my position then to
attack the entire FSF and GNU apparatus, when in reality the firing had only
been decided upon by one man, namely John Sullivan who was the FSF's
executive director. Even if my allegations were true, I did a lot of damage
to the reputation of the FSF and the GNU project, and to Libreboot, and although
it wasn't my intention at that time, it brought a lot of undue attention upon
the person in question, who only wanted privacy.

I felt bad about all of it, so I publicly recanted my allegations on 2
April 2017, and stepped down as leader of the project. You can read about
the event here:
<https://www.reddit.com/r/linux/comments/639ob1/libreboot_no_longer_opposes_the_gnu_project_or/>

Also of note: Alyssa contributed to Libreboot a custom-written static site
generator, converting its static HTML into Markdown files for documentation
on the website, then generating pages with Pandoc. This static site generator
is included in the original Libreboot git repository, and it later became the
basis for my own [Untitled Static Site Generator](https://untitled.vimuser.org/)
which libreboot.org now uses. Alyssa acted as a sort of spokesperson during
this period, acting in my place and I briefly gave her sysadmin privileges for
the Libreboot hosting infrastructure, during that year (2017), because she
was helping me improve my infrastructure - for example, she taught me how to
use Nginx, where I'd previously used lighttpd as Libreboot's web server.

And that is the greatest irony of all. One of my main concerns about Libreboot's
GNU membership was that I would lose control of the project, but I soon stepped
down and handed it over to other people, after its departure; I'll have more to
say about this, in later sections. I was absent from leadership during 2017
to 2021, though I retained exclusive control of the domain name and
infrastructure, while fully delegating all day to day development, maintenance
and user support to other people - I later took over the project again in 2021,
a topic which I will also cover, later in this article.

2017-2021: the great rewrite
-----------------------

### Initial work, and why

While Libreboot was a member of the GNU project, I did a thought experiment:
what if Libreboot's build system and general infrastructure *did* adhere to
GNU standards?

I attempted to answer this, by actually doing it. I commissioned work, on the
Libreboot mailing list (which existed at the time, and was hosted by GNU), to
convert the website's static HTML files. Work was underway for converting the
entire documentation to Texinfo files, GNU's preferred format for documents.
This was later scrapped, when I decided to accept Alyssa's work instead; she
converted the website to use Markdown instead, with a custom static site
generator.

### Paper build system

I simultaneously commissioned a re-write of the build system. There wasn't
anything seriously wrong with the one I wrote, but I wanted to see if it could
be done better, so I went along with this. Paul Kocialkowski began the work.
Paul was at that time a Libreboot developer. He is listed on
the [contrib page](../contrib.md).

Paul's build system, the so-called *Paper build system*, was provided by him as
a proof of concept. It initially only supported CrOS-based devices, for example
the ASUS Chromebook C201, integrating coreboot, Depthcharge and various
ChromeOS utils that were needed.

The goal of the build system re-write was to make Libreboot much more flexible
and generally more configurable. Libreboot's build system *worked* very well at
that time, but a lot of functionalities were hardcoded; the entire design was
basically geared towards providing a useful sane default configuration per
board, in the quickest way possible, so as to provide releases for end users.
Reconfiguration *required* code modification. It was basically similar to
the *suckless* design philosophy. 

I was initially impressed by Paul's work. He got a proof of concept done in
only a few months, writing thousands and thousands of lines of code. Indeed,
his build system design was much more complex. Too complex, but its flaws
would not be realised until later.

All development history on *Paper* can be found in the *old* pre-2021 Libreboot
git repository, here (roll back by a few commits to see the code, because the
code was nuked in the last commits, adding a notice that the repository had
been split into multiple smaller repositories):
<https://notabug.org/libreboot/obsolete-repository-preserved-for-historical-purposes/>

I keep that repository there for archival, but it is no longer developed. I
took over the project again in 2021, and scrapped the rewrite. More on this
later in the article!

### Andrew Robbins and Sebastian Grzywna

Sebastian had joined the project during early 2016, advising about hardware
and he made quite a few useful code contributions at first. For example, he
added support for 16MB IFD configurations in ich9gen.

Some time around mid-2017, another person named Andrew Robbins joined the
Libreboot project. His ambition was to expand upon Paul's work in the Paper
build system, adding support for x86 machines.

As we discovered very early on, the *Paper* design was very, very complex and
required a lot more heavy maintenance than the original Libreboot build system.
The Paper design was the antithesis of the original Libreboot design (now
named lbmk, but back then it was just called *the old libreboot build system*).

The *Paper* design was implemented with the assumption: the user must be able
to reconfigure absolutely anything, without ever touching code. Sort of like
when you have a game engine, and then a scripting engine and editors, and the
like, in videogame development. Everything completely modularised, where one
component could work independently of the other. If I had to make an analogy,
it was sort of like the monolith vs microkernel argument, paper being the
same sort of mentality for the latter.

### I was AWOL for years

I wasn't active in the project during these years, at all. I first was prepping
mentally and financially for gender reassignment surgery scheduled for late
August 2018; then I spent a year recovering from that. And lots of other things.
A lot of events, most/all of which won't be covered in detail here, were going
on in my life, such that I never had the time nor mental energy to get involved
in Libreboot. And then the COVID pandemic threw me off for a further year. I
was planning a takeover of Libreboot in early 2020, but ended up doing it
in 2021 instead. I had discussed the possibility publicly, several times
during 2020, but nobody took me seriously at the time.

During my hiatus, I did still keep up to date with developments in the project.
I occasionally engaged in code review, helping out where I could, but I wasn't
in charge. One of the problems I had during this period, was that the other
people I put in charge were regularly hostile to my ideas, and seemingly did
not want my help at all. They wanted to maintain everything themselves, their
way. Which, fair enough, and for a while they did actually do a lot of work.
Good work, even. The problem was not their competence, or passion, both of which
they had in abundance, but the build system design that they were working on
was inherently unmaintainable; to put it most succinctly, it was crap. But they
wanted to do that, and I wasn't ready to fully take over again, so I left them
to it, hoping they'd prove me wrong.

When I stepped down, the project had adapted a formalised "democratic"
governance policy, implementing a horizontal hierarchy form of collective
management. In practise, the former BDFL leadership under me was replaced
by basically the same thing, only it was two people; Andrew and Sebastian
called all the shots. They would regularly turn away code contributions, and
Sebastian in particular was often extremely rude to users on the IRC channel,
acting in a very elitist manner.

Another general problem that Sebastian's leadership had was, that everything
was always *later*. You want X new feature added? Wait until after next release.
When's the next release? Soon. That account of events is quite reductive, but
it more or less sums everything up perfectly. The 2017-2021 leadership under
Andrew and Sebastian had no focus. It was overly ambitious, trying to focus on
and perfect everything, but the scope of the work required at least 5 developers
not 2, but those extra 3 developers weren't welcome in the project. They tried
to control everything themselves. It was their Libreboot. They were trying to
do what I do: lead a project. But they weren't competent at leading it. The
total lack of releases during that time is evidence of it. I provided them with
all the infrastructure they needed, funding too (from my own pocket), they had
an existing prestige (Libreboot was and still is very popular) to fall behind,
all they had to do was finish their work. They never finished it, because the
design of the Paper build system was unworkable.

But that's how it all was, for many years. I regard Libreboot as having been
a *dead project*, during this period. All (*all*) of the work put into it at
that time, was a complete waste of energy and effort.

### Paper never worked

The rewrite largely failed. During 2017-2021, Libreboot no longer had any
releases. The Paper build system *never* reliably built any ROM images, due
to its design; it wasn't actually designed to build anything on its own. The
whole point of it was to provide a large framework for *other* people to make
their own configs, in any number of permutations, on whatever hardware they
liked, with many different payloads and machines supported.

In other words, they were re-creating the coreboot build system. Poorly. The
sad thing is that, in retrospect, those two could have helped coreboot
directly, working on its own build system. Many of the features they worked on
would have been suitable to upstream, and *all* coreboot distros (not just
Libreboot) could have benefited, but I digress.

It was an extremely complex design. The *old* build system was still provided,
by the script named `oldbuild` and the directory named `resources/` - if I
remove those in a branch, and then run `sloccount .` (using David Wheeler's
sloccount utility), I see:

```
SLOC	Directory	SLOC-by-Language (Sorted)
7874    tools           sh=7874
5343    projects        sh=3278,ansic=2065
2359    libs            sh=2359
472     www             ansic=369,sh=103
282     top_dir         sh=282
```

In total, 13896 of shell scripts and several thousand lines of C for various
utils (most of the C sloccount is ich9utils).

If you actually look at the Paper system, almost all of it is covering
utilities that don't need to be included in the project, many of them
ChromeOS-related; modern Libreboot (using my design, the lbmk build system),
uses U-Boot, courtesy of work done by Alper Nebi Yasak (more on this later).
I compile U-Boot with the *same* generic script that I maintain, which is
less than 300 sloc in size, and compiles SeaBIOS, coreboot and U-Boot, without
any project-specific logic for the most part, and it doesn't just clean. It
also configures, updates configs, fetches, patches... it does it all.

For comparison, here is *modern* lbmk (the current Libreboot build system
today on 12 December 2023):

```
SLOC	Directory	SLOC-by-Language (Sorted)
1410    script          sh=1410
1007    util            ansic=601,python=406
321     include         sh=321
127     top_dir         sh=127
0       config          (none)
```

I will write more about *lbmk* later in the article, but what you need to
know for now is: lbmk supports more boards than Paper (a lot more), and actually
does a lot *more*, but the design is extremely efficient. The *Paper* design
results in an extreme amount of code repetition, where each module (e.g.
packaged util) is handled by scripts conforming to a uniform design, but each
script is tweaked per task. On the one hand, that offers Paper some flexibility
but a project like Libreboot is only ever managed by a few people, and the
Paper design was very overwhelming to new contributors.

Actually, I won't write much about lbmk at all. You can just read the
[lbmk documentation](../docs/maintain/). Paper also has in excess of 100
scripts. The lbmk design, at least on 12 December 2023, is currently 12
scripts. Just 12, but don't be fooled by simplicity. It can do everything
Paper can.

The lbmk design is so light because it generalises everything as much as
possible. The lbmk design is about 1800 lines of shell script and a couple
hundred lines of C; ich9utils is no longer included, because lbmk instead
includes the ifd/gbe configs generated by it, directly, and many other utils
are now handled (downloaded, patched and compiled) by the shell scripts. So,
the modern lbmk design does/can do everything Paper does/can do, but in 90%
fewer lines of code.

This sloccount comparison is valid, comparing Paper from 2021 (I ended all
development of it in 2021), versus lbmk in December 2023. I saw as early
as *2017*, when Paper was in very early development stages, that the design
was completely unworkable due to complexity, versus the scope of the project
which is to provide firmware images for end users.

I was going to scrap Paper in 2017, and revive my work on the original design,
but as I said: I had other real-life concerns going on, and had to go on
hiatus for many years. I let development of Paper continue during all those
years, in the hope that it would be stabilised at some point, and I had intended
to take it over myself at some point; but it was too complex.

I would later take over the Libreboot project. This is what I will cover,
in the next sections. Paul stopped working on Libreboot after around
late 2017, leaving the work solely in the hands of Andrew and Sebastian.

late 2020: osboot
----------------

I started the [osboot project](https://notabug.org/osboot) in December 2020.
Check *osboot.org* on the Wayback Machine. Osboot was initially called
Retroboot, but soon renamed to osboot, so also check *retroboot.org* on the
wayback machine.

Osboot started as an experiment: what if Libreboot hardware support could be
greatly expanded, by adopting a more pragmatic policy? That was answered, with
the [Binary Blob Reduction Policy](policy.md) - today, that is the Libreboot
policy, since osboot later merged with Libreboot, in November of 2022, but it's
the same policy that osboot used.

I was commissioned by a Minifree customer to provide a ThinkPad X230. I already
knew then that the X230 (an Ivy Bridge platform) could boot entirely blob-free
in coreboot, except for the neutered Intel ME (using `me_cleaner`) and
microcode updates. To my mind, it seemed acceptable in terms of software
freedom. A solid, all-round very useful machine.

I had a problem: what firmware would I provide? Skulls? Heads? This customer
wanted something easy. Skulls is great but lacks a build system as advanced
as Libreboot's (Paper *or* lbmk), though it does have one that is reminiscent
of ours, and they standardize on SeaBIOS. They didn't (and still don't) have
very good documentation, in my view. Then there is Heads: an excellent
project, but quite excessive for this customer's needs. In fact, the customer
specifically wanted *UEFI* at that time.

I decided to fork the Libreboot 20160907 build system, during December 2020,
for this customer. The 20160907 build system had many flaws, and it was 4 years
unmaintained at that point; the Paper build system was nominally still in
development, and the official build system of Libreboot, but not developed by
myself. Although I understood the Paper design well, I didn't like the code.
I still hate it. I *hate* that design, passionately. I wanted something clean,
and efficient.

Thus, osboot was born. It initially began with Tianocore integrated in it,
using MrChromebox's branch for coreboot. MrChromebox is a coreboot distro that
provides Tianocore as a payload, on many Chromebooks, so I leaned on his
expertise to provide experimental Tianocore support, in my Libreboot 20160907
fork. I completely gutted about half of the build system in that Libreboot
release, when forking it, because most of it no longer worked for modern
upstreams like coreboot and GRUB, both of which had gone through massive
changes over the years.

One of Libreboot's earlier design flaws was that parts of the build system
ran completely standalone, while relying on work done by other parts of the
build system, *while not* checking automatically whether other steps had been
done. For example, the final preparation of a ROM image did not check whether
GRUB had been built. So you had to *know* the build system well, and know which
parts of it to run, and in what precise order. The Libreboot documentation
used to cover this, telling you how to use it in different ways, depending
on the desired configuration. *This was fixed*, very early on in the osboot
project.

Osboot greatly improved the configurability of everything. For example, it
enabled you to more easily mix and match different payload combinations per
motherboard, whereas the Libreboot 20160907 design only allowed *one* payload
type, per target, and it contained a lot of target-specific logic that was
hardcoded, baked into the build system's design - even in December 2020 when
osboot started, I envisioned that it would one day support many more boards,
whereas Libreboot only supported like 15 motherboards in 2016.

The osboot redesign, relative to Libreboot 20160907, made handling of source
tree revisions and patches much cleaner, especially for multi-tree projects
like coreboot, where multiple revisions could be used depending on motherboard.

Of course, the first osboot revision also updated to a modern coreboot
revision at that time, which (in that month, December 2020) was
coreboot 4.14.

Although I only did osboot initially for the X230, for a customer, it took
weeks of work to get the build system up to date, and I spent time updating
all of the documentation too. At that point, I realised what I had *actually*
done: I had gotten back into development again. Moreover, I found the experience
fun again, and I found that I once again had the energy.

In short, I had my mojo back. My then 4-year hiatus was over.

### December 2020 Libreboot takeover

Perhaps getting too carried away too soon, I actually took over the Libreboot
project again in late December 2020. I was rapidly working on adding all the
Libreboot boards to osboot, and I would have just very quickly updated the
deblob scripts; I acted on this desire too soon, running under the gun.

I actually did remove Sebastian and Andrew's access to the Libreboot
infrastructure, for a few hours, before re-instating them - I wasn't ready for
a Libreboot takeover yet. I needed more time to polish everything. Doing a
tiny release for 1 customer, on 1 machine (the X230) was all well and good, but
I decided that I had time to polish it more.

### March 2021 Libreboot takeover

I wanted to get rid of Sebastian and Andrew for some time, at that point. Too
many years had gone by, without any releases in Libreboot, and the Paper build
system was only growing more complex; it was completely unworkable, and their
time was up. They failed. An unwritten rule in the new constitution of 2017
was that they would *competently* run the project; I entrusted this to them,
in that year. They failed, miserably. Despite their clear passion and desire
to do good for the project, they were adamant.

I had tried to sell to them the idea of scrapping the Paper build system (the
re-write), instead opting for my cleanly revived build system based on Libreboot
20160907, which at that time was called *osbmk* (osboot make). They would have
worked under me on it. They refused this, but asserted that Libreboot would have
two projects within it: one run by me, using my newly updated design, and one
with theirs. Now, I ask: why should I accept/enable the authority of those who
clearly had none? I was at a point then that I knew my work was viable, and that
I would have a release soon.

I'd had too many arguments with them over the years, largely technical in
nature. They regularly derided my own work, even the improved build system
design and all the rapid early progress I'd already made with the new osboot
project; I actually did make some temporary releases of osboot (tarballs, with
ROM images and source code) in December 2020, but deleted them, because they
weren't intended for general use. I was only testing everything.

Sebastian had a lot of knowledge about hardware, but did almost no coding
himself; he left that all to Andrew. And Andrew hadn't done any substantial
work in over 6 months at that time. And the work that was done, was still far
from complete. I anticipated that there would be years left before the Paper
design would yield a stable release, so I came to the conclusion:

I should not carry around so much baggage. I had a clean new design, that worked.

So I removed all their access to everything, and took over the Libreboot
project. Naturally, they both started denouncing me, but it didn't matter: I
was in charge. I was (and still am) grateful for their efforts, but Libreboot
must have stable releases, and there must be a clear direction. Having two
projects within it would only confuse people, and I was already addressing many
of the previous flaws in my design, fixing them one by one.

However, I only had osboot then. I started actually working on a new Libreboot
release *after* I took over.

2021 (lib)reboot
---------------

### New Libreboot repositories

The original Libreboot git repository can be found here:
<https://notabug.org/libreboot/obsolete-repository-preserved-for-historical-purposes>
(if this link ever goes offline, I'll mirror that repository to another git
site, or self-host it)

From mid-2021 onward, the Libreboot project was revived. The original repository,
linked above, contained the build system, documentation and images, along with
the *static site generator* that generates the Libreboot website (from Markdown
files). All in the same repository.

In mid-2021, Libreboot was split into smaller repositories:

* `lbmk`: the build system
* `lbwww`: the website (markdown files)
* `lbww-img`: images
* various other repositories, containing random utilities
* `untitled`: the static site generator, which creates the website, by creating
  HTML files from the Markdown files in `lbwww`

### Untitled Static Site Generator

Untitled Static Site Generator was going to be part of Libreboot officially, but
by that time, I had forked the Libreboot static site generator many times, for
other websites that I also host. Therefore, the static site generator was split
into its own standalone project, independent of Libreboot. It is
hosted [here](https://untitled.vimuser.org/). It combines all of the features
of the forks, and it can handle many different websites simultaneously. Many
changes were made, to make Untitled more reliable and user-friendly than the
original scripts. The *original* static site generator, that Untitled was
forked from, was submitted to the Libreboot project by Alyssa Rosenzweig
in 2017.

The osboot project greatly expanded, during this time. It never made any
releases officially, but it provided an excellent proof of concept, and it
became the basis for modern day Libreboot.

### May 2021 Libreboot release

Somewhat annoyingly, it coincided with the Freenode/Libera drama at that time,
when the latter forked from Freenode after a hostile takeover. Thankfully, that
drama ended quickly and we ended up with Libera being the clear winner.

Anyway: I finally did get a new Libreboot release out, based on the work that
I had started in osboot, but at that time Libreboot had the blob-free policy.

I did not use any of the work in the *Paper* re-write. I used precisely zero
lines of code from Sebastian and Andrew's work. I did it all myself. My decision
to take over the project had been vindicated. I did it for the users. People
had been complaining for years about the lack of a release. The Libreboot
project was dead. A joke to everyone, and it was no longer my fault; it was
theirs, for utterly failing to do any releases, and for running it into the
ground.

I still feel anger to this day, about my own failure. I should have never stepped
down, in 2017. I should have stuck it out, and carried on my work. There are
many works that I and others are completing today, that would have been
done *then*. Alas, hindsight is 20/20.

The [Libreboot 20210522 release](libreboot20210522.md) was the first release
in about 5 years, at that point, and it added many new boards. It inherited all
of the massive build system design improvements from osboot.

Osboot from 2021-2022
----------------------

The *osboot* project continued, since December 2020 when it started. I started
adding many new boards to it. The purpose of Osboot was the same as Libreboot,
except that it had the [Binary Blob Reduction Policy](policy.md) instead.
This is the policy that *modern* Libreboot uses, since merging with osboot.

### Goals of osboot

I *wanted* to start a project like osboot much earlier, in 2017. In fact, I was
going to, but real life got in the way and I went on hiatus for a few years.
I concluded as early as 2017 that the no-blob policy was a liability, especially
after `me_cleaner` became available. I realised that there were many more
machines out there, that I then considered acceptable from a software freedom
perspective, even if they did require an additional blob or two; I regard
the no-blob policy as overly dogmatic, and I've always thought so, but in practise
it didn't hurt anything because Intel ME was always a problem. I didn't know
ME neutering was possible, until I found out about `me_cleaner` - I would never
provide anyone with a setup that uses a non-neutered ME, because of the networking
and backdoors provided in such setups. The `me_cleaner` project removes such
backdoors from the Intel ME, resulting in a clean image that only contains the
init firmware in the ME. In this configuration, the ME initialises itself but
doesn't actually run anything, so it just sits there permanently in the init
stage. Things like AMT no longer work, when you run `me_cleaner`.

To put it simply: at least on the Intel side, `me_cleaner` changed everything
and opened up a lot more machines for me. But to do that, I had to abandon
Libreboot policy. Hence, osboot was born. Libreboot policy was a liability to
the free software movement, because it limited the amount of free software that
people could easily use. Remember, nothing else as easy to use as Libreboot
existed, within the coreboot community. I saw that many people have machines
which *can* have most of the proprietary firmware replaced with free software,
namely coreboot, but Libreboot set very arbitrary limits on what boards I could
add. These restrictions *became* a liability to the project.

The plan therefore was to modify Libreboot policy, and adapt to this new
reality, but I wasn't really sure, and at that time I wasn't sure whether my
work would succeed; this is why I created a separate project, rather than
directly taking back over Libreboot from the start. To my surprise, osboot
started becoming popular within my communities, early on, so I kept it going
for another 2 years or so, to see how it would go.

The feedback I kept getting was that most people saw essentially no difference
between in and Libreboot, except that Libreboot had a bunch of limitations in
it preventing people from using more hardware. People often got confused, asking
what differs between the two projects. I decided later that they would merge.

The purpose of osboot was then to support *every* board from coreboot, which is
more challenging, especially when dealing with code from the vendor that often
must be added, in different ways depending on the machine.

At first, osboot was very hands-on. For example, you had to dump the original
vendor BIOS to extract Intel ME, to then run `me_cleaner`, extracting the IFD,
GBE and (neutered) ME region with *ifdtool* to then insert into the ROM image.
Nowadays, that is completely [automated](../docs/install/ivy_has_common.md),
based on initial work done in osboot by Caleb La Grange. Caleb adapted logic
from Heads that extracts Intel ME images from Lenovo UEFI firmware updates,
thus eliminating the need for vendor firmware dumps prior to flashing; though,
backing up the factory firmware is still recommended, on any motherboard.

I later expanded Caleb's work, making the logic much more generic, expandable
more easily to other boards/vendors and platforms. I also added support for
other files such as Intel MRC firmware and SMSC KBC1126 EC firmware (KBC1126 EC
firmware extraction was only done in Libreboot, after it merged with osboot -
more on this later)

### November 2022: osboot/libreboot merger

I *shut* down the osboot project, formerly hosted on *osboot.org*, during
November 2022. The website was redirected to Libreboot. I then added all
extra documentation and code from osboot, into Libreboot, thus merging the
two projects together, and Libreboot formally adopted osboot's [Binary Blob
Reduction Policy](policy.md). I concluded that the two projects were essentially
the same, and I'd decided during the two years of osboot's existence that it
was vastly superior to Libreboot. I had a lot more fun working on it. Libreboot
became a side hobby at that point. OSBoot was my primary focus.

This was a resounding success. It was done in a day. Caleb adapted the
documentation, while I worked on the build system. *We did it in a day*.

My efforts in osboot and my extensive research revealed to me that almost
everyone supported this move. Sure enough, I saw a relative lack of opposition
to it; though, some of the more dogmatic members of the FSF were quite upset.
This level of upset later caused.... well, that's what I'm going to cover next.

Cold Boot War
-------

This period of Libreboot's history involved a massive amount of extreme and
hostile competition between the Libreboot project and a *hostile fork* of
Libreboot started by the FSF (now a GNU project). Libreboot fought hard to ensure
that it, the *real* Libreboot project, the one on libreboot.org, survived,
because the FSF literally tried to destroy it. They made no secret of it, and
even publicly announced such intentions at their LibrePlanet 2023 conference.

Much of the remainder of this article will cover this period, and its aftermath.
This period of Libreboot's history is called the *Cold Boot War*. SPOILER ALERT:
Libreboot won.

The purpose of today's article has been to write a rigorous history section for
the Libreboot project, because a lot of earlier history for the project wasn't
available. Many of Libreboot's early years were turbulent, and I never expected
then that the project would last 5 years, let alone 10.

### FSF's hostile fork

During Libreplanet 2023, which is the FSF's annual conference, the FSF, through
Denis Carikli who is part of their inner circle, announced a *hostile fork* of
Libreboot. I anticipated a fork of Libreboot by the FSF, as a result of the
osboot merger, and I was OK with it, but:

They tried to steal the name *Libreboot*, and sell themselves as the real
Libreboot project. This, I could not tolerate. I already knew of their effort
in December 2022, because its existence was leaked to me; they asked all of the
people I'd worked with to that point, asking them to betray me and work for them
instead. None were interested, and one of them leaked it to me.

So I was prepared. I expected they'd announce it during Libreplanet and I was
right; Denis had a talk scheduled for 19 March 2023, a Sunday, about boot
firmware, though the fork wasn't announced until he spoke, in the talk. But I
knew. So I prepared.

I released [Libreboot 20230319](libreboot20230319.md), several hours before
his talk, and I started an aggressive *countercoup*, whereby Libreboot was
developed much more aggressively than ever before, to completely outcompete them
in every way. It worked. What's more, I did the unthinkable: I got them to back
down. That almost never happens, as the FSF tends to be extremely dogmatic, too
drunk on their own prestige; set in their ways.

They initially hosted their project on the official sourcehut instance run by
Drew DeVault. I simply asked Drew to terminate their hosting. He complied. He
gave them two weeks to rename their project, or be deleted, and they did not
rename. Their website was hosted on sourcehut at the time, so their website
went offline for a day; on that same day, I announced the [Libreboot
20230423 release](libreboot20230423.md). Drew's assessment, matching my own,
was that it would be inappropriate to host a hostile same-named fork of an
active project. *I* now own access to <https://sr.ht/~libreboot/>, at least
on 12 December 2023, and I even pay for it, though it is currently empty - I may
very well use at a later date, to provide *mailing lists* for Libreboot.

If you run `whois` on libreboot.at (the domain name of their original fork site),
you will see that it says *GNU Hostmaster*. Owned by the FSF. Same config as
used for several other domains used by GNU projects - they were going to make
another *GNU Libreboot*, against my will. This, in spite of the truce established
in 2017.

I don't feel bad about what I did. What they did is widely considered to be
a *dick move* in the free software movement; it is widely considered impolite
to fork an active project and use the same name. The unwritten rule is always
that you use a new name. It's more than that though: in the FSF's fork, they
didn't just say: this is what we are, what we do and why you should use our
product. No. They put a paragraph in their documentation,
urging people to *delete* links to libreboot.org, and link to them. *They were
out for blood*.

### FSF's 2nd fork attempt

So I've responded in kind, ever since. Regardless of whether they succeed or
whether they are competent, a thought exists in their head. A dream, you could
say. Their dream is a world in which Leah Rowe and Libreboot no longer exist.
They wanted to destroy me. It's evident in Denis's LP2023 talk, where he said
he wanted to "continue" the Libreboot project. In his mind, there is no room for
disagreement over policy; it's their way or nothing. I had to play by their
rules, or go home.

During that time, and subsequently, I and others had repeatedly put pressure
on them to rename. I personally came up with the name *GNU Boot* - and suggested
that they use it. It's a name that I myself came up with several years prior,
when I was considering whether to work for GNU again *myself*, but as an actual
fork of coreboot. The name just works.

GNU did rename their project, but only after I forced them to do so. I forced
them to do so, by exposing the moral bankrupcy on their part, in their initial
effort to steal the Libreboot name. Their initial plan was to create a newly
established *GNU Libreboot* project. The name that they *now* use was created
by me, and I made them use it.

By 2023-12-12, GNU's fork had a new RC imminent for release, on this day, and it
was still based largely on Libreboot 20220710, with only superficial changes on
top of it. it still has all the old, obsolete revisions for all projects,
including coreboot. It still has all of the same bugs, that Libreboot has since
fixed, especially during 2023. Libreboot is *vastly* superior, in every way.

Unlike with their first attempt, GNU's new project is hosted on the GNU Savannah
infrastructure, as any proper GNU project should be. I *respect* the latter GNU
project more, because it is its own thing, that doesn't try to ride off of my
coattails. However, my perception of them is permanently coloured by their
initial hostile actions; and the only reason they ceased such actions was
because I made it clear that they would not be allowed. The fact that they even
tried, means they thought I would roll over, or otherwise fail to counteract it
meaningfully. They still want to damage Libreboot.

So, my strategy has been to constantly develop Libreboot from now on, much
more aggressively, and generally stay on top of my game. And I made no secret
of this strategy; I've been pretty open about everything, throughout 2023.

### Countercoup

My countercoup has essentially consisted of a single strategy: be the best, on
a technical level. During all of 2023, roughly 5x as much work has gone into
Libreboot compared to any other average development year (2017-2021
notwithstanding). Essentially, the *FSF's* strategy was to overwhelm Libreboot;
they wanted to make a big splash about their fork, and get devs on board as
quickly as possible, before Libreboot could develop much further under the new
policy, because Libreboot had not yet fully asserted itself in this regard, at
least so far as public recognition was concerned. So I doubled, tripled
and quadrupled down, and maintained absolute laser focus from 19 March 2023
onward, a focus that I still maintain to this day - I have many plans for
Libreboot. If you think 2023 has been crazy, 2024 will be even better. 2024
will be Libreboot's biggest development year yet. 2023 was only a warmup.

I've done *three* major audits to the Libreboot build system, during 2023.
The build system has been *re-engineered*, 3 times, each time becoming
infinitely more efficient.

Many new boards have been added. Many new features. *Non-coreboot* firmware
is now supported; for example, the (libre) stm32-vserprog and pico-serprog
code is now used by Libreboot, to provide serprog firmware on many STM32-
and RP2040-based microcontroller boards; we use them as SPI flashers, but you
can use them for many other purposes. They're quite handy little machines. The
serprog firmware integration was done by Riku Viitanen, who also added many
HP EliteBook machines to Libreboot during 2023.

Thanks to the work done by Nicholas Chin, several Dell Latitude laptops are now
supported in Libreboot, which can be flashed without disassembly. We support
GM45 and Ivy Bridge models, and we're adding many more (we have identified
about 20 of them).

You can actually just read the Libreboot release announcements from 2023, if
you want to know about all of the rapid progress made in Libreboot this year.
It is quite simply impossible to adequately describe, in only a short few
paragraphs, just how much Libreboot has improved during 2023. The development
pace during all of 2023 has been completely insane. Here are all of the
Libreboot release announcements from 2023:

* [Libreboot 20230319](libreboot20230319.md)
* [Libreboot 20230413](libreboot20230413.md)
* [Libreboot 20230423](libreboot20230423.md)
* [Libreboot 20230625](libreboot20230625.md)
* [Libreboot 20231021](libreboot20231021.md)
* [Libreboot 20231101](libreboot20231101.md)
* [Libreboot 20231106](libreboot20231106.md)

I also previously wrote about each of the three audits during 2023:

* [Libreboot Build System Audit 1](audit.md)
* [Libreboot Build System Audit 2](audit2.md)
* [Libreboot Build System Audit 3](audit3.md)

and now:

### Canoeboot

Purely for my own entertainment, I decided to re-create blob-free
Libreboot *myself*, exactly the same one that Libreboot used in the past, before
it adopted the modern [Binary Blob Reduction Policy](policy.md) - GNU started
their new project, specifically because it opposed the new policy in Libreboot.

Well, GNU's fork seemed to be going nowhere fast. I monitor their Git activity
daily, and their development pace is much slower than mine; slower than mine,
even when I'm going slow. I thought to myself: what if a *competently*
engineered solution existed? One maintained by someone who's been doing this
for over a decade?

And thus, [Canoeboot](https://canoeboot.org/) was born. I still mainly develop
Libreboot, but I spend a few hours after each release, bringing Canoeboot up
to date and running the deblob scripts, to update the `blob.list` files in
its build system.

Canoeboot is even listed on the FSF's
[Free Software Directory](https://directory.fsf.org/wiki/Canoeboot) - Craig
Topham approved it, he's the FSF's current licensing and compliance manager,
at least on 12 December 2023.

The purpose of Canoeboot is to simply exist, adhering to the no-blob policy
while being superior to GNU in every way, outcompeting it so fast that GNU's
own project is constantly behind - it's done, specifically to demonstrate
the superiority of Libreboot policy, by showing what Libreboot *would have
been*, if it didn't adopt the [Binary Blob Reduction Policy](policy.md) policy.

The FSF failed in its coup. My countercoup was a success. I madly beat them at
their own game. The FSF's strategy *might* have worked, if I hadn't been so
vigilant; Libreboot's development pace was much more conservative at that point,
and most of the works that have now been completed or are now underway, were
not even started. Libreboot was very young into its existence, relative to
the merging of the osboot project. They probably didn't expect any of the
actions that I've taken, or the massive leapfrog year of development this has
been for Libreboot. As far as I'm concerned, Libreboot has *won* 2023 - 2024
is the next battle.

And I *will* maintain Canoeboot. It is currently completely in sync with the
latest Libreboot release, and it will *keep* staying in sync, relative to each
new Libreboot release. I actually *describe* how this syncing is done, in great
detail, on Canoeboot's [about page](https://canoeboot.org/about.html) - and
the first Canoeboot release was done, based on the latest Libreboot release at
that time, in only 2 days, with all of Libreboot's vast improvements in it
compared to GNU's work, or lack thereof. As of this day, 12 December 2023,
Canoeboot is about 1 year ahead of GNU in terms of code, and 2 years ahead on
the writing of documentation. Conversely, GNU is *1 year* and *2 years* out of
date, in terms of code and documentation respectively.

2024 reconciliation intentions
------------------------------

### End of the Cold Boot War

The *FSF* started the coldboot war. Libreboot merely won it, decisively.

From 2024 onward, unless more hostilities develop from FSF/GNU's side, I intend
to adopt a more conciliatory approach toward GNU/FSF. I won the battle of 2023.
I won the *cold boot war*, but the real battle is this: how do we get free boot
firmware to non-technical end users, efficiently and reliably? The answer to
that question is projects such as Libreboot, or indeed others like, Heads,
Skulls, MrChromebox... you name it. Distros, designed similarly to Linux
distros, but for building boot firmware instead.

The *first* coldbootwar occured between 19 March 2023 and 31 December 2023,
described in the article above.

Much of 2023 was spent counteracting the FSF's coup, because they were hostile
to the Libreboot project, but I decided that I will avoid any such counter
action from now on. I will stil develop Canoeboot, but my main focus is
Libreboot. My conclusion is that, so long as my own efforts exist, and I keep
working on everything, the GNU project is no threat to Libreboot whatsoever.

Towards the end of 2023, there *was* in fact cooperation, between the GNU project
and Libreboot projects, in the form of small patches; Denis Carikli sent a few
patches and reports to Canoeboot and the Untitled Static Site Generator, and I
did similar for the GNU boot project. The FSF themselves even decided to
accept Canoeboot, on their Free Software Directory. See:
<https://directory.fsf.org/wiki/Canoeboot>

My only issue with GNU and FSF at the start of 2023 was that they wanted
to *replace* the Libreboot project, by using the same name. They *did* try to
destroy the Libreboot project, and take it for themselves. Things pretty much
calmed towards the end of 2023, and now the two projects/communities operate
to their own ends, not taking much stock of the other. If they don't bother me
from now on, I won't pay any attention to them.

They are welcome to send me patches, and I *may* help them if I feel like it.

Aside from remarks made on *this* page, which are necessary for historical
context, neither Libreboot nor Canoeboot aggressively act against the FSF
anymore; to do so was necessary, when they themselves did the same, because
the FSF is a well-funded organisation with much bigger reach and would walk
all over me if I allowed it, so it was necessary to show strength.

I don't start fights; I only finish them, decisively and without fear or
prejudice. Aside from minor acts on GNU's part, they have largely left me well
alone since the end of 2023, and my intention is to leave them alone. I have
at times perhaps been guilty of overthinking, but I basically don't care about
the FSF or GNU at this point.

My intention is that the FSF promote *Canoeboot*, much like they did with the
old Libreboot, prior to policy change. GNU Boot can do whatever it wants, I
don't really care; so long as they're not taking potshots at Libreboot. FSF can
also promote their own project (GNU Boot), as they have; there's room for both.
It'd be nice if GNU Boot criticised coreboot instead of Libreboot; coreboot is
the project that includes binary blobs, Libreboot merely tries to make the best
of a situation that is not ideal, while not being dogmatic; Canoeboot and GNU
Boot are dogmatic answers to the same issue, namely that hardware vendors suck.
Prior to Libreboot's policy change, Libreboot was not a fork of something; it
was its own original distribution, and it criticized the hardware vendors and
coreboot for not being firm enough with them - and this is a criticism that
I still have, today, and always will have. What more is there to say? GNU chose
to see me as its enemy, even though I'm ideologically very much in line with it
and wish to see its goals advanced to the fullest; the only difference with
Libreboot is the exact method by which this is strived for, a methodology that
they (the GNU project) vehemently disagree with. Libreboot's instrument is
the [Binary Blob Reduction Policy](policy.md), while Canoeboot's is
the [Binary Blob Extermination Policy](https://canoeboot.org/news/policy.html),
and Canoeboot's policy is very much identical to GNU's own policy document.

Last remarks
-----------

I've pretty much gone through the entire history, to the best of my ability.
I probably did forget a few things, but these are the broad strokes. If you
managed to read this far, I salute you. In any case, this article describes
both the history and nature of the Libreboot project up to this day, 12
December 2023, marking the 10th anniversary of the Libreboot project, relative
to its first release on 12 December 2013. I *was* planning a new release for
this day, but I decided not to rush that; more testing is needed, and there
are several new features/boards that I and others in the Libreboot project
are working on.

If you made it this far, reading all the way to the end, I will now reward
your patience and your courage with a cool easter egg:

The `minifree.org` domain name initially hosted a website that was teaching
people how to use VPNs and Tor, and it contained information about how to
be private on the internet. I later planned on making it into a blob-free
fork of *Puppy Linux* - because Puppy is small, lightweight, and mini is another
word for *small*, and it was to be a fully free distribution, containing no
blobs, not even firmware. Minifree GNU/Linux. I later scrapped the plan, and
realised that *Minifree* was also newspeak, that could mean *Ministry of
Freedom*. The domain name was re-purposed to provide my company website, with
the erstwhile *gluglug* domain then redirecting to it, and I registered Minifree
Ltd in the UK. Minifree is how I fund the Libreboot project, by selling computers
with Libreboot pre-installed. You can find it
on [minifree.org](https://minifree.org/).

*January 2025 update removed; hostilities briefly resumed, resulting from
accusations made by the GNU project against Libreboot and against me personally,
in a talk that they made at 38c3, but I've since decided to disregard it as being
that Adrien Bourmault simply doesn't know his place and spoke out of turn - I've
since begun discussions with the FSF and its executive director is remarkably
intelligent and decent, something I did not expect given my prior history -
more will be said about this, possibly, in future news updates, but not as
further updates to this 2023 article that you are currently reading. Good day!*

*Some language on this page has been toned down, while not altering the substance
of this article in any way, and without removing any of the history or otherwise
any other information presented here. I remain wary of course, but my focus is
simply on Libreboot and Canoeboot - those people in GNU Boot such as Adrien
simply do not think the way I do and would likely never work with me. That is
why they have their project, and I have mine!!*
