/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#include <console/console.h>
#include <soc/devapc.h>

static const struct apc_infra_peri_dom_16 infra_ao_sys0_devices[] = {
	/* 0 */
	DAPC_INFRA_AO_SYS0_ATTR("SPM_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("SPM_APB_S-1",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("SPM_APB_S-2",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("SPM_APB_S-4",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("APMIXEDSYS_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION2, FORBIDDEN3,
				NO_PROTECTION2, FORBIDDEN4, NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("APMIXEDSYS_APB_S-1",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("TINSYS_AO_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("TOPCKGEN_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION2, FORBIDDEN3,
				NO_PROTECTION2, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRACFG_AO_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION2, FORBIDDEN4, NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRACFG_AO_MEM_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	/* 10 */
	DAPC_INFRA_AO_SYS0_ATTR("PERICFG_AO_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("GPIO_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION2, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("TOPRGU_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("DSP_IRQ_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("DEVICE_APC_INFRA_AO_APB_S",
				SEC_RW_ONLY, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("BCRM_INFRA_AO_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("DEBUG_CTRL_INFRA_AO_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("AP_CIRQ_EINT_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("PMIC_WRAP_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("KP_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	/* 20 */
	DAPC_INFRA_AO_SYS0_ATTR("TOP_MISC_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("DVFSRC_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION2, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("MBIST_AO_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("HDMI_CEC_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("HDMI_EDID_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("HDMI_SCDC_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("IRRX_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("SYS_TIMER_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION2, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("MODEM_TEMP_SHARE_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("PMIF1_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 30 */
	DAPC_INFRA_AO_SYS0_ATTR("PMICSPI_MST_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("TIA_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("TOPCKGEN_INFRA_CFG_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("DRM_DEBUG_TOP_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("EFUSE_DEBUG_AO_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("APXGPT_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("SEJ_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("AES_TOP0_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("SECURITY_AO_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("SPMI_MST_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 40 */
	DAPC_INFRA_AO_SYS0_ATTR("DEBUG_CTRL_FMEM_AO_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("BCRM_FMEM_AO_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("DEVICE_APC_FMEM_AO_APB_S",
				SEC_RW_ONLY, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("PWM_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("PMSR_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("SRCLKEN_RC_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-1",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-2",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-3",
				NO_PROTECTION, FORBIDDEN15),
	/* 50 */
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-4",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-5",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-6",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-7",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-8",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("APU_S_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-1",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-2",
				NO_PROTECTION, FORBIDDEN2, SEC_RW_ONLY, FORBIDDEN4,
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-3",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-4",
				NO_PROTECTION, FORBIDDEN15),
	/* 60 */
	DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-5",
				NO_PROTECTION, FORBIDDEN2, SEC_RW_ONLY, FORBIDDEN4,
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-1",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-2",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-3",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-4",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("L3C_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("L3C_S-1",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("L3C_S-2",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("PCIE0_AXI_S",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN13),
	/* 70 */
	DAPC_INFRA_AO_SYS0_ATTR("VIOSYS_APB0_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("VIOSYS_APB1_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("VIOSYS_APB2_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("VIOSYS_APB3_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_INFRA_AO_SYS0_ATTR("VIOSYS_APB4_S",
				NO_PROTECTION, FORBIDDEN15),
};

static const struct apc_infra_peri_dom_4 infra_ao_sys1_devices[] = {
	/* 0 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-1",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-2",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-3",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-4",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-5",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-6",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-7",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-8",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-9",
				NO_PROTECTION2, FORBIDDEN2),
	/* 10 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-10",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-11",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-12",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-13",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-14",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-15",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-16",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-17",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-18",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-19",
				NO_PROTECTION, FORBIDDEN3),
	/* 20 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-20",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-21",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-22",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-23",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-24",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-25",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-26",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-27",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-28",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-29",
				NO_PROTECTION, FORBIDDEN3),
	/* 30 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-30",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-31",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-32",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-33",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-34",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-35",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-36",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-37",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-38",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-39",
				NO_PROTECTION, FORBIDDEN3),
	/* 40 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-40",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-41",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-42",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-43",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-44",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-45",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-46",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-47",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-48",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-49",
				NO_PROTECTION, FORBIDDEN3),
	/* 50 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-50",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-51",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-52",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-53",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-54",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-55",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-56",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-57",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-58",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-59",
				NO_PROTECTION, FORBIDDEN3),
	/* 60 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-60",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-61",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-62",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-63",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-64",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-65",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-66",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-67",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-68",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-69",
				NO_PROTECTION, FORBIDDEN3),
	/* 70 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-70",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-71",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-72",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-73",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-74",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-75",
				SEC_RW_ONLY, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-76",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-77",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-78",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-79",
				NO_PROTECTION, FORBIDDEN3),
	/* 80 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-80",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-81",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-82",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-83",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-84",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-85",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-86",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-87",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-88",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-89",
				NO_PROTECTION, FORBIDDEN3),
	/* 90 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-90",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-91",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-92",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-93",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-94",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-95",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-96",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-97",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-98",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-99",
				NO_PROTECTION, FORBIDDEN3),
	/* 100 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-100",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-101",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-102",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-103",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-104",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-105",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-106",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-107",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-108",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-109",
				NO_PROTECTION, FORBIDDEN3),
	/* 110 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-110",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-111",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-112",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-113",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-114",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-115",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-116",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-117",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-118",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-119",
				NO_PROTECTION, FORBIDDEN3),
	/* 120 */
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-120",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-121",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-122",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-1",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-2",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-3",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-4",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-5",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-6",
				NO_PROTECTION, FORBIDDEN3),
	/* 130 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-7",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-8",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-9",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-10",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-11",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-12",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-13",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-14",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-15",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-16",
				NO_PROTECTION, FORBIDDEN3),
	/* 140 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-17",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-18",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-19",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-20",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-21",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-22",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-23",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-24",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-25",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-26",
				NO_PROTECTION, FORBIDDEN3),
	/* 150 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-27",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-28",
				SEC_RW_ONLY, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-29",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-30",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-31",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-32",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-33",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-34",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-35",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-36",
				NO_PROTECTION, FORBIDDEN3),
	/* 160 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-37",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-38",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-39",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-40",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-41",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-42",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-43",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-44",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-45",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-46",
				NO_PROTECTION, FORBIDDEN3),
	/* 170 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-47",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-48",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-49",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-50",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-51",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-52",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-53",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-54",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-55",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-56",
				NO_PROTECTION, FORBIDDEN3),
	/* 180 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-57",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-58",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-59",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-60",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-61",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-62",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-63",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-64",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-65",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-66",
				NO_PROTECTION, FORBIDDEN3),
	/* 190 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-67",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-68",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-69",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-70",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-71",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-72",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-73",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-74",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-75",
				NO_PROTECTION2, FORBIDDEN2),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-76",
				NO_PROTECTION, FORBIDDEN3),
	/* 200 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-77",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-78",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-79",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-86",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-88",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-94",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-95",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-96",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-97",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-98",
				NO_PROTECTION, FORBIDDEN3),
	/* 210 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-99",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-101",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-102",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-103",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-104",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-106",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-107",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-108",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-109",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-110",
				NO_PROTECTION, FORBIDDEN3),
	/* 220 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-111",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-114",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-115",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-116",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-117",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-119",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-121",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-122",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-123",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-125",
				NO_PROTECTION, FORBIDDEN3),
	/* 230 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-126",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-127",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-128",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-129",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-130",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-131",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-132",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-133",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-134",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-135",
				NO_PROTECTION, FORBIDDEN3),
	/* 240 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-136",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-137",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-138",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-140",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-141",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-142",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-143",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-144",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-145",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-146",
				NO_PROTECTION, FORBIDDEN3),
	/* 250 */
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-147",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-148",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-149",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-150",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-151",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS1_ATTR("MDP_S_S-152",
				NO_PROTECTION, FORBIDDEN3),
};

static const struct apc_infra_peri_dom_4 infra_ao_sys2_devices[] = {
	/* 0 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-153",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-154",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-155",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-156",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-157",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-158",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-159",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-160",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-161",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-163",
				NO_PROTECTION, FORBIDDEN3),
	/* 10 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-164",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-165",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-166",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-167",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-168",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-169",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-170",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-171",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-172",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-173",
				NO_PROTECTION, FORBIDDEN3),
	/* 20 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-174",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-176",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-177",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-178",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-179",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-181",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-182",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-183",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-184",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-186",
				NO_PROTECTION, FORBIDDEN3),
	/* 30 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-187",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-188",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-189",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-190",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-191",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-192",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-193",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-194",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-195",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-196",
				NO_PROTECTION, FORBIDDEN3),
	/* 40 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-197",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-198",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-199",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-200",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-201",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-202",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-203",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-204",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-205",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-207",
				NO_PROTECTION, FORBIDDEN3),
	/* 50 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-208",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-209",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-210",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-211",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-212",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-213",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-215",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-216",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-217",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-218",
				NO_PROTECTION, FORBIDDEN3),
	/* 60 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-219",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-220",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-221",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-222",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-224",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-225",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-226",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-227",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-228",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-229",
				NO_PROTECTION, FORBIDDEN3),
	/* 70 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-230",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-231",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-232",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-233",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-234",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-235",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-236",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-237",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-238",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-239",
				NO_PROTECTION, FORBIDDEN3),
	/* 80 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-240",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-242",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-243",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-244",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-246",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-247",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-249",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-250",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-251",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-253",
				NO_PROTECTION, FORBIDDEN3),
	/* 90 */
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-254",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-256",
				NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS2_ATTR("MDP_S_S-257",
				NO_PROTECTION, FORBIDDEN3),
};

static const struct apc_infra_peri_dom_16 peri_ao_sys0_devices[] = {
	/* 0 */
	DAPC_PERI_AO_SYS0_ATTR("DEVICE_APC_PERI_AO_APB_S",
			       SEC_RW_ONLY, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("BCRM_PERI_AO_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("DEBUG_CTRL_PERI_AO_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-1",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-2",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-3",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-4",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-5",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-6",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	/* 10 */
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-7",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-8",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-9",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-10",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DEBUGSYS_APB_S",
			       NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION, FORBIDDEN),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_MD32_S0_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_MD32_S0_APB_S-1",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_MD32_S1_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_MD32_S1_APB_S-1",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP0_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	/* 20 */
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP1_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP2_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP3_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP4_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP5_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP6_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP0_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP1_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP2_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP3_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	/* 30 */
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP4_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP5_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP6_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP0_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP1_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP2_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP3_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP4_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP5_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP6_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	/* 40 */
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP0_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP1_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP2_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP3_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP4_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP5_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP6_APB_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI_AO_SYS0_ATTR("CCIF2_AP_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("CCIF2_MD_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("CCIF3_AP_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	/* 50 */
	DAPC_PERI_AO_SYS0_ATTR("CCIF3_MD_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("CCIF4_AP_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("CCIF4_MD_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("CCIF5_AP_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("CCIF5_MD_APB_S",
			       NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_AO_SYS0_ATTR("SSC_INFRA_APB0_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION, FORBIDDEN7),
	DAPC_PERI_AO_SYS0_ATTR("SSC_INFRA_APB1_S",
			       NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
			       NO_PROTECTION, FORBIDDEN7),
	DAPC_PERI_AO_SYS0_ATTR("DEVICE_MPU_ACP_APB_S",
			       SEC_RW_ONLY, FORBIDDEN15),
};

static const struct apc_infra_peri_dom_8 peri_ao_sys1_devices[] = {
	/* 0 */
	DAPC_PERI_AO_SYS1_ATTR("TINSYS_S",
			       NO_PROTECTION, FORBIDDEN7),
};

static const struct apc_infra_peri_dom_16 peri2_ao_sys0_devices[] = {
	/* 0 */
	DAPC_PERI2_AO_SYS0_ATTR("DEVICE_APC_PERI_AO2_APB_S",
				SEC_RW_ONLY, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BCRM_PERI_AO2_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEBUG_CTRL_PERI_AO2_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB0_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB1_S",
				NO_PROTECTION, FORBIDDEN13, NO_PROTECTION, FORBIDDEN),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB2_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB3_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB4_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB5_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB6_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 10 */
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB7_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB8_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB9_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB10_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB11_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB12_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB13_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB14_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_APB15_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB0_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 20 */
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB1_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB2_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB3_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB4_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB5_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB6_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB7_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB8_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_WEST_APB9_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB0_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 30 */
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB1_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB2_S",
				NO_PROTECTION, FORBIDDEN4, NO_PROTECTION, FORBIDDEN8,
				NO_PROTECTION, FORBIDDEN),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB3_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB4_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB5_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB6_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB7_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB8_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB9_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB10_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 40 */
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB11_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB12_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB13_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB14_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_NORTH_APB15_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB0_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB1_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB2_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB3_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB4_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 50 */
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB5_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB6_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB7_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB8_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB9_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB10_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB11_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB12_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB13_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB14_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 60 */
	DAPC_PERI2_AO_SYS0_ATTR("BND_SOUTH_APB15_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_NORTH_APB0_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_NORTH_APB1_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_NORTH_APB2_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_NORTH_APB3_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_NORTH_APB4_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BND_EAST_NORTH_APB5_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("SYS_CIRQ_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEVICE_APC_INFRA_PDN_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEBUG_TRACKER_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 70 */
	DAPC_PERI2_AO_SYS0_ATTR("CCIF0_AP_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("CCIF0_MD_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("CCIF1_AP_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("CCIF1_MD_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("MBIST_PDN_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("INFRACFG_PDN_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION2, FORBIDDEN6),
	DAPC_PERI2_AO_SYS0_ATTR("TRNG_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("GCPU_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("GCPU_NS_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("CQ_DMA_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 80 */
	DAPC_PERI2_AO_SYS0_ATTR("SRAMROM_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_PERI2_AO_SYS0_ATTR("INFRACFG_MEM_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("ECC_TOP_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("GCE_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("GCE_M2_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("SYS_CIRQ1_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("SYS_CIRQ2_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEBUG_TRACKER_APB1_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("INFRA_IOMMU_WRAP_APB0_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_PERI2_AO_SYS0_ATTR("INFRA_IOMMU_WRAP_APB1_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	/* 90 */
	DAPC_PERI2_AO_SYS0_ATTR("INFRA_IOMMU_WRAP_APB2_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_PERI2_AO_SYS0_ATTR("INFRA_IOMMU_WRAP_APB3_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_PERI2_AO_SYS0_ATTR("INFRA_IOMMU_WRAP_APB4_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_PERI2_AO_SYS0_ATTR("EMI_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN7),
	DAPC_PERI2_AO_SYS0_ATTR("EMI_MPU_APB_S",
				SEC_RW_ONLY, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEVICE_MPU_PDN_APB_S",
				SEC_RW_ONLY, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("APDMA_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEBUG_TRACKER_APB2_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BCRM_INFRA_PDN_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BCRM_PERI_PDN_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 100 */
	DAPC_PERI2_AO_SYS0_ATTR("BCRM_PERI_PDN2_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEVICE_APC_PERI_PDN_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEVICE_APC_PERI_PDN2_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BCRM_FMEM_PDN_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("FAKE_ENGINE_1_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("FAKE_ENGINE_0_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("PERI_SLOW_M_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("EMI_SUB_INFRA_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN7),
	DAPC_PERI2_AO_SYS0_ATTR("EMI_MPU_SUB_INFRA_APB_S",
				SEC_RW_ONLY, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEVICE_MPU_PDN_SUB_INFRA_APB_S",
				SEC_RW_ONLY, FORBIDDEN15),
	/* 110 */
	DAPC_PERI2_AO_SYS0_ATTR("MBIST_PDN_SUB_INFRA_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("INFRACFG_MEM_SUB_INFRA_APB_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN7),
	DAPC_PERI2_AO_SYS0_ATTR("BCRM_SUB_INFRA_AO_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("DEBUG_CTRL_SUB_INFRA_AO_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("BCRM_SUB_INFRA_PDN_APB_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("SSC_SUB_INFRA_APB1_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN7),
	DAPC_PERI2_AO_SYS0_ATTR("SSC_SUB_INFRA_APB2_S",
				NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN7),
	DAPC_PERI2_AO_SYS0_ATTR("INFRACFG_AO_MEM_SUB_INFRA_APB_S",
				NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN6),
	DAPC_PERI2_AO_SYS0_ATTR("SUB_FAKE_ENGINE_MM_S",
				NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI2_AO_SYS0_ATTR("SUB_FAKE_ENGINE_MDP_S",
				NO_PROTECTION, FORBIDDEN15),
	/* 120 */
	DAPC_PERI2_AO_SYS0_ATTR("DEVICE_APC_SUB_INFRA_AO_APB_S",
				SEC_RW_ONLY, FORBIDDEN15),
};

static const struct apc_infra_peri_dom_16 peri_par_ao_sys0_devices[] = {
	/* 0 */
	DAPC_PERI_PAR_AO_SYS0_ATTR("SCP_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SCP_S-1",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SCP_S-2",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SCP_S-3",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SCP_S-4",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SCP_S-5",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SSUSB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SSUSB_S-1",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SSUSB_S-2",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("NOR_AXI_S",
				   NO_PROTECTION, FORBIDDEN15),
	/* 10 */
	DAPC_PERI_PAR_AO_SYS0_ATTR("MSDC0_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("MSDC1_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("MSDC2_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("PCIE0_AHB_S",
				   NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN13),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SSUSB_P2_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SSUSB_P3_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("AUXADC_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("UART0_APB_S",
				   NO_PROTECTION, FORBIDDEN2, NO_PROTECTION, FORBIDDEN4,
				   NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN),
	DAPC_PERI_PAR_AO_SYS0_ATTR("UART1_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("UART2_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	/* 20 */
	DAPC_PERI_PAR_AO_SYS0_ATTR("UART3_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("dummy_0",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("dummy_1",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SPI0_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("PTP_THERM_CTRL_APB_S",
				   NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
				   NO_PROTECTION, FORBIDDEN),
	DAPC_PERI_PAR_AO_SYS0_ATTR("PERI_MBIST_PDN_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("DISP_PWM_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("DISP_PWM1_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SNPS_MAC_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SPI1_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	/* 30 */
	DAPC_PERI_PAR_AO_SYS0_ATTR("SPI2_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SPI3_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SPI4_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SPI5_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SPIS0_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("SPIS1_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("NFI_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("NFIECC_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("I2S_DMA_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("I2S_DMA1_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	/* 40 */
	DAPC_PERI_PAR_AO_SYS0_ATTR("BCRM_PERI_PAR_PDN_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("DEVICE_APC_PERI_PAR_PDN_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("PTP_THERM_CTRL2_APB_S",
				   NO_PROTECTION, FORBIDDEN8, NO_PROTECTION, FORBIDDEN4,
				   NO_PROTECTION, FORBIDDEN),
	DAPC_PERI_PAR_AO_SYS0_ATTR("IIC_P2P_REMAP_APB_S",
				   NO_PROTECTION, FORBIDDEN13, NO_PROTECTION, FORBIDDEN),
	DAPC_PERI_PAR_AO_SYS0_ATTR("NOR_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("PERICFG2_AO_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("DEVICE_APC_PERI_PAR_AO_APB_S",
				   SEC_RW_ONLY, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("DEBUG_CTRL_PERI_PAR_AO_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
	DAPC_PERI_PAR_AO_SYS0_ATTR("BCRM_PERI_PAR_AO_APB_S",
				   NO_PROTECTION, FORBIDDEN15),
};

static const enum domain_id domain_map[] = {
	DOMAIN_0, DOMAIN_1, DOMAIN_2, DOMAIN_3, DOMAIN_4, DOMAIN_5, DOMAIN_6, DOMAIN_7,
	DOMAIN_8, DOMAIN_9, DOMAIN_10, DOMAIN_11, DOMAIN_12, DOMAIN_13, DOMAIN_14, DOMAIN_15,
};

static void set_infra_ao_apc(uintptr_t base)
{
	int i, j;

	for (i = 0; i < ARRAY_SIZE(infra_ao_sys0_devices); i++)
		for (j = 0; j < ARRAY_SIZE(infra_ao_sys0_devices[i].d_permission); j++)
			set_module_apc(base + SYS0_D0_APC_0, i, domain_map[j],
				       infra_ao_sys0_devices[i].d_permission[j]);

	for (i = 0; i < ARRAY_SIZE(infra_ao_sys1_devices); i++)
		for (j = 0; j < ARRAY_SIZE(infra_ao_sys1_devices[i].d_permission); j++)
			set_module_apc(base + SYS1_D0_APC_0, i, domain_map[j],
				       infra_ao_sys1_devices[i].d_permission[j]);

	for (i = 0; i < ARRAY_SIZE(infra_ao_sys2_devices); i++)
		for (j = 0; j < ARRAY_SIZE(infra_ao_sys2_devices[i].d_permission); j++)
			set_module_apc(base + SYS2_D0_APC_0, i, domain_map[j],
				       infra_ao_sys2_devices[i].d_permission[j]);
}

static void set_peri_ao_apc(uintptr_t base)
{
	int i, j;

	for (i = 0; i < ARRAY_SIZE(peri_ao_sys0_devices); i++)
		for (j = 0; j < ARRAY_SIZE(peri_ao_sys0_devices[i].d_permission); j++)
			set_module_apc(base + SYS0_D0_APC_0, i, domain_map[j],
				       peri_ao_sys0_devices[i].d_permission[j]);

	/*
	 * Extra apc setting.
	 * Block debugsys to avoid privilege escalation.
	 */
	if (!CONFIG(CONSOLE_SERIAL))
		set_module_apc(base + SYS0_D0_APC_0, DEVAPC_DEBUGSYS_INDEX,
			       DOMAIN_0, SEC_RW_NS_R);

	for (i = 0; i < ARRAY_SIZE(peri_ao_sys1_devices); i++)
		for (j = 0; j < ARRAY_SIZE(peri_ao_sys1_devices[i].d_permission); j++)
			set_module_apc(base + SYS1_D0_APC_0, i, domain_map[j],
				       peri_ao_sys1_devices[i].d_permission[j]);
}

static void set_peri2_ao_apc(uintptr_t base)
{
	int i, j;

	for (i = 0; i < ARRAY_SIZE(peri2_ao_sys0_devices); i++)
		for (j = 0; j < ARRAY_SIZE(peri2_ao_sys0_devices[i].d_permission); j++)
			set_module_apc(base + SYS0_D0_APC_0, i, domain_map[j],
				       peri2_ao_sys0_devices[i].d_permission[j]);
}

static void set_peri_par_ao_apc(uintptr_t base)
{
	int i, j;

	for (i = 0; i < ARRAY_SIZE(peri_par_ao_sys0_devices); i++)
		for (j = 0; j < ARRAY_SIZE(peri_par_ao_sys0_devices[i].d_permission); j++)
			set_module_apc(base + SYS0_D0_APC_0, i, domain_map[j],
				       peri_par_ao_sys0_devices[i].d_permission[j]);
}

static void dump_infra_ao_apc(uintptr_t base)
{
	int reg_max;
	int d, i;

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(infra_ao_sys0_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_INFRA_AO_SYS0; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (INFRA_AO_SYS0)D%d_APC_%d: %#x\n", d,
			       i, read32(getreg_domain(base, SYS0_D0_APC_0, d, i)));

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(infra_ao_sys1_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_INFRA_AO_SYS1; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (INFRA_AO_SYS1)D%d_APC_%d: %#x\n", d,
			       i, read32(getreg_domain(base, SYS1_D0_APC_0, d, i)));

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(infra_ao_sys2_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_INFRA_AO_SYS2; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (INFRA_AO_SYS2)D%d_APC_%d: %#x\n", d,
			       i, read32(getreg_domain(base, SYS2_D0_APC_0, d, i)));

	printk(BIOS_DEBUG, "[DEVAPC] (INFRA_AO)MAS_SEC_0: %#x\n",
	       read32(getreg(base, MAS_SEC_0)));
}

static void dump_peri_ao_apc(uintptr_t base)
{
	int reg_max;
	int d, i;

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(peri_ao_sys0_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_PERI_AO_SYS0; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (PERI_AO_SYS0)D%d_APC_%d: %#x\n", d,
			       i, read32(getreg_domain(base, SYS0_D0_APC_0, d, i)));

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(peri_ao_sys1_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_PERI_AO_SYS1; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (PERI_AO_SYS1)D%d_APC_%d: %#x\n", d,
			       i, read32(getreg_domain(base, SYS1_D0_APC_0, d, i)));

	printk(BIOS_DEBUG, "[DEVAPC] (PERI_AO)MAS_SEC_0: %#x\n",
	       read32(getreg(base, MAS_SEC_0)));
}

static void dump_peri2_ao_apc(uintptr_t base)
{
	int reg_max;
	int d, i;

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(peri2_ao_sys0_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_PERI2_AO_SYS0; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (PERI2_AO_SYS0)D%d_APC_%d: %#x\n", d,
			       i, read32(getreg_domain(base, SYS0_D0_APC_0, d, i)));
}

static void dump_peri_par_ao_apc(uintptr_t base)
{
	int reg_max;
	int d, i;

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(peri_par_ao_sys0_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_PERI_PAR_AO_SYS0; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (PERI_PAR_AO_SYS0)D%d_APC_%d: %#x\n", d,
			       i, read32(getreg_domain(base, SYS0_D0_APC_0, d, i)));

	printk(BIOS_DEBUG, "[DEVAPC] (PERI_PAR_AO)MAS_SEC_0: %#x\n",
	       read32(getreg(base, MAS_SEC_0)));
}

static void dump_fmem_ao(uintptr_t base)
{
	printk(BIOS_DEBUG, "[DEVAPC] (DEVAPC_FMEM_AO_BASE %#lx)DOM_REMAP_0_0:%#x\n",
	       base, read32(getreg(base, DOM_REMAP_0_0)));
}

static void dump_infra2_ao(uintptr_t base)
{
	printk(BIOS_DEBUG, "[DEVAPC] (DEVAPC_INFRA2_AO_BASE %#lx)DOM_REMAP_0_0:%#x\n",
	       base, read32(getreg(base, DOM_REMAP_0_0)));
}

static void dump_scp_master(uintptr_t base)
{
	printk(BIOS_DEBUG, "[DEVAPC] SCP_DOM0:%#x SCP_DOM1:%#x SCP_DOM2:%#x Lock:%#x\n",
	       read32(getreg(base, SCP_DOM0)),
	       read32(getreg(base, SCP_DOM1)),
	       read32(getreg(base, SCP_DOM2)),
	       read32(getreg(base, ONETIME_LOCK)));
}

static void infra_init(uintptr_t base)
{
	void *reg;

	/* Side-band */
	SET32_BITFIELDS(getreg(base, MAS_SEC_0), CPU_EB_SEC, SECURE_TRANS);
	SET32_BITFIELDS(getreg(base, MAS_SEC_0), SCP_SSPM_SEC, SECURE_TRANS);

	/* Master Domain */
	SET32_BITFIELDS(getreg(base, MAS_DOM_0),
			SCP_SSPM_DOM, DOMAIN_3,
			CPU_EB_DOM, DOMAIN_14);

	/*
	 * Domain Remap: INFRA (4-bit) -> MMSYS (2-bit)
	 *               domain 0      -> domain 0
	 *               domain 8      -> domain 1   (SCP)
	 *               others        -> domain 3
	 */
	reg = getreg(base, DOM_REMAP_2_0);
	write32(reg, 0xFFFFFFFF);
	SET32_BITFIELDS(reg,
			TWO_BIT_DOM_REMAP_0, DOMAIN_0,
			TWO_BIT_DOM_REMAP_8, DOMAIN_1);

	/*
	 * Domain Remap: TINYSYS (3-bit) -> INFRA (4-bit)
	 *               domain 0        -> domain 4  (DSP)
	 *               others          -> domain 15
	 */
	reg = getreg(base, DOM_REMAP_0_0);
	write32(reg, 0xFFFFFFFF);
	SET32_BITFIELDS(reg,
			FOUR_BIT_DOM_REMAP_0, DOMAIN_4);


	/* TODO: Setup SCP, SSPM and MCUPM permissions in APC . */
	set_infra_ao_apc(base);
}

static void peri_init(uintptr_t base)
{
	void *reg;

	/* Default APC setting */
	set_peri_ao_apc(base);

	/* Master Domain */
	SET32_BITFIELDS(getreg(base, MAS_DOM_0), SPM_DOM, DOMAIN_9);

	/*
	 * Domain Remap: INFRA (4-bit) -> TINYSYS (3-bit)
	 *               domain 0      -> domain 0
	 *               domain 4      -> domain 0   (DSP)
	 *               others        -> domain 7
	 */
	reg = getreg(base, DOM_REMAP_0_0);
	write32(reg, 0xFFFFFFFF);
	SET32_BITFIELDS(reg,
			THREE_BIT_DOM_REMAP_0, DOMAIN_0,
			THREE_BIT_DOM_REMAP_4, DOMAIN_0);
	write32(getreg(base, DOM_REMAP_0_1), 0xFFFFFFFF);
}

static void peri2_init(uintptr_t base)
{
	/* Default APC setting */
	set_peri2_ao_apc(base);
}

static void peri_par_init(uintptr_t base)
{
	/* Default APC setting */
	set_peri_par_ao_apc(base);

	/* Master Domain */
	SET32_BITFIELDS(getreg_domain(base, MAS_DOM_0, 0, 4),
			PCIE0_DOM, DOMAIN_2);
}

static void fmem_master_init(uintptr_t base)
{
	/*
	 * Domain Remap: TINYSYS to EMI (3-bit to 4-bit)
	 *     1. DSP from 0 to 4
	 *     2. others from XXX to 15
	 */
	SET32_BITFIELDS(getreg(base, DOM_REMAP_0_0),
			FOUR_BIT_DOM_REMAP_0, DOMAIN_4,
			FOUR_BIT_DOM_REMAP_1, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_2, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_3, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_4, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_5, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_6, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_7, DOMAIN_15);
}

static void infra2_master_init(uintptr_t base)
{
	/*
	 * Domain Remap: TINYSYS to EMI (3-bit to 4-bit)
	 *     1. DSP from 0 to 4
	 *     2. others from XXX to 15
	 */
	SET32_BITFIELDS(getreg(base, DOM_REMAP_0_0),
			FOUR_BIT_DOM_REMAP_0, DOMAIN_4,
			FOUR_BIT_DOM_REMAP_1, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_2, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_3, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_4, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_5, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_6, DOMAIN_15,
			FOUR_BIT_DOM_REMAP_7, DOMAIN_15);
}

static void scp_master_init(uintptr_t base)
{
	SET32_BITFIELDS(getreg(base, SCP_DOM0),
			FOUR_BIT_DOM_REMAP_0, DOMAIN_8,
			FOUR_BIT_DOM_REMAP_2, DOMAIN_8,
			FOUR_BIT_DOM_REMAP_4, DOMAIN_8,
			FOUR_BIT_DOM_REMAP_6, DOMAIN_8);

	SET32_BITFIELDS(getreg(base, SCP_DOM1),
			FOUR_BIT_DOM_REMAP_0, DOMAIN_8,
			FOUR_BIT_DOM_REMAP_2, DOMAIN_8,
			FOUR_BIT_DOM_REMAP_4, DOMAIN_8,
			FOUR_BIT_DOM_REMAP_6, DOMAIN_8);

	SET32_BITFIELDS(getreg(base, SCP_DOM2),
			FOUR_BIT_DOM_REMAP_0, DOMAIN_8);

	/* Let SCP_DOM registers be read-only for security */
	write32(getreg(base, ONETIME_LOCK), 0x5);
}

const struct devapc_init_ops devapc_init[] = {
	{ DEVAPC_INFRA_AO_BASE, infra_init, dump_infra_ao_apc },
	{ DEVAPC_PERI_AO_BASE, peri_init, dump_peri_ao_apc },
	{ DEVAPC_PERI2_AO_BASE, peri2_init, dump_peri2_ao_apc },
	{ DEVAPC_PERI_PAR_AO_BASE, peri_par_init, dump_peri_par_ao_apc },
	{ DEVAPC_FMEM_AO_BASE, fmem_master_init, dump_fmem_ao },
	{ DEVAPC_INFRA2_AO_BASE, infra2_master_init, dump_infra2_ao },
	{ SCP_CFG_BASE, scp_master_init, dump_scp_master },
};

const size_t devapc_init_cnt = ARRAY_SIZE(devapc_init);
