/* SPDX-License-Identifier: GPL-2.0-only */

#include <arch/io.h>
#include <device/pnp_ops.h>
#include <superio/smsc/sch555x/sch555x.h>
#include <southbridge/intel/lynxpoint/pch.h>
#include "sch5555_ec.h"

struct ec_init_entry {
	uint16_t addr;
	uint8_t val;
};

static void bootblock_ec_init(void)
{
	/*
	 * Tables from CORE_PEI
	 */

	static const struct ec_init_entry init_table1[] = {
		{0x08cc, 0x11}, {0x08d0, 0x11}, {0x088c, 0x10}, {0x0890, 0x10},
		{0x0894, 0x10}, {0x0898, 0x12}, {0x089c, 0x12}, {0x08a0, 0x10},
		{0x08a4, 0x12}, {0x08a8, 0x10}, {0x0820, 0x12}, {0x0824, 0x12},
		{0x0878, 0x12}, {0x0880, 0x12}, {0x0884, 0x12}, {0x08e0, 0x12},
		{0x08e4, 0x12}, {0x083c, 0x10}, {0x0840, 0x10}, {0x0844, 0x10},
		{0x0848, 0x10}, {0x084c, 0x10}, {0x0850, 0x10}, {0x0814, 0x11},
	};

	for (size_t i = 0; i < ARRAY_SIZE(init_table1); ++i)
		ec_write(2, init_table1[i].addr, init_table1[i].val);

	static const struct ec_init_entry init_table2[] = {
		{0x0005, 0x33}, {0x0018, 0x2f}, {0x0019, 0x2f}, {0x001a, 0x2f},
		{0x0083, 0xbb}, {0x0085, 0xd9}, {0x0086, 0x2c}, {0x008a, 0x34},
		{0x008b, 0x60}, {0x0090, 0x5e}, {0x0091, 0x5e}, {0x0092, 0x86},
		{0x0096, 0xa4}, {0x0097, 0xa4}, {0x0098, 0xa4}, {0x009b, 0xa4},
		{0x00a0, 0x0a}, {0x00a1, 0x0a}, {0x00ae, 0x7c}, {0x00af, 0x7c},
		{0x00b0, 0x9e}, {0x00b3, 0x7c}, {0x00b6, 0x08}, {0x00b7, 0x08},
		{0x00ea, 0x64}, {0x00ef, 0xff}, {0x00f8, 0x15}, {0x00f9, 0x00},
		{0x00f0, 0x30}, {0x00fd, 0x01}, {0x01a1, 0x00}, {0x01a2, 0x00},
		{0x01b1, 0x08}, {0x01be, 0x90}, {0x0280, 0x24}, {0x0281, 0x13},
		{0x0282, 0x03}, {0x0283, 0x0a}, {0x0284, 0x80}, {0x0285, 0x03},
		{0x0288, 0x80}, {0x0289, 0x0c}, {0x028a, 0x03}, {0x028b, 0x0a},
		{0x028c, 0x80}, {0x028d, 0x03}, {0x0040, 0x01},
	};

	for (size_t i = 0; i < ARRAY_SIZE(init_table2); ++i)
		ec_write(1, init_table2[i].addr, init_table2[i].val);

	/*
	 * Table from PeiHwmInit
	 */

	static const struct ec_init_entry hwm_init_table[] = {
		{0x02fc, 0xa0}, {0x02fd, 0x32}, {0x0005, 0x77}, {0x0019, 0x2f},
		{0x001a, 0x2f}, {0x008a, 0x33}, {0x008b, 0x33}, {0x008c, 0x33},
		{0x00ba, 0x10}, {0x00d1, 0xff}, {0x00d6, 0xff}, {0x00db, 0xff},
		{0x0048, 0x00}, {0x0049, 0x00}, {0x007a, 0x00}, {0x007b, 0x00},
		{0x007c, 0x00}, {0x0080, 0x00}, {0x0081, 0x00}, {0x0082, 0x00},
		{0x0083, 0xbb}, {0x0084, 0xb0}, {0x01a1, 0x88}, {0x01a4, 0x80},
		{0x0088, 0x00}, {0x0089, 0x00}, {0x00a0, 0x02}, {0x00a1, 0x02},
		{0x00a2, 0x02}, {0x00a4, 0x04}, {0x00a5, 0x04}, {0x00a6, 0x04},
		{0x00ab, 0x00}, {0x00ad, 0x3f}, {0x00b7, 0x07}, {0x0062, 0x50},
		{0x0000, 0x46}, {0x0000, 0x50}, {0x0000, 0x46}, {0x0000, 0x50},
		{0x0000, 0x46}, {0x0000, 0x98}, {0x0059, 0x98}, {0x0061, 0x7c},
		{0x01bc, 0x00}, {0x01bd, 0x00}, {0x01bb, 0x00}, {0x0085, 0xdd},
		{0x0086, 0xdd}, {0x0087, 0x07}, {0x0090, 0x82}, {0x0091, 0x5e},
		{0x0095, 0x5d}, {0x0096, 0xa9}, {0x0097, 0x00}, {0x009b, 0x00},
		{0x00ae, 0x86}, {0x00af, 0x86}, {0x00b3, 0x67}, {0x00c4, 0xff},
		{0x00c5, 0xff}, {0x00c9, 0xff}, {0x0040, 0x01}, {0x02fc, 0x00},
		{0x02b3, 0x9a}, {0x02b4, 0x05}, {0x02cc, 0x01}, {0x02d0, 0x4c},
		{0x02d2, 0x01}, {0x02db, 0x01}, {0x006f, 0x01}, {0x0070, 0x02},
		{0x0071, 0x03}, {0x018b, 0x03}, {0x018c, 0x03},
	};

	for (size_t i = 0; i < ARRAY_SIZE(hwm_init_table); ++i)
		ec_write(1, hwm_init_table[i].addr, hwm_init_table[i].val);
}

#define SCH555x_IOBASE	0x2e
#define GLOBAL_DEV	PNP_DEV(SCH555x_IOBASE, SCH555x_LDN_GLOBAL)
#define SERIAL_DEV	PNP_DEV(SCH555x_IOBASE, SCH555x_LDN_UART1)

void mainboard_config_superio(void)
{
	// Super I/O early init will map Runtime and EMI registers
	sch555x_early_init(GLOBAL_DEV);

	// Changes LED color among a few other things (extracted from Dell's FW)
	outb(0x01, SCH555x_RUNTIME_IOBASE + SCH555x_RUNTIME_PME_STS);
	outb(0x00, SCH555x_RUNTIME_IOBASE + SCH555x_RUNTIME_PME_EN);
	outb(0x18, SCH555x_RUNTIME_IOBASE + SCH555x_RUNTIME_PME_EN1);
	outb(0x01, SCH555x_RUNTIME_IOBASE + SCH555x_RUNTIME_UNK1);
	outb(0x0f, SCH555x_RUNTIME_IOBASE + SCH555x_RUNTIME_LED);

	// Perform bootblock EC initialization
	bootblock_ec_init();

	// Bootblock EC initialization is required for UART1 to work
	sch555x_enable_serial(SERIAL_DEV, CONFIG_TTYS0_BASE);
}
