% Політика зменшення бінарних блобів
% Лія Роу
% 4 січня 2022 року (оновлено 15 листопада 2022 року)

Вступ
============

У цій статті описано *принципи*, які керують проектом Libreboot. Щоб отримати
інформацію про те, *як ці принципи застосовуються на практиці*, прочитайте
натомість цю статтю: [Статус свободи програмного та апаратного забезпечення для
кожної материнської плати, що підтримується Libreboot](../freedom-status.uk.md)

Політика Libreboot полягає в тому, щоб надати настільки, наскільки можливо, свободи
кожному користувачу, на кожному підтримуваному апаратному забезпеченні та *підтримувати
стільки апаратного забезпечення з coreboot, наскільки це можливо*; це означає, що ви повинні
мати можливість вивчати, змінювати та *ділитися* всім джерельним кодом, документацією
чи іншими подібними ресурсами, які роблять Libreboot таким, яким він є. Простіше кажучи, ви повинні
мати *контроль* над своїми власними обчисленнями.

*Мета* Libreboot полягає в тому, щоб
зробити саме це та допомогти якомога більшій кількості людей, автоматизувавши
конфігурацію, компіляцію та встановлення *coreboot* для *нетехнічних*
користувачів, ще більше спростивши це для звичайного користувача, надаючи користувачам
дружні інструкції для всього. По суті, Libreboot - це *дистрибутив
coreboot*, приблизно так само, як *Alpine Linux* є дистрибутивом Linux!

Метою цього документа є окреслення того, як це досягається, і як
проект працює на цій основі. *Цей* документ здебільшого стосується
ідеології, тому він (переважно) нетехнічний; для отримання технічної інформації
ви можете звернутися до [документації системи збірки Libreboot](../docs/maintain/).

Поточний обсяг проекту
=====================

Проект libreboot стосується того, що входить до основної мікросхеми завантажувальної флеш-пам'яті,
але є й інші компоненти мікропрограми, які слід взяти до уваги, про що йдеться
в [поширених запитаннях щодо libreboot](../faq.uk.md#яке-ще-мікропрограмне-забезпечення-існує-за-межами-libreboot).

Найбільш критичні з них це:

* Прошивка вбудованого контролера (EC)
* Прошивка жорстких дисків/твердотілих накопичувачів
* Прошивка Intel Management Engine / AMD PSP

Що таке двійковий блоб?
----------------------

Двійковий блоб у цьому контексті - це будь-який виконуваний файл, для якого не існує вихідного коду,
який ви не можете досліджувати та змінювати розумним чином. За визначенням,
усі такі блоби є *пропрієтарними* за своєю природою, і їх слід уникати, якщо це можливо.

Конкретні двійкові блоби також є проблематичними в більшості систем coreboot, але вони
відрізняються для кожної машини. Дізнайтесь більше в розділі поширених запитань і на цій сторінці про те,
як ми працюємо з двійковими блобами в проекті Libreboot.

Для інформації про Intel Management Engine та AMD PSP зверніться до поширених запитань.

Політика *зменшення* блобів
=======================

Конфігурації за замовчуванням
----------------------

Coreboot, на якому Libreboot базується, є здебільшого вільним програмним забезпеченням, але
на деяких платформах вимагає двійкових блобів. Найпоширенішим прикладом може бути raminit
(ініціалізація контролера пам'яті) або ініціалізація кадрового буфера відео. Прошивка
coreboot використовує двійкові блоби для деяких з цих завдань, на деяких материнських платах,
але деякі материнські плати з coreboot можна ініціалізувати з 100% вільним джерельним
кодом, який ви можете перевірити та скомпілювати для свого використання.

Libreboot вирішує цю ситуацію *суворо* та *принципово*. Природа
цього - це те, що ви збираєтесь прочитати.

Проект libreboot має наступну політику:

* Якщо блоб *можна* уникнути, його слід уникати. Наприклад, якщо ініціалізація VGA ROM
  в іншому випадку працює краще, але coreboot має *вільний* код ініціалізації
  для певного графічного пристрою, цей код слід використовувати в libreboot під
  час створення образу ROM. Подібним чином, якщо *ініціалізація контролера пам'яті* можлива
  за допомогою бінарного блобу *або* вільного коду в coreboot, *вільний* код
  слід використовувати в ROM, створених системою збірки Libreboot, а *блоб*
  для raminit не слід використовувати; однак, якщо вільний код ініціалізації недоступний
  для зазначеного raminit, це дозволено, і система збірки Libreboot використовуватиме
  *блоб*.
* Необхідно звернути увагу на деякі нюанси: у деяких конфігураціях ноутбуків або настільних комп'ютерів
  зазвичай буде *два* графічних пристрої (наприклад, чіп nvidia та
  чіп intel, використовуючи технологію nvidia optimus technology, на ноутбуці). Можливо,
  один із них має вільний код ініціалізації в coreboot, а інший - ні. Абсолютно
  прийнятно і бажано, щоб libreboot підтримував обидва пристрої та
  розміщував необхідний двійковий блоб на тому, якому бракує власної
  ініціалізації.
* Виняток зроблено для оновлень мікрокоду ЦП: вони дозволені та фактично
  *обов'язкові* відповідно до політики libreboot. Ці оновлення виправляють помилки ЦП, у тому
  числі помилки безпеки, і оскільки ЦП уже має невільний мікрокод, записаний в
  ROM в будь-якому випадку, єдиний вибір - *x86* або *зламаний x86*. Таким чином, libreboot
  дозволить лише конфігурації материнської плати coreboot, де
  *ввімкнено* оновлення мікрокоду, якщо доступно для ЦП на цій системній платі.
  [Releases after 20230423 will provide separate ROM images with microcode
  excluded, alongside the default ones that include microcode.](microcode.md)
* Intel Management Engine: у документації libreboot *повинні* бути написані
  слова, щоб розповісти людям, як *нейтралізувати* ME, якщо це можливо на даній дошці.
  Програма `me_cleaner` є дуже корисною та забезпечує набагато безпечнішу конфігурацію
  ME.
* Бінарні блоби *ніколи* не слід видаляти, навіть якщо вони не використовуються. 
  У проекті coreboot доступний набір субмодулів `3rdparty` з бінарними блобами
  для завдань ініціалізації на багатьох платах. *Усі* вони повинні бути включені до випусків
  libreboot, навіть якщо вони не використовуються. Таким чином, навіть якщо система збірки Libreboot
  ще не підтримує певну плату, хтось, хто завантажує libreboot, все одно
  може внести зміни у свою локальну версію системи збірки, якщо
  забажає, щоб надати конфігурацію свого апаратного забезпечення.

Загалом, застосовано здоровий глузд. Наприклад, винятком
із мінімізації може бути те, що *блоб* raminit та *вільний* raminit доступні, але
*вільний* так зламано, що його не можна використовувати. У такій ситуації натомість
слід використовувати той, що з блобом, тому що в іншому випадку користувач може повернутися до
повністю пропрієтарної системи замість використання coreboot (через libreboot).
*Деякі* свободи *краще, ніж жодних*.

Нова прагматична політика Libreboot також може призвести до того, що в майбутньому більше людей стануть
розробниками coreboot, виступаючи в якості важливого *містка* між
*ним* і нетехнічними людьми, яким просто потрібна допомога, щоб розпочати роботу.

Налаштування
-------------

Наведені вище принципи мають застосовуватися до конфігурацій *за замовчуванням*. Однак libreboot
має бути *конфігурованим*, дозволяючи користувачеві робити все, що заманеться.

Цілком природно, що користувач може захотіти створити *менш* вільний параметр, ніж
стандартний у libreboot. Це цілком прийнятно; свобода вище,
і її слід заохочувати, але *свободу вибору* користувача
також слід поважати та пристосовуватись до неї.

Іншими словами, не читайте лекції користувачеві. Просто спробуйте допомогти їм у
їхній проблемі! Метою проекту libreboot є просто зробити coreboot більш
доступним для нетехнічних користувачів.

КАТАЛОГ СВОБОДИ
===============

Також має бути доступна сторінка *[статусу блобів](../freedom-status.uk.md)*,
яка інформуватиме людей про статус бінарних блобів на кожній машині, що
підтримується системою збірки Libreboot. Дивіться:
[Статус свободи програмного та апаратного забезпечення для кожної плати, яка
підтримується Libreboot](../freedom-status.uk.md)

Бажано бачити світ, де все апаратне та програмне забезпечення є вільним, під
тією ж ідеологією, що й проект Libreboot. Обладнання!?

Так, обладнання. RISC-V є чудовим прикладом сучасної спроби вільного апаратного забезпечення, яке
часто називають *Апаратним забезпеченням з відкритим кодом*.
Це ISA для виробництва мікропроцесора. Уже існує багато реальних
реалізацій, які можна використовувати, і їх буде лише
більше.

Таке *апаратне забезпечення* ще знаходиться в зародковому стані. Ми повинні почати проект, який
буде каталогізувати статус різних зусиль, у тому числі на апаратному рівні (навіть на
рівні кремнію). Такі рухи, як OSHW і Право на ремонт (Right To Repair), є надзвичайно
важливими, включно з нашим власним рухом, який інакше зазвичай менше думатиме про свободу апаратного
забезпечення (хоча йому справді, справді
варто!)

Одного дня ми житимемо у світі, де будь-хто зможе виготовити власні чіпи,
включаючи процесори, а також будь-які інші типи мікросхем. Зусилля зробити домашнє виробництво
чіпів реальністю зараз знаходяться в зародковому стані, але такі зусилля існують,
наприклад, робота, виконана Семом Зелофом і проектом Libre Silicon:

* <https://www.youtube.com/channel/UC7E8-0Ou69hwScPW1_fQApA>
* <http://sam.zeloof.xyz/>
* <https://libresilicon.com/>

(Сем буквально виробляє процесори в своєму гаражі)
