% HP EliteBook 2170p support added to Libreboot
% Leah Rowe
% 9 August 2023

**UPDATE, 16 August 2023:
[installation instructions are now available](../docs/hardware/hp2170p.md).**

<img tabindex=1 class="r" style="max-width:35%" src="https://av.libreboot.org/hp2170p/hp2170p.jpg" /><span class="f"><img src="https://av.libreboot.org/hp2170p/hp2170p.jpg" /></span>

Introduction
============

HP EliteBook 2170p support was added to coreboot, in
the [coreboot 4.20.1 release](https://doc.coreboot.org/releases/coreboot-4.20.1-relnotes.html)
and Libreboot recently [updated](update202308.md) to a revision past that
release.

I'm very pleased to announce that Libreboot now *fully supports* this machine!
It was added in this patch:
<https://browse.libreboot.org/lbmk.git/commit/?id=f8f77cb2886331d1b8b26d88d2407e2f85dc59a2>

Information about the board can be found on the coreboot documentation:
<https://doc.coreboot.org/mainboard/hp/2170p.html>

This will be available in the next Libreboot release. For now, you
can [download Libreboot from Git](../git.md) and [build from
source](../docs/build/) if you wish to use this board. Read those instructions
first; with build dependencies then installed, you can build the board like
so:

	./build roms hp2170p_16mb

Installation instructions are being written for Libreboot, but you can refer
to the coreboot instructions for now.

Socketed flash IC!
------------------

I love HP EliteBooks. Truly. This is the only 11 inch laptop I've ever seen
that has socketed SOIC8 flash:

<img tabindex=1 class="l" style="max-width:35%" src="https://av.libreboot.org/hp2170p/hp2170p_socket.jpg" /><span class="f"><img src="https://av.libreboot.org/hp2170p/hp2170p_socket.jpg" /></span>

I flashed it with my [3.3v-modded](../docs/install/spi.md#do-not-use-ch341a)
CH341A - if you read that page, it says CH341A is ill advised, but if the
voltage is correct, flashing it in a socket like this is actually what that
programmer is intended for.

Mine is the black one, which has to be modified for correct voltage. Revision 1.6
which is the newer green model, is either 3.3v already or has a switch on it for
that.

After removing the flash IC, I flashed it in a spring socket adapter (SOP to
DIP) inserted into the CH341A's ZIF socket:

<img tabindex=1 class="r" style="max-width:35%" src="https://av.libreboot.org/hp2170p/ch341a_socket_soic8.jpg" /><span class="f"><img src="https://av.libreboot.org/hp2170p/ch341a_socket_soic8.jpg" /></span>

Basically everything works, on this laptop, as you would expect. NOTE: that
coreboot page says GRUB hangs on keyboard init, as of 9 August 2023. However,
this is no longer true. GRUB has fixed this, courtesy of a patch that Riku
Viitanen sent them.

Other works currently in progress
=================================

More boards coming soon
-----------------------

I'm on a spree, adding more boards to Libreboot, especially HP EliteBooks.

I have these boards, that I'm working on and testing; they will be available
in future revisions of Libreboot:

* HP ProBook 6360b - it has been added today to Libreboot, but it's not yet
  tested.
* HP Revolve 810 G1
* HP EliteBook Folio 9480m - it has been added already to Libreboot (WIP), but
  currently does not boot (more testing needed - not sure what my problem is
  yet, but it was added today).
* HP EliteBook 820 G2 (broadwell generation)
* HP Z220 workstation
* Dell OptiPlex 9010
* Dell Precision T1650

Another build system audit
--------------------------

I've also started another audit of the Libreboot build system; the [last
one](audit.md) was quite intense and a lot more work is going in for the
next release.
