---
title: Керівництво перенесення
...

NOTE: Libreboot standardises on [flashprog](https://flashprog.org/wiki/Flashprog)
now, as of 27 January 2024, which is a fork of flashrom.

Це керівнитво передбачається для тих, хто має дуже низький рівень знань про прошивку
загалом та coreboot окремо.
Більшість плат в coreboot може бути доволі легко перенесена в libreboot.
Ви не потребуєте ніяких знань окремої мови програмування або
технології загалом для перенесення плати.
Якщо ви бажаєте зробити більш суттєві внески до системи побудови,
будь ласка прочитайте [головну сторінку обслуговування.](/docs/maintain/index.html)

Ви точно будете потребувати обладнання для прошивки, якщо ви бажаєте проходити
це керівництво. Дивіться [керівництво прошивки](/docs/install/spi.html) для
винайдення того, що вам буде потрібно.

Coreboot це прошивка для заміни для чіпів прошивки на друкованих
платах (PCB) машини під питанням.
Libreboot є *дистрибутивом* Coreboot.
Ви можливо звикли посилатись до вашої машини як *машина, пристрій, ноутбук*
або його ім'я (наприклад: thinkpad t420).
Тому що наша ціль чіпи на PCB, ми посилаємося до всіх вище термінів синонімічно
як `плата.`
Залишок цієї статті буде посилатись до плати, яку ви бажаєте перенести до
libreboot як `плата.`

Якщо `плата` не підтримується в coreboot, тоді ви маєте почати там спочатку.
Розробники Libreboot зазвичайно не будуть переносити нові плати в coreboot за запитом.
Якщо ви не впевнені про те, чи ваша плата в coreboot, перевірте [таблицю апаратного забезпечення coreboot.](https://coreboot.org/status/board-status.html)

Якщо ви визначили, що `плата` підтримується coreboot, але не
підтримується libreboot, тоді проходьте залишок цього керівництво для спроби
перенести її самостійно. Як ви досі не можете перенести плату, або щось в цьому
керівництві не зрозуміло, тоді зв'яжіться з розробниками libreboot.
Найкращий шлях вийти на зв'язок через [irc libreboot.](/contact.uk.html#кімната-irc)

Клонування lbmk
============

Перед тим, як ви спробуєте зробити будь-яку роботу, вам потрібно буде клонувати проект lbmk (libreboot make).
Щоб зробити це, ви будете потребувати git, встановлений на вашій машині. Ви можете потім клонувати
проект.

	git clone https://codeberg.org/libreboot/lbmk

Якщо ви хочете більше інформації про побудову lbmk, дивіться [інструкції побудови.](/docs/build/index.uk.html)

Конфігурація Coreboot
===============

Корисні навантаження Coreboot (GRUB, Seabios, і так далі) будуються окремо.
Ви таким чином тільки потребуєте фокусуватись на конфігурації(ях) coreboot для `плати.`
Всі з цих конфігурацій зберігаються під config/coreboot/`плата`

Найпростіший шлях почати нову конфігурацію для даної плати це копіювати існуючу
конфігурацію і зробити потрібні модифікації.
Наприклад, якщо хтось хотів би перенести t420s, тоді конфігурація t420 була би відмінною
початковою точкою.

	cp -r config/coreboot/t420_12mb/ config/coreboot/t420s_12mb

Ви можете потім легко модифікувати існуючі конфігурації coreboot для вашої плати через lbmk.

	./update trees -m coreboot t420s_12mb

Цей сценарій надать інтерфейс curses, через який ви можете легко модифікувати
потрібні змінні та налаштування.
Найбліьш важлива річ - це змінити `Материнську плату (Mainboard).`
Ви мусити переконатись, що визначення материнської плати в цій конфігурації відповідає `платі.`
Наприклад, ви би хотіли змінити lenovo/t420 на lenovo/t420s.
Вибір `exit` в інтерфейсі curses виведе вам пропозицію зберегти ваші
зміни, переконайтесь, щоб відповідь так (yes).
Зробіть примітку, що ви загалом мусите пройти через цей процес двічі, оскільки існує
конфігурація corebootfb та txtmode для кожної плати (сценарій впорається з цим для вас).

Тепер ви можете побудувати та випробувати rom для `плати.`
Як тільки ви завершили це, ви можете спробувати прошивку отриманого rom на вашу плату в якості випробування.

	./build roms t420s_12mb

Якщо ви пробуєте прошити цей rom і це провалюється, тоді існує дві можливих причини:

1) Розмір CBFS або розмір ROM неправильний
2) Блоби є несумісними

Рішення до цих проблем ідуть в наступних розділах.

Неправильний розмір CBFS та/або розмір ROM
==========================

Різні плати мають різні налаштування чіпів флеш-пам'яті.
Загалом, ви маєте один або два флеш-пам'яті з сумарним розміром в 4-16Мбайт.
На щастя, flashprog дасть вам знати розмір флеш-чіпа, який ви прошиваєте.
Наприклад: коли прошиваєте X230, ви побачите, що один чіп 8192, та інший 4096.
Сумарний розмір rom тоді має бути встановлено на 12Мбайт.

Розмір CBFS залежить безпосередньо від розміру флеш-чіпа, який обрано.
Переконайтесь, що ваш розмір CBFS не більше, ніж максимум для вашої плати.
Розміри CBFS зазначено в hex значеннях, ось таблиця, яка показує правильні максимуми
для різноманітних розмірів rom.

| Розмір ROM | Розмір CBFS |
|:----------:|:-----------:|
| 8Мбайт     | 0x7E0000    |
| 12Мбайт    | 0xBE0000    |
| 16Мбайт    | 0xFE0000    |

Отримання допомоги
============

Коли ви спробували все вищенаведене, ви могли би знайти, що ця плата досі не
працює.
Якщо це той випадок, тоді вам варто зв'язатися з розробниками libreboot для більшої допомоги.
Ви можете ping `leah` на irc або відкрити проблемне питання на git.
В обох випадках, переконайтеся, що включено деталізований опис всього, що ви
спробували, і що точно сталося, коли ви спробували прошити rom.
Якщо ваша плата не підтримується в libreboot, тоді ви можете передбачати, що наші
розробники не мають її.
Тоді від вас будуть очікувати випробувати образи, створені розробниками libreboot
на вашій власній машині.

До того часу, ви можете завжди прошити зовнішньо резервну копію rom вашого
постачальника, щоб тримати вашу машину в працюючому стані, поки розробка проходить
над вашою платою.
