---
title: HP EliteBook 8460p
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../../news/safety.md),
OR YOU MIGHT BRICK YOUR MACHINE: [SAFETY PRECAUTIONS](../../news/safety.md)**

<div class="specs">
<center>
<img tabindex=1 alt="HP EliteBook 8460p" class="p" src="https://av.libreboot.org/hp8460p/hp8460p.webp" /><span class="f"><img src="https://av.libreboot.org/hp8460p/hp8460p.webp" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | HP                                             |
| **Name**                   | EliteBook 8460p                                |
| **Variants**               | EliteBook 8460p                                |
| **Released**               | 2011                                           |
| **Chipset**                | Intel QM67                                     |
| **CPU**                    | Intel Sandy Bridge (socketed)                  |
| **Graphics**               | Intel HD Graphics (supported in Libreboot) or
                               AMD Radeon HD 6470M (unsupported in Libreboot) |
| **Display**                | 14" 1366x768 or 1600x900 TFT                   |
| **Memory**                 | Two slots, max 8GB/slot (16GB), DDR3/SODIMM    |
| **Architecture**           | x86_64                                         |
| **EC**                     | SMSC KBC1126, proprietary (in main boot flash) |
| **Original boot firmware** | HP UEFI firmware                               |
| **Intel ME/AMD PSP**       | Present. Can be disabled with me_cleaner.      |
| **Flash chip**             | SOIC-8 8MiB (64Mbit)                           |


```
W+: Works without blobs;
N: Doesn't work;
W*: Works with blobs;
U: Untested;
P+: Partially works;
P*: Partially works with blobs
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | N  |
| **Display (if Intel GPU)**                        | W+ |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |
| **External output**                               | W+ |
| **Display brightness**                            | W+ |

| ***Payloads supported***  |           |
|---------------------------|-----------|
| **GRUB**                  | Works     |
| **SeaBIOS**               | Works     |
| **SeaBIOS with GRUB**     | Works     |
</div>
Introduction
============

**Unavailable in Libreboot 20231106 or earlier. You must [compile from
source](../build/), or use a release newer than 20231106.**

This is a beastly 14" Sandy Bridge platform from HP.
**NOTE: Until otherwise stated, only the Intel GPU variant is supported in
Libreboot.**

Build ROM image from source
---------------------------

The build target, when building from source, is thus:

	./build roms hp8460pintel_8mb

Installation
============

Insert binary files
-------------------

If you're using a release ROM, please ensure that you've inserted extra firmware
required refer to the [guide](../install/ivy_has_common.md) for that. (failure
to adhere to this advice will result in a bricked machine)

Set MAC address
---------------

This platform uses an Intel Flash Descriptor, and defines an Intel GbE NVM
region. As such, release/build ROMs will contain the same MAC address. To
change the MAC address, please read [nvmutil documentation](../install/nvmutil.md).

Flash a ROM image (software)
-----------------

If you're already running Libreboot, and you don't have flash protection
turned on, [internal flashing](../install/) is possible.

Flash a ROM image (hardware)
-----------------

**REMOVE all power sources like battery, charger and so on, before doing this.
This is to prevent short circuiting and power surges while flashing.**

For general information, please refer to [25xx NOR flash
instructions](../install/spi.md).

At this present time, disassembly instructions are unavailable from the
Libreboot project, but you can search for HP's own hardware maintenance manual
or look at videos online showing disassembly.

The flash chip is visible by removing the "bottom door" panel. But the
frame makes it hard to put a clip on it, so it's recommended to follow the
HP [service manual](https://h10032.www1.hp.com/ctg/Manual/c03015458.pdf)
to remove the **bottom cover**, as it's called.

