---
title: HP EliteBook 2570p
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../../news/safety.md),
OR YOU MIGHT BRICK YOUR MACHINE: [SAFETY PRECAUTIONS](../../news/safety.md)**

<div class="specs">
<center>
HP EliteBook 2570p
</center>

| ***Specifications***      |                                   |
|---------------------------|-----------------------------------|
| **Manufacturer**          | HP                                |
| **Name**                  | EliteBook 2570p                   |
| **Released**              | 2012                              |
| **Chipset**               | Intel QM77                        |
| **CPU**                   | Intel Ivy Bridge, socketed        |
| **Graphics**              | Intel HD Graphics                 |
| **Display**               | 12.5" 1366x768                    |
| **Memory**                | Up to 16GB (2x8GB)                |
| **Architecture**          | x86_64                            |
| **EC**                    | KBC1126, proprietary              |
| **Intel ME/AMD PSP**      | Present, neutered                 |
| **Flash chip**            | SOIC-16 16MiB                     |


| ***Payloads supported***  |       |
|---------------------------|-------|
| **GRUB**                  | Works |
| **SeaBIOS**               | Works |
| **SeaBIOS with GRUB**     | Works |
</div>


Introduction
============

Libreboot has support for this, in the Git repository and release versions
after (but not including) 20230423.

Brief board info
----------------

HP EliteBook 2570p is a 12.5" laptop very similar to the 2560p.
The only real difference seems to be that this shipped with Ivy Bridge
processors rather than Sandy Bridge, and has an USB 3.0 port.

You can read more specifications directly from HP:

<https://support.hp.com/us-en/document/c03412731>

The following is tested and confirmed working
thanks to `Johan Ehnberg (johan@molnix.com)`:

- Native raminit with 2+2 (matched or unmatched), 2+8 or 8+8 GiB RAM
- SeaBIOS and GRUB (booted Devuan and Ubuntu) (corebootfb+txtmode)
- S3 suspend to RAM
- Backlight control
- 2.5" SATA SSD
- Optical drive slot
- Gigabit Ethernet
- Mini-PCIe Wi-Fi
- SD card reader
- Bluetooth
- Touchpad
- Headphone jack, speakers and microphone
- Webcam
- Docking station: all ports except that weird extension port tested,
  hotplug and unplug work
- VGA & DisplayPort
- Fn combos, mute button
- "Launch browser" button: worked one day, not other.
  Probably just not configured in OS.

These were visible on lsusb, but no further tests were performed:

- Fingerprint sensor
- Smart card reader
- WWAN (3G modem)

Untested:

- Trackpoint (not present on cheap aftermarket keyboard tested)
- ExpressCard
- eSATA & mSATA (believed to work based on coreboot comments)

Not working:

- Radio button

Installation of Libreboot
-------------------------

You can actually just compile the Libreboot ROM for this, and flash the
entire ROM. The process is the same as 2560p, except you probably have
a SOIC-16 chip instead of SOIC-8. Follow these instructions:

<https://doc.coreboot.org/mainboard/hp/2560p.html#programming>

Refer to that coreboot guide for flashing instructions, and you can
build the images for it in Libreboot like so:

	./build roms hp2570p_16mb

More information about building ROM images can be found in
the [build guide](../build/).

This is an *Ivy Bridge* board which means that a neutered ME image is required
if you wish to flash the ME region. Libreboot's build system automatically
downloads, neuters (using `me_cleaner`) and inserts this if compiling from
source.

If you're using *Libreboot release* ROM images, the ME image has been scrubbed
and you must re-insert it. Use the information on this guide to know how
to do that:

[Insert vendor files on Intel Sandybridge/Ivybridge/Haswell
platforms](../install/ivy_has_common.md)

You may also wish to change the *default MAC address* if you're planning to
use the onboard Intel Gigabit Ethernet. You can do this using the information
in the same guide linked above, or read the nvmutil manual:

[Modify MAC addresses with nvmutil](../install/nvmutil.md).

