---
title: Dell OptiPlex 9020 SFF/MT (and 7020), and XE2 MT/SFF
x-toc-enable: true
...

**NOTE: Dell XE2 MT/SFF are also known to work, using the 9020 images. Same
motherboards as the 9020 and 7020.**

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../../news/safety.md),
OR YOU MIGHT BRICK YOUR MACHINE: [SAFETY PRECAUTIONS](../../news/safety.md)**

<div class="specs">
<center>
<img tabindex=1 alt="Dell OptiPlex 9020" class="p" src="https://av.libreboot.org/9020/9020sff.jpg" /><span class="f"><img src="https://av.libreboot.org/9020/9020sff.jpg" /></span>
<img tabindex=1 alt="Dell OptiPlex 9020" class="p" src="https://av.libreboot.org/9020/9020sff_ports.jpg" /><span class="f"><img src="https://av.libreboot.org/9020/9020sff_ports.jpg" /></span>
<br/>
<img tabindex=1 alt="Dell OptiPlex 9020" class="p" src="https://av.libreboot.org/9020/9020sff_inside.jpg" /><span class="f"><img src="https://av.libreboot.org/9020/9020sff_inside.jpg" /></span>
<img tabindex=1 alt="Dell OptiPlex 9020" class="p" src="https://av.libreboot.org/9020/9020mt.jpg" /><span class="f"><img src="https://av.libreboot.org/9020/9020mt.jpg" /></span>
<br/>
<img tabindex=1 alt="Dell OptiPlex 9020" class="p" src="https://av.libreboot.org/9020/9020mt_ports.jpg" /><span class="f"><img src="https://av.libreboot.org/9020/9020mt_ports.jpg" /></span>
<img tabindex=1 alt="Dell OptiPlex 9020" class="p" src="https://av.libreboot.org/9020/9020mt_inside.jpg" /><span class="f"><img src="https://av.libreboot.org/9020/9020mt_inside.jpg" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | Dell                                           |
| **Name**                   | OptiPlex 9020 SFF/MT                                |
| **Variants**               | OptiPlex 9020 SFF/MT                                |
| **Chipset**                | Intel Q87 Express                                     |
| **CPU**                    | Intel Haswell                               |
| **Graphics**               | Intel HD Graphics |
| **Memory**                 | DDR3 DIMMs (max 32GB, 4x8GB)    |
| **Architecture**           | x86_64                                         |
| **Original boot firmware** | Dell UEFI firmware                             |
| **Intel ME/AMD PSP**       | Present. Can be disabled with me_cleaner.      |
| **Flash chip**             | 2x SOIC-8, 12MiB (8+4) (96Mbit)           |


```
W+: Works without blobs; 
N: Doesn't work; 
W*: Works with blobs; 
U: Untested; 
P+: Partially works; 
P*: Partially works with blobs
?: UNKNOWN AT THIS TIME
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | W+ |
| **Display (if Intel GPU)**                        | W+ |
| **Display (discrete CPU, SeaBIOS payload only)**  | W* |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |

| ***Payloads supported***   |           |
|----------------------------|-----------|
| **GRUB (libgfxinit only)** | Works     |
| **SeaBIOS**                | Works     |
| **SeaBIOS with GRUB**      | Works     |
</div>
Introduction
============

**Unavailable in Libreboot 20240126 or earlier. You must [compile from
source](../build/), or use a version newer than Libreboot 20240126**

Official information about this machine can be found here:
<https://i.dell.com/sites/doccontent/shared-content/data-sheets/en/Documents/optiplex-9020-micro-technical-spec-sheet.pdf>

Buy Libreboot preinstalled
======================

You can buy this machine professionally serviced, with Libreboot preinstalled
and your choice of Linux/BSD system. Many upgrades are also available. See:

<https://minifree.org/product/libreboot-9020/>

Sales are conducted to provide funding for the Libreboot project. Leah Rowe
who runs Minifree, is also Libreboot's founder and lead developer.

Patch
=====

Mate Kukri is the author of the original coreboot port. Thanks go to Kukri.
Kukri's patch is here:

<https://review.coreboot.org/c/coreboot/+/55232/31>

This patch, at this revision (patchset 31), is what Libreboot uses for this
port.

QUBES: how to get it working
-------------------

Qubes requires IOMMU to be turned on. Please now read the next section.
Qubes *WILL* work, if you configure Libreboot as directed below, but otherwise
it will fail by default. This is because Libreboot *disables the IOMMU by
default*, on this board.

Graphics cards and IOMMU
--------------

IOMMU is buggy for some reason (we don't know why yet), when you plug in
a graphics card. The graphics card simply won't work. On some of them,
you can use the console but as soon as you start xorg, it will just b0rk.

Current Libreboot revisions *disable IOMMU by default*, on this board. The
coreboot code for initialising IOMMU was modified by the Libreboot project, to
make it a toggle. IOMMU works fine if you use only Intel graphics.

The way coreboot works is this: if vt-d is present on the CPU, it enables an
IOMMU, and only if vt-d is present. This is still the behaviour in Libreboot,
but Libreboot adds an additional check: if `iommu` is not set in nvram, it
defaults to on, but if it's set to disabled, then IOMMU is not initialised.

On all other Haswell boards, LIbreboot enables IOMMU by default. To enable
it on the 9020, do this on your ROM:

	nvramtool -C libreboot.rom -w iommu=Enable

Then flash the ROM image. You can find nvram
under `src/coreboot/default/util/nvramtool`. Do this in lbmk if you don't
already havse `src/coreboot/default/`:

	./update trees -f coreboot default

Then do this:

	make -C src/coreboot/default/util/nvramtool

The binary `nvramtool` will then live in that directory. More information
available in [Libreboot build instructions](../build/). Information about
dumping/flashing the ROM can be found
in [Libreboot flashing instructions](../install/)
and [Libreboot external flashing instructions](../install/spi.md).

NOTE: If IOMMU is enabled, you can still use a graphics card, but you must
pass this on the Linux cmdline paramaters: `iommu=off`

NOTE2: Libreboot uses a *static option table* on all boards that have nvram,
which is why you must use the `-C` option on your ROM, to change the static
table that is baked into it.

Here is an example of the type of errors we got when testing graphics cards
with IOMMU enabled:

<https://av.vimuser.org/error.jpg>

Make sure to configure your image accordingly.

7020 compatibility
------------------

7020/9020 MT each have the same motherboard. Flash the 9020 ROM from Libreboot
on your 7020, and it will work.

Ditto 7020/9020 SFF, it's the same motherboard. However, Libreboot provides
separate targets for MT and SFF.

Build ROM image from source
---------------------------

For the MT variant (7020 MT and 9020 MT):

	./build roms dell9020mt_12mb

For the SFF variant (7020 SFF and 9020 SFF):

	./build roms dell9020sff_12mb

It is important that you choose the right one. The MT variant is the full
MTX tower.

Installation
============

Insert binary files
-------------------

If you're using a release ROM, please ensure that you've inserted extra firmware
required refer to the [guide](../install/ivy_has_common.md) for that. (failure
to adhere to this advice will result in a bricked machine)

Libreboot's build system automatically downloads and processes these files if
you build Libreboot from source, but the same logic that it uses must be re-run
if you're using a release image.

Set MAC address
---------------

This platform uses an Intel Flash Descriptor, and defines an Intel GbE NVM
region. As such, release/build ROMs will contain the same MAC address. To
change the MAC address, please read [nvmutil documentation](../install/nvmutil.md).

Flash a ROM image (software)
-----------------

If you're already running Libreboot, and you don't have flash protection
turned on, [internal flashing](../install/) is possible.

Internal flashing can also be done with the original Dell BIOS, if the
SERVICE_MODE jumper near the PCIe slots is installed. Before flashing,

	rmmod spi-intel-platform

needs to be run to prevent errors. Once Libreboot is installed, the
SERVICE_MODE jumper can be removed.

**Note: The Dell BIOS can write EFI variables to flash when shutting
down, which could corrupt the newly flashed Libreboot ROM and render
the system unusable. To prevent this, after flashing internally from
the original Dell BIOS, remove power from the computer instead of
shutting it down normally. It's recommended to use a live USB instead
of the internal drive to prevent potential filesystem corruption.**

Flash a ROM image (hardware)
-----------------

**REMOVE all power sources and connectors from the machine, before doing this.
This is to prevent short circuiting and power surges while flashing.**

For general information, please refer to [25xx NOR flash
instructions](../install/spi.md) - that page refers to use of socketed flash.

There are two SOIC-8 chips. You can split up your 12MB ROM image
like so:

	dd if=libreboot.rom of=4mb.rom bs=1M skip=8
	dd if=libreboot.rom of=8mb.rom bs=1M count=8

The side cover comes off easily, and you can find the flash ICs next to the RAM.

Here's the SOIC8 ICs being flashed:

<img tabindex=1 alt="SOIC8 flash IC on 9020 SFF" style="max-width:35%" src="https://av.libreboot.org/9020/9020sff_flash1.jpg" /><span class="f"><img src="https://av.libreboot.org/9020/9020sff_flash1.jpg" /></span>
<img tabindex=1 alt="SOIC8 flash IC on 9020 SFF" style="max-width:35%" src="https://av.libreboot.org/9020/9020sff_flash2.jpg" /><span class="f"><img src="https://av.libreboot.org/9020/9020sff_flash2.jpg" /></span>

Enjoy!
