/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2012 Google Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdint.h>
#include "i915io.h"

struct iodef iodefs[] = {
	{V, 0},
	{W, 1, "", PCH_GMBUS0, 0x00000000, 0},
	{R, 1, "", PP_ON_DELAYS, ( /* T2 */ 0x0 << 16) | ( /* T5 */ 0x0 << 0) | 0x00000000, 0},
	{R, 1, "", PP_OFF_DELAYS, ( /* T3 */ 0x0 << 16) | ( /* Tx */ 0x0 << 0) | 0x00000000, 0},
	{W, 1, "", PP_ON_DELAYS, ( /* T2 */ 0x190 << 16) | ( /* T5 */ 0x7d0 << 0) | 0x019007d0, 0},
	{W, 1, "", PP_OFF_DELAYS, ( /* T3 */ 0x15e << 16) | ( /* Tx */ 0x7d0 << 0) | 0x015e07d0, 0},
	{M, 1, "[drm:intel_detect_pch], Found PatherPoint PCH", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:i915_load_modeset_init], failed to find VBIOS tables", 0x0, 0xcf8e64, 0},
	{R, 50, "", FORCEWAKE_MT_ACK, 0x00000001, 10},
	{W, 1, "", FORCEWAKE_MT, 0x00010001, 0},
	{R, 1, "", FORCEWAKE_MT, 0x00010001, 0},
	{R, 1, "", FORCEWAKE_MT_ACK, 0x00000001, 0},
	{R, 1, "", 0x13805c, 0x40000000, 0},
	{R, 1, "", 0xa180, 0x84100020, 0},
	{W, 1, "", FORCEWAKE_MT, 0x00010000, 0},
	{R, 1, "", 0x120000, 0x00000000, 0},
	{M, 1, "[drm:intel_init_display], Using MT version of forcewake", 0x0, 0xcf8e64, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{M, 1, "[drm:intel_modeset_init], 3 display pipes available.", 0x0, 0xcf8e64, 0},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_8 | PIPECONF_DITHER_TYPE_SP | 0x00000000, 0},
	{W, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_8 | PIPECONF_DITHER_TYPE_SP | 0x00000000, 0},
	{R, 1, "", _PIPEBCONF, 0x00000000, 0},
	{W, 1, "", _PIPEBCONF, 0x00000000, 0},
	{R, 1, "", 0x72008, 0x00000000, 0},
	{W, 1, "", 0x72008, 0x00000000, 0},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_8 | PIPECONF_DITHER_TYPE_SP | 0x00000000, 0},
	{W, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_8 | PIPECONF_DITHER_TYPE_SP | 0x00000000, 0},
	{R, 1, "", _PIPEBCONF, 0x00000000, 0},
	{W, 1, "", _PIPEBCONF, 0x00000000, 0},
	{R, 1, "", 0x72008, 0x00000000, 0},
	{W, 1, "", 0x72008, 0x00000000, 0},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_8 | PIPECONF_DITHER_TYPE_SP | 0x00000000, 0},
	{W, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_8 | PIPECONF_DITHER_TYPE_SP | 0x00000000, 0},
	{R, 1, "", _PIPEBCONF, 0x00000000, 0},
	{W, 1, "", _PIPEBCONF, 0x00000000, 0},
	{R, 1, "", 0x72008, 0x00000000, 0},
	{W, 1, "", 0x72008, 0x00000000, 300},
	{W, 1, "", CPU_VGACNTRL, 0x80000000, 0},
	{R, 1, "", CPU_VGACNTRL, 0x80000000, 0},
	{R, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000001c, 0},
	{R, 1, "", PCH_PP_ON_DELAYS, PANEL_PORT_SELECT_DPA | ( /* PANEL_POWER_UP_DELAY */ 0x7d0 << 16) | ( /* PANEL_LIGHT_ON_DELAY */ 0x7d0 << 0) | 0x47d007d0, 0},
	{R, 1, "", PCH_PP_OFF_DELAYS, ( /* PANEL_POWER_DOWN_DELAY */ 0x1f4 << 16) | ( /* PANEL_LIGHT_OFF_DELAY */ 0x7d0 << 0) | 0x01f407d0, 0},
	{R, 1, "", PCH_PP_DIVISOR, 0x00186906, 0},
	{M, 1, "[drm:intel_dp_init], cur t1_t3 2000 t8 2000 t9 2000 t10 500t11_t12 6000", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_init], vbt t1_t3 0 t8 0 t9 0 t10 0 t11_t12 0", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_init], panel power up delay 200,power down" "delay 50, power cycle delay 600", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_init], backlight on delay 200, off delay 200", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:ironlake_edp_panel_vdd_on], Turn eDP VDD on", 0x0, 0xcf8e64, 0},
	{R, 1, "", PCH_PP_CONTROL, 0x00000000, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{M, 1, "[drm:ironlake_wait_panel_power_cycle], Wait for panel power cycle", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:ironlake_wait_panel_status], R PCH_PP_CONTROL:00000000", 0x0, 0xcf8e64, 0},
	{R, 2, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, 0x00000000, 0},
	{W, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{M, 1, "[drm:ironlake_edp_panel_vdd_on], R PCH_PP_CONTROL:abcd0008", 0x0, 0xcf8e64, 0},
	{R, 2, "", PCH_PP_STATUS, 0x00000000, 0},
	{M, 1, "[drm:ironlake_edp_panel_vdd_on], eDP was not running", 0x0, 0xcf8e64, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{M, 1, "[drm:intel_dp_i2c_init], i2c_init DPDDC-A", 0x0, 0x00000000, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{I,},
	{M, 1, "[drm:ironlake_edp_panel_vdd_off], Turn eDP VDD off 1", 0x0, 0x00000000, 0},
	{R, 1, "", BLC_PWM_CPU_CTL, 0x000010ce, 0},
	{M, 1, "[drm:intel_panel_get_backlight], get backlight PWM = 4302", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_aux_ch], dp_aux_ch timeout status 0x5145003f", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_i2c_aux_ch], aux_ch failed -110", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:ironlake_init_pch_refclk], has_panel 1 has_lvds 0 " "has_pch_edp 0has_cpu_edp 1 has_ck505 0", 0x0, 0xcf8e64, 0},
	{R, 1, "", PCH_DREF_CONTROL, 0x00000000, 0},
	{M, 1, "[drm:ironlake_init_pch_refclk], Using SSC on panel", 0x0, 0xcf8e64, 0},
	{W, 1, "", PCH_DREF_CONTROL, DREF_SSC_SOURCE_ENABLE | DREF_NONSPREAD_SOURCE_ENABLE | DREF_SSC1_ENABLE | 0x00001402, 0},
	{R, 1, "", PCH_DREF_CONTROL, DREF_SSC_SOURCE_ENABLE | DREF_NONSPREAD_SOURCE_ENABLE | DREF_SSC1_ENABLE | 0x00001402, 200},
	{M, 1, "[drm:ironlake_init_pch_refclk], Using SSC on eDP", 0x0, 0xcf8e64, 0},
	{W, 1, "", PCH_DREF_CONTROL, DREF_CPU_SOURCE_OUTPUT_DOWNSPREAD | DREF_SSC_SOURCE_ENABLE | DREF_NONSPREAD_SOURCE_ENABLE | DREF_SSC1_ENABLE | 0x00005402, 0},
	{R, 1, "", PCH_DREF_CONTROL, DREF_CPU_SOURCE_OUTPUT_DOWNSPREAD | DREF_SSC_SOURCE_ENABLE | DREF_NONSPREAD_SOURCE_ENABLE | DREF_SSC1_ENABLE | 0x00005402, 200},
	{W, 1, "", ILK_DSPCLK_GATE, IVB_VRHUNIT_CLK_GATE | 0x10000000, 0},
	{W, 1, "", WM3_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{W, 1, "", WM2_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{W, 1, "", WM1_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{W, 1, "", 0x9404, 0x00002000, 0},
	{W, 1, "", ILK_DSPCLK_GATE, IVB_VRHUNIT_CLK_GATE | 0x10000000, 0},
	{W, 1, "", IVB_CHICKEN3, 0x00000024, 0},
	{W, 1, "", GEN7_COMMON_SLICE_CHICKEN1, 0x04000400, 0},
	{W, 1, "", 0xb01c, 0x3c4fff8c, 0},
	{W, 1, "", GEN7_L3_CHICKEN_MODE_REGISTER, 0x20000000, 0},
	{R, 1, "", GEN7_SQ_CHICKEN_MBCUNIT_CONFIG, 0x00000000, 0},
	{W, 1, "", GEN7_SQ_CHICKEN_MBCUNIT_CONFIG, 0x00000800, 0},
	{R, 1, "", _DSPACNTR, ( /* DISPPLANE_SEL_PIPE(0=A,1=B) */ 0x0 << 24) | 0x00000000, 0},
	{W, 1, "", _DSPACNTR, ( /* DISPPLANE_SEL_PIPE(0=A,1=B) */ 0x0 << 24) | DISPPLANE_TRICKLE_FEED_DISABLE /* Ironlake */  | 0x00004000, 0},
	{R, 1, "", _DSPAADDR, 0x00000000, 0},
	{W, 1, "", _DSPAADDR, 0x00000000, 0},
	{R, 1, "", _DSPASIZE + 0xc, 0x00000000, 0},
	{W, 1, "", _DSPASIZE + 0xc, 0x00000000, 0},
	{R, 1, "", _DSPBCNTR, 0x00000000, 0},
	{W, 1, "", _DSPBCNTR, 0x00004000, 0},
	{R, 1, "", _DSPBADDR, 0x00000000, 0},
	{W, 1, "", _DSPBADDR, 0x00000000, 0},
	{R, 1, "", _DSPBSURF, 0x00000000, 0},
	{W, 1, "", _DSPBSURF, 0x00000000, 0},
	{R, 1, "", _DVSACNTR, 0x00000000, 0},
	{W, 1, "", _DVSACNTR, DVS_TRICKLE_FEED_DISABLE | 0x00004000, 0},
	{R, 1, "", _DVSALINOFF, 0x00000000, 0},
	{W, 1, "", _DVSALINOFF, 0x00000000, 0},
	{R, 1, "", _DVSASURF, 0x00000000, 0},
	{W, 1, "", _DVSASURF, 0x00000000, 0},
	{W, 1, "", SOUTH_DSPCLK_GATE_D, PCH_DPLSUNIT_CLOCK_GATE_DISABLE | 0x20000000, 0},
	{R, 1, "", SOUTH_CHICKEN2, 0x00000000, 0},
	{W, 1, "", SOUTH_CHICKEN2, DPLS_EDP_PPS_FIX_DIS | 0x00000001, 0},
	{W, 1, "", _TRANSA_CHICKEN2, 0x80000000, 0},
	{W, 1, "", _TRANSB_CHICKEN2, TRANS_AUTOTRAIN_GEN_STALL_DIS | 0x80000000, 0},
	{M, 1, "[drm:drm_edid_to_eld], ELD:no CEA Extension found", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_helper_probe_single_connector_modes], " "[CONNECTOR:6:eDP-1]probed modes :", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_mode_debug_printmodeline],Modeline 0:\"2560x1700\" " "60 285250 2560 2608 2640 2720 1700 1703 1713 17490x48 0xa", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_setup_crtcs], ", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_enable_connectors], connector 6 enabled? yes", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_setup_crtcs], picking CRTCs for 8192x8192 config", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_setup_crtcs], desired mode 2560x1700 set on crtc 3", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_helper_probe_single_connector_modes], [CONNECTOR:6:eDP-1]", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_detect], DPCD:110a8441000001c0", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:ironlake_edp_panel_vdd_on], Turn eDP VDD on", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_detect], DPCD:110a8441000001c0", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_enable_connectors], connector 6 enabled? yes", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_get_load_detect_pipe], [CONNECTOR:6:eDP-1],[ENCODER:7:TMDS-7]", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_mode_fixup], Display port link bw 0a lane count 4clock 270000", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_crtc_helper_set_mode], [CRTC:3]", 0x0, 0xcf8e64, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{I,},
	{R, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000001c, 0},
	{M, 1, "[drm:ironlake_edp_panel_vdd_off], Turn eDP VDD off 1", 0x0, 0xcf8e64, 0},
	{R, 2, "", PCH_DP_D, 0x00000004, 0},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_8 | PIPECONF_DITHER_TYPE_SP | 0x00000000, 0},
	{W, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_TYPE_SP | 0x00000040, 0},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_TYPE_SP | 0x00000040, 0},
	{M, 1, "[drm:ironlake_crtc_mode_set], Mode for pipe 0:", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_mode_debug_printmodeline],Modeline 0:\"2560x1700\" " "60 285250 2560 2608 2640 2720 1700 1703 1713 1749 0x48 0xa", 0x0, 0xcf8e64, 0},
	{W, 1, "", _TRANSA_DATA_M1, 0x00000000, 0},
	{W, 1, "", _TRANSA_DATA_N1, 0x00000000, 0},
	{W, 1, "", _TRANSA_DP_LINK_M1, 0x00000000, 0},
	{W, 1, "", _TRANSA_DP_LINK_N1, 0x00000000, 0},
	{W, 1, "", _PCH_FPA1, 0x00020e08, 0},
	{W, 1, "", _VSYNCSHIFT_A, 0x00000000, 0},
	{W, 1, "", _HTOTAL_A, 0x0a9f09ff, 0},
	{W, 1, "", _HBLANK_A, 0x0a9f09ff, 0},
	{W, 1, "", _HSYNC_A, 0x0a4f0a2f, 0},
	{W, 1, "", _VTOTAL_A, 0x06d406a3, 0},
	{W, 1, "", _VBLANK_A, 0x06d406a3, 0},
	{W, 1, "", _VSYNC_A, 0x06b006a6, 0},
	{W, 1, "", _PIPEASRC, 0x09ff06a3, 0},
	{W, 1, "", _PIPEA_DATA_M1, 0x7e4e58a4, 0},
	{W, 1, "", _PIPEA_DATA_N1, 0x0083d600, 0},
	{W, 1, "", _PIPEA_LINK_M1, 0x00045a42, 0},
	{W, 1, "", _PIPEA_LINK_N1, 0x00041eb0, 0},
	{M, 1, "[drm:ironlake_set_pll_edp], eDP PLL enable for clock 270000", 0x0, 0xcf8e64, 0},
	{R, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000001c, 0},
	{W, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000001c, 0},
	{R, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000001c, 500},
	{W, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_EN | PIPECONF_DITHER_TYPE_SP | 0x00000050, 0},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_EN | PIPECONF_DITHER_TYPE_SP | 0x00000050, 0},
	{R, 1, "", _PIPEASTAT, 0x00000000, 0},
	{W, 1, "", _PIPEASTAT, PIPE_VBLANK_INTERRUPT_STATUS | 0x00000002, 0},
	{R, 4562, "", _PIPEASTAT, 0x00000000, 0},
	{M, 1, "[drm:intel_wait_for_vblank], vblank wait timed out", 0x0, 0xcf8e64, 0},
	{W, 1, "", _DSPACNTR, DISPPLANE_GAMMA_ENABLE | ( /* DISPPLANE_SEL_PIPE(0=A,1=B) */ 0x0 << 24) | 0x40000000, 0},
	{R, 2, "", _DSPACNTR, DISPPLANE_GAMMA_ENABLE | ( /* DISPPLANE_SEL_PIPE(0=A,1=B) */ 0x0 << 24) | 0x40000000, 0},
	{W, 1, "", _DSPACNTR, DISPPLANE_GAMMA_ENABLE | (DISPPLANE_32BPP_NO_ALPHA & 0x18000000) | ( /* DISPPLANE_SEL_PIPE(0=A,1=B) */ 0x0 << 24) | DISPPLANE_TRICKLE_FEED_DISABLE /* Ironlake */  | 0x58004000, 0},
	{M, 1, "[drm:ironlake_update_plane], Writing base 00000000 00000000 0 0 10240", 0x0, 0xcf8e64, 0},
	{W, 1, "", _DSPASTRIDE, 0x00002800, 0},
	{W, 1, "", _DSPASIZE + 0xc, 0x00000000, 0},
	{W, 1, "", _DSPACNTR + 0x24, 0x00000000, 0},
	{W, 1, "", _DSPAADDR, 0x00000000, 0},
	{R, 1, "", _DSPACNTR, DISPPLANE_GAMMA_ENABLE | (DISPPLANE_32BPP_NO_ALPHA & 0x18000000) | ( /* DISPPLANE_SEL_PIPE(0=A,1=B) */ 0x0 << 24) | DISPPLANE_TRICKLE_FEED_DISABLE /* Ironlake */  | 0x58004000, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{R, 1, "", WM0_PIPEA_ILK, 0x00783818, 0},
	{W, 1, "", WM0_PIPEA_ILK, 0x00183806, 0},
	{M, 1, "[drm:sandybridge_update_wm], FIFO watermarks For pipe A - plane 24,cursor:6", 0x0, 0xcf8e64, 0},
	{W, 1, "", WM3_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{W, 1, "", WM2_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{W, 1, "", WM1_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{M, 1, "[drm:ironlake_check_srwm], watermark 1:display plane 38, fbc lines 3,cursor 6", 0x0, 0xcf8e64, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{W, 1, "", WM1_LP_ILK, WMx_LP_SR_EN | ( /* WMx_LP_LATENCY */ 0x4 << 24) | ( /* WMx_LP_FBC */ 0x3 << 20) | ( /* WMx_LP_SR */ 0x26 << 8) | ( /* WMx_LP_CURSOR */ 0x6 << 0) | 0x84302606, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{M, 1, "[drm:ironlake_check_srwm], watermark 2:display plane 145, " "fbc lines 3,cursor 6", 0x0, 0xcf8e64, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{W, 1, "", WM2_LP_ILK, WMx_LP_SR_EN | ( /* WMx_LP_LATENCY */ 0x10 << 24) | ( /* WMx_LP_FBC */ 0x3 << 20) | ( /* WMx_LP_SR */ 0x91 << 8) | ( /* WMx_LP_CURSOR */ 0x6 << 0) | 0x90309106, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{M, 1, "[drm:ironlake_check_srwm], watermark 3:display plane " "288, fbc lines 4,cursor 10", 0x0, 0xcf8e64, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{W, 1, "", WM3_LP_ILK, WMx_LP_SR_EN | ( /* WMx_LP_LATENCY */ 0x20 << 24) | ( /* WMx_LP_FBC */ 0x4 << 20) | ( /* WMx_LP_SR */ 0x120 << 8) | ( /* WMx_LP_CURSOR */ 0xa << 0) | 0xa041200a, 0},
	{M, 1, "[drm:drm_crtc_helper_set_mode], [ENCODER:7:TMDS-7]set [MODE:0:2560x1700]", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:ironlake_edp_pll_on], ", 0x0, 0xcf8e64, 0},
	{R, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000001c, 0},
	{W, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000401c, 0},
	{R, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000401c, 200},
	{R, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_VOLTAGE_0_4 | DP_PRE_EMPHASIS_0 | DP_PORT_WIDTH_1 | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_SYNC_VS_HIGH | DP_SYNC_HS_HIGH | DP_DETECTED | 0x0000401c, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{R, 1, "", WM0_PIPEA_ILK, 0x00183806, 0},
	{W, 1, "", WM0_PIPEA_ILK, 0x00183806, 0},
	{M, 1, "[drm:sandybridge_update_wm], FIFO watermarks For pipe A - plane 24,cursor:6", 0x0, 0xcf8e64, 0},
	{W, 1, "", WM3_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{W, 1, "", WM2_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{W, 1, "", WM1_LP_ILK, ( /* WMx_LP_LATENCY */ 0x0 << 24) | ( /* WMx_LP_FBC */ 0x0 << 20) | ( /* WMx_LP_SR */ 0x0 << 8) | ( /* WMx_LP_CURSOR */ 0x0 << 0) | 0x00000000, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{M, 1, "[drm:ironlake_check_srwm], watermark 1:display plane 38, fbc lines 3,cursor 6", 0x0, 0xcf8e64, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{W, 1, "", WM1_LP_ILK, WMx_LP_SR_EN | ( /* WMx_LP_LATENCY */ 0x4 << 24) | ( /* WMx_LP_FBC */ 0x3 << 20) |( /* WMx_LP_SR */ 0x26 << 8) | ( /* WMx_LP_CURSOR */ 0x6 << 0) | 0x84302606, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{M, 1, "[drm:ironlake_check_srwm], watermark 2:display plane 145, " "fbc lines 3,cursor 6", 0x0, 0xcf8e64, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{W, 1, "", WM2_LP_ILK, WMx_LP_SR_EN | ( /* WMx_LP_LATENCY */ 0x10 << 24) | ( /* WMx_LP_FBC */ 0x3 << 20) |( /* WMx_LP_SR */ 0x91 << 8) | ( /* WMx_LP_CURSOR */ 0x6 << 0) | 0x90309106, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{M, 1, "[drm:ironlake_check_srwm], watermark 3:display plane 288, " "fbc lines 4,cursor 10", 0x0, 0xcf8e64, 0},
	{R, 1, "", 0x145d10, 0x2010040c, 0},
	{W, 1, "", WM3_LP_ILK, WMx_LP_SR_EN | ( /* WMx_LP_LATENCY */ 0x20 << 24) | ( /* WMx_LP_FBC */ 0x4 << 20) |( /* WMx_LP_SR */ 0x120 << 8) | ( /* WMx_LP_CURSOR */ 0xa << 0) | 0xa041200a, 0},
	{R, 1, "", _FDI_TXA_CTL, 0x00040000, 0},
	{W, 1, "", _FDI_TXA_CTL, 0x00040000, 0},
	{R, 1, "", _FDI_TXA_CTL, 0x00040000, 0},
	{R, 1, "", _FDI_RXA_CTL, 0x00000040, 0},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_EN | PIPECONF_DITHER_TYPE_SP | 0x00000050, 0},
	{W, 1, "", _FDI_RXA_CTL, 0x00020040, 0},
	{R, 1, "", _FDI_RXA_CTL, 0x00020040, 100},
	{R, 1, "", SOUTH_CHICKEN1, 0x00000000, 0},
	{W, 2, "", SOUTH_CHICKEN1, 0x00000000, 0},
	{R, 1, "", SOUTH_CHICKEN1, 0x00000000, 0},
	{R, 1, "", _FDI_TXA_CTL, 0x00040000, 0},
	{W, 1, "", _FDI_TXA_CTL, 0x00040000, 0},
	{R, 1, "", _FDI_RXA_CTL, 0x00020040, 0},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_EN | PIPECONF_DITHER_TYPE_SP | 0x00000050, 0},
	{W, 1, "", _FDI_RXA_CTL, 0x00020040, 0},
	{R, 1, "", _FDI_RXA_CTL, 0x00020040, 100},
	{P, 1, "Set Palette"},
	{R, 1, "", _PIPEACONF, ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_EN | PIPECONF_DITHER_TYPE_SP | 0x00000050, 0},
	{W, 1, "", _PIPEACONF, PIPECONF_ENABLE | ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_EN | PIPECONF_DITHER_TYPE_SP | 0x80000050, 0},
	{R, 1, "", _PIPEASTAT, 0x00000000, 0},
	{W, 1, "", _PIPEASTAT, PIPE_VBLANK_INTERRUPT_STATUS | 0x00000002, 0},
	{R, 4533, "", _PIPEASTAT, 0x00000000, 0},
	{M, 1, "[drm:intel_wait_for_vblank], vblank wait timed out", 0x0, 0xcf8e64, 0},
	{R, 1, "", _PIPEACONF, PIPECONF_ENABLE | PIPECONF_DOUBLE_WIDE | ( /* PIPECONF_FRAME_START_DELAY_MASK */ 0x0 << 27) | PIPECONF_BPP_6 | PIPECONF_DITHER_EN | PIPECONF_DITHER_TYPE_SP |0xc0000050, 0},
	{R, 1, "", _DSPACNTR, DISPPLANE_GAMMA_ENABLE | (DISPPLANE_32BPP_NO_ALPHA & 0x18000000) | ( /* DISPPLANE_SEL_PIPE(0=A,1=B) */ 0x0 << 24) | DISPPLANE_TRICKLE_FEED_DISABLE /* Ironlake */  | 0x58004000, 0},
	{W, 1, "", _DSPACNTR, DISPLAY_PLANE_ENABLE | DISPPLANE_GAMMA_ENABLE | (DISPPLANE_32BPP_NO_ALPHA & 0x18000000) | ( /* DISPPLANE_SEL_PIPE(0=A,1=B) */ 0x0 << 24) | DISPPLANE_TRICKLE_FEED_DISABLE /* Ironlake */  | 0xd8004000, 0},
	{R, 1, "", _DSPAADDR, 0x00000000, 0},
	{W, 1, "", _DSPAADDR, 0x00000000, 0},
	{R, 1, "", _DSPASIZE + 0xc, 0x00000000, 0},
	{W, 1, "", _DSPASIZE + 0xc, 0x00000000, 0},
	{R, 1, "", _PIPEASTAT, 0x00000000, 0},
	{W, 1, "", _PIPEASTAT, PIPE_VBLANK_INTERRUPT_STATUS | 0x00000002, 0},
	{R, 4392, "", _PIPEASTAT, 0x00000000, 0},
	{M, 1, "[drm:intel_wait_for_vblank], vblank wait timed out", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:ironlake_edp_panel_vdd_on], Turn eDP VDD on", 0x0, 0xcf8e64, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{M, 1, "[drm:ironlake_edp_panel_on], Turn eDP power on", 0x0, 0xcf8e64, 0},
	{R, 1, "", PCH_PP_STATUS, 0x00000000, 0},
	{M, 1, "[drm:ironlake_wait_panel_power_cycle], Wait for panel power cycle", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:ironlake_wait_panel_status], R PCH_PP_CONTROL:abcd0008", 0x0, 0xcf8e64, 0},
	{R, 2, "", PCH_PP_STATUS, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | 0xabcd0008, 0},
	{W, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | PANEL_POWER_RESET | PANEL_POWER_ON | 0xabcd000b, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | PANEL_POWER_RESET | PANEL_POWER_ON | 0xabcd000b, 0},
	{M, 1, "[drm:ironlake_wait_panel_on], Wait for panel power on", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:ironlake_wait_panel_status], R PCH_PP_CONTROL:abcd000b", 0x0, 0xcf8e64, 0},
	{R, 4, "", PCH_PP_STATUS, /*undocbit3 | undocbit1 | */ 0x0000000a, 0},
	{R, 16983, "", PCH_PP_STATUS, PP_ON | PP_SEQUENCE_POWER_UP | /*undocbit3 | undocbit1 | */ 0x9000000a, 0},
	{R, 17839, "", PCH_PP_STATUS, PP_ON | PP_SEQUENCE_POWER_UP | /*undocbit3 | undocbit0 | */ 0x90000009, 0},
	{R, 1, "", PCH_PP_STATUS, PP_ON | /*undocbit3 | */ 0x80000008, 0},
	{M, 1, "[drm:ironlake_edp_panel_vdd_off], Turn eDP VDD off 1", 0x0, 0xcf8e64, 0},
	{R, 2, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_FORCE_VDD | PANEL_POWER_RESET | PANEL_POWER_ON | 0xabcd000b, 0},
	{W, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | PANEL_POWER_RESET | PANEL_POWER_ON | 0xabcd0003, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | PANEL_POWER_RESET | PANEL_POWER_ON | 0xabcd0003, 0},
	{M, 1, "[drm:ironlake_panel_vdd_off_sync], R PCH_PP_CONTROL:abcd0003", 0x0, 0xcf8e64, 0},
	{R, 1, "", PCH_PP_STATUS, PP_ON | /*undocbit3 | */ 0x80000008, 0},
	{W, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_2_CPT | DP_PRE_EMPHASIS_0 | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x8e1c4104, 0},
	{R, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_2_CPT | DP_PRE_EMPHASIS_0 | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x8e1c4104, 0},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /*undocbit3 | */ 0x80000008, 0},
	{R, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_2_CPT | (DP_PRE_EMPHASIS_9_5 & 0xc00000) | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x8cdc4104, 0},
	{M, 1, "[drm:intel_dp_link_down], ", 0x0, 0xcf8e64, 0},
	{W, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_PRE_EMPHASIS_0 | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_DETECTED | 0x8e1c0004, 0},
	{R, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | DP_PRE_EMPHASIS_0 | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_DETECTED | 0x8e1c0004, 100},
	{W, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_IDLE_CPT | DP_PRE_EMPHASIS_0 | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_DETECTED | 0x8e1c0204, 0},
	{R, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_IDLE_CPT | DP_PRE_EMPHASIS_0 | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_DETECTED | 0x8e1c0204, 0},
	{W, 1, "", DP_A, DP_LINK_TRAIN_PAT_1 | (DP_LINK_TRAIN_OFF_CPT & 0x300) | DP_PRE_EMPHASIS_0 | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_DETECTED | 0x0e1c0304, 0},
	{R, 2, "", DP_A, DP_LINK_TRAIN_PAT_1 | (DP_LINK_TRAIN_OFF_CPT & 0x300) | DP_PRE_EMPHASIS_0 | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_DETECTED | 0x0e1c0304, 0},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /*undocbit3 | */ 0x80000008, 0},
	{I,},
	{W, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x891c4004, 0},
	{R, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_1_CPT | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x891c4004, 0},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /*undocbit3 | */ 0x80000008, 0},
	{I,},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /*undocbit3 | */ 0x80000008, 0},
	{I,},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /*undocbit3 | */ 0x80000008, 0},
	{I,},
	{M, 1, "[drm:intel_dp_start_link_train], clock recovery OK", 0x0, 0x00000000, 0},
	{W, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_2_CPT | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x891c4104, 0},
	{R, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | DP_LINK_TRAIN_PAT_2_CPT | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x891c4104, 0},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /* undocbit3 | */ 0x80000008, 0},
	{I,},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /* undocbit3 | */ 0x80000008, 0},
	{I,},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /* undocbit3 | */ 0x80000008, 0},
	{I,},
	{W, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | (DP_LINK_TRAIN_OFF_CPT & 0x300) | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x891c4304, 0},
	{R, 1, "", DP_A, DP_PORT_EN | DP_LINK_TRAIN_PAT_1 | (DP_LINK_TRAIN_OFF_CPT & 0x300) | (DP_PORT_WIDTH_4 & 0x180000) | DP_ENHANCED_FRAMING | DP_PLL_FREQ_270MHZ | DP_PLL_ENABLE | DP_DETECTED | 0x891c4304, 0},
	{R, 2, "", PCH_PP_STATUS, PP_ON | /* undocbit3 | */ 0x80000008, 0},
	{I,},
	{M, 1, "[drm:ironlake_edp_backlight_on], ", 0x0, 0x00000000, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | PANEL_POWER_RESET | PANEL_POWER_ON | 0xabcd0003, 0},
	{W, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_BLC_ENABLE | PANEL_POWER_RESET | PANEL_POWER_ON | 0xabcd0007, 0},
	{R, 1, "", PCH_PP_CONTROL, (PCH_PP_UNLOCK & 0xabcd0000) | EDP_BLC_ENABLE | PANEL_POWER_RESET | PANEL_POWER_ON | 0xabcd0007, 0},
	{R, 1, "", _PIPEADSL, 0x00000633, 500},
	{R, 1, "", _PIPEADSL, 0x00000652, 0},
	{R, 1, "", _PIPEASTAT, 0x00000000, 0},
	{W, 1, "", _PIPEASTAT, PIPE_VBLANK_INTERRUPT_STATUS | 0x00000002, 0},
	{R, 5085, "", _PIPEASTAT, 0x00000000, 0},
	{M, 1, "[drm:intel_wait_for_vblank], vblank wait timed out", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:intel_dp_mode_fixup], Display port link bw 0a lane count 4clock 270000", 0x0, 0xcf8e64, 0},
	{M, 1, "[drm:drm_crtc_helper_set_mode], [CRTC:3]", 0x0, 0xcf8e64, 0},
	{I,},
};

int niodefs = ARRAY_SIZE(iodefs);
