    /*
     * Some or all of this work - Copyright (c) 2006 - 2017, Intel Corp.
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without modification,
     * are permitted provided that the following conditions are met:
     *
     * Redistributions of source code must retain the above copyright notice,
     * this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
     * this list of conditions and the following disclaimer in the documentation
     * and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
     * may be used to endorse or promote products derived from this software
     * without specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
     * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
     * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
     * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
     * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
     * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */
    /*
     * Data type conversion and manipulation
     *
     * Find Object Match (check for Integer values)
     */
    Name (Z038, 0x26)
    /* The depth of testing flag */

    Name (C099, 0x00)
    /* Match operator wrapper */

    Method (M306, 6, Serialized)
    {
        Switch (ToInteger (Arg1))
        {
            Case (0x00)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x00)
                    {
                        Local0 = Match (Arg0, MTR, Arg2, MTR, Arg4, Arg5)
                    }
                    Case (0x01)
                    {
                        Local0 = Match (Arg0, MTR, Arg2, MEQ, Arg4, Arg5)
                    }
                    Case (0x02)
                    {
                        Local0 = Match (Arg0, MTR, Arg2, MLE, Arg4, Arg5)
                    }
                    Case (0x03)
                    {
                        Local0 = Match (Arg0, MTR, Arg2, MLT, Arg4, Arg5)
                    }
                    Case (0x04)
                    {
                        Local0 = Match (Arg0, MTR, Arg2, MGE, Arg4, Arg5)
                    }
                    Case (0x05)
                    {
                        Local0 = Match (Arg0, MTR, Arg2, MGT, Arg4, Arg5)
                    }

                }
            }
            Case (0x01)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x00)
                    {
                        Local0 = Match (Arg0, MEQ, Arg2, MTR, Arg4, Arg5)
                    }
                    Case (0x01)
                    {
                        Local0 = Match (Arg0, MEQ, Arg2, MEQ, Arg4, Arg5)
                    }
                    Case (0x02)
                    {
                        Local0 = Match (Arg0, MEQ, Arg2, MLE, Arg4, Arg5)
                    }
                    Case (0x03)
                    {
                        Local0 = Match (Arg0, MEQ, Arg2, MLT, Arg4, Arg5)
                    }
                    Case (0x04)
                    {
                        Local0 = Match (Arg0, MEQ, Arg2, MGE, Arg4, Arg5)
                    }
                    Case (0x05)
                    {
                        Local0 = Match (Arg0, MEQ, Arg2, MGT, Arg4, Arg5)
                    }

                }
            }
            Case (0x02)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x00)
                    {
                        Local0 = Match (Arg0, MLE, Arg2, MTR, Arg4, Arg5)
                    }
                    Case (0x01)
                    {
                        Local0 = Match (Arg0, MLE, Arg2, MEQ, Arg4, Arg5)
                    }
                    Case (0x02)
                    {
                        Local0 = Match (Arg0, MLE, Arg2, MLE, Arg4, Arg5)
                    }
                    Case (0x03)
                    {
                        Local0 = Match (Arg0, MLE, Arg2, MLT, Arg4, Arg5)
                    }
                    Case (0x04)
                    {
                        Local0 = Match (Arg0, MLE, Arg2, MGE, Arg4, Arg5)
                    }
                    Case (0x05)
                    {
                        Local0 = Match (Arg0, MLE, Arg2, MGT, Arg4, Arg5)
                    }

                }
            }
            Case (0x03)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x00)
                    {
                        Local0 = Match (Arg0, MLT, Arg2, MTR, Arg4, Arg5)
                    }
                    Case (0x01)
                    {
                        Local0 = Match (Arg0, MLT, Arg2, MEQ, Arg4, Arg5)
                    }
                    Case (0x02)
                    {
                        Local0 = Match (Arg0, MLT, Arg2, MLE, Arg4, Arg5)
                    }
                    Case (0x03)
                    {
                        Local0 = Match (Arg0, MLT, Arg2, MLT, Arg4, Arg5)
                    }
                    Case (0x04)
                    {
                        Local0 = Match (Arg0, MLT, Arg2, MGE, Arg4, Arg5)
                    }
                    Case (0x05)
                    {
                        Local0 = Match (Arg0, MLT, Arg2, MGT, Arg4, Arg5)
                    }

                }
            }
            Case (0x04)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x00)
                    {
                        Local0 = Match (Arg0, MGE, Arg2, MTR, Arg4, Arg5)
                    }
                    Case (0x01)
                    {
                        Local0 = Match (Arg0, MGE, Arg2, MEQ, Arg4, Arg5)
                    }
                    Case (0x02)
                    {
                        Local0 = Match (Arg0, MGE, Arg2, MLE, Arg4, Arg5)
                    }
                    Case (0x03)
                    {
                        Local0 = Match (Arg0, MGE, Arg2, MLT, Arg4, Arg5)
                    }
                    Case (0x04)
                    {
                        Local0 = Match (Arg0, MGE, Arg2, MGE, Arg4, Arg5)
                    }
                    Case (0x05)
                    {
                        Local0 = Match (Arg0, MGE, Arg2, MGT, Arg4, Arg5)
                    }

                }
            }
            Case (0x05)
            {
                Switch (ToInteger (Arg3))
                {
                    Case (0x00)
                    {
                        Local0 = Match (Arg0, MGT, Arg2, MTR, Arg4, Arg5)
                    }
                    Case (0x01)
                    {
                        Local0 = Match (Arg0, MGT, Arg2, MEQ, Arg4, Arg5)
                    }
                    Case (0x02)
                    {
                        Local0 = Match (Arg0, MGT, Arg2, MLE, Arg4, Arg5)
                    }
                    Case (0x03)
                    {
                        Local0 = Match (Arg0, MGT, Arg2, MLT, Arg4, Arg5)
                    }
                    Case (0x04)
                    {
                        Local0 = Match (Arg0, MGT, Arg2, MGE, Arg4, Arg5)
                    }
                    Case (0x05)
                    {
                        Local0 = Match (Arg0, MGT, Arg2, MGT, Arg4, Arg5)
                    }

                }
            }

        }

        Return (Local0)
    }

    /* Test engine */
    /* arg0 - test name */
    /* arg1 - number of the test cases in the test parameters package */
    /* arg2 - search package name */
    /* arg3 - test parameters package */
    /* arg4 - benchmark package */
    /* arg5 - search package */
    /* arg6 - to do transposition of match objects flag */
    Method (M308, 7, Serialized)
    {
        Name (LPN0, 0x00)
        Name (LPC0, 0x00)
        Name (LPN1, 0x00)
        Name (LPC1, 0x00)
        Name (LPC2, 0x00)
        LPN0 = Arg1
        LPC0 = 0x00
        While (LPN0)
        {
            /* Operands */

            Local6 = (LPC0 * 0x03)
            Local1 = DerefOf (Arg3 [Local6])
            Local6++
            Local3 = DerefOf (Arg3 [Local6])
            Local6++
            Local4 = DerefOf (Arg3 [Local6])
            /* Expected result package */

            Local5 = DerefOf (Arg4 [LPC0])
            LPN1 = 0x24
            LPC1 = 0x00
            While (LPN1)
            {
                Divide (LPC1, 0x06, Local2, Local0)
                /* Expected result */

                Local7 = DerefOf (Local5 [LPC1])
                Local6 = M306 (Arg5, Local0, Local1, Local2, Local3, Local4)
                If ((Local7 != Local6))
                {
                    ERR ("err 1", Z038, 0xE3, 0x00, 0x00, LPC1, Arg2)
                }

                If ((Arg6 && (Local1 != Local3)))
                {
                    /* Transpose match objects */
                    /* Expected result */
                    LPC2 = ((Local2 * 0x06) + Local0)
                    Local7 = DerefOf (Local5 [LPC2])
                    Local6 = M306 (Arg5, Local0, Local3, Local2, Local1, Local4)
                    If ((Local7 != Local6))
                    {
                        ERR ("err 2", Z038, 0xF0, 0x00, 0x00, LPC2, Arg2)
                    }
                }

                LPN1--
                LPC1++
            }

            LPN0--
            LPC0++
        }
    }

    /* Search package */

    Name (P370, Package (0x0C)
    {
        0x1A, 
        0x0B, 
        0x13, 
        0x0E, 
        0x0C, 
        0x23, 
        0x26, 
        0x1D, 
        0x1F, 
        0x17, 
        0x12, 
        0x20
    })
    /* Test parameters package, */
    /* array of triples: MO1, MO2, SInd */
    Name (P371, Package (0x66)
    {
        0x00, 
        0x00, 
        0x00, 
        0x00, 
        0x28, 
        0x00, 
        0x28, 
        0x28, 
        0x00, 
        0x0D, 
        0x0D, 
        0x00, 
        0x0E, 
        0x0E, 
        0x00, 
        0x0F, 
        0x0F, 
        0x00, 
        0x00, 
        0x0D, 
        0x00, 
        0x00, 
        0x0E, 
        0x00, 
        0x00, 
        0x0F, 
        0x00, 
        0x0D, 
        0x28, 
        0x00, 
        0x0E, 
        0x28, 
        0x00, 
        0x0F, 
        0x28, 
        0x00, 
        0x0D, 
        0x1D, 
        0x00, 
        0x0E, 
        0x1D, 
        0x00, 
        0x0F, 
        0x1D, 
        0x00, 
        0x0E, 
        0x1C, 
        0x00, 
        0x0E, 
        0x1E, 
        0x00, 
        0x0F, 
        0x1C, 
        0x00, 
        0x0E, 
        0x1D, 
        0x01, 
        0x0F, 
        0x1D, 
        0x01, 
        0x0E, 
        0x1E, 
        0x01, 
        0x0F, 
        0x1C, 
        0x01, 
        0x0E, 
        0x1D, 
        0x06, 
        0x0F, 
        0x1D, 
        0x06, 
        0x0E, 
        0x1E, 
        0x06, 
        0x0F, 
        0x1C, 
        0x06, 
        0x0E, 
        0x1D, 
        0x09, 
        0x0F, 
        0x1D, 
        0x09, 
        0x0E, 
        0x1E, 
        0x09, 
        0x0F, 
        0x1C, 
        0x09, 
        0x0E, 
        0x1D, 
        0x0B, 
        0x0F, 
        0x1D, 
        0x0B, 
        0x0E, 
        0x1E, 
        0x0B, 
        0x0F, 
        0x1C, 
        0x0B
    })
    /* Benchmark package, each package in it */
    /* corresponds to the relevant test parameters */
    /* case and enumerates the results of Match for */
    /* all combinations of the match operators (36). */
    Name (P372, Package (0x22)
    {
        Package (0x24)
        {
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            0x03, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            0x03, 
            0x03, 
            0x03, 
            Ones, 
            0x03, 
            Ones, 
            0x01, 
            0x03, 
            0x01, 
            0x01, 
            0x03, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            0x03, 
            0x03, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x01, 
            0x01, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            0x03, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x03, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            0x00, 
            0x03, 
            0x01, 
            0x01, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x01, 
            0x01, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x01, 
            0x01, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x03, 
            Ones, 
            0x03, 
            0x03, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x03, 
            Ones, 
            0x03, 
            0x03, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x00, 
            0x07, 
            0x00, 
            0x00, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x03, 
            Ones, 
            0x03, 
            0x03, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x03, 
            Ones, 
            0x03, 
            0x03, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x01, 
            0x07, 
            0x01, 
            0x01, 
            0x05, 
            0x05, 
            0x03, 
            Ones, 
            0x03, 
            0x03, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x02, 
            0x07, 
            0x02, 
            0x02, 
            0x05, 
            0x05, 
            0x02, 
            0x07, 
            0x02, 
            0x02, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x01, 
            0x07, 
            0x01, 
            0x01, 
            0x05, 
            0x05, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x02, 
            0x07, 
            0x02, 
            0x02, 
            0x05, 
            0x05, 
            0x02, 
            0x07, 
            0x02, 
            0x02, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            0x05, 
            0x05, 
            0x03, 
            Ones, 
            0x03, 
            0x03, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x02, 
            Ones, 
            0x02, 
            0x02, 
            0x05, 
            0x05, 
            0x02, 
            Ones, 
            0x02, 
            0x02, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            0x05, 
            0x05, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x01, 
            Ones, 
            0x01, 
            0x01, 
            Ones, 
            Ones, 
            0x02, 
            Ones, 
            0x02, 
            0x02, 
            0x05, 
            0x05, 
            0x02, 
            Ones, 
            0x02, 
            0x02, 
            0x05, 
            0x05
        }, 

        Package (0x24)
        {
            0x06, 
            0x07, 
            0x07, 
            0x09, 
            0x06, 
            0x06, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x06, 
            0x07, 
            0x07, 
            0x09, 
            0x06, 
            0x06, 
            0x06, 
            0x07, 
            0x07, 
            0x09, 
            0x06, 
            0x06
        }, 

        Package (0x24)
        {
            0x06, 
            0x07, 
            0x07, 
            0x09, 
            0x06, 
            0x06, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x06, 
            0x07, 
            0x07, 
            0x09, 
            0x06, 
            0x06, 
            0x06, 
            0x07, 
            0x07, 
            0x09, 
            0x06, 
            0x06
        }, 

        Package (0x24)
        {
            0x06, 
            Ones, 
            0x07, 
            0x07, 
            0x06, 
            0x06, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x06, 
            Ones, 
            0x07, 
            0x07, 
            0x06, 
            0x06, 
            0x06, 
            Ones, 
            0x07, 
            0x07, 
            0x06, 
            0x06
        }, 

        Package (0x24)
        {
            0x06, 
            Ones, 
            0x09, 
            0x09, 
            0x06, 
            0x06, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x06, 
            Ones, 
            0x09, 
            0x09, 
            0x06, 
            0x06, 
            0x06, 
            Ones, 
            0x09, 
            0x09, 
            0x06, 
            0x06
        }, 

        Package (0x24)
        {
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B, 
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B
        }, 

        Package (0x24)
        {
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B, 
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B
        }, 

        Package (0x24)
        {
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B, 
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B
        }, 

        Package (0x24)
        {
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B, 
            0x09, 
            Ones, 
            0x09, 
            0x09, 
            0x0B, 
            0x0B
        }, 

        Package (0x24)
        {
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B
        }, 

        Package (0x24)
        {
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B
        }, 

        Package (0x24)
        {
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B
        }, 

        Package (0x24)
        {
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B, 
            0x0B, 
            Ones, 
            Ones, 
            Ones, 
            0x0B, 
            0x0B
        }
    })
    Name (P373, Package (0x0C)
    {
        0x1A, 
        0x0B, 
        0x13, 
        0x0E, 
        0x0E, 
        0x23, 
        0x26, 
        0x1D, 
        0x1F, 
        0x17, 
        0x12, 
        0x20
    })
    Name (P374, Package (0x0C)
    {
        0x1A, 
        0x0B, 
        0x13, 
        0x0E, 
        0x0C, 
        0x23, 
        0x26, 
        0x1D, 
        0x1D, 
        0x17, 
        0x12, 
        0x20
    })
    Name (P375, Package (0x0C)
    {
        0x1A, 
        0x0B, 
        0x13, 
        0x0E, 
        0x0E, 
        0x23, 
        0x26, 
        0x1D, 
        0x1D, 
        0x17, 
        0x12, 
        0x20
    })
    Name (P376, Package (0x0C)
    {
        0x1A, 
        0x0B, 
        0x13, 
        0x0E, 
        Package (0x01)
        {
            0x1D
        }, 

        0x23, 
        0x26, 
        0x1D, 
        Package (0x01)
        {
            0x28
        }, 

        0x17, 
        Package (0x01)
        {
            0x00
        }, 

        0x20
    })
    Name (P389, Package (0x0C)
    {
        0x80000026, 
        0x0B, 
        0x13, 
        0x0E, 
        0x0C, 
        0x80000035, 
        0x80000038, 
        0x80000029, 
        0x80000031, 
        0x17, 
        0x12, 
        0x80000032
    })
    Name (P38A, Package (0x66)
    {
        0x00, 
        0x00, 
        0x00, 
        0x00, 
        0x80000040, 
        0x00, 
        0x80000040, 
        0x80000040, 
        0x00, 
        0x0D, 
        0x0D, 
        0x00, 
        0x0E, 
        0x0E, 
        0x00, 
        0x0F, 
        0x0F, 
        0x00, 
        0x00, 
        0x0D, 
        0x00, 
        0x00, 
        0x0E, 
        0x00, 
        0x00, 
        0x0F, 
        0x00, 
        0x0D, 
        0x80000040, 
        0x00, 
        0x0E, 
        0x80000040, 
        0x00, 
        0x0F, 
        0x80000040, 
        0x00, 
        0x0D, 
        0x80000029, 
        0x00, 
        0x0E, 
        0x80000029, 
        0x00, 
        0x0F, 
        0x80000029, 
        0x00, 
        0x0E, 
        0x80000028, 
        0x00, 
        0x0E, 
        0x80000030, 
        0x00, 
        0x0F, 
        0x80000028, 
        0x00, 
        0x0E, 
        0x80000029, 
        0x01, 
        0x0F, 
        0x80000029, 
        0x01, 
        0x0E, 
        0x80000030, 
        0x01, 
        0x0F, 
        0x80000028, 
        0x01, 
        0x0E, 
        0x80000029, 
        0x06, 
        0x0F, 
        0x80000029, 
        0x06, 
        0x0E, 
        0x80000030, 
        0x06, 
        0x0F, 
        0x80000028, 
        0x06, 
        0x0E, 
        0x80000029, 
        0x09, 
        0x0F, 
        0x80000029, 
        0x09, 
        0x0E, 
        0x80000030, 
        0x09, 
        0x0F, 
        0x80000028, 
        0x09, 
        0x0E, 
        0x80000029, 
        0x0B, 
        0x0F, 
        0x80000029, 
        0x0B, 
        0x0E, 
        0x80000030, 
        0x0B, 
        0x0F, 
        0x80000028, 
        0x0B
    })
    Name (P38B, Package (0x0C)
    {
        0x0000000100000026, 
        0x0B, 
        0x13, 
        0x0E, 
        0x0C, 
        0x0000000100000035, 
        0x0000000100000038, 
        0x0000000100000029, 
        0x0000000100000031, 
        0x17, 
        0x12, 
        0x0000000100000032
    })
    Name (P38C, Package (0x66)
    {
        0x00, 
        0x00, 
        0x00, 
        0x00, 
        0x0000000100000040, 
        0x00, 
        0x0000000100000040, 
        0x0000000100000040, 
        0x00, 
        0x0D, 
        0x0D, 
        0x00, 
        0x0E, 
        0x0E, 
        0x00, 
        0x0F, 
        0x0F, 
        0x00, 
        0x00, 
        0x0D, 
        0x00, 
        0x00, 
        0x0E, 
        0x00, 
        0x00, 
        0x0F, 
        0x00, 
        0x0D, 
        0x0000000100000040, 
        0x00, 
        0x0E, 
        0x0000000100000040, 
        0x00, 
        0x0F, 
        0x0000000100000040, 
        0x00, 
        0x0D, 
        0x0000000100000029, 
        0x00, 
        0x0E, 
        0x0000000100000029, 
        0x00, 
        0x0F, 
        0x0000000100000029, 
        0x00, 
        0x0E, 
        0x0000000100000028, 
        0x00, 
        0x0E, 
        0x0000000100000030, 
        0x00, 
        0x0F, 
        0x0000000100000028, 
        0x00, 
        0x0E, 
        0x0000000100000029, 
        0x01, 
        0x0F, 
        0x0000000100000029, 
        0x01, 
        0x0E, 
        0x0000000100000030, 
        0x01, 
        0x0F, 
        0x0000000100000028, 
        0x01, 
        0x0E, 
        0x0000000100000029, 
        0x06, 
        0x0F, 
        0x0000000100000029, 
        0x06, 
        0x0E, 
        0x0000000100000030, 
        0x06, 
        0x0F, 
        0x0000000100000028, 
        0x06, 
        0x0E, 
        0x0000000100000029, 
        0x09, 
        0x0F, 
        0x0000000100000029, 
        0x09, 
        0x0E, 
        0x0000000100000030, 
        0x09, 
        0x0F, 
        0x0000000100000028, 
        0x09, 
        0x0E, 
        0x0000000100000029, 
        0x0B, 
        0x0F, 
        0x0000000100000029, 
        0x0B, 
        0x0E, 
        0x0000000100000030, 
        0x0B, 
        0x0F, 
        0x0000000100000028, 
        0x0B
    })
    Name (P38D, Package (0x0C)
    {
        0x8000000000000026, 
        0x0000000100000011, 
        0x0000000100000019, 
        0x0000000100000014, 
        0x0000000100000012, 
        0x8000000000000035, 
        0x8000000000000038, 
        0x8000000000000029, 
        0x8000000000000031, 
        0x0000000100000023, 
        0x0000000100000018, 
        0x8000000000000032
    })
    Name (P38E, Package (0x66)
    {
        0x0000000100000000, 
        0x0000000100000000, 
        0x00, 
        0x0000000100000000, 
        0x8000000000000040, 
        0x00, 
        0x8000000000000040, 
        0x8000000000000040, 
        0x00, 
        0x0000000100000013, 
        0x0000000100000013, 
        0x00, 
        0x0000000100000014, 
        0x0000000100000014, 
        0x00, 
        0x0000000100000015, 
        0x0000000100000015, 
        0x00, 
        0x0000000100000000, 
        0x0000000100000013, 
        0x00, 
        0x0000000100000000, 
        0x0000000100000014, 
        0x00, 
        0x0000000100000000, 
        0x0000000100000015, 
        0x00, 
        0x0000000100000013, 
        0x8000000000000040, 
        0x00, 
        0x0000000100000014, 
        0x8000000000000040, 
        0x00, 
        0x0000000100000015, 
        0x8000000000000040, 
        0x00, 
        0x0000000100000013, 
        0x8000000000000029, 
        0x00, 
        0x0000000100000014, 
        0x8000000000000029, 
        0x00, 
        0x0000000100000015, 
        0x8000000000000029, 
        0x00, 
        0x0000000100000014, 
        0x8000000000000028, 
        0x00, 
        0x0000000100000014, 
        0x8000000000000030, 
        0x00, 
        0x0000000100000015, 
        0x8000000000000028, 
        0x00, 
        0x0000000100000014, 
        0x8000000000000029, 
        0x01, 
        0x0000000100000015, 
        0x8000000000000029, 
        0x01, 
        0x0000000100000014, 
        0x8000000000000030, 
        0x01, 
        0x0000000100000015, 
        0x8000000000000028, 
        0x01, 
        0x0000000100000014, 
        0x8000000000000029, 
        0x06, 
        0x0000000100000015, 
        0x8000000000000029, 
        0x06, 
        0x0000000100000014, 
        0x8000000000000030, 
        0x06, 
        0x0000000100000015, 
        0x8000000000000028, 
        0x06, 
        0x0000000100000014, 
        0x8000000000000029, 
        0x09, 
        0x0000000100000015, 
        0x8000000000000029, 
        0x09, 
        0x0000000100000014, 
        0x8000000000000030, 
        0x09, 
        0x0000000100000015, 
        0x8000000000000028, 
        0x09, 
        0x0000000100000014, 
        0x8000000000000029, 
        0x0B, 
        0x0000000100000015, 
        0x8000000000000029, 
        0x0B, 
        0x0000000100000014, 
        0x8000000000000030, 
        0x0B, 
        0x0000000100000015, 
        0x8000000000000028, 
        0x0B
    })
    Name (P377, Package (0x0C)
    {
        0xFFFFFFFFFFFFFF26, 
        0xFFFFFFFFFFFFFF11, 
        0xFFFFFFFFFFFFFF19, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF35, 
        0xFFFFFFFFFFFFFF38, 
        0xFFFFFFFFFFFFFF29, 
        0xFFFFFFFFFFFFFF29, 
        0xFFFFFFFFFFFFFF23, 
        0xFFFFFFFFFFFFFF18, 
        0xFFFFFFFFFFFFFF32
    })
    Name (P378, Package (0x66)
    {
        0xFFFFFFFFFFFFFF00, 
        0xFFFFFFFFFFFFFF00, 
        0x00, 
        0xFFFFFFFFFFFFFF00, 
        0xFFFFFFFFFFFFFFFF, 
        0x00, 
        0xFFFFFFFFFFFFFFFF, 
        0xFFFFFFFFFFFFFFFF, 
        0x00, 
        0xFFFFFFFFFFFFFF13, 
        0xFFFFFFFFFFFFFF13, 
        0x00, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF14, 
        0x00, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF15, 
        0x00, 
        0xFFFFFFFFFFFFFF00, 
        0xFFFFFFFFFFFFFF13, 
        0x00, 
        0xFFFFFFFFFFFFFF00, 
        0xFFFFFFFFFFFFFF14, 
        0x00, 
        0xFFFFFFFFFFFFFF00, 
        0xFFFFFFFFFFFFFF15, 
        0x00, 
        0xFFFFFFFFFFFFFF13, 
        0xFFFFFFFFFFFFFFFF, 
        0x00, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFFFF, 
        0x00, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFFFF, 
        0x00, 
        0xFFFFFFFFFFFFFF13, 
        0xFFFFFFFFFFFFFF29, 
        0x00, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF29, 
        0x00, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF29, 
        0x00, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF28, 
        0x00, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF2A, 
        0x00, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF28, 
        0x00, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF29, 
        0x01, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF29, 
        0x01, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF2A, 
        0x01, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF28, 
        0x01, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF29, 
        0x06, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF29, 
        0x06, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF2A, 
        0x06, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF28, 
        0x06, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF29, 
        0x09, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF29, 
        0x09, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF2A, 
        0x09, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF28, 
        0x09, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF29, 
        0x0B, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF29, 
        0x0B, 
        0xFFFFFFFFFFFFFF14, 
        0xFFFFFFFFFFFFFF2A, 
        0x0B, 
        0xFFFFFFFFFFFFFF15, 
        0xFFFFFFFFFFFFFF28, 
        0x0B
    })
    /* One-element length package special case */

    Name (P380, Package (0x01)
    {
        0x01
    })
    Name (P381, Package (0x12)
    {
        0x00, 
        0x00, 
        0x00, 
        0x00, 
        0x01, 
        0x00, 
        0x00, 
        0x02, 
        0x00, 
        0x01, 
        0x01, 
        0x00, 
        0x01, 
        0x02, 
        0x00, 
        0x02, 
        0x02, 
        0x00
    })
    Name (P382, Package (0x06)
    {
        Package (0x24)
        {
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x00, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones
        }
    })
    /* 255-element length package special case */

    Name (P383, Package (0xFF)
    {
        0x01, 
        0x02, 
        0x03, 
        0x04, 
        0x05, 
        0x06, 
        0x07, 
        0x08, 
        0x09, 
        0x0A, 
        0x0B, 
        0x0C, 
        0x0D, 
        0x0E, 
        0x0F, 
        0x10, 
        0x11, 
        0x12, 
        0x13, 
        0x14, 
        0x15, 
        0x16, 
        0x17, 
        0x18, 
        0x19, 
        0x1A, 
        0x1B, 
        0x1C, 
        0x1D, 
        0x1E, 
        0x1F, 
        0x20, 
        0x21, 
        0x22, 
        0x23, 
        0x24, 
        0x25, 
        0x26, 
        0x27, 
        0x28, 
        0x29, 
        0x2A, 
        0x2B, 
        0x2C, 
        0x2D, 
        0x2E, 
        0x2F, 
        0x30, 
        0x31, 
        0x32, 
        0x33, 
        0x34, 
        0x35, 
        0x36, 
        0x37, 
        0x38, 
        0x39, 
        0x3A, 
        0x3B, 
        0x3C, 
        0x3D, 
        0x3E, 
        0x3F, 
        0x40, 
        0x41, 
        0x42, 
        0x43, 
        0x44, 
        0x45, 
        0x46, 
        0x47, 
        0x48, 
        0x49, 
        0x4A, 
        0x4B, 
        0x4C, 
        0x4D, 
        0x4E, 
        0x4F, 
        0x50, 
        0x51, 
        0x52, 
        0x53, 
        0x54, 
        0x55, 
        0x56, 
        0x57, 
        0x58, 
        0x59, 
        0x5A, 
        0x5B, 
        0x5C, 
        0x5D, 
        0x5E, 
        0x5F, 
        0x60, 
        0x61, 
        0x62, 
        0x63, 
        0x64, 
        0x65, 
        0x66, 
        0x67, 
        0x68, 
        0x69, 
        0x6A, 
        0x6B, 
        0x6C, 
        0x6D, 
        0x6E, 
        0x6F, 
        0x70, 
        0x71, 
        0x72, 
        0x73, 
        0x74, 
        0x75, 
        0x76, 
        0x77, 
        0x78, 
        0x79, 
        0x7A, 
        0x7B, 
        0x7C, 
        0x7D, 
        0x7E, 
        0x7F, 
        0x80, 
        0x81, 
        0x82, 
        0x83, 
        0x84, 
        0x85, 
        0x86, 
        0x87, 
        0x88, 
        0x89, 
        0x8A, 
        0x8B, 
        0x8C, 
        0x8D, 
        0x8E, 
        0x8F, 
        0x90, 
        0x91, 
        0x92, 
        0x93, 
        0x94, 
        0x95, 
        0x96, 
        0x97, 
        0x98, 
        0x99, 
        0x9A, 
        0x9B, 
        0x9C, 
        0x9D, 
        0x9E, 
        0x9F, 
        0xA0, 
        0xA1, 
        0xA2, 
        0xA3, 
        0xA4, 
        0xA5, 
        0xA6, 
        0xA7, 
        0xA8, 
        0xA9, 
        0xAA, 
        0xAB, 
        0xAC, 
        0xAD, 
        0xAE, 
        0xAF, 
        0xB0, 
        0xB1, 
        0xB2, 
        0xB3, 
        0xB4, 
        0xB5, 
        0xB6, 
        0xB7, 
        0xB8, 
        0xB9, 
        0xBA, 
        0xBB, 
        0xBC, 
        0xBD, 
        0xBE, 
        0xBF, 
        0xC0, 
        0xC1, 
        0xC2, 
        0xC3, 
        0xC4, 
        0xC5, 
        0xC6, 
        0xC7, 
        0xC8, 
        0xC9, 
        0xCA, 
        0xCB, 
        0xCC, 
        0xCD, 
        0xCE, 
        0xCF, 
        0xD0, 
        0xD1, 
        0xD2, 
        0xD3, 
        0xD4, 
        0xD5, 
        0xD6, 
        0xD7, 
        0xD8, 
        0xD9, 
        0xDA, 
        0xDB, 
        0xDC, 
        0xDD, 
        0xDE, 
        0xDF, 
        0xE0, 
        0xE1, 
        0xE2, 
        0xE3, 
        0xE4, 
        0xE5, 
        0xE6, 
        0xE7, 
        0xE8, 
        0xE9, 
        0xEA, 
        0xEB, 
        0xEC, 
        0xED, 
        0xEE, 
        0xEF, 
        0xF0, 
        0xF1, 
        0xF2, 
        0xF3, 
        0xF4, 
        0xF5, 
        0xF6, 
        0xF7, 
        0xF8, 
        0xF9, 
        0xFA, 
        0xFB, 
        0xFC, 
        0xFD, 
        0xFE, 
        0xFF
    })
    Name (P384, Package (0x12)
    {
        0x00, 
        0x00, 
        0x00, 
        0x00, 
        0x80, 
        0x00, 
        0x00, 
        0x0100, 
        0x00, 
        0x80, 
        0x80, 
        0x00, 
        0x80, 
        0x0100, 
        0x00, 
        0x0100, 
        0x0100, 
        0x00
    })
    Name (P385, Package (0x06)
    {
        Package (0x24)
        {
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x00
        }, 

        Package (0x24)
        {
            0x00, 
            0x7F, 
            0x00, 
            0x00, 
            0x7F, 
            0x80, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            0x7F, 
            0x00, 
            0x00, 
            0x7F, 
            0x80, 
            0x00, 
            0x7F, 
            0x00, 
            0x00, 
            0x7F, 
            0x80
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            0x7F, 
            0x00, 
            0x00, 
            0x7F, 
            0x80, 
            0x7F, 
            0x7F, 
            0x7F, 
            Ones, 
            0x7F, 
            Ones, 
            0x00, 
            0x7F, 
            0x00, 
            0x00, 
            0x7F, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x7F, 
            0x7F, 
            0x7F, 
            Ones, 
            0x7F, 
            0x80, 
            0x80, 
            Ones, 
            Ones, 
            Ones, 
            0x80, 
            0x80
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x7F, 
            Ones, 
            0x7F, 
            0x7F, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x7F, 
            Ones, 
            0x7F, 
            0x7F, 
            Ones, 
            Ones, 
            0x80, 
            Ones, 
            0x80, 
            0x80, 
            Ones, 
            Ones
        }, 

        Package (0x24)
        {
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            0x00, 
            Ones, 
            0x00, 
            0x00, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones, 
            Ones
        }
    })
    /* Run-method */

    Method (MAT0, 0, Serialized)
    {
        Name (TS, "MAT0")
        Debug = "TEST: MAT0, Find Object Match"
        /* to do transposition of match objects flag */

        Name (TRNS, 0x00)
        If (C099)
        {
            TRNS = 0x01
        }

        M308 (TS, 0x22, "p370", P371, P372, P370, TRNS)
        If (C099)
        {
            M308 (TS, 0x22, "p373", P371, P372, P373, TRNS)
            M308 (TS, 0x22, "p374", P371, P372, P374, TRNS)
        }

        M308 (TS, 0x22, "p375", P371, P372, P375, TRNS)
        If ((F64 == 0x01))
        {
            M308 (TS, 0x22, "p377", P378, P372, P377, TRNS)
            If (C099)
            {
                M308 (TS, 0x22, "p389", P38A, P372, P389, TRNS)
                M308 (TS, 0x22, "p38b", P38C, P372, P38B, TRNS)
                M308 (TS, 0x22, "p38d", P38E, P372, P38D, TRNS)
            }
        }
        Else
        {
            M308 (TS, 0x22, "p389", P38A, P372, P389, TRNS)
        }

        /* One-element length package special case */

        M308 (TS, 0x06, "p380", P381, P382, P380, TRNS)
        /* 255-element length package special case */

        If (C099)
        {
            M308 (TS, 0x06, "p383", P384, P385, P383, TRNS)
        }
    }

