/*
 * Some or all of this work - Copyright (c) 2006 - 2011, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Resource Descriptor macros
 *
 * GpioInt Resource Descriptor Macro
 */

Device (GPII) {}

Name (p452, Package() {
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceConsumer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},


	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},

	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveLow, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer,)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Edge, ActiveBoth, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer)
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveHigh, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveLow, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Exclusive, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, ExclusiveAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, Shared, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullUp, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullDown, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullDefault, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},
	ResourceTemplate () {
        GpioInt (Level, ActiveBoth, SharedAndWake, PullNone, 0x1234,
            "\\GPII", 0xBB, ResourceProducer, ,
            RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
            {0xC1A3}},

    // Minimal invocation

	ResourceTemplate () {
        GpioInt (Edge, ActiveHigh, , PullUp, , "\\GPII", , , ,)
            {0xF1F2}
	},
})

Name (P453, Package ()
{
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x11,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x11,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x11,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x11,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x09,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x09,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x09,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x09,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x19,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x19,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x19,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x19,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x13,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x13,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x13,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x13,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0B,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0B,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0B,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0B,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1B,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1B,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1B,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1B,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x05,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x05,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x05,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x05,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x15,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x15,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x15,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x15,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0D,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0D,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0D,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0D,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1D,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1D,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1D,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1D,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x10,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x10,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x10,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x10,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x08,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x08,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x08,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x08,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x18,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x18,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x18,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x18,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x12,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x12,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x12,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x12,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0A,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0A,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0A,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0A,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1A,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1A,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1A,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1A,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x14,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x14,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x14,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x14,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0C,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0C,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0C,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0C,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1C,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1C,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1C,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1C,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x19,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x19,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x19,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x19,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x13,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x13,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x13,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x13,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1B,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1B,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1B,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1B,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0D,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0D,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0D,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0D,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1D,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1D,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1D,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1D,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1A,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1A,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1A,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1A,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1C,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1C,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1C,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1C,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x19,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x19,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x19,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x19,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x13,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x13,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x13,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x13,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1B,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1B,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1B,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1B,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0D,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0D,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0D,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0D,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1D,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1D,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1D,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1D,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x12,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1A,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1A,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1A,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1A,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1C,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1C,
        /* 0008 */    0x00, 0x02, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1C,
        /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x25)
    {
        /* 0000 */    0x8C, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1C,
        /* 0008 */    0x00, 0x03, 0x00, 0x00, 0x34, 0x12, 0x17, 0x00,
        /* 0010 */    0xBB, 0x19, 0x00, 0x1F, 0x00, 0x04, 0x00, 0xA3,
        /* 0018 */    0xC1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x11,
        /* 0020 */    0x22, 0x33, 0x44, 0x79, 0x00
    },
    Buffer (0x21)
    {
        /* 0000 */    0x8C, 0x1C, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
        /* 0008 */    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00,
        /* 0010 */    0x00, 0x19, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xF2,
        /* 0018 */    0xF1, 0x5C, 0x47, 0x50, 0x49, 0x49, 0x00, 0x79,
        /* 0020 */    0x00
    }
})

Method(RT21)
{
	Name(ts, "RT21")

	// Emit test header, set the filename

	THDR (ts, "GpioInt Resource Descriptor Macro", __FILE__)

    // The main test packages must have the same number of entries
    
    If (LNotEqual (SizeOf (p452), SizeOf (p453)))
    {
        err (ts, 178, 0, 0, 0, 0, "Incorrect package length")
        Return ()
    }

    // Main test case for packages above

	m330(ts, SizeOf (p452), "p452", p452, p453)
	
    // Check resource descriptor tag offsets

	Store (
		ResourceTemplate () {
            GpioInt (Edge, ActiveHigh, Exclusive, PullUp, 0x1234,
                "\\GPII", 0xBB, ResourceConsumer, GIN0,
                RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
                {0x00A3}
            GpioInt (Edge, ActiveHigh, Exclusive, PullUp, 0x1234,
                "\\GPII", 0xBB, ResourceConsumer, GIN1,
                RawDataBuffer () {0x11, 0x22, 0x33, 0x44})
                {0x00A3}
		}, Local0)

    m331(ts, 1, GIN0._MOD, 0x38, GIN1._MOD, 0x150, "_MOD")
    m331(ts, 2, GIN0._POL, 0x39, GIN1._POL, 0x151, "_POL")
    m331(ts, 3, GIN0._SHR, 0x3b, GIN1._SHR, 0x153, "_SHR")
    m331(ts, 4, GIN0._PPI, 0x48, GIN1._PPI, 0x160, "_PPI")
    m331(ts, 5, GIN0._DBT, 0x60, GIN1._DBT, 0x178, "_DBT")
    m331(ts, 6, GIN0._PIN, 0xB8, GIN1._PIN, 0x1d0, "_PIN")
    m331(ts, 7, GIN0._VEN, 0xF8, GIN1._VEN, 0x210, "_VEN")
}


