/*
 * Some or all of this work - Copyright (c) 2006 - 2017, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Resource Descriptor macros
 *
 * DWord Memory Resource Descriptor Macro
 */

Name (p426, Package() {

	// Byte 4 (General Flags) of DWord Address Space Descriptor

	ResourceTemplate () {
		DWordMemory (ResourceProducer, PosDecode, MinNotFixed, MaxNotFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceProducer, PosDecode, MinNotFixed, MaxFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxNotFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceProducer, SubDecode, MinNotFixed, MaxNotFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceProducer, SubDecode, MinNotFixed, MaxFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceProducer, SubDecode, MinFixed, MaxNotFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceProducer, SubDecode, MinFixed, MaxFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, PosDecode, MinNotFixed, MaxNotFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, PosDecode, MinNotFixed, MaxFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, PosDecode, MinFixed, MaxNotFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, PosDecode, MinFixed, MaxFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, SubDecode, MinNotFixed, MaxNotFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, SubDecode, MinNotFixed, MaxFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxNotFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},

	// Byte 5 (Type Specific Flags) of DWord Address Space Descriptor

	// NonCacheable
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , NonCacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeTranslation)
	},

	// Cacheable
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Cacheable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeTranslation)
	},

	// WriteCombining
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , WriteCombining, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeTranslation)
	},

	// Prefetchable
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeMemory, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeReserved, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeStatic)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , Prefetchable, ReadWrite,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			 , , , AddressRangeNVS, TypeTranslation)
	},

	// Particular cases

	ResourceTemplate () {
		DWordMemory ( , , , , , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
	},
	ResourceTemplate () {
		DWordMemory ( , , , , , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			, , , , )
	},

	// Resource Source

	ResourceTemplate () {
		DWordMemory ( , , , , , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0x01, "", , , )
	},
	ResourceTemplate () {
		DWordMemory ( , , , , , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0x0f, "P", , , )
	},
	ResourceTemplate () {
		DWordMemory ( , , , , , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xf0, "PATH", , , )
	},
	ResourceTemplate () {
		DWordMemory ( , , , , , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			  , , )
	},

	// Particular cases

	ResourceTemplate () {
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DME0, AddressRangeACPI, TypeTranslation)
	},
	ResourceTemplate () {
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0, 0, 0, 0, 0,
			0xff, "PATHPATHPATH", , AddressRangeACPI, TypeTranslation)
	},

	// 20051021, relaxation for omitted ResourceSource (bug-fix 70 rejection)
	ResourceTemplate () {
		DWordMemory ( , , , , , ,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0x0f)
	},
})

/*
ACPI Specification, Revision 3.0, September 2, 2004
6.4.3.5.2   DWord Address Space Descriptor

Memory DWord Address Space Descriptor layout:

Byte 0 (Tag Bits): Value=10000111B (0x87) (Type = 1, Large item name = 0x7)
Byte 1 (Length, bits[7:0]): Variable: Value = 23 (minimum)
Byte 2 (Length, bits[15:8]): Variable: Value = 0 (minimum)
Byte 3 (Resource Type):
	0		Memory range
Byte 4 (General Flags):
	Bits[7:4] 	Reserved (must be 0)
	Bit[3] 		Min Address Fixed, _MAF:
			1	The specified maximum address is fixed
			0	The specified maximum address is not fixed
				and can be changed
	Bit[2] 		Max Address Fixed,_MIF:
			1	The specified minimum address is fixed
			0	The specified minimum address is not fixed
				and can be changed
	Bit[1] 		Decode Type, _DEC:
			1	This bridge subtractively decodes this address
	 	 	 	(top level bridges only)
			0	This bridge positively decodes this address
	Bit[0] 		Consumer/Producer:
			1-This device consumes this resource
			0-This device produces and consumes this resource
Byte 5 (Type Specific Flags):
		Flags that are specific to each resource type. The meaning of the flags
		in this field depends on the value of the Resource Type field (see above)
	Bits[7:6]	Reserved (must be 0)
	Bit[5]		Memory to I/O Translation, _TTP
			1	TypeTranslation: This resource, which is memory on the secondary
				side of the bridge, is I/O on the primary side of the bridge.
			0	TypeStatic: This resource, which is memory on the secondary side
				of the bridge, is also memory on the primary side of the bridge.
	Bits[4:3] 	Memory attributes, _MTP. These bits are only defined if this memory
				resource describes system RAM. For a definition of the labels described
				here, see section 15, "System Address Map Interfaces."
			0	AddressRangeMemory
			1	AddressRangeReserved
			2	AddressRangeACPI
			3	AddressRangeNVS
	Bits[2:1] 	Memory attributes, _MEM
			0	The memory is non-cacheable.
			1	The memory is cacheable.
			2	The memory is cacheable and supports write combining.
			3	The memory is cacheable and prefetchable.
			(Notice: OSPM ignores this field in the Extended address space descriptor.
			Instead it uses the Type Specific Attributes field to determine memory attributes)
	Bit[0]		Write status, _RW
			1	This memory range is read-write.
			0	This memory range is read-only.
Byte 6 (Address space granularity, _GRA bits[7:0]):
	A set bit in this mask means that this bit is decoded. All bits less
	significant than the most significant set bit must be set. (in other
	words, the value of the full Address Space Granularity field (all 32
	bits) must be a number (2**n-1).
Byte 7 (Address space granularity, _GRA bits[15:8])
Byte 8 (Address space granularity, _GRA bits[23:16])
Byte 9 (Address space granularity, _GRA bits[31:24])
Byte 10 (Address range minimum, _MIN bits [7:0]):
	For bridges that translate addresses, this is the address space
	on the secondary side of the bridge
Byte 11 (Address range minimum, _MIN bits[15:8])
Byte 12 (Address range minimum, _MIN bits[23:16])
Byte 13 (Address range minimum, _MIN bits[31:24])
Byte 14 (Address range maximum, _MAX bits [7:0]): See comment for _MIN
Byte 15 (Address range maximum, _MAX bits[15:8])
Byte 16 (Address range maximum, _MAX bits[23:16])
Byte 17 (Address range maximum, _MAX bits[31:24])
Byte 18 (Address Translation offset, _TRA bits [7:0]):
	For bridges that translate addresses across the bridge, this is the
	offset that must be added to the address on the secondary side to obtain
	the address on the primary side. Non-bridge devices must list 0 for all
	Address Translation offset bits
Byte 19 (Address Translation offset, _TRA bits[15:8])
Byte 20 (Address Translation offset, _TRA bits[23:16])
Byte 21 (Address Translation offset, _TRA bits[31:24])
Byte 22 (Address Length, _LEN bits [7:0])
Byte 23 (Address Length, _LEN bits[15:8])
Byte 24 (Address Length, _LEN bits[23:16])
Byte 25 (Address Length, _LEN bits[31:24])
Byte 26 (Resource Source Index):
	(Optional) Only present if Resource Source (below) is present. This
	field gives an index to the specific resource descriptor that this
	device consumes from in the current resource template for the device
	object pointed to in Resource Source
String (Resource Source):
	(Optional) If present, the device that uses this descriptor consumes
	its resources from the resources produced by the named device object.
	If not present, the device consumes its resources out of a global pool.
	If not present, the device consumes this resource from its hierarchical
	parent.
*/

Name (p427, Package() {

	// Byte 4 (General Flags) of DWord Address Space Descriptor

	Buffer () {0x87, 0x17, 0x00, 0x00, 0x00, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x08, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x04, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x0c, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x02, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x0a, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x06, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x0e, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x09, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x05, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x0d, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x03, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x0b, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x07, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x0f, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},

	// Byte 5 (Type Specific Flags) of DWord Address Space Descriptor

	// NonCacheable
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x00,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x20,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x08,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x28,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x10,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x30,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x18,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x38,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x21,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x09,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x29,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x11,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x31,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x19,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x39,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},

	// Cacheable
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x02,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x22,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x0a,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x2a,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x12,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x32,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x1a,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x3a,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x03,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x23,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x0b,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x2b,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x13,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x33,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x1b,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x3b,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},

	// WriteCombining
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x04,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x24,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x0c,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x2c,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x14,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x34,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x1c,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x3c,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x05,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x25,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x0d,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x2d,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x15,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x35,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x1d,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x3d,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},

	// Prefetchable
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x06,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x26,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x0e,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x2e,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x16,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x36,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x1e,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x3e,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x07,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x27,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x0f,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x2f,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x17,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x37,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x1f,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x3f,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},

	// Particular cases

	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},
	Buffer () {0x87, 0x17, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc, 0x79, 0x00},

	// Resource Source

	Buffer () {0x87, 0x19, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x01, 0x00, 0x79, 0x00},
	Buffer () {0x87, 0x1a, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x0f, 0x50, 0x00, 0x79, 0x00},
	Buffer () {0x87, 0x1d, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0xf0, 0x50, 0x41, 0x54, 0x48, 0x00, 0x79, 0x00},
	Buffer () {0x87, 0xe1, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0xff,
		0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
		0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
		0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
		0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
		0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
		0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
		0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
		0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
		0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
		0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
		0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
		0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21,
		0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
		0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
		0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
		0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
		0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
		0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
		0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
		0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
		0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
		0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
		0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
		0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21, 0x22,
		0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
		0x00, 0x79, 0x00},

	// Particular cases

	Buffer () {0x87, 0x25, 0x00, 0x00, 0x0f, 0x30,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
		0x48, 0x50, 0x41, 0x54, 0x48, 0x00, 0x79, 0x00},
	Buffer () {0x87, 0x25, 0x00, 0x00, 0x0f, 0x30,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
		0x48, 0x50, 0x41, 0x54, 0x48, 0x00, 0x79, 0x00},

	// 20051021, relaxation for omitted ResourceSource (bug-fix 70 rejection)
	Buffer () {0x87, 0x18, 0x00, 0x00, 0x01, 0x01,
		0xef, 0xee, 0xed, 0xec,
		0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x0f, 0x79, 0x00},
})

Method(RT11,, Serialized)
{
	Name(ts, "RT11")

	// Emit test header, set the filename

	THDR (ts, "DWordMemory Resource Descriptor Macro", __FILE__)

    // Main test case for packages above

	m330(ts, 89, "p426", p426, p427)

    // Check resource descriptor tag offsets

	Store (
		ResourceTemplate () {
			DWordMemory (ResourceProducer, PosDecode, MinNotFixed, MaxNotFixed, NonCacheable, ReadOnly,
				0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, , , DME0)
			DWordMemory (ResourceConsumer, PosDecode, MinNotFixed, MaxNotFixed, NonCacheable, ReadOnly,
				0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, , , DME1)
		}, Local0)

	m331(ts, 1,  DME0._DEC, 0x21, DME1._DEC, 0xf1, "_DEC")
	m331(ts, 2,  DME0._MIF, 0x22, DME1._MIF, 0xf2, "_MIF")
	m331(ts, 3,  DME0._MAF, 0x23, DME1._MAF, 0xf3, "_MAF")
	m331(ts, 4,  DME0._RW,  0x28, DME1._RW,  0xf8, "_RW")
	m331(ts, 5,  DME0._MEM, 0x29, DME1._MEM, 0xf9, "_MEM")
	m331(ts, 6,  DME0._MTP, 0x2b, DME1._MTP, 0xfb, "_MTP")
	m331(ts, 6,  DME0._TTP, 0x2d, DME1._TTP, 0xfd, "_TTP")
	m331(ts, 7,  DME0._GRA, 0x30, DME1._GRA, 0x100, "_GRA")
	m331(ts, 8,  DME0._MIN, 0x50, DME1._MIN, 0x120, "_MIN")
	m331(ts, 9,  DME0._MAX, 0x70, DME1._MAX, 0x140, "_MAX")
	m331(ts, 10, DME0._TRA, 0x90, DME1._TRA, 0x160, "_TRA")
	m331(ts, 11, DME0._LEN, 0xB0, DME1._LEN, 0x180, "_LEN")
}

