
/*
 * ACPICA API Test Suite.
 * Support for testing of invalid handle processing.
 * Implements the following functional ASL Methods:
 * INIT - preparing for emulation of a initialy loaded SSDT in an OpRegion,
 * LD   - loading the auxiliary SSDT by Load ASL operator, then \SS00 handler
 *        can be obtained,
 * UNLD - unloading the auxiliary SSDT by Load ASL operator, the handler
 *        should become invalid
 */

// Do not use Device Object that can intercept common checks
//Device (AUX0)
Processor(AUX0, 0xA, 0x0, 0x0)
{
/*
 *
 * Intel ACPI Component Architecture
 * ASL Optimizing Compiler version 20060912 [Sep 14 2006]
 * Copyright (C) 2000 - 2006 Intel Corporation
 * Supports ACPI Specification Revision 3.0a
 *
 * Compilation of "ssdt_aux.asl" - Mon Sep 18 17:51:24 2006
 *
 * C source code output
 *
 */

Name(BUF0, Buffer() {
    0x53,0x53,0x44,0x54,0x79,0x04,0x00,0x00,  /* 00000000    "SSDTy..." */
    0x02,0xE8,0x49,0x6E,0x74,0x65,0x6C,0x00,  /* 00000008    "..Intel." */
    0x4D,0x61,0x6E,0x79,0x00,0x00,0x00,0x00,  /* 00000010    "Many...." */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x12,0x09,0x06,0x20,0x5B,0x82,0x43,0x45,  /* 00000020    "... [.CE" */
    0x41,0x55,0x58,0x32,0x14,0x14,0x53,0x53,  /* 00000028    "AUX2..SS" */
    0x30,0x30,0x00,0x70,0x0D,0x41,0x55,0x58,  /* 00000030    "00.p.AUX" */
    0x32,0x2E,0x53,0x53,0x30,0x30,0x00,0x5B,  /* 00000038    "2.SS00.[" */
    0x31,0x08,0x49,0x4E,0x54,0x30,0x0E,0x10,  /* 00000040    "1.INT0.." */
    0x32,0x54,0x76,0x98,0xBA,0xDC,0xFE,0x08,  /* 00000048    "2Tv....." */
    0x49,0x4E,0x54,0x31,0x0E,0x11,0x32,0x54,  /* 00000050    "INT1..2T" */
    0x76,0x98,0xBA,0xDC,0xFE,0x08,0x49,0x4E,  /* 00000058    "v.....IN" */
    0x54,0x32,0x0E,0x12,0x32,0x54,0x76,0x98,  /* 00000060    "T2..2Tv." */
    0xBA,0xDC,0xFE,0x08,0x49,0x4E,0x54,0x33,  /* 00000068    "....INT3" */
    0x0E,0x13,0x32,0x54,0x76,0x98,0xBA,0xDC,  /* 00000070    "..2Tv..." */
    0xFE,0x08,0x49,0x4E,0x54,0x34,0x0E,0x14,  /* 00000078    "..INT4.." */
    0x32,0x54,0x76,0x98,0xBA,0xDC,0xFE,0x08,  /* 00000080    "2Tv....." */
    0x49,0x4E,0x54,0x35,0x0E,0x15,0x32,0x54,  /* 00000088    "INT5..2T" */
    0x76,0x98,0xBA,0xDC,0xFE,0x08,0x49,0x4E,  /* 00000090    "v.....IN" */
    0x54,0x36,0x0E,0x16,0x32,0x54,0x76,0x98,  /* 00000098    "T6..2Tv." */
    0xBA,0xDC,0xFE,0x08,0x49,0x4E,0x54,0x37,  /* 000000A0    "....INT7" */
    0x0E,0x17,0x32,0x54,0x76,0x98,0xBA,0xDC,  /* 000000A8    "..2Tv..." */
    0xFE,0x08,0x49,0x4E,0x54,0x38,0x0E,0x18,  /* 000000B0    "..INT8.." */
    0x32,0x54,0x76,0x98,0xBA,0xDC,0xFE,0x08,  /* 000000B8    "2Tv....." */
    0x49,0x4E,0x54,0x39,0x0E,0x19,0x32,0x54,  /* 000000C0    "INT9..2T" */
    0x76,0x98,0xBA,0xDC,0xFE,0x08,0x53,0x54,  /* 000000C8    "v.....ST" */
    0x52,0x30,0x0D,0x73,0x6F,0x75,0x72,0x63,  /* 000000D0    "R0.sourc" */
    0x65,0x20,0x73,0x74,0x72,0x69,0x6E,0x67,  /* 000000D8    "e string" */
    0x30,0x00,0x08,0x53,0x54,0x52,0x31,0x0D,  /* 000000E0    "0..STR1." */
    0x73,0x6F,0x75,0x72,0x63,0x65,0x20,0x73,  /* 000000E8    "source s" */
    0x74,0x72,0x69,0x6E,0x67,0x31,0x00,0x08,  /* 000000F0    "tring1.." */
    0x53,0x54,0x52,0x32,0x0D,0x73,0x6F,0x75,  /* 000000F8    "STR2.sou" */
    0x72,0x63,0x65,0x20,0x73,0x74,0x72,0x69,  /* 00000100    "rce stri" */
    0x6E,0x67,0x32,0x00,0x08,0x53,0x54,0x52,  /* 00000108    "ng2..STR" */
    0x33,0x0D,0x73,0x6F,0x75,0x72,0x63,0x65,  /* 00000110    "3.source" */
    0x20,0x73,0x74,0x72,0x69,0x6E,0x67,0x33,  /* 00000118    " string3" */
    0x00,0x08,0x53,0x54,0x52,0x34,0x0D,0x73,  /* 00000120    "..STR4.s" */
    0x6F,0x75,0x72,0x63,0x65,0x20,0x73,0x74,  /* 00000128    "ource st" */
    0x72,0x69,0x6E,0x67,0x34,0x00,0x08,0x53,  /* 00000130    "ring4..S" */
    0x54,0x52,0x35,0x0D,0x73,0x6F,0x75,0x72,  /* 00000138    "TR5.sour" */
    0x63,0x65,0x20,0x73,0x74,0x72,0x69,0x6E,  /* 00000140    "ce strin" */
    0x67,0x35,0x00,0x08,0x53,0x54,0x52,0x36,  /* 00000148    "g5..STR6" */
    0x0D,0x73,0x6F,0x75,0x72,0x63,0x65,0x20,  /* 00000150    ".source " */
    0x73,0x74,0x72,0x69,0x6E,0x67,0x36,0x00,  /* 00000158    "string6." */
    0x08,0x53,0x54,0x52,0x37,0x0D,0x73,0x6F,  /* 00000160    ".STR7.so" */
    0x75,0x72,0x63,0x65,0x20,0x73,0x74,0x72,  /* 00000168    "urce str" */
    0x69,0x6E,0x67,0x37,0x00,0x08,0x53,0x54,  /* 00000170    "ing7..ST" */
    0x52,0x38,0x0D,0x73,0x6F,0x75,0x72,0x63,  /* 00000178    "R8.sourc" */
    0x65,0x20,0x73,0x74,0x72,0x69,0x6E,0x67,  /* 00000180    "e string" */
    0x38,0x00,0x08,0x42,0x55,0x46,0x30,0x11,  /* 00000188    "8..BUF0." */
    0x0C,0x0A,0x09,0x09,0x08,0x07,0x06,0x05,  /* 00000190    "........" */
    0x04,0x03,0x02,0x01,0x08,0x42,0x55,0x46,  /* 00000198    ".....BUF" */
    0x31,0x11,0x0B,0x0A,0x08,0x08,0x07,0x06,  /* 000001A0    "1......." */
    0x05,0x04,0x03,0x02,0x01,0x08,0x42,0x55,  /* 000001A8    "......BU" */
    0x46,0x32,0x11,0x0A,0x0A,0x07,0x07,0x06,  /* 000001B0    "F2......" */
    0x05,0x04,0x03,0x02,0x01,0x08,0x42,0x55,  /* 000001B8    "......BU" */
    0x46,0x33,0x11,0x09,0x0A,0x06,0x06,0x05,  /* 000001C0    "F3......" */
    0x04,0x03,0x02,0x01,0x08,0x42,0x55,0x46,  /* 000001C8    ".....BUF" */
    0x34,0x11,0x08,0x0A,0x05,0x05,0x04,0x03,  /* 000001D0    "4......." */
    0x02,0x01,0x08,0x42,0x55,0x46,0x35,0x11,  /* 000001D8    "...BUF5." */
    0x07,0x0A,0x04,0x04,0x03,0x02,0x01,0x08,  /* 000001E0    "........" */
    0x42,0x55,0x46,0x36,0x11,0x06,0x0A,0x03,  /* 000001E8    "BUF6...." */
    0x03,0x02,0x01,0x08,0x42,0x55,0x46,0x37,  /* 000001F0    "....BUF7" */
    0x11,0x05,0x0A,0x02,0x02,0x01,0x08,0x50,  /* 000001F8    ".......P" */
    0x41,0x43,0x30,0x12,0x27,0x03,0x0E,0x1F,  /* 00000200    "AC0.'..." */
    0x32,0x54,0x76,0x98,0xBA,0xDC,0xFE,0x0D,  /* 00000208    "2Tv....." */
    0x74,0x65,0x73,0x74,0x20,0x70,0x61,0x63,  /* 00000210    "test pac" */
    0x6B,0x61,0x67,0x65,0x30,0x00,0x11,0x0C,  /* 00000218    "kage0..." */
    0x0A,0x09,0x13,0x12,0x11,0x10,0x0F,0x0E,  /* 00000220    "........" */
    0x0D,0x0C,0x0B,0x08,0x50,0x41,0x43,0x31,  /* 00000228    "....PAC1" */
    0x12,0x27,0x03,0x0E,0x1F,0x32,0x54,0x76,  /* 00000230    ".'...2Tv" */
    0x98,0xBA,0xDC,0xFE,0x0D,0x74,0x65,0x73,  /* 00000238    ".....tes" */
    0x74,0x20,0x70,0x61,0x63,0x6B,0x61,0x67,  /* 00000240    "t packag" */
    0x65,0x31,0x00,0x11,0x0C,0x0A,0x09,0x13,  /* 00000248    "e1......" */
    0x12,0x11,0x10,0x0F,0x0E,0x0D,0x0C,0x0B,  /* 00000250    "........" */
    0x08,0x50,0x41,0x43,0x32,0x12,0x27,0x03,  /* 00000258    ".PAC2.'." */
    0x0E,0x1F,0x32,0x54,0x76,0x98,0xBA,0xDC,  /* 00000260    "..2Tv..." */
    0xFE,0x0D,0x74,0x65,0x73,0x74,0x20,0x70,  /* 00000268    "..test p" */
    0x61,0x63,0x6B,0x61,0x67,0x65,0x32,0x00,  /* 00000270    "ackage2." */
    0x11,0x0C,0x0A,0x09,0x13,0x12,0x11,0x10,  /* 00000278    "........" */
    0x0F,0x0E,0x0D,0x0C,0x0B,0x5B,0x81,0x2A,  /* 00000280    ".....[.*" */
    0x4F,0x50,0x52,0x30,0x01,0x46,0x4C,0x55,  /* 00000288    "OPR0.FLU" */
    0x30,0x45,0x04,0x46,0x4C,0x55,0x31,0x44,  /* 00000290    "0E.FLU1D" */
    0x04,0x46,0x4C,0x55,0x32,0x43,0x04,0x46,  /* 00000298    ".FLU2C.F" */
    0x4C,0x55,0x33,0x42,0x04,0x46,0x4C,0x55,  /* 000002A0    "LU3B.FLU" */
    0x34,0x41,0x04,0x46,0x4C,0x55,0x35,0x40,  /* 000002A8    "4A.FLU5@" */
    0x04,0x5B,0x82,0x10,0x44,0x45,0x56,0x30,  /* 000002B0    ".[..DEV0" */
    0x08,0x53,0x30,0x30,0x30,0x0D,0x44,0x45,  /* 000002B8    ".S000.DE" */
    0x56,0x30,0x00,0x5B,0x82,0x10,0x44,0x45,  /* 000002C0    "V0.[..DE" */
    0x56,0x31,0x08,0x53,0x30,0x30,0x30,0x0D,  /* 000002C8    "V1.S000." */
    0x44,0x45,0x56,0x31,0x00,0x5B,0x82,0x10,  /* 000002D0    "DEV1.[.." */
    0x44,0x45,0x56,0x32,0x08,0x53,0x30,0x30,  /* 000002D8    "DEV2.S00" */
    0x30,0x0D,0x44,0x45,0x56,0x32,0x00,0x5B,  /* 000002E0    "0.DEV2.[" */
    0x82,0x10,0x44,0x45,0x56,0x33,0x08,0x53,  /* 000002E8    "..DEV3.S" */
    0x30,0x30,0x30,0x0D,0x44,0x45,0x56,0x33,  /* 000002F0    "000.DEV3" */
    0x00,0x5B,0x02,0x45,0x56,0x45,0x30,0x5B,  /* 000002F8    ".[.EVE0[" */
    0x02,0x45,0x56,0x45,0x31,0x5B,0x02,0x45,  /* 00000300    ".EVE1[.E" */
    0x56,0x45,0x32,0x14,0x09,0x4D,0x4D,0x4D,  /* 00000308    "VE2..MMM" */
    0x30,0x00,0xA4,0x0A,0x00,0x14,0x09,0x4D,  /* 00000310    "0......M" */
    0x4D,0x4D,0x31,0x00,0xA4,0x0A,0x01,0x14,  /* 00000318    "MM1....." */
    0x09,0x4D,0x4D,0x4D,0x32,0x00,0xA4,0x0A,  /* 00000320    ".MMM2..." */
    0x02,0x5B,0x01,0x4D,0x54,0x58,0x30,0x00,  /* 00000328    ".[.MTX0." */
    0x5B,0x01,0x4D,0x54,0x58,0x31,0x01,0x5B,  /* 00000330    "[.MTX1.[" */
    0x01,0x4D,0x54,0x58,0x32,0x02,0x5B,0x01,  /* 00000338    ".MTX2.[." */
    0x4D,0x54,0x58,0x33,0x03,0x5B,0x01,0x4D,  /* 00000340    "MTX3.[.M" */
    0x54,0x58,0x34,0x04,0x5B,0x80,0x4F,0x50,  /* 00000348    "TX4.[.OP" */
    0x52,0x30,0x00,0x0A,0x00,0x0A,0x32,0x5B,  /* 00000350    "R0....2[" */
    0x80,0x4F,0x50,0x52,0x31,0x00,0x0A,0xC8,  /* 00000358    ".OPR1..." */
    0x0A,0x1E,0x5B,0x84,0x13,0x50,0x57,0x52,  /* 00000360    "..[..PWR" */
    0x30,0x00,0x00,0x00,0x08,0x53,0x30,0x30,  /* 00000368    "0....S00" */
    0x30,0x0D,0x50,0x57,0x52,0x30,0x00,0x5B,  /* 00000370    "0.PWR0.[" */
    0x84,0x13,0x50,0x57,0x52,0x31,0x00,0x00,  /* 00000378    "..PWR1.." */
    0x00,0x08,0x53,0x30,0x30,0x30,0x0D,0x50,  /* 00000380    "..S000.P" */
    0x57,0x52,0x31,0x00,0x5B,0x84,0x13,0x50,  /* 00000388    "WR1.[..P" */
    0x57,0x52,0x32,0x00,0x00,0x00,0x08,0x53,  /* 00000390    "WR2....S" */
    0x30,0x30,0x30,0x0D,0x50,0x57,0x52,0x32,  /* 00000398    "000.PWR2" */
    0x00,0x5B,0x83,0x16,0x43,0x50,0x55,0x30,  /* 000003A0    ".[..CPU0" */
    0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x08,0x53,  /* 000003A8    ".......S" */
    0x30,0x30,0x30,0x0D,0x43,0x50,0x55,0x30,  /* 000003B0    "000.CPU0" */
    0x00,0x5B,0x83,0x16,0x43,0x50,0x55,0x31,  /* 000003B8    ".[..CPU1" */
    0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x08,0x53,  /* 000003C0    ".......S" */
    0x30,0x30,0x30,0x0D,0x43,0x50,0x55,0x31,  /* 000003C8    "000.CPU1" */
    0x00,0x5B,0x83,0x16,0x43,0x50,0x55,0x32,  /* 000003D0    ".[..CPU2" */
    0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x08,0x53,  /* 000003D8    ".......S" */
    0x30,0x30,0x30,0x0D,0x43,0x50,0x55,0x32,  /* 000003E0    "000.CPU2" */
    0x00,0x5B,0x85,0x10,0x54,0x5A,0x4E,0x30,  /* 000003E8    ".[..TZN0" */
    0x08,0x53,0x30,0x30,0x30,0x0D,0x54,0x5A,  /* 000003F0    ".S000.TZ" */
    0x4E,0x30,0x00,0x5B,0x85,0x10,0x54,0x5A,  /* 000003F8    "N0.[..TZ" */
    0x4E,0x31,0x08,0x53,0x30,0x30,0x30,0x0D,  /* 00000400    "N1.S000." */
    0x54,0x5A,0x4E,0x31,0x00,0x5B,0x85,0x10,  /* 00000408    "TZN1.[.." */
    0x54,0x5A,0x4E,0x32,0x08,0x53,0x30,0x30,  /* 00000410    "TZN2.S00" */
    0x30,0x0D,0x54,0x5A,0x4E,0x32,0x00,0x5B,  /* 00000418    "0.TZN2.[" */
    0x13,0x5C,0x42,0x55,0x46,0x5A,0x0A,0x00,  /* 00000420    ".\BUFZ.." */
    0x0A,0x45,0x42,0x46,0x4C,0x30,0x5B,0x13,  /* 00000428    ".EBFL0[." */
    0x5C,0x42,0x55,0x46,0x5A,0x0A,0x07,0x0A,  /* 00000430    "\BUFZ..." */
    0x44,0x42,0x46,0x4C,0x31,0x5B,0x13,0x5C,  /* 00000438    "DBFL1[.\" */
    0x42,0x55,0x46,0x5A,0x0A,0x0B,0x0A,0x43,  /* 00000440    "BUFZ...C" */
    0x42,0x46,0x4C,0x32,0x5B,0x13,0x5C,0x42,  /* 00000448    "BFL2[.\B" */
    0x55,0x46,0x5A,0x0A,0x0D,0x0A,0x42,0x42,  /* 00000450    "UFZ...BB" */
    0x46,0x4C,0x33,0x5B,0x13,0x5C,0x42,0x55,  /* 00000458    "FL3[.\BU" */
    0x46,0x5A,0x0A,0x18,0x0A,0x41,0x42,0x46,  /* 00000460    "FZ...ABF" */
    0x4C,0x34,0x5B,0x13,0x5C,0x42,0x55,0x46,  /* 00000468    "L4[.\BUF" */
    0x5A,0x0A,0x1D,0x0A,0x40,0x42,0x46,0x4C,  /* 00000470    "Z...@BFL" */
    0x35,
})

	Name (HI0F, 0x00)
	Name (HI0, 0)
	Name (HI0N, 0)
	Name (INIF, 0x00)

	OperationRegion (IST0, SystemMemory, 0, 0x479)

	Field(IST0, ByteAcc, NoLock, Preserve) {
		RFU0, 0x23C8,
	}

	Field(IST0, ByteAcc, NoLock, Preserve) {
		SIG, 32,
		LENG, 32,
		REV, 8,
		SUM, 8,
		OID, 48,
		OTID, 64,
		OREV, 32,
		CID, 32,
		CREV, 32,
		Offset(38),
		SSNM, 32
	}

	// components/utilities/utmisc.c AcpiUtGenerateChecksum() analog
	Method(CHSM, 2)	// buf, len
	{
		Name(lpN0, 0)
		Name(lpC0, 0)

		Store(0, Local0) // sum

		Store(arg1, lpN0)
		Store(0, lpC0)

		While(lpN0) {
			Store(DeRefOf(Index(arg0, lpC0)), Local1)
			Add(Local0, Local1, Local0)
			Mod(Local0, 0x100, Local0)
			Decrement(lpN0)
			Increment(lpC0)
		}

		Subtract(0, Local0, Local0)
		Mod(Local0, 0x100, Local0)

		Store("Checksum", Debug)
		Store(Local0, Debug)

		return (Local0)
	}

	Method(INIT)
	{
		if (INIF) {
			Store("INIT: OpRegion has been initialized previously", Debug)
			Return (1)
		}
		Store(BUF0, RFU0)
		Store(1, INIF)
		Store("INIT: OpRegion initialized with SSDT", Debug)

		Return (0)
	}

	Method(LD)
	{
		if (HI0F) {
			Store("LD: SSDT has already been loaded", Debug)
			Return (1)
		}
		Increment(HI0N)

		// Recalculate and save CheckSum
		Store(RFU0, Local0)
		Store(Add(SUM, CHSM(Local0, SizeOf (Local0))), SUM)

//		Load(IST0, HI0)
		Load(RFU0, HI0)
		Store(1, HI0F)
		Store("LD: SSDT loaded", Debug)

		Return (0)
	}

	Method(UNLD)
	{
		if (LNot(HI0F)) {
			Store("UNLD: there are no SSDT loaded", Debug)
			Return (1)
		}

		UnLoad(HI0)
		Store(0, HI0F)
		Store(0, HI0)
		Store("UNLD: SSDT UnLoaded", Debug)

		Return (0)
	}
}
