/*
 * Some or all of this work - Copyright (c) 2006 - 2012, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Resource Descriptor macros
 *
 * I2cSerialBus Resource Descriptor Macro
 */
Device (I2C) {}

Name (p456, Package() {
	ResourceTemplate () {
        I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
            AddressingMode7Bit, "\\I2C",
            0xEE, ResourceConsumer, ,
            RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceConsumer, ,
            RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode7Bit, "\\I2C",
            0xEE, ResourceConsumer, ,
            RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceConsumer, ,
            RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
            AddressingMode7Bit, "\\I2C",
            0xEE, ResourceProducer, ,
            RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceProducer, ,
            RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode7Bit, "\\I2C",
            0xEE, ResourceProducer, ,
            RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceProducer, ,
            RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
            AddressingMode7Bit, "\\I2C",
            0xEE, ResourceConsumer, ,)
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceConsumer,)
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode7Bit, "\\I2C",
            0xEE, ResourceConsumer)
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceConsumer)
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
            AddressingMode7Bit, "\\I2C",
            0xEE, ResourceProducer, ,)
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceProducer,)
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode7Bit, "\\I2C",
            0xEE, ResourceProducer)
    },
	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceProducer, ,)
    },


    // Minimal invocation
	ResourceTemplate () {
        I2cSerialBus (0x1234, , 0x88775544, , "\\I2C", , , ,)
    },

	ResourceTemplate () {
        I2cSerialBus (0x1234, ControllerInitiated, 0x88775544,
            AddressingMode10Bit, "\\I2C",
            0xEE, ResourceProducer, ,
            RawDataBuffer () {
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
                0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
            })
    },

})


Name (p457, Package() {
    Buffer (0x1D)
    {
        /* 0000 */    0x8E, 0x18, 0x00, 0x01, 0xEE, 0x01, 0x03, 0x00,
        /* 0008 */    0x00, 0x01, 0x0A, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0x5C, 0x49,
        /* 0018 */    0x32, 0x43, 0x00, 0x79, 0x00
    },

    Buffer (0x1D)
    {
        /* 0000 */    0x8E, 0x18, 0x00, 0x01, 0xEE, 0x01, 0x03, 0x01,
        /* 0008 */    0x00, 0x01, 0x0A, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0x5C, 0x49,
        /* 0018 */    0x32, 0x43, 0x00, 0x79, 0x00
    },

    Buffer (0x1D)
    {
        /* 0000 */    0x8E, 0x18, 0x00, 0x01, 0xEE, 0x01, 0x02, 0x00,
        /* 0008 */    0x00, 0x01, 0x0A, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0x5C, 0x49,
        /* 0018 */    0x32, 0x43, 0x00, 0x79, 0x00
    },

    Buffer (0x1D)
    {
        /* 0000 */    0x8E, 0x18, 0x00, 0x01, 0xEE, 0x01, 0x02, 0x01,
        /* 0008 */    0x00, 0x01, 0x0A, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0x5C, 0x49,
        /* 0018 */    0x32, 0x43, 0x00, 0x79, 0x00
    },

    Buffer (0x1D)
    {
        /* 0000 */    0x8E, 0x18, 0x00, 0x01, 0xEE, 0x01, 0x01, 0x00,
        /* 0008 */    0x00, 0x01, 0x0A, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0x5C, 0x49,
        /* 0018 */    0x32, 0x43, 0x00, 0x79, 0x00
    },

    Buffer (0x1D)
    {
        /* 0000 */    0x8E, 0x18, 0x00, 0x01, 0xEE, 0x01, 0x01, 0x01,
        /* 0008 */    0x00, 0x01, 0x0A, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0x5C, 0x49,
        /* 0018 */    0x32, 0x43, 0x00, 0x79, 0x00
    },

    Buffer (0x1D)
    {
        /* 0000 */    0x8E, 0x18, 0x00, 0x01, 0xEE, 0x01, 0x00, 0x00,
        /* 0008 */    0x00, 0x01, 0x0A, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0x5C, 0x49,
        /* 0018 */    0x32, 0x43, 0x00, 0x79, 0x00
    },

    Buffer (0x1D)
    {
        /* 0000 */    0x8E, 0x18, 0x00, 0x01, 0xEE, 0x01, 0x00, 0x01,
        /* 0008 */    0x00, 0x01, 0x0A, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0x5C, 0x49,
        /* 0018 */    0x32, 0x43, 0x00, 0x79, 0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0xEE, 0x01, 0x03, 0x00,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0xEE, 0x01, 0x03, 0x01,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0xEE, 0x01, 0x02, 0x00,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0xEE, 0x01, 0x02, 0x01,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0xEE, 0x01, 0x01, 0x00,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0xEE, 0x01, 0x01, 0x01,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0xEE, 0x01, 0x00, 0x00,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0xEE, 0x01, 0x00, 0x01,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x19)
    {
        /* 0000 */    0x8E, 0x14, 0x00, 0x01, 0x00, 0x01, 0x02, 0x00,
        /* 0008 */    0x00, 0x01, 0x06, 0x00, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0018 */    0x00
    },

    Buffer (0x0181)
    {
        /* 0000 */    0x8E, 0x7C, 0x01, 0x01, 0xEE, 0x01, 0x00, 0x01,
        /* 0008 */    0x00, 0x01, 0x6E, 0x01, 0x44, 0x55, 0x77, 0x88,
        /* 0010 */    0x34, 0x12, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0018 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0020 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0028 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0030 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0038 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0040 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0048 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0050 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0058 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0060 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0068 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0070 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0078 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0080 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0088 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0090 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0098 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00A0 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00A8 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00B0 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00B8 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00C0 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00C8 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00D0 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00D8 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00E0 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00E8 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00F0 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 00F8 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0100 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0108 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0110 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0118 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0120 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0128 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0130 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0138 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0140 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0148 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0150 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0158 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0160 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0168 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0170 */    0xB7, 0xB8, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6,
        /* 0178 */    0xB7, 0xB8, 0x5C, 0x49, 0x32, 0x43, 0x00, 0x79,
        /* 0180 */    0x00
    }
})

Method(RT23)
{
	Name(ts, "RT23")

	// Emit test header, set the filename

	THDR (ts, "I2cSerialBus Resource Descriptor Macro", __FILE__)

    // The main test packages must have the same number of entries

    If (LNotEqual (SizeOf (p456), SizeOf (p457)))
    {
        err (ts, 180, 0, 0, 0, 0, "Incorrect package length")
        Return ()
    }

    // Main test case for packages above

	m330(ts, SizeOf (p456), "p456", p456, p457)

    // Check resource descriptor tag offsets

	Store (
		ResourceTemplate () {
            I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
                AddressingMode10Bit, "\\I2C",
                0xEE, ResourceConsumer, I2C0,
                RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
            I2cSerialBus (0x1234, DeviceInitiated, 0x88775544,
                AddressingMode10Bit, "\\I2C",
                0xEE, ResourceConsumer, I2C1,
                RawDataBuffer (4) {0xB1, 0xB2, 0xB3, 0xB4})
		}, Local0)

    m331(ts, 1, I2C0._SLV, 0x30, I2C1._SLV, 0x108, "_SLV")
    m331(ts, 2, I2C0._MOD, 0x38, I2C1._MOD, 0x110, "_MOD")
    m331(ts, 3, I2C0._SPE, 0x60, I2C1._SPE, 0x138, "_SPE")
    m331(ts, 4, I2C0._ADR, 0x80, I2C1._ADR, 0x158, "_ADR")
    m331(ts, 5, I2C0._VEN, 0x90, I2C1._VEN, 0x168, "_VEN")
}


