/*
 * Some or all of this work - Copyright (c) 2006 - 2015, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Resource Descriptor macros
 *
 * Resource To Buffer Conversion Macro
 */

Name (p438, Package() {
	ResourceTemplate () {
	},
	ResourceTemplate () {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		FixedIO (0x03f1, 0xf2)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIOX, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIOX, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIOX, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QMEX, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DMEX, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBNX)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INTX) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIOX, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EMEX, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESPX)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSPX)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSPX)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSPX)
	},
	ResourceTemplate () {
		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		}
		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		}
		StartDependentFn (0, 0) {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		}
		StartDependentFn (0, 1) {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		FixedIO (0x03f1, 0xf2)
		}
		StartDependentFn (0, 2) {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		FixedIO (0x03f1, 0xf2)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		}
		StartDependentFn (1, 0) {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		FixedIO (0x03f1, 0xf2)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		FixedIO (0x03f1, 0xf2)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		FixedIO (0x03f1, 0xf2)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIOY, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIOY, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIOY, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QMEY, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DMEY, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBNY)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INTY) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIOY, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EMEY, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESPY)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSPY)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSPY)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSPY)
		}
		StartDependentFn (1, 2) {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		FixedIO (0x03f1, 0xf2)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7)
		}
		StartDependentFn (2, 0) {}
		StartDependentFn (2, 1) {
		IRQ (Level, ActiveHigh, Exclusive) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		FixedIO (0x03f1, 0xf2)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		}
		StartDependentFn (2, 2) {}
		EndDependentFn ()
	},
})

// Complex test data

Name (p445, Package() {
	ResourceTemplate () {
		IRQ (Level, ActiveHigh, Exclusive, IRQZ) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAZ) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0Z)
		FixedIO (0x03f1, 0xf2, FIOZ)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24Z)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32Z)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FZ)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIOZ, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIOZ, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIOZ, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QMEZ, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DMEZ, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBNZ)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INTZ) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIOZ, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EMEZ, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESPZ)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSPZ)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSPZ)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSPZ)

		// Duplicated part

		IRQ (Level, ActiveHigh, Exclusive, IRQ1) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA1) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO01)
		FixedIO (0x03f1, 0xf2, FIO1)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M241)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32Y)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3F1)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIO1, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIO1, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIO1, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QME1, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DME1, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBN1)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INT1) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIO1, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EME1, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESP1)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSP1)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSP1)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSP1)
	},

	ResourceTemplate () {
		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ2) {0}
		IRQNoFlags () {1}
		}
		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ4) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA4) {2}
		}
		StartDependentFn (0, 0) {
		IRQ (Level, ActiveHigh, Exclusive, IRQ6) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA6) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		}
		StartDependentFn (0, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQ8) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA8) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO08)
		FixedIO (0x03f1, 0xf2, FIO8)
		}
		StartDependentFn (0, 2) {
		IRQ (Level, ActiveHigh, Exclusive, IRQA) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAA) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0A)
		FixedIO (0x03f1, 0xf2, FIOA)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		}
		StartDependentFn (1, 0) {
		IRQ (Level, ActiveHigh, Exclusive, IRQC) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAC) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0C)
		FixedIO (0x03f1, 0xf2, FIOC)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24C)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQE) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAE) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0E)
		FixedIO (0x03f1, 0xf2, FIOE)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24E)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32E)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQG) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAG) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0G)
		FixedIO (0x03f1, 0xf2, FIOG)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24G)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32G)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FG)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIOG, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIOG, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIOG, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QMEG, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DMEG, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBNG)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INTG) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIOG, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EMEG, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESPG)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSPG)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSPG)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSPG)
		}
		StartDependentFn (1, 2) {
		IRQ (Level, ActiveHigh, Exclusive, IRQI) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAI) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0I)
		FixedIO (0x03f1, 0xf2, FIOI)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24I)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32I)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FI)
		}
		StartDependentFn (2, 0) {}
		StartDependentFn (2, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQK) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAK) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0K)
		FixedIO (0x03f1, 0xf2, FIOK)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24K)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32K)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FK)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		}
		StartDependentFn (2, 2) {}
		EndDependentFn ()

		// Duplicated part

		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ3) {0}
		IRQNoFlags () {1}
		}
		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ5) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA5) {2}
		}
		StartDependentFn (0, 0) {
		IRQ (Level, ActiveHigh, Exclusive, IRQ7) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA7) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5)
		}
		StartDependentFn (0, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQ9) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA9) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO09)
		FixedIO (0x03f1, 0xf2, FIO9)
		}
		StartDependentFn (0, 2) {
		IRQ (Level, ActiveHigh, Exclusive, IRQB) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAB) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0B)
		FixedIO (0x03f1, 0xf2, FIOB)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		}
		StartDependentFn (1, 0) {
		IRQ (Level, ActiveHigh, Exclusive, IRQD) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAD) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0D)
		FixedIO (0x03f1, 0xf2, FIOD)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24D)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQF) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAF) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0F)
		FixedIO (0x03f1, 0xf2, FIOF)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24F)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32F)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQH) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAH) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0H)
		FixedIO (0x03f1, 0xf2, FIOH)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24H)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32H)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FH)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIOH, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIOH, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIOH, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QMEH, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DMEH, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBNH)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INTH) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIOH, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EMEH, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESPH)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSPH)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSPH)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSPH)
		}
		StartDependentFn (1, 2) {
		IRQ (Level, ActiveHigh, Exclusive, IRQJ) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAJ) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0J)
		FixedIO (0x03f1, 0xf2, FIOJ)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24J)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32J)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FJ)
		}
		StartDependentFn (2, 0) {}
		StartDependentFn (2, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQL) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAL) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0L)
		FixedIO (0x03f1, 0xf2, FIOL)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24L)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32L)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FL)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		}
		StartDependentFn (2, 2) {}
		EndDependentFn ()
	},
})

/*
ACPI Specification, Revision 3.0, September 2, 2004
6.4.2.8   End Tag

Type 0, Small Item Name 0xF, Length = 1
The End tag identifies an end of resource data.
Note: If the checksum field is zero, the resource data is treated as if the checksum
operation succeeded. Configuration proceeds normally.
	Table 6-31   End Tag Definition
Offset	Field Name
Byte 0	Value = 01111001B (0x79) (Type = 0, small item name = 0xF, length = 1)
Byte 1	Checksum covering all resource data after the serial identifier. This checksum is
		generated such that adding it to the sum of all the data bytes will produce a zero sum.
The End Tag is automatically generated by the ASL compiler at the end of the ResourceTemplate
statement.
*/

Name (p439, Package() {
	Buffer () {0x79, 0x00},
	Buffer () {0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
		0x8a, 0x39, 0x00, 0x01, 0x0f, 0x33,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x01, 0x0f, 0x33, 0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x01, 0x0f, 0x33,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0x00, 0x0f, 0x30,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x00, 0x0f, 0x30,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x02, 0x0f, 0x00,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x89, 0xc8, 0x04, 0x0f, 0xff,
			  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
			  5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,
			  9,  0,  0,  0, 10,  0,  0,  0, 11,  0,  0,  0, 12,  0,  0,  0,
			 13,  0,  0,  0, 14,  0,  0,  0, 15,  0,  0,  0, 16,  0,  0,  0,
			 17,  0,  0,  0, 18,  0,  0,  0, 19,  0,  0,  0, 20,  0,  0,  0,
			 21,  0,  0,  0, 22,  0,  0,  0, 23,  0,  0,  0, 24,  0,  0,  0,
			 25,  0,  0,  0, 26,  0,  0,  0, 27,  0,  0,  0, 28,  0,  0,  0,
			 29,  0,  0,  0, 30,  0,  0,  0, 31,  0,  0,  0, 32,  0,  0,  0,
			 33,  0,  0,  0, 34,  0,  0,  0, 35,  0,  0,  0, 36,  0,  0,  0,
			 37,  0,  0,  0, 38,  0,  0,  0, 39,  0,  0,  0, 40,  0,  0,  0,
			 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0, 44,  0,  0,  0,
			 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0, 48,  0,  0,  0,
			 49,  0,  0,  0, 50,  0,  0,  0, 51,  0,  0,  0, 52,  0,  0,  0,
			 53,  0,  0,  0, 54,  0,  0,  0, 55,  0,  0,  0, 56,  0,  0,  0,
			 57,  0,  0,  0, 58,  0,  0,  0, 59,  0,  0,  0, 60,  0,  0,  0,
			 61,  0,  0,  0, 62,  0,  0,  0, 63,  0,  0,  0, 64,  0,  0,  0,
			 65,  0,  0,  0, 66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0,
			 69,  0,  0,  0, 70,  0,  0,  0, 71,  0,  0,  0, 72,  0,  0,  0,
			 73,  0,  0,  0, 74,  0,  0,  0, 75,  0,  0,  0, 76,  0,  0,  0,
			 77,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
			 81,  0,  0,  0, 82,  0,  0,  0, 83,  0,  0,  0, 84,  0,  0,  0,
			 85,  0,  0,  0, 86,  0,  0,  0, 87,  0,  0,  0, 88,  0,  0,  0,
			 89,  0,  0,  0, 90,  0,  0,  0, 91,  0,  0,  0, 92,  0,  0,  0,
			 93,  0,  0,  0, 94,  0,  0,  0, 95,  0,  0,  0, 96,  0,  0,  0,
			 97,  0,  0,  0, 98,  0,  0,  0, 99,  0,  0,  0,100,  0,  0,  0,
			101,  0,  0,  0,102,  0,  0,  0,103,  0,  0,  0,104,  0,  0,  0,
			105,  0,  0,  0,106,  0,  0,  0,107,  0,  0,  0,108,  0,  0,  0,
			109,  0,  0,  0,110,  0,  0,  0,111,  0,  0,  0,112,  0,  0,  0,
			113,  0,  0,  0,114,  0,  0,  0,115,  0,  0,  0,116,  0,  0,  0,
			117,  0,  0,  0,118,  0,  0,  0,119,  0,  0,  0,120,  0,  0,  0,
			121,  0,  0,  0,122,  0,  0,  0,123,  0,  0,  0,124,  0,  0,  0,
			125,  0,  0,  0,126,  0,  0,  0,127,  0,  0,  0,128,  0,  0,  0,
			129,  0,  0,  0,130,  0,  0,  0,131,  0,  0,  0,132,  0,  0,  0,
			133,  0,  0,  0,134,  0,  0,  0,135,  0,  0,  0,136,  0,  0,  0,
			137,  0,  0,  0,138,  0,  0,  0,139,  0,  0,  0,140,  0,  0,  0,
			141,  0,  0,  0,142,  0,  0,  0,143,  0,  0,  0,144,  0,  0,  0,
			145,  0,  0,  0,146,  0,  0,  0,147,  0,  0,  0,148,  0,  0,  0,
			149,  0,  0,  0,150,  0,  0,  0,151,  0,  0,  0,152,  0,  0,  0,
			153,  0,  0,  0,154,  0,  0,  0,155,  0,  0,  0,156,  0,  0,  0,
			157,  0,  0,  0,158,  0,  0,  0,159,  0,  0,  0,160,  0,  0,  0,
			161,  0,  0,  0,162,  0,  0,  0,163,  0,  0,  0,164,  0,  0,  0,
			165,  0,  0,  0,166,  0,  0,  0,167,  0,  0,  0,168,  0,  0,  0,
			169,  0,  0,  0,170,  0,  0,  0,171,  0,  0,  0,172,  0,  0,  0,
			173,  0,  0,  0,174,  0,  0,  0,175,  0,  0,  0,176,  0,  0,  0,
			177,  0,  0,  0,178,  0,  0,  0,179,  0,  0,  0,180,  0,  0,  0,
			181,  0,  0,  0,182,  0,  0,  0,183,  0,  0,  0,184,  0,  0,  0,
			185,  0,  0,  0,186,  0,  0,  0,187,  0,  0,  0,188,  0,  0,  0,
			189,  0,  0,  0,190,  0,  0,  0,191,  0,  0,  0,192,  0,  0,  0,
			193,  0,  0,  0,194,  0,  0,  0,195,  0,  0,  0,196,  0,  0,  0,
			197,  0,  0,  0,198,  0,  0,  0,199,  0,  0,  0,200,  0,  0,  0,
			201,  0,  0,  0,202,  0,  0,  0,203,  0,  0,  0,204,  0,  0,  0,
			205,  0,  0,  0,206,  0,  0,  0,207,  0,  0,  0,208,  0,  0,  0,
			209,  0,  0,  0,210,  0,  0,  0,211,  0,  0,  0,212,  0,  0,  0,
			213,  0,  0,  0,214,  0,  0,  0,215,  0,  0,  0,216,  0,  0,  0,
			217,  0,  0,  0,218,  0,  0,  0,219,  0,  0,  0,220,  0,  0,  0,
			221,  0,  0,  0,222,  0,  0,  0,223,  0,  0,  0,224,  0,  0,  0,
			225,  0,  0,  0,226,  0,  0,  0,227,  0,  0,  0,228,  0,  0,  0,
			229,  0,  0,  0,230,  0,  0,  0,231,  0,  0,  0,232,  0,  0,  0,
			233,  0,  0,  0,234,  0,  0,  0,235,  0,  0,  0,236,  0,  0,  0,
			237,  0,  0,  0,238,  0,  0,  0,239,  0,  0,  0,240,  0,  0,  0,
			241,  0,  0,  0,242,  0,  0,  0,243,  0,  0,  0,244,  0,  0,  0,
			245,  0,  0,  0,246,  0,  0,  0,247,  0,  0,  0,248,  0,  0,  0,
			249,  0,  0,  0,250,  0,  0,  0,251,  0,  0,  0,252,  0,  0,  0,
			253,  0,  0,  0,254,  0,  0,  0,255,  0,  0,  0,
			0xff,
			0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
			0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
			0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
			0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
			0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
			0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
			0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
			0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
			0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
			0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
			0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
			0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21,
			0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
			0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
			0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
			0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
			0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
			0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
			0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
			0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
			0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
			0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21, 0x22,
			0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
			0x00,
		0x82, 0x0c, 0x00, 0x7f, 0xf0, 0xf1, 0x00,
			0xf9, 0xf8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
		0x8b, 0x35, 0x00, 0x01, 0x0f, 0x33, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0x00, 0x0f, 0x30, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0xc0, 0x0f, 0x5a, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x87, 0x25, 0x00, 0xc0, 0x0f, 0x5a,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0xc0, 0x0f, 0x5a,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0xc0, 0x0f, 0x5a,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x79, 0x00},
	Buffer () {
	0x30,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
	0x30,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
	0x31, 0x00,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
	0x31, 0x04,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
	0x31, 0x08,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
	0x31, 0x01,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
	0x31, 0x05,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
	0x31, 0x05,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
		0x8a, 0x39, 0x00, 0x01, 0x0f, 0x33,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x01, 0x0f, 0x33, 0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x01, 0x0f, 0x33,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0x00, 0x0f, 0x30,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x00, 0x0f, 0x30,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x02, 0x0f, 0x00,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x89, 0xc8, 0x04, 0x0f, 0xff,
			  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
			  5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,
			  9,  0,  0,  0, 10,  0,  0,  0, 11,  0,  0,  0, 12,  0,  0,  0,
			 13,  0,  0,  0, 14,  0,  0,  0, 15,  0,  0,  0, 16,  0,  0,  0,
			 17,  0,  0,  0, 18,  0,  0,  0, 19,  0,  0,  0, 20,  0,  0,  0,
			 21,  0,  0,  0, 22,  0,  0,  0, 23,  0,  0,  0, 24,  0,  0,  0,
			 25,  0,  0,  0, 26,  0,  0,  0, 27,  0,  0,  0, 28,  0,  0,  0,
			 29,  0,  0,  0, 30,  0,  0,  0, 31,  0,  0,  0, 32,  0,  0,  0,
			 33,  0,  0,  0, 34,  0,  0,  0, 35,  0,  0,  0, 36,  0,  0,  0,
			 37,  0,  0,  0, 38,  0,  0,  0, 39,  0,  0,  0, 40,  0,  0,  0,
			 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0, 44,  0,  0,  0,
			 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0, 48,  0,  0,  0,
			 49,  0,  0,  0, 50,  0,  0,  0, 51,  0,  0,  0, 52,  0,  0,  0,
			 53,  0,  0,  0, 54,  0,  0,  0, 55,  0,  0,  0, 56,  0,  0,  0,
			 57,  0,  0,  0, 58,  0,  0,  0, 59,  0,  0,  0, 60,  0,  0,  0,
			 61,  0,  0,  0, 62,  0,  0,  0, 63,  0,  0,  0, 64,  0,  0,  0,
			 65,  0,  0,  0, 66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0,
			 69,  0,  0,  0, 70,  0,  0,  0, 71,  0,  0,  0, 72,  0,  0,  0,
			 73,  0,  0,  0, 74,  0,  0,  0, 75,  0,  0,  0, 76,  0,  0,  0,
			 77,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
			 81,  0,  0,  0, 82,  0,  0,  0, 83,  0,  0,  0, 84,  0,  0,  0,
			 85,  0,  0,  0, 86,  0,  0,  0, 87,  0,  0,  0, 88,  0,  0,  0,
			 89,  0,  0,  0, 90,  0,  0,  0, 91,  0,  0,  0, 92,  0,  0,  0,
			 93,  0,  0,  0, 94,  0,  0,  0, 95,  0,  0,  0, 96,  0,  0,  0,
			 97,  0,  0,  0, 98,  0,  0,  0, 99,  0,  0,  0,100,  0,  0,  0,
			101,  0,  0,  0,102,  0,  0,  0,103,  0,  0,  0,104,  0,  0,  0,
			105,  0,  0,  0,106,  0,  0,  0,107,  0,  0,  0,108,  0,  0,  0,
			109,  0,  0,  0,110,  0,  0,  0,111,  0,  0,  0,112,  0,  0,  0,
			113,  0,  0,  0,114,  0,  0,  0,115,  0,  0,  0,116,  0,  0,  0,
			117,  0,  0,  0,118,  0,  0,  0,119,  0,  0,  0,120,  0,  0,  0,
			121,  0,  0,  0,122,  0,  0,  0,123,  0,  0,  0,124,  0,  0,  0,
			125,  0,  0,  0,126,  0,  0,  0,127,  0,  0,  0,128,  0,  0,  0,
			129,  0,  0,  0,130,  0,  0,  0,131,  0,  0,  0,132,  0,  0,  0,
			133,  0,  0,  0,134,  0,  0,  0,135,  0,  0,  0,136,  0,  0,  0,
			137,  0,  0,  0,138,  0,  0,  0,139,  0,  0,  0,140,  0,  0,  0,
			141,  0,  0,  0,142,  0,  0,  0,143,  0,  0,  0,144,  0,  0,  0,
			145,  0,  0,  0,146,  0,  0,  0,147,  0,  0,  0,148,  0,  0,  0,
			149,  0,  0,  0,150,  0,  0,  0,151,  0,  0,  0,152,  0,  0,  0,
			153,  0,  0,  0,154,  0,  0,  0,155,  0,  0,  0,156,  0,  0,  0,
			157,  0,  0,  0,158,  0,  0,  0,159,  0,  0,  0,160,  0,  0,  0,
			161,  0,  0,  0,162,  0,  0,  0,163,  0,  0,  0,164,  0,  0,  0,
			165,  0,  0,  0,166,  0,  0,  0,167,  0,  0,  0,168,  0,  0,  0,
			169,  0,  0,  0,170,  0,  0,  0,171,  0,  0,  0,172,  0,  0,  0,
			173,  0,  0,  0,174,  0,  0,  0,175,  0,  0,  0,176,  0,  0,  0,
			177,  0,  0,  0,178,  0,  0,  0,179,  0,  0,  0,180,  0,  0,  0,
			181,  0,  0,  0,182,  0,  0,  0,183,  0,  0,  0,184,  0,  0,  0,
			185,  0,  0,  0,186,  0,  0,  0,187,  0,  0,  0,188,  0,  0,  0,
			189,  0,  0,  0,190,  0,  0,  0,191,  0,  0,  0,192,  0,  0,  0,
			193,  0,  0,  0,194,  0,  0,  0,195,  0,  0,  0,196,  0,  0,  0,
			197,  0,  0,  0,198,  0,  0,  0,199,  0,  0,  0,200,  0,  0,  0,
			201,  0,  0,  0,202,  0,  0,  0,203,  0,  0,  0,204,  0,  0,  0,
			205,  0,  0,  0,206,  0,  0,  0,207,  0,  0,  0,208,  0,  0,  0,
			209,  0,  0,  0,210,  0,  0,  0,211,  0,  0,  0,212,  0,  0,  0,
			213,  0,  0,  0,214,  0,  0,  0,215,  0,  0,  0,216,  0,  0,  0,
			217,  0,  0,  0,218,  0,  0,  0,219,  0,  0,  0,220,  0,  0,  0,
			221,  0,  0,  0,222,  0,  0,  0,223,  0,  0,  0,224,  0,  0,  0,
			225,  0,  0,  0,226,  0,  0,  0,227,  0,  0,  0,228,  0,  0,  0,
			229,  0,  0,  0,230,  0,  0,  0,231,  0,  0,  0,232,  0,  0,  0,
			233,  0,  0,  0,234,  0,  0,  0,235,  0,  0,  0,236,  0,  0,  0,
			237,  0,  0,  0,238,  0,  0,  0,239,  0,  0,  0,240,  0,  0,  0,
			241,  0,  0,  0,242,  0,  0,  0,243,  0,  0,  0,244,  0,  0,  0,
			245,  0,  0,  0,246,  0,  0,  0,247,  0,  0,  0,248,  0,  0,  0,
			249,  0,  0,  0,250,  0,  0,  0,251,  0,  0,  0,252,  0,  0,  0,
			253,  0,  0,  0,254,  0,  0,  0,255,  0,  0,  0,
			0xff,
			0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
			0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
			0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
			0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
			0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
			0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
			0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
			0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
			0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
			0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
			0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
			0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21,
			0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
			0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
			0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
			0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
			0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
			0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
			0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
			0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
			0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
			0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21, 0x22,
			0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
			0x00,
		0x82, 0x0c, 0x00, 0x7f, 0xf0, 0xf1, 0x00,
			0xf9, 0xf8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
		0x8b, 0x35, 0x00, 0x01, 0x0f, 0x33, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0x00, 0x0f, 0x30, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0xc0, 0x0f, 0x5a, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x87, 0x25, 0x00, 0xc0, 0x0f, 0x5a,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0xc0, 0x0f, 0x5a,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0xc0, 0x0f, 0x5a,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
	0x31, 0x09,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
	0x31, 0x02,
	0x31, 0x06,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
	0x31, 0x0a,
	0x38,
	0x79, 0x00},
})

// Complex test data

Name (p446, Package() {
	Buffer () {0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
		0x8a, 0x39, 0x00, 0x01, 0x0f, 0x33,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x01, 0x0f, 0x33, 0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x01, 0x0f, 0x33,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0x00, 0x0f, 0x30,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x00, 0x0f, 0x30,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x02, 0x0f, 0x00,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x89, 0xc8, 0x04, 0x0f, 0xff,
			  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
			  5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,
			  9,  0,  0,  0, 10,  0,  0,  0, 11,  0,  0,  0, 12,  0,  0,  0,
			 13,  0,  0,  0, 14,  0,  0,  0, 15,  0,  0,  0, 16,  0,  0,  0,
			 17,  0,  0,  0, 18,  0,  0,  0, 19,  0,  0,  0, 20,  0,  0,  0,
			 21,  0,  0,  0, 22,  0,  0,  0, 23,  0,  0,  0, 24,  0,  0,  0,
			 25,  0,  0,  0, 26,  0,  0,  0, 27,  0,  0,  0, 28,  0,  0,  0,
			 29,  0,  0,  0, 30,  0,  0,  0, 31,  0,  0,  0, 32,  0,  0,  0,
			 33,  0,  0,  0, 34,  0,  0,  0, 35,  0,  0,  0, 36,  0,  0,  0,
			 37,  0,  0,  0, 38,  0,  0,  0, 39,  0,  0,  0, 40,  0,  0,  0,
			 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0, 44,  0,  0,  0,
			 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0, 48,  0,  0,  0,
			 49,  0,  0,  0, 50,  0,  0,  0, 51,  0,  0,  0, 52,  0,  0,  0,
			 53,  0,  0,  0, 54,  0,  0,  0, 55,  0,  0,  0, 56,  0,  0,  0,
			 57,  0,  0,  0, 58,  0,  0,  0, 59,  0,  0,  0, 60,  0,  0,  0,
			 61,  0,  0,  0, 62,  0,  0,  0, 63,  0,  0,  0, 64,  0,  0,  0,
			 65,  0,  0,  0, 66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0,
			 69,  0,  0,  0, 70,  0,  0,  0, 71,  0,  0,  0, 72,  0,  0,  0,
			 73,  0,  0,  0, 74,  0,  0,  0, 75,  0,  0,  0, 76,  0,  0,  0,
			 77,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
			 81,  0,  0,  0, 82,  0,  0,  0, 83,  0,  0,  0, 84,  0,  0,  0,
			 85,  0,  0,  0, 86,  0,  0,  0, 87,  0,  0,  0, 88,  0,  0,  0,
			 89,  0,  0,  0, 90,  0,  0,  0, 91,  0,  0,  0, 92,  0,  0,  0,
			 93,  0,  0,  0, 94,  0,  0,  0, 95,  0,  0,  0, 96,  0,  0,  0,
			 97,  0,  0,  0, 98,  0,  0,  0, 99,  0,  0,  0,100,  0,  0,  0,
			101,  0,  0,  0,102,  0,  0,  0,103,  0,  0,  0,104,  0,  0,  0,
			105,  0,  0,  0,106,  0,  0,  0,107,  0,  0,  0,108,  0,  0,  0,
			109,  0,  0,  0,110,  0,  0,  0,111,  0,  0,  0,112,  0,  0,  0,
			113,  0,  0,  0,114,  0,  0,  0,115,  0,  0,  0,116,  0,  0,  0,
			117,  0,  0,  0,118,  0,  0,  0,119,  0,  0,  0,120,  0,  0,  0,
			121,  0,  0,  0,122,  0,  0,  0,123,  0,  0,  0,124,  0,  0,  0,
			125,  0,  0,  0,126,  0,  0,  0,127,  0,  0,  0,128,  0,  0,  0,
			129,  0,  0,  0,130,  0,  0,  0,131,  0,  0,  0,132,  0,  0,  0,
			133,  0,  0,  0,134,  0,  0,  0,135,  0,  0,  0,136,  0,  0,  0,
			137,  0,  0,  0,138,  0,  0,  0,139,  0,  0,  0,140,  0,  0,  0,
			141,  0,  0,  0,142,  0,  0,  0,143,  0,  0,  0,144,  0,  0,  0,
			145,  0,  0,  0,146,  0,  0,  0,147,  0,  0,  0,148,  0,  0,  0,
			149,  0,  0,  0,150,  0,  0,  0,151,  0,  0,  0,152,  0,  0,  0,
			153,  0,  0,  0,154,  0,  0,  0,155,  0,  0,  0,156,  0,  0,  0,
			157,  0,  0,  0,158,  0,  0,  0,159,  0,  0,  0,160,  0,  0,  0,
			161,  0,  0,  0,162,  0,  0,  0,163,  0,  0,  0,164,  0,  0,  0,
			165,  0,  0,  0,166,  0,  0,  0,167,  0,  0,  0,168,  0,  0,  0,
			169,  0,  0,  0,170,  0,  0,  0,171,  0,  0,  0,172,  0,  0,  0,
			173,  0,  0,  0,174,  0,  0,  0,175,  0,  0,  0,176,  0,  0,  0,
			177,  0,  0,  0,178,  0,  0,  0,179,  0,  0,  0,180,  0,  0,  0,
			181,  0,  0,  0,182,  0,  0,  0,183,  0,  0,  0,184,  0,  0,  0,
			185,  0,  0,  0,186,  0,  0,  0,187,  0,  0,  0,188,  0,  0,  0,
			189,  0,  0,  0,190,  0,  0,  0,191,  0,  0,  0,192,  0,  0,  0,
			193,  0,  0,  0,194,  0,  0,  0,195,  0,  0,  0,196,  0,  0,  0,
			197,  0,  0,  0,198,  0,  0,  0,199,  0,  0,  0,200,  0,  0,  0,
			201,  0,  0,  0,202,  0,  0,  0,203,  0,  0,  0,204,  0,  0,  0,
			205,  0,  0,  0,206,  0,  0,  0,207,  0,  0,  0,208,  0,  0,  0,
			209,  0,  0,  0,210,  0,  0,  0,211,  0,  0,  0,212,  0,  0,  0,
			213,  0,  0,  0,214,  0,  0,  0,215,  0,  0,  0,216,  0,  0,  0,
			217,  0,  0,  0,218,  0,  0,  0,219,  0,  0,  0,220,  0,  0,  0,
			221,  0,  0,  0,222,  0,  0,  0,223,  0,  0,  0,224,  0,  0,  0,
			225,  0,  0,  0,226,  0,  0,  0,227,  0,  0,  0,228,  0,  0,  0,
			229,  0,  0,  0,230,  0,  0,  0,231,  0,  0,  0,232,  0,  0,  0,
			233,  0,  0,  0,234,  0,  0,  0,235,  0,  0,  0,236,  0,  0,  0,
			237,  0,  0,  0,238,  0,  0,  0,239,  0,  0,  0,240,  0,  0,  0,
			241,  0,  0,  0,242,  0,  0,  0,243,  0,  0,  0,244,  0,  0,  0,
			245,  0,  0,  0,246,  0,  0,  0,247,  0,  0,  0,248,  0,  0,  0,
			249,  0,  0,  0,250,  0,  0,  0,251,  0,  0,  0,252,  0,  0,  0,
			253,  0,  0,  0,254,  0,  0,  0,255,  0,  0,  0,
			0xff,
			0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
			0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
			0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
			0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
			0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
			0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
			0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
			0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
			0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
			0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
			0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
			0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21,
			0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
			0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
			0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
			0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
			0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
			0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
			0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
			0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
			0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
			0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21, 0x22,
			0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
			0x00,
		0x82, 0x0c, 0x00, 0x7f, 0xf0, 0xf1, 0x00,
			0xf9, 0xf8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
		0x8b, 0x35, 0x00, 0x01, 0x0f, 0x33, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0x00, 0x0f, 0x30, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0xc0, 0x0f, 0x5a, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x87, 0x25, 0x00, 0xc0, 0x0f, 0x5a,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0xc0, 0x0f, 0x5a,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0xc0, 0x0f, 0x5a,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
		0x8a, 0x39, 0x00, 0x01, 0x0f, 0x33,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x01, 0x0f, 0x33, 0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x01, 0x0f, 0x33,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0x00, 0x0f, 0x30,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x00, 0x0f, 0x30,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x02, 0x0f, 0x00,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x89, 0xc8, 0x04, 0x0f, 0xff,
			  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
			  5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,
			  9,  0,  0,  0, 10,  0,  0,  0, 11,  0,  0,  0, 12,  0,  0,  0,
			 13,  0,  0,  0, 14,  0,  0,  0, 15,  0,  0,  0, 16,  0,  0,  0,
			 17,  0,  0,  0, 18,  0,  0,  0, 19,  0,  0,  0, 20,  0,  0,  0,
			 21,  0,  0,  0, 22,  0,  0,  0, 23,  0,  0,  0, 24,  0,  0,  0,
			 25,  0,  0,  0, 26,  0,  0,  0, 27,  0,  0,  0, 28,  0,  0,  0,
			 29,  0,  0,  0, 30,  0,  0,  0, 31,  0,  0,  0, 32,  0,  0,  0,
			 33,  0,  0,  0, 34,  0,  0,  0, 35,  0,  0,  0, 36,  0,  0,  0,
			 37,  0,  0,  0, 38,  0,  0,  0, 39,  0,  0,  0, 40,  0,  0,  0,
			 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0, 44,  0,  0,  0,
			 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0, 48,  0,  0,  0,
			 49,  0,  0,  0, 50,  0,  0,  0, 51,  0,  0,  0, 52,  0,  0,  0,
			 53,  0,  0,  0, 54,  0,  0,  0, 55,  0,  0,  0, 56,  0,  0,  0,
			 57,  0,  0,  0, 58,  0,  0,  0, 59,  0,  0,  0, 60,  0,  0,  0,
			 61,  0,  0,  0, 62,  0,  0,  0, 63,  0,  0,  0, 64,  0,  0,  0,
			 65,  0,  0,  0, 66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0,
			 69,  0,  0,  0, 70,  0,  0,  0, 71,  0,  0,  0, 72,  0,  0,  0,
			 73,  0,  0,  0, 74,  0,  0,  0, 75,  0,  0,  0, 76,  0,  0,  0,
			 77,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
			 81,  0,  0,  0, 82,  0,  0,  0, 83,  0,  0,  0, 84,  0,  0,  0,
			 85,  0,  0,  0, 86,  0,  0,  0, 87,  0,  0,  0, 88,  0,  0,  0,
			 89,  0,  0,  0, 90,  0,  0,  0, 91,  0,  0,  0, 92,  0,  0,  0,
			 93,  0,  0,  0, 94,  0,  0,  0, 95,  0,  0,  0, 96,  0,  0,  0,
			 97,  0,  0,  0, 98,  0,  0,  0, 99,  0,  0,  0,100,  0,  0,  0,
			101,  0,  0,  0,102,  0,  0,  0,103,  0,  0,  0,104,  0,  0,  0,
			105,  0,  0,  0,106,  0,  0,  0,107,  0,  0,  0,108,  0,  0,  0,
			109,  0,  0,  0,110,  0,  0,  0,111,  0,  0,  0,112,  0,  0,  0,
			113,  0,  0,  0,114,  0,  0,  0,115,  0,  0,  0,116,  0,  0,  0,
			117,  0,  0,  0,118,  0,  0,  0,119,  0,  0,  0,120,  0,  0,  0,
			121,  0,  0,  0,122,  0,  0,  0,123,  0,  0,  0,124,  0,  0,  0,
			125,  0,  0,  0,126,  0,  0,  0,127,  0,  0,  0,128,  0,  0,  0,
			129,  0,  0,  0,130,  0,  0,  0,131,  0,  0,  0,132,  0,  0,  0,
			133,  0,  0,  0,134,  0,  0,  0,135,  0,  0,  0,136,  0,  0,  0,
			137,  0,  0,  0,138,  0,  0,  0,139,  0,  0,  0,140,  0,  0,  0,
			141,  0,  0,  0,142,  0,  0,  0,143,  0,  0,  0,144,  0,  0,  0,
			145,  0,  0,  0,146,  0,  0,  0,147,  0,  0,  0,148,  0,  0,  0,
			149,  0,  0,  0,150,  0,  0,  0,151,  0,  0,  0,152,  0,  0,  0,
			153,  0,  0,  0,154,  0,  0,  0,155,  0,  0,  0,156,  0,  0,  0,
			157,  0,  0,  0,158,  0,  0,  0,159,  0,  0,  0,160,  0,  0,  0,
			161,  0,  0,  0,162,  0,  0,  0,163,  0,  0,  0,164,  0,  0,  0,
			165,  0,  0,  0,166,  0,  0,  0,167,  0,  0,  0,168,  0,  0,  0,
			169,  0,  0,  0,170,  0,  0,  0,171,  0,  0,  0,172,  0,  0,  0,
			173,  0,  0,  0,174,  0,  0,  0,175,  0,  0,  0,176,  0,  0,  0,
			177,  0,  0,  0,178,  0,  0,  0,179,  0,  0,  0,180,  0,  0,  0,
			181,  0,  0,  0,182,  0,  0,  0,183,  0,  0,  0,184,  0,  0,  0,
			185,  0,  0,  0,186,  0,  0,  0,187,  0,  0,  0,188,  0,  0,  0,
			189,  0,  0,  0,190,  0,  0,  0,191,  0,  0,  0,192,  0,  0,  0,
			193,  0,  0,  0,194,  0,  0,  0,195,  0,  0,  0,196,  0,  0,  0,
			197,  0,  0,  0,198,  0,  0,  0,199,  0,  0,  0,200,  0,  0,  0,
			201,  0,  0,  0,202,  0,  0,  0,203,  0,  0,  0,204,  0,  0,  0,
			205,  0,  0,  0,206,  0,  0,  0,207,  0,  0,  0,208,  0,  0,  0,
			209,  0,  0,  0,210,  0,  0,  0,211,  0,  0,  0,212,  0,  0,  0,
			213,  0,  0,  0,214,  0,  0,  0,215,  0,  0,  0,216,  0,  0,  0,
			217,  0,  0,  0,218,  0,  0,  0,219,  0,  0,  0,220,  0,  0,  0,
			221,  0,  0,  0,222,  0,  0,  0,223,  0,  0,  0,224,  0,  0,  0,
			225,  0,  0,  0,226,  0,  0,  0,227,  0,  0,  0,228,  0,  0,  0,
			229,  0,  0,  0,230,  0,  0,  0,231,  0,  0,  0,232,  0,  0,  0,
			233,  0,  0,  0,234,  0,  0,  0,235,  0,  0,  0,236,  0,  0,  0,
			237,  0,  0,  0,238,  0,  0,  0,239,  0,  0,  0,240,  0,  0,  0,
			241,  0,  0,  0,242,  0,  0,  0,243,  0,  0,  0,244,  0,  0,  0,
			245,  0,  0,  0,246,  0,  0,  0,247,  0,  0,  0,248,  0,  0,  0,
			249,  0,  0,  0,250,  0,  0,  0,251,  0,  0,  0,252,  0,  0,  0,
			253,  0,  0,  0,254,  0,  0,  0,255,  0,  0,  0,
			0xff,
			0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
			0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
			0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
			0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
			0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
			0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
			0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
			0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
			0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
			0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
			0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
			0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21,
			0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
			0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
			0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
			0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
			0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
			0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
			0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
			0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
			0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
			0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21, 0x22,
			0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
			0x00,
		0x82, 0x0c, 0x00, 0x7f, 0xf0, 0xf1, 0x00,
			0xf9, 0xf8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
		0x8b, 0x35, 0x00, 0x01, 0x0f, 0x33, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0x00, 0x0f, 0x30, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0xc0, 0x0f, 0x5a, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x87, 0x25, 0x00, 0xc0, 0x0f, 0x5a,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0xc0, 0x0f, 0x5a,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0xc0, 0x0f, 0x5a,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x79, 0x00},

	Buffer () {
	0x30,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
	0x30,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
	0x31, 0x00,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
	0x31, 0x04,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
	0x31, 0x08,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
	0x31, 0x01,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
	0x31, 0x05,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
	0x31, 0x05,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
		0x8a, 0x39, 0x00, 0x01, 0x0f, 0x33,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x01, 0x0f, 0x33, 0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x01, 0x0f, 0x33,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0x00, 0x0f, 0x30,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x00, 0x0f, 0x30,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x02, 0x0f, 0x00,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x89, 0xc8, 0x04, 0x0f, 0xff,
			  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
			  5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,
			  9,  0,  0,  0, 10,  0,  0,  0, 11,  0,  0,  0, 12,  0,  0,  0,
			 13,  0,  0,  0, 14,  0,  0,  0, 15,  0,  0,  0, 16,  0,  0,  0,
			 17,  0,  0,  0, 18,  0,  0,  0, 19,  0,  0,  0, 20,  0,  0,  0,
			 21,  0,  0,  0, 22,  0,  0,  0, 23,  0,  0,  0, 24,  0,  0,  0,
			 25,  0,  0,  0, 26,  0,  0,  0, 27,  0,  0,  0, 28,  0,  0,  0,
			 29,  0,  0,  0, 30,  0,  0,  0, 31,  0,  0,  0, 32,  0,  0,  0,
			 33,  0,  0,  0, 34,  0,  0,  0, 35,  0,  0,  0, 36,  0,  0,  0,
			 37,  0,  0,  0, 38,  0,  0,  0, 39,  0,  0,  0, 40,  0,  0,  0,
			 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0, 44,  0,  0,  0,
			 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0, 48,  0,  0,  0,
			 49,  0,  0,  0, 50,  0,  0,  0, 51,  0,  0,  0, 52,  0,  0,  0,
			 53,  0,  0,  0, 54,  0,  0,  0, 55,  0,  0,  0, 56,  0,  0,  0,
			 57,  0,  0,  0, 58,  0,  0,  0, 59,  0,  0,  0, 60,  0,  0,  0,
			 61,  0,  0,  0, 62,  0,  0,  0, 63,  0,  0,  0, 64,  0,  0,  0,
			 65,  0,  0,  0, 66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0,
			 69,  0,  0,  0, 70,  0,  0,  0, 71,  0,  0,  0, 72,  0,  0,  0,
			 73,  0,  0,  0, 74,  0,  0,  0, 75,  0,  0,  0, 76,  0,  0,  0,
			 77,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
			 81,  0,  0,  0, 82,  0,  0,  0, 83,  0,  0,  0, 84,  0,  0,  0,
			 85,  0,  0,  0, 86,  0,  0,  0, 87,  0,  0,  0, 88,  0,  0,  0,
			 89,  0,  0,  0, 90,  0,  0,  0, 91,  0,  0,  0, 92,  0,  0,  0,
			 93,  0,  0,  0, 94,  0,  0,  0, 95,  0,  0,  0, 96,  0,  0,  0,
			 97,  0,  0,  0, 98,  0,  0,  0, 99,  0,  0,  0,100,  0,  0,  0,
			101,  0,  0,  0,102,  0,  0,  0,103,  0,  0,  0,104,  0,  0,  0,
			105,  0,  0,  0,106,  0,  0,  0,107,  0,  0,  0,108,  0,  0,  0,
			109,  0,  0,  0,110,  0,  0,  0,111,  0,  0,  0,112,  0,  0,  0,
			113,  0,  0,  0,114,  0,  0,  0,115,  0,  0,  0,116,  0,  0,  0,
			117,  0,  0,  0,118,  0,  0,  0,119,  0,  0,  0,120,  0,  0,  0,
			121,  0,  0,  0,122,  0,  0,  0,123,  0,  0,  0,124,  0,  0,  0,
			125,  0,  0,  0,126,  0,  0,  0,127,  0,  0,  0,128,  0,  0,  0,
			129,  0,  0,  0,130,  0,  0,  0,131,  0,  0,  0,132,  0,  0,  0,
			133,  0,  0,  0,134,  0,  0,  0,135,  0,  0,  0,136,  0,  0,  0,
			137,  0,  0,  0,138,  0,  0,  0,139,  0,  0,  0,140,  0,  0,  0,
			141,  0,  0,  0,142,  0,  0,  0,143,  0,  0,  0,144,  0,  0,  0,
			145,  0,  0,  0,146,  0,  0,  0,147,  0,  0,  0,148,  0,  0,  0,
			149,  0,  0,  0,150,  0,  0,  0,151,  0,  0,  0,152,  0,  0,  0,
			153,  0,  0,  0,154,  0,  0,  0,155,  0,  0,  0,156,  0,  0,  0,
			157,  0,  0,  0,158,  0,  0,  0,159,  0,  0,  0,160,  0,  0,  0,
			161,  0,  0,  0,162,  0,  0,  0,163,  0,  0,  0,164,  0,  0,  0,
			165,  0,  0,  0,166,  0,  0,  0,167,  0,  0,  0,168,  0,  0,  0,
			169,  0,  0,  0,170,  0,  0,  0,171,  0,  0,  0,172,  0,  0,  0,
			173,  0,  0,  0,174,  0,  0,  0,175,  0,  0,  0,176,  0,  0,  0,
			177,  0,  0,  0,178,  0,  0,  0,179,  0,  0,  0,180,  0,  0,  0,
			181,  0,  0,  0,182,  0,  0,  0,183,  0,  0,  0,184,  0,  0,  0,
			185,  0,  0,  0,186,  0,  0,  0,187,  0,  0,  0,188,  0,  0,  0,
			189,  0,  0,  0,190,  0,  0,  0,191,  0,  0,  0,192,  0,  0,  0,
			193,  0,  0,  0,194,  0,  0,  0,195,  0,  0,  0,196,  0,  0,  0,
			197,  0,  0,  0,198,  0,  0,  0,199,  0,  0,  0,200,  0,  0,  0,
			201,  0,  0,  0,202,  0,  0,  0,203,  0,  0,  0,204,  0,  0,  0,
			205,  0,  0,  0,206,  0,  0,  0,207,  0,  0,  0,208,  0,  0,  0,
			209,  0,  0,  0,210,  0,  0,  0,211,  0,  0,  0,212,  0,  0,  0,
			213,  0,  0,  0,214,  0,  0,  0,215,  0,  0,  0,216,  0,  0,  0,
			217,  0,  0,  0,218,  0,  0,  0,219,  0,  0,  0,220,  0,  0,  0,
			221,  0,  0,  0,222,  0,  0,  0,223,  0,  0,  0,224,  0,  0,  0,
			225,  0,  0,  0,226,  0,  0,  0,227,  0,  0,  0,228,  0,  0,  0,
			229,  0,  0,  0,230,  0,  0,  0,231,  0,  0,  0,232,  0,  0,  0,
			233,  0,  0,  0,234,  0,  0,  0,235,  0,  0,  0,236,  0,  0,  0,
			237,  0,  0,  0,238,  0,  0,  0,239,  0,  0,  0,240,  0,  0,  0,
			241,  0,  0,  0,242,  0,  0,  0,243,  0,  0,  0,244,  0,  0,  0,
			245,  0,  0,  0,246,  0,  0,  0,247,  0,  0,  0,248,  0,  0,  0,
			249,  0,  0,  0,250,  0,  0,  0,251,  0,  0,  0,252,  0,  0,  0,
			253,  0,  0,  0,254,  0,  0,  0,255,  0,  0,  0,
			0xff,
			0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
			0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
			0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
			0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
			0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
			0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
			0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
			0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
			0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
			0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
			0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
			0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21,
			0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
			0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
			0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
			0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
			0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
			0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
			0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
			0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
			0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
			0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21, 0x22,
			0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
			0x00,
		0x82, 0x0c, 0x00, 0x7f, 0xf0, 0xf1, 0x00,
			0xf9, 0xf8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
		0x8b, 0x35, 0x00, 0x01, 0x0f, 0x33, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0x00, 0x0f, 0x30, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0xc0, 0x0f, 0x5a, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x87, 0x25, 0x00, 0xc0, 0x0f, 0x5a,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0xc0, 0x0f, 0x5a,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0xc0, 0x0f, 0x5a,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
	0x31, 0x09,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
	0x31, 0x02,
	0x31, 0x06,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
	0x31, 0x0a,
	0x38,
	0x30,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
	0x30,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
	0x31, 0x00,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
	0x31, 0x04,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
	0x31, 0x08,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
	0x31, 0x01,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
	0x31, 0x05,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
	0x31, 0x05,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
		0x8a, 0x39, 0x00, 0x01, 0x0f, 0x33,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x01, 0x0f, 0x33, 0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x01, 0x0f, 0x33,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0x00, 0x0f, 0x30,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x87, 0x25, 0x00, 0x00, 0x0f, 0x30,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0x02, 0x0f, 0x00,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x89, 0xc8, 0x04, 0x0f, 0xff,
			  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
			  5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,
			  9,  0,  0,  0, 10,  0,  0,  0, 11,  0,  0,  0, 12,  0,  0,  0,
			 13,  0,  0,  0, 14,  0,  0,  0, 15,  0,  0,  0, 16,  0,  0,  0,
			 17,  0,  0,  0, 18,  0,  0,  0, 19,  0,  0,  0, 20,  0,  0,  0,
			 21,  0,  0,  0, 22,  0,  0,  0, 23,  0,  0,  0, 24,  0,  0,  0,
			 25,  0,  0,  0, 26,  0,  0,  0, 27,  0,  0,  0, 28,  0,  0,  0,
			 29,  0,  0,  0, 30,  0,  0,  0, 31,  0,  0,  0, 32,  0,  0,  0,
			 33,  0,  0,  0, 34,  0,  0,  0, 35,  0,  0,  0, 36,  0,  0,  0,
			 37,  0,  0,  0, 38,  0,  0,  0, 39,  0,  0,  0, 40,  0,  0,  0,
			 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0, 44,  0,  0,  0,
			 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0, 48,  0,  0,  0,
			 49,  0,  0,  0, 50,  0,  0,  0, 51,  0,  0,  0, 52,  0,  0,  0,
			 53,  0,  0,  0, 54,  0,  0,  0, 55,  0,  0,  0, 56,  0,  0,  0,
			 57,  0,  0,  0, 58,  0,  0,  0, 59,  0,  0,  0, 60,  0,  0,  0,
			 61,  0,  0,  0, 62,  0,  0,  0, 63,  0,  0,  0, 64,  0,  0,  0,
			 65,  0,  0,  0, 66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0,
			 69,  0,  0,  0, 70,  0,  0,  0, 71,  0,  0,  0, 72,  0,  0,  0,
			 73,  0,  0,  0, 74,  0,  0,  0, 75,  0,  0,  0, 76,  0,  0,  0,
			 77,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
			 81,  0,  0,  0, 82,  0,  0,  0, 83,  0,  0,  0, 84,  0,  0,  0,
			 85,  0,  0,  0, 86,  0,  0,  0, 87,  0,  0,  0, 88,  0,  0,  0,
			 89,  0,  0,  0, 90,  0,  0,  0, 91,  0,  0,  0, 92,  0,  0,  0,
			 93,  0,  0,  0, 94,  0,  0,  0, 95,  0,  0,  0, 96,  0,  0,  0,
			 97,  0,  0,  0, 98,  0,  0,  0, 99,  0,  0,  0,100,  0,  0,  0,
			101,  0,  0,  0,102,  0,  0,  0,103,  0,  0,  0,104,  0,  0,  0,
			105,  0,  0,  0,106,  0,  0,  0,107,  0,  0,  0,108,  0,  0,  0,
			109,  0,  0,  0,110,  0,  0,  0,111,  0,  0,  0,112,  0,  0,  0,
			113,  0,  0,  0,114,  0,  0,  0,115,  0,  0,  0,116,  0,  0,  0,
			117,  0,  0,  0,118,  0,  0,  0,119,  0,  0,  0,120,  0,  0,  0,
			121,  0,  0,  0,122,  0,  0,  0,123,  0,  0,  0,124,  0,  0,  0,
			125,  0,  0,  0,126,  0,  0,  0,127,  0,  0,  0,128,  0,  0,  0,
			129,  0,  0,  0,130,  0,  0,  0,131,  0,  0,  0,132,  0,  0,  0,
			133,  0,  0,  0,134,  0,  0,  0,135,  0,  0,  0,136,  0,  0,  0,
			137,  0,  0,  0,138,  0,  0,  0,139,  0,  0,  0,140,  0,  0,  0,
			141,  0,  0,  0,142,  0,  0,  0,143,  0,  0,  0,144,  0,  0,  0,
			145,  0,  0,  0,146,  0,  0,  0,147,  0,  0,  0,148,  0,  0,  0,
			149,  0,  0,  0,150,  0,  0,  0,151,  0,  0,  0,152,  0,  0,  0,
			153,  0,  0,  0,154,  0,  0,  0,155,  0,  0,  0,156,  0,  0,  0,
			157,  0,  0,  0,158,  0,  0,  0,159,  0,  0,  0,160,  0,  0,  0,
			161,  0,  0,  0,162,  0,  0,  0,163,  0,  0,  0,164,  0,  0,  0,
			165,  0,  0,  0,166,  0,  0,  0,167,  0,  0,  0,168,  0,  0,  0,
			169,  0,  0,  0,170,  0,  0,  0,171,  0,  0,  0,172,  0,  0,  0,
			173,  0,  0,  0,174,  0,  0,  0,175,  0,  0,  0,176,  0,  0,  0,
			177,  0,  0,  0,178,  0,  0,  0,179,  0,  0,  0,180,  0,  0,  0,
			181,  0,  0,  0,182,  0,  0,  0,183,  0,  0,  0,184,  0,  0,  0,
			185,  0,  0,  0,186,  0,  0,  0,187,  0,  0,  0,188,  0,  0,  0,
			189,  0,  0,  0,190,  0,  0,  0,191,  0,  0,  0,192,  0,  0,  0,
			193,  0,  0,  0,194,  0,  0,  0,195,  0,  0,  0,196,  0,  0,  0,
			197,  0,  0,  0,198,  0,  0,  0,199,  0,  0,  0,200,  0,  0,  0,
			201,  0,  0,  0,202,  0,  0,  0,203,  0,  0,  0,204,  0,  0,  0,
			205,  0,  0,  0,206,  0,  0,  0,207,  0,  0,  0,208,  0,  0,  0,
			209,  0,  0,  0,210,  0,  0,  0,211,  0,  0,  0,212,  0,  0,  0,
			213,  0,  0,  0,214,  0,  0,  0,215,  0,  0,  0,216,  0,  0,  0,
			217,  0,  0,  0,218,  0,  0,  0,219,  0,  0,  0,220,  0,  0,  0,
			221,  0,  0,  0,222,  0,  0,  0,223,  0,  0,  0,224,  0,  0,  0,
			225,  0,  0,  0,226,  0,  0,  0,227,  0,  0,  0,228,  0,  0,  0,
			229,  0,  0,  0,230,  0,  0,  0,231,  0,  0,  0,232,  0,  0,  0,
			233,  0,  0,  0,234,  0,  0,  0,235,  0,  0,  0,236,  0,  0,  0,
			237,  0,  0,  0,238,  0,  0,  0,239,  0,  0,  0,240,  0,  0,  0,
			241,  0,  0,  0,242,  0,  0,  0,243,  0,  0,  0,244,  0,  0,  0,
			245,  0,  0,  0,246,  0,  0,  0,247,  0,  0,  0,248,  0,  0,  0,
			249,  0,  0,  0,250,  0,  0,  0,251,  0,  0,  0,252,  0,  0,  0,
			253,  0,  0,  0,254,  0,  0,  0,255,  0,  0,  0,
			0xff,
			0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
			0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
			0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
			0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
			0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
			0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
			0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
			0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
			0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
			0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
			0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
			0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21,
			0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
			0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
			0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
			0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
			0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
			0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
			0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
			0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
			0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
			0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21, 0x22,
			0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
			0x00,
		0x82, 0x0c, 0x00, 0x7f, 0xf0, 0xf1, 0x00,
			0xf9, 0xf8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
		0x8b, 0x35, 0x00, 0x01, 0x0f, 0x33, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0x00, 0x0f, 0x30, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x8b, 0x35, 0x00, 0xc0, 0x0f, 0x5a, 0x01, 0x00,
			0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
		0x87, 0x25, 0x00, 0xc0, 0x0f, 0x5a,
			0xef, 0xee, 0xed, 0xec,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x8a, 0x39, 0x00, 0xc0, 0x0f, 0x5a,
			0xdf, 0xde, 0xdd, 0xdc, 0xdb, 0xda, 0xd9, 0xd8,
			0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 0xe0,
			0xef, 0xee, 0xed, 0xec, 0xeb, 0xea, 0xe9, 0xe8,
			0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
			0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
		0x88, 0x1b, 0x00, 0xc0, 0x0f, 0x5a,
			0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
			0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
			0x48, 0x50, 0x41, 0x54, 0x48, 0x00,
	0x31, 0x09,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
	0x31, 0x02,
	0x31, 0x06,
		0x23, 0x01, 0x00, 0x00,
		0x22, 0x02, 0x00,
		0x2a, 0x04, 0x02,
		0x47, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf4, 0xf5,
		0x4b, 0xf1, 0x03, 0xf2,
		0x77, 0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7,
		0x81, 0x09, 0x00, 0x01, 0xf1, 0xf0, 0xf3, 0xf2, 0xf5, 0xf4, 0xf7, 0xf6,
		0x85, 0x11, 0x00, 0x01,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
			0xfb, 0xfa, 0xf9, 0xf8, 0xff, 0xfe, 0xfd, 0xfc,
		0x86, 0x09, 0x00, 0x00,
			0xf3, 0xf2, 0xf1, 0xf0, 0xf7, 0xf6, 0xf5, 0xf4,
		0x84, 0x15, 0x00, 0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03,
	0x31, 0x0a,
	0x38,
	0x79, 0x00},
})

Method(RT1a,, Serialized)
{
	Name(ts, "RT1a")

	// Emit test header, set the filename

	THDR (ts, "Resource To Buffer Conversion Macro", __FILE__)

    // Main test case for packages above

	m330(ts, 3, "p438", p438, p439)

}

Method(RT1c,, Serialized)
{
	Name(ts, "RT1c")

	// Emit test header, set the filename

	THDR (ts, "Resource Conversion Macros complex test", __FILE__)

	Name (RT00, ResourceTemplate () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ0) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA0) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO00)
		FixedIO (0x03f1, 0xf2, FIO0)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M240)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M320)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3F0)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIO0, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIO0, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIO0, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QME0, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DME0, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBN0)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INT0) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIO0, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EME0, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESP0)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSP0)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSP0)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSP0)

		// Duplicated part

		IRQ (Level, ActiveHigh, Exclusive, IRQ1) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA1) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO01)
		FixedIO (0x03f1, 0xf2, FIO1)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M241)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M321)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3F1)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIO1, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIO1, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIO1, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QME1, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DME1, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBN1)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INT1) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIO1, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EME1, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESP1)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSP1)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSP1)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSP1)
		})

	Name (RT01, ResourceTemplate () {
		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ2) {0}
		IRQNoFlags () {1}
		}
		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ4) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA4) {2}
		}
		StartDependentFn (0, 0) {
		IRQ (Level, ActiveHigh, Exclusive, IRQ6) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA6) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO06)
		}
		StartDependentFn (0, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQ8) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA8) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO08)
		FixedIO (0x03f1, 0xf2, FIO8)
		}
		StartDependentFn (0, 2) {
		IRQ (Level, ActiveHigh, Exclusive, IRQA) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAA) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0A)
		FixedIO (0x03f1, 0xf2, FIOA)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		}
		StartDependentFn (1, 0) {
		IRQ (Level, ActiveHigh, Exclusive, IRQC) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAC) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0C)
		FixedIO (0x03f1, 0xf2, FIOC)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24C)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQE) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAE) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0E)
		FixedIO (0x03f1, 0xf2, FIOE)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24E)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32E)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQG) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAG) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0G)
		FixedIO (0x03f1, 0xf2, FIOG)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24G)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32G)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FG)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIOG, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIOG, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIOG, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QMEG, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DMEG, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBNG)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INTG) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIOG, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EMEG, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESPG)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSPG)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSPG)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSPG)
		}
		StartDependentFn (1, 2) {
		IRQ (Level, ActiveHigh, Exclusive, IRQI) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAI) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0I)
		FixedIO (0x03f1, 0xf2, FIOI)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24I)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32I)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FI)
		}
		StartDependentFn (2, 0) {}
		StartDependentFn (2, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQK) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAK) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0K)
		FixedIO (0x03f1, 0xf2, FIOK)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24K)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32K)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FK)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		}
		StartDependentFn (2, 2) {}
		EndDependentFn ()

		// Duplicated part

		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ3) {0}
		IRQNoFlags () {1}
		}
		StartDependentFnNoPri () {
		IRQ (Level, ActiveHigh, Exclusive, IRQ5) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA5) {2}
		}
		StartDependentFn (0, 0) {
		IRQ (Level, ActiveHigh, Exclusive, IRQ7) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA7) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO07)
		}
		StartDependentFn (0, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQ9) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMA9) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO09)
		FixedIO (0x03f1, 0xf2, FIO9)
		}
		StartDependentFn (0, 2) {
		IRQ (Level, ActiveHigh, Exclusive, IRQB) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAB) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0B)
		FixedIO (0x03f1, 0xf2, FIOB)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		}
		StartDependentFn (1, 0) {
		IRQ (Level, ActiveHigh, Exclusive, IRQD) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAD) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0D)
		FixedIO (0x03f1, 0xf2, FIOD)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24D)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQF) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAF) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0F)
		FixedIO (0x03f1, 0xf2, FIOF)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24F)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32F)
		}
		StartDependentFn (1, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQH) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAH) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0H)
		FixedIO (0x03f1, 0xf2, FIOH)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24H)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32H)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FH)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		QWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QIOH, TypeTranslation, SparseTranslation)
		DWordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DIOH, TypeTranslation, SparseTranslation)
		WordIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WIOH, TypeTranslation, SparseTranslation)
		QWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QMEH, AddressRangeACPI, TypeTranslation)
		DWordMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DMEH, AddressRangeACPI, TypeTranslation)
		WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, SubDecode,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WBNH)
		Interrupt (ResourceConsumer, Edge, ActiveLow, Shared,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			INTH) {
			  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
			 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
			 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
			 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
			 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
			 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
			 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
			113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
			129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
			145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
			161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
			177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
			193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
			209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
			225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
			241,242,243,244,245,246,247,248,249,250,251,252,253,254,255}
		Register (FFixedHW, 0xf0, 0xf1, 0xf2f3f4f5f6f7f8f9)
		ExtendedIO (ResourceConsumer, MinFixed, MaxFixed, SubDecode, EntireRange,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EIOH, TypeTranslation, SparseTranslation)
		ExtendedMemory (ResourceConsumer, SubDecode, MinFixed, MaxFixed, NonCacheable, ReadOnly,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			EMEH, AddressRangeACPI, TypeTranslation)
		ExtendedSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd0d1d2d3d4d5d6d7, 0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7,
			0xe8e9eaebecedeeef, 0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			ESPH)
		DWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xecedeeef, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff,
			0xff, "PATHPATHPATH", DSPH)
		QWordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xd8d9dadbdcdddedf, 0xe0e1e2e3e4e5e6e7, 0xe8e9eaebecedeeef,
			0xf0f1f2f3f4f5f6f7, 0xf8f9fafbfcfdfeff,
			0xff, "PATHPATHPATH", QSPH)
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSPH)
		}
		StartDependentFn (1, 2) {
		IRQ (Level, ActiveHigh, Exclusive, IRQJ) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAJ) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0J)
		FixedIO (0x03f1, 0xf2, FIOJ)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24J)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32J)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FJ)
		}
		StartDependentFn (2, 0) {}
		StartDependentFn (2, 1) {
		IRQ (Level, ActiveHigh, Exclusive, IRQL) {0}
		IRQNoFlags () {1}
		DMA (Compatibility, NotBusMaster, Transfer16, DMAL) {2}
		IO (Decode16, 0xf0f1, 0xf2f3, 0xf4, 0xf5, IO0L)
		FixedIO (0x03f1, 0xf2, FIOL)
		VendorShort () {0x00, 0xa2, 0xb3, 0x76, 0xd5, 0xe6, 0xf7}
		Memory24 (ReadWrite, 0xf0f1, 0xf2f3, 0xf4f5, 0xf6f7, M24L)
		Memory32 (ReadWrite, 0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff, M32L)
		Memory32Fixed (ReadOnly, 0xf0f1f2f3, 0xf4f5f6f7, M3FL)
		VendorLong () {0x9f,
			0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
			0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
			0x00, 0x01, 0x02, 0x03}
		}
		StartDependentFn (2, 2) {}
		EndDependentFn ()
	})

	m330(ts, 2, "p445", p445, p446)

	// Checkings relating to RT00

	m331(ts, 1,  IRQ0._HE,  0x0018, IRQ1._HE,  0x3b68, "_HE")
	m331(ts, 2,  IRQ0._LL,  0x001b, IRQ1._LL,  0x3b6b, "_LL")
	m331(ts, 3,  IRQ0._SHR, 0x001c, IRQ1._SHR, 0x3b6c, "_SHR")

	m331(ts, 4,  DMA0._TYP, 0x004d, DMA1._TYP, 0x3b9d, "_TYP")
	m331(ts, 5,  DMA0._BM,  0x004a, DMA1._BM,  0x3b9a, "_BM")
	m331(ts, 6,  DMA0._SIZ, 0x0048, DMA1._SIZ, 0x3b98, "_SIZ")

	m331(ts, 7,  IO00._DEC, 0x0058, IO01._DEC, 0x3ba8, "_DEC")
	m331(ts, 8,  IO00._MIN, 0x0060, IO01._MIN, 0x3bb0, "_MIN")
	m331(ts, 9,  IO00._MAX, 0x0070, IO01._MAX, 0x3bc0, "_MAX")
	m331(ts, 10, IO00._ALN, 0x0080, IO01._ALN, 0x3bd0, "_ALN")
	m331(ts, 11, IO00._LEN, 0x0088, IO01._LEN, 0x3bd8, "_LEN")

	m331(ts, 12, FIO0._BAS, 0x0098, FIO1._BAS, 0x3be8, "_BAS")
	m331(ts, 13, FIO0._LEN, 0x00a8, FIO1._LEN, 0x3bf8, "_LEN")

	m331(ts, 14, M240._RW,  0x0108, M241._RW,  0x3C58, "_RW")
	m331(ts, 15, M240._MIN, 0x0110, M241._MIN, 0x3c60, "_MIN")
	m331(ts, 16, M240._MAX, 0x0120, M241._MAX, 0x3c70, "_MAX")
	m331(ts, 17, M240._ALN, 0x0130, M241._ALN, 0x3c80, "_ALN")
	m331(ts, 18, M240._LEN, 0x0140, M241._LEN, 0x3c90, "_LEN")

	m331(ts, 19, M320._RW,  0x0168, M321._RW,  0x3CB8, "_RW")
	m331(ts, 20, M320._MIN, 0x0170, M321._MIN, 0x3cc0, "_MIN")
	m331(ts, 21, M320._MAX, 0x0190, M321._MAX, 0x3ce0, "_MAX")
	m331(ts, 22, M320._ALN, 0x01b0, M321._ALN, 0x3d00, "_ALN")
	m331(ts, 23, M320._LEN, 0x01d0, M321._LEN, 0x3d20, "_LEN")

	m331(ts, 24, M3F0._RW,  0x0208, M3F1._RW,  0x3D58, "_RW")
	m331(ts, 25, M3F0._BAS, 0x0210, M3F1._BAS, 0x3d60, "_BAS")
	m331(ts, 26, M3F0._LEN, 0x0230, M3F1._LEN, 0x3d80, "_LEN")

	m331(ts, 27, QIO0._DEC, 0x0331, QIO1._DEC, 0x3e81, "_DEC")
	m331(ts, 28, QIO0._MIF, 0x0332, QIO1._MIF, 0x3e82, "_MIF")
	m331(ts, 29, QIO0._MAF, 0x0333, QIO1._MAF, 0x3e83, "_MAF")
	m331(ts, 30, QIO0._RNG, 0x0338, QIO1._RNG, 0x3e88, "_RNG")
	m331(ts, 31, QIO0._TTP, 0x033c, QIO1._TTP, 0x3e8c, "_TTP")
	m331(ts, 32, QIO0._TRS, 0x033d, QIO1._TRS, 0x3e8d, "_TRS")
	m331(ts, 33, QIO0._GRA, 0x0340, QIO1._GRA, 0x3e90, "_GRA")
	m331(ts, 34, QIO0._MIN, 0x0380, QIO1._MIN, 0x3ed0, "_MIN")
	m331(ts, 35, QIO0._MAX, 0x03c0, QIO1._MAX, 0x3f10, "_MAX")
	m331(ts, 36, QIO0._TRA, 0x0400, QIO1._TRA, 0x3f50, "_TRA")
	m331(ts, 37, QIO0._LEN, 0x0440, QIO1._LEN, 0x3f90, "_LEN")

	m331(ts, 38, DIO0._DEC, 0x0511, DIO1._DEC, 0x4061, "_DEC")
	m331(ts, 39, DIO0._MIF, 0x0512, DIO1._MIF, 0x4062, "_MIF")
	m331(ts, 40, DIO0._MAF, 0x0513, DIO1._MAF, 0x4063, "_MAF")
	m331(ts, 41, DIO0._RNG, 0x0518, DIO1._RNG, 0x4068, "_RNG")
	m331(ts, 42, DIO0._TTP, 0x051c, DIO1._TTP, 0x406c, "_TTP")
	m331(ts, 43, DIO0._TRS, 0x051d, DIO1._TRS, 0x406d, "_TRS")
	m331(ts, 44, DIO0._GRA, 0x0520, DIO1._GRA, 0x4070, "_GRA")
	m331(ts, 45, DIO0._MIN, 0x0540, DIO1._MIN, 0x4090, "_MIN")
	m331(ts, 46, DIO0._MAX, 0x0560, DIO1._MAX, 0x40b0, "_MAX")
	m331(ts, 47, DIO0._TRA, 0x0580, DIO1._TRA, 0x40d0, "_TRA")
	m331(ts, 48, DIO0._LEN, 0x05a0, DIO1._LEN, 0x40f0, "_LEN")

	m331(ts, 49, WIO0._DEC, 0x0651, WIO1._DEC, 0x41a1, "_DEC")
	m331(ts, 50, WIO0._MIF, 0x0652, WIO1._MIF, 0x41a2, "_MIF")
	m331(ts, 51, WIO0._MAF, 0x0653, WIO1._MAF, 0x41a3, "_MAF")
	m331(ts, 52, WIO0._RNG, 0x0658, WIO1._RNG, 0x41a8, "_RNG")
	m331(ts, 53, WIO0._TTP, 0x065c, WIO1._TTP, 0x41ac, "_TTP")
	m331(ts, 54, WIO0._TRS, 0x065d, WIO1._TRS, 0x41ad, "_TRS")
	m331(ts, 55, WIO0._GRA, 0x0660, WIO1._GRA, 0x41b0, "_GRA")
	m331(ts, 56, WIO0._MIN, 0x0670, WIO1._MIN, 0x41c0, "_MIN")
	m331(ts, 57, WIO0._MAX, 0x0680, WIO1._MAX, 0x41d0, "_MAX")
	m331(ts, 58, WIO0._TRA, 0x0690, WIO1._TRA, 0x41e0, "_TRA")
	m331(ts, 59, WIO0._LEN, 0x06a0, WIO1._LEN, 0x41f0, "_LEN")

	m331(ts, 60, QME0._DEC, 0x0741, QME1._DEC, 0x4291, "_DEC")
	m331(ts, 61, QME0._MIF, 0x0742, QME1._MIF, 0x4292, "_MIF")
	m331(ts, 62, QME0._MAF, 0x0743, QME1._MAF, 0x4293, "_MAF")
	m331(ts, 63, QME0._RW,  0x0748, QME1._RW,  0x4298, "_RW")
	m331(ts, 64, QME0._MEM, 0x0749, QME1._MEM, 0x4299, "_MEM")
	m331(ts, 65, QME0._MTP, 0x074b, QME1._MTP, 0x429b, "_MTP")
	m331(ts, 66, QME0._TTP, 0x074d, QME1._TTP, 0x429d, "_TTP")
	m331(ts, 67, QME0._GRA, 0x0750, QME1._GRA, 0x42a0, "_GRA")
	m331(ts, 68, QME0._MIN, 0x0790, QME1._MIN, 0x42e0, "_MIN")
	m331(ts, 69, QME0._MAX, 0x07d0, QME1._MAX, 0x4320, "_MAX")
	m331(ts, 70, QME0._TRA, 0x0810, QME1._TRA, 0x4360, "_TRA")
	m331(ts, 71, QME0._LEN, 0x0850, QME1._LEN, 0x43a0, "_LEN")

	m331(ts, 72, DME0._DEC, 0x0921, DME1._DEC, 0x4471, "_DEC")
	m331(ts, 73, DME0._MIF, 0x0922, DME1._MIF, 0x4472, "_MIF")
	m331(ts, 74, DME0._MAF, 0x0923, DME1._MAF, 0x4473, "_MAF")
	m331(ts, 75, DME0._RW,  0x0928, DME1._RW,  0x4478, "_RW")
	m331(ts, 76, DME0._MEM, 0x0929, DME1._MEM, 0x4479, "_MEM")
	m331(ts, 77, DME0._MTP, 0x092b, DME1._MTP, 0x447b, "_MTP")
	m331(ts, 78, DME0._TTP, 0x092d, DME1._TTP, 0x447d, "_TTP")
	m331(ts, 79, DME0._GRA, 0x0930, DME1._GRA, 0x4480, "_GRA")
	m331(ts, 80, DME0._MIN, 0x0950, DME1._MIN, 0x44a0, "_MIN")
	m331(ts, 81, DME0._MAX, 0x0970, DME1._MAX, 0x44c0, "_MAX")
	m331(ts, 82, DME0._TRA, 0x0990, DME1._TRA, 0x44e0, "_TRA")
	m331(ts, 83, DME0._LEN, 0x09b0, DME1._LEN, 0x4500, "_LEN")

	m331(ts, 84, WBN0._DEC, 0x0a61, WBN1._DEC, 0x45b1, "_DEC")
	m331(ts, 85, WBN0._MIF, 0x0a62, WBN1._MIF, 0x45b2, "_MIF")
	m331(ts, 86, WBN0._MAF, 0x0a63, WBN1._MAF, 0x45b3, "_MAF")
	m331(ts, 87, WBN0._GRA, 0x0a70, WBN1._GRA, 0x45c0, "_GRA")
	m331(ts, 88, WBN0._MIN, 0x0a80, WBN1._MIN, 0x45d0, "_MIN")
	m331(ts, 89, WBN0._MAX, 0x0a90, WBN1._MAX, 0x45e0, "_MAX")
	m331(ts, 90, WBN0._TRA, 0x0aa0, WBN1._TRA, 0x45f0, "_TRA")
	m331(ts, 91, WBN0._LEN, 0x0ab0, WBN1._LEN, 0x4600, "_LEN")

	m331(ts, 92, INT0._HE,  0x0b49, INT1._HE,  0x4699, "_HE")
	m331(ts, 93, INT0._LL,  0x0b4a, INT1._LL,  0x469a, "_LL")
	m331(ts, 94, INT0._SHR, 0x0b4b, INT1._SHR, 0x469b, "_SHR")
	m331(ts, 95, INT0._INT, 0x0b58, INT1._INT, 0x46a8, "_INT")

	m331(ts, 96, EIO0._DEC, 0x3221, EIO1._DEC, 0x6d71, "_DEC")
	m331(ts, 97, EIO0._MIF, 0x3222, EIO1._MIF, 0x6d72, "_MIF")
	m331(ts, 98, EIO0._MAF, 0x3223, EIO1._MAF, 0x6d73, "_MAF")
	m331(ts, 99, EIO0._RNG, 0x3228, EIO1._RNG, 0x6d78, "_RNG")
	m331(ts, 100, EIO0._TTP, 0x322c, EIO1._TTP, 0x6d7c, "_TTP")
	m331(ts, 101, EIO0._TRS, 0x322d, EIO1._TRS, 0x6d7d, "_TRS")
	m331(ts, 102, EIO0._GRA, 0x3240, EIO1._GRA, 0x6d90, "_GRA")
	m331(ts, 103, EIO0._MIN, 0x3280, EIO1._MIN, 0x6dd0, "_MIN")
	m331(ts, 104, EIO0._MAX, 0x32c0, EIO1._MAX, 0x6e10, "_MAX")
	m331(ts, 105, EIO0._TRA, 0x3300, EIO1._TRA, 0x6e50, "_TRA")
	m331(ts, 106, EIO0._LEN, 0x3340, EIO1._LEN, 0x6e90, "_LEN")
	m331(ts, 107, EIO0._ATT, 0x3380, EIO1._ATT, 0x6ed0, "_ATT")

	m331(ts, 108, EME0._DEC, 0x33e1, EME1._DEC, 0x6f31, "_DEC")
	m331(ts, 109, EME0._MIF, 0x33e2, EME1._MIF, 0x6f32, "_MIF")
	m331(ts, 110, EME0._MAF, 0x33e3, EME1._MAF, 0x6f33, "_MAF")
	m331(ts, 111, EME0._RW,  0x33e8, EME1._RW,  0x6f38, "_RW")
	m331(ts, 112, EME0._MEM, 0x33e9, EME1._MEM, 0x6f39, "_MEM")
	m331(ts, 113, EME0._MTP, 0x33eb, EME1._MTP, 0x6f3b, "_MTP")
	m331(ts, 114, EME0._TTP, 0x33ed, EME1._TTP, 0x6f3d, "_TTP")
	m331(ts, 115, EME0._GRA, 0x3400, EME1._GRA, 0x6f50, "_GRA")
	m331(ts, 116, EME0._MIN, 0x3440, EME1._MIN, 0x6f90, "_MIN")
	m331(ts, 117, EME0._MAX, 0x3480, EME1._MAX, 0x6fd0, "_MAX")
	m331(ts, 118, EME0._TRA, 0x34c0, EME1._TRA, 0x7010, "_TRA")
	m331(ts, 119, EME0._LEN, 0x3500, EME1._LEN, 0x7050, "_LEN")
	m331(ts, 120, EME0._ATT, 0x3540, EME1._ATT, 0x7090, "_ATT")

	m331(ts, 121, ESP0._DEC, 0x35a1, ESP1._DEC, 0x70f1, "_DEC")
	m331(ts, 122, ESP0._MIF, 0x35a2, ESP1._MIF, 0x70f2, "_MIF")
	m331(ts, 123, ESP0._MAF, 0x35a3, ESP1._MAF, 0x70f3, "_MAF")
	m331(ts, 124, ESP0._GRA, 0x35c0, ESP1._GRA, 0x7110, "_GRA")
	m331(ts, 125, ESP0._MIN, 0x3600, ESP1._MIN, 0x7150, "_MIN")
	m331(ts, 126, ESP0._MAX, 0x3640, ESP1._MAX, 0x7190, "_MAX")
	m331(ts, 127, ESP0._TRA, 0x3680, ESP1._TRA, 0x71d0, "_TRA")
	m331(ts, 128, ESP0._LEN, 0x36c0, ESP1._LEN, 0x7210, "_LEN")
	m331(ts, 129, ESP0._ATT, 0x3700, ESP1._ATT, 0x7250, "_ATT")

	m331(ts, 130, DSP0._DEC, 0x3761, DSP1._DEC, 0x72b1, "_DEC")
	m331(ts, 131, DSP0._MIF, 0x3762, DSP1._MIF, 0x72b2, "_MIF")
	m331(ts, 132, DSP0._MAF, 0x3763, DSP1._MAF, 0x72b3, "_MAF")
	m331(ts, 133, DSP0._GRA, 0x3770, DSP1._GRA, 0x72c0, "_GRA")
	m331(ts, 134, DSP0._MIN, 0x3790, DSP1._MIN, 0x72e0, "_MIN")
	m331(ts, 135, DSP0._MAX, 0x37b0, DSP1._MAX, 0x7300, "_MAX")
	m331(ts, 136, DSP0._TRA, 0x37d0, DSP1._TRA, 0x7320, "_TRA")
	m331(ts, 137, DSP0._LEN, 0x37f0, DSP1._LEN, 0x7340, "_LEN")

	m331(ts, 138, QSP0._DEC, 0x38a1, QSP1._DEC, 0x73f1, "_DEC")
	m331(ts, 139, QSP0._MIF, 0x38a2, QSP1._MIF, 0x73f2, "_MIF")
	m331(ts, 140, QSP0._MAF, 0x38a3, QSP1._MAF, 0x73f3, "_MAF")
	m331(ts, 141, QSP0._GRA, 0x38b0, QSP1._GRA, 0x7400, "_GRA")
	m331(ts, 142, QSP0._MIN, 0x38f0, QSP1._MIN, 0x7440, "_MIN")
	m331(ts, 143, QSP0._MAX, 0x3930, QSP1._MAX, 0x7480, "_MAX")
	m331(ts, 144, QSP0._TRA, 0x3970, QSP1._TRA, 0x74c0, "_TRA")
	m331(ts, 145, QSP0._LEN, 0x39b0, QSP1._LEN, 0x7500, "_LEN")

	m331(ts, 146, WSP0._DEC, 0x3a81, WSP1._DEC, 0x75d1, "_DEC")
	m331(ts, 147, WSP0._MIF, 0x3a82, WSP1._MIF, 0x75d2, "_MIF")
	m331(ts, 148, WSP0._MAF, 0x3a83, WSP1._MAF, 0x75d3, "_MAF")
	m331(ts, 149, WSP0._GRA, 0x3a90, WSP1._GRA, 0x75e0, "_GRA")
	m331(ts, 150, WSP0._MIN, 0x3aa0, WSP1._MIN, 0x75f0, "_MIN")
	m331(ts, 151, WSP0._MAX, 0x3ab0, WSP1._MAX, 0x7600, "_MAX")
	m331(ts, 152, WSP0._TRA, 0x3ac0, WSP1._TRA, 0x7610, "_TRA")
	m331(ts, 153, WSP0._LEN, 0x3ad0, WSP1._LEN, 0x7620, "_LEN")

	// Checkings relating to RT01

	m331(ts, 154, IRQ2._HE,  0x20, IRQ3._HE,  0x4780, "_HE")
	m331(ts, 155, IRQ2._LL,  0x23, IRQ3._LL,  0x4783, "_LL")
	m331(ts, 156, IRQ2._SHR, 0x24, IRQ3._SHR, 0x4784, "_SHR")

	m331(ts, 157, IRQ4._HE,  0x60, IRQ5._HE,  0x47c0, "_HE")
	m331(ts, 158, IRQ4._LL,  0x63, IRQ5._LL,  0x47c3, "_LL")
	m331(ts, 159, IRQ4._SHR, 0x64, IRQ5._SHR, 0x47c4, "_SHR")

	m331(ts, 160, DMA4._TYP, 0x95, DMA5._TYP, 0x47f5, "_TYP")
	m331(ts, 161, DMA4._BM,  0x92, DMA5._BM,  0x47f2, "_BM")
	m331(ts, 162, DMA4._SIZ, 0x90, DMA5._SIZ, 0x47f0, "_SIZ")

	m331(ts, 163, IRQ6._HE,  0xc0, IRQ7._HE,  0x4820, "_HE")
	m331(ts, 164, IRQ6._LL,  0xc3, IRQ7._LL,  0x4823, "_LL")
	m331(ts, 165, IRQ6._SHR, 0xc4, IRQ7._SHR, 0x4824, "_SHR")

	m331(ts, 166, DMA6._TYP, 0xf5, DMA7._TYP, 0x4855, "_TYP")
	m331(ts, 167, DMA6._BM,  0xf2, DMA7._BM,  0x4852, "_BM")
	m331(ts, 168, DMA6._SIZ, 0xf0, DMA7._SIZ, 0x4850, "_SIZ")

	m331(ts, 169, IO06._DEC, 0x100, IO07._DEC, 0x4860, "_DEC")
	m331(ts, 170, IO06._MIN, 0x108, IO07._MIN, 0x4868, "_MIN")
	m331(ts, 171, IO06._MAX, 0x118, IO07._MAX, 0x4878, "_MAX")
	m331(ts, 172, IO06._ALN, 0x128, IO07._ALN, 0x4888, "_ALN")
	m331(ts, 173, IO06._LEN, 0x130, IO07._LEN, 0x4890, "_LEN")

	m331(ts, 174, IRQ8._HE,  0x160, IRQ9._HE,  0x48c0, "_HE")
	m331(ts, 175, IRQ8._LL,  0x163, IRQ9._LL,  0x48c3, "_LL")
	m331(ts, 176, IRQ8._SHR, 0x164, IRQ9._SHR, 0x48c4, "_SHR")

	m331(ts, 177, DMA8._TYP, 0x195, DMA9._TYP, 0x48f5, "_TYP")
	m331(ts, 178, DMA8._BM,  0x192, DMA9._BM,  0x48f2, "_BM")
	m331(ts, 179, DMA8._SIZ, 0x190, DMA9._SIZ, 0x48f0, "_SIZ")

	m331(ts, 180, IO08._DEC, 0x1a0, IO09._DEC, 0x4900, "_DEC")
	m331(ts, 181, IO08._MIN, 0x1a8, IO09._MIN, 0x4908, "_MIN")
	m331(ts, 182, IO08._MAX, 0x1b8, IO09._MAX, 0x4918, "_MAX")
	m331(ts, 183, IO08._ALN, 0x1c8, IO09._ALN, 0x4928, "_ALN")
	m331(ts, 184, IO08._LEN, 0x1d0, IO09._LEN, 0x4930, "_LEN")

	m331(ts, 185, FIO8._BAS, 0x1e0, FIO9._BAS, 0x4940, "_BAS")
	m331(ts, 186, FIO8._LEN, 0x1f0, FIO9._LEN, 0x4950, "_LEN")

	m331(ts, 187, IRQA._HE,  0x220, IRQB._HE,  0x4980, "_HE")
	m331(ts, 188, IRQA._LL,  0x223, IRQB._LL,  0x4983, "_LL")
	m331(ts, 189, IRQA._SHR, 0x224, IRQB._SHR, 0x4984, "_SHR")

	m331(ts, 190, DMAA._TYP, 0x255, DMAB._TYP, 0x49b5, "_TYP")
	m331(ts, 191, DMAA._BM,  0x252, DMAB._BM,  0x49b2, "_BM")
	m331(ts, 192, DMAA._SIZ, 0x250, DMAB._SIZ, 0x49b0, "_SIZ")

	m331(ts, 193, IO0A._DEC, 0x260, IO0B._DEC, 0x49c0, "_DEC")
	m331(ts, 194, IO0A._MIN, 0x268, IO0B._MIN, 0x49c8, "_MIN")
	m331(ts, 195, IO0A._MAX, 0x278, IO0B._MAX, 0x49d8, "_MAX")
	m331(ts, 196, IO0A._ALN, 0x288, IO0B._ALN, 0x49e8, "_ALN")
	m331(ts, 197, IO0A._LEN, 0x290, IO0B._LEN, 0x49f0, "_LEN")

	m331(ts, 198, FIOA._BAS, 0x2a0, FIOB._BAS, 0x4a00, "_BAS")
	m331(ts, 199, FIOA._LEN, 0x2b0, FIOB._LEN, 0x4a10, "_LEN")

	m331(ts, 200, IRQC._HE,  0x320, IRQD._HE,  0x4a80, "_HE")
	m331(ts, 201, IRQC._LL,  0x323, IRQD._LL,  0x4a83, "_LL")
	m331(ts, 202, IRQC._SHR, 0x324, IRQD._SHR, 0x4a84, "_SHR")

	m331(ts, 203, DMAC._TYP, 0x355, DMAD._TYP, 0x4ab5, "_TYP")
	m331(ts, 204, DMAC._BM,  0x352, DMAD._BM,  0x4ab2, "_BM")
	m331(ts, 205, DMAC._SIZ, 0x350, DMAD._SIZ, 0x4ab0, "_SIZ")

	m331(ts, 206, IO0C._DEC, 0x360, IO0D._DEC, 0x4ac0, "_DEC")
	m331(ts, 207, IO0C._MIN, 0x368, IO0D._MIN, 0x4ac8, "_MIN")
	m331(ts, 208, IO0C._MAX, 0x378, IO0D._MAX, 0x4ad8, "_MAX")
	m331(ts, 209, IO0C._ALN, 0x388, IO0D._ALN, 0x4ae8, "_ALN")
	m331(ts, 210, IO0C._LEN, 0x390, IO0D._LEN, 0x4af0, "_LEN")

	m331(ts, 211, FIOC._BAS, 0x3a0, FIOD._BAS, 0x4b00, "_BAS")
	m331(ts, 212, FIOC._LEN, 0x3b0, FIOD._LEN, 0x4b10, "_LEN")

	m331(ts, 213, M24C._RW,  0x410, M24D._RW,  0x4b70, "_RW")
	m331(ts, 214, M24C._MIN, 0x418, M24D._MIN, 0x4b78, "_MIN")
	m331(ts, 215, M24C._MAX, 0x428, M24D._MAX, 0x4b88, "_MAX")
	m331(ts, 216, M24C._ALN, 0x438, M24D._ALN, 0x4b98, "_ALN")
	m331(ts, 217, M24C._LEN, 0x448, M24D._LEN, 0x4ba8, "_LEN")

	m331(ts, 218, IRQE._HE,  0x480, IRQF._HE,  0x4be0, "_HE")
	m331(ts, 219, IRQE._LL,  0x483, IRQF._LL,  0x4be3, "_LL")
	m331(ts, 220, IRQE._SHR, 0x484, IRQF._SHR, 0x4be4, "_SHR")

	m331(ts, 221, DMAE._TYP, 0x4b5, DMAF._TYP, 0x4c15, "_TYP")
	m331(ts, 222, DMAE._BM,  0x4b2, DMAF._BM,  0x4c12, "_BM")
	m331(ts, 223, DMAE._SIZ, 0x4b0, DMAF._SIZ, 0x4c10, "_SIZ")

	m331(ts, 224, IO0E._DEC, 0x4c0, IO0F._DEC, 0x4c20, "_DEC")
	m331(ts, 225, IO0E._MIN, 0x4c8, IO0F._MIN, 0x4c28, "_MIN")
	m331(ts, 226, IO0E._MAX, 0x4d8, IO0F._MAX, 0x4c38, "_MAX")
	m331(ts, 227, IO0E._ALN, 0x4e8, IO0F._ALN, 0x4c48, "_ALN")
	m331(ts, 228, IO0E._LEN, 0x4f0, IO0F._LEN, 0x4c50, "_LEN")

	m331(ts, 229, FIOE._BAS, 0x500, FIOF._BAS, 0x4c60, "_BAS")
	m331(ts, 230, FIOE._LEN, 0x510, FIOF._LEN, 0x4c70, "_LEN")

	m331(ts, 231, M24E._RW,  0x570, M24F._RW,  0x4cd0, "_RW")
	m331(ts, 232, M24E._MIN, 0x578, M24F._MIN, 0x4cd8, "_MIN")
	m331(ts, 233, M24E._MAX, 0x588, M24F._MAX, 0x4ce8, "_MAX")
	m331(ts, 234, M24E._ALN, 0x598, M24F._ALN, 0x4cf8, "_ALN")
	m331(ts, 235, M24E._LEN, 0x5a8, M24F._LEN, 0x4d08, "_LEN")

	m331(ts, 236, M32E._RW,  0x5d0, M32F._RW,  0x4d30, "_RW")
	m331(ts, 237, M32E._MIN, 0x5d8, M32F._MIN, 0x4d38, "_MIN")
	m331(ts, 238, M32E._MAX, 0x5f8, M32F._MAX, 0x4d58, "_MAX")
	m331(ts, 239, M32E._ALN, 0x618, M32F._ALN, 0x4d78, "_ALN")
	m331(ts, 240, M32E._LEN, 0x638, M32F._LEN, 0x4d98, "_LEN")

	// Checkings below are not exhaustive

	m331(ts, 241, M3FG._RW,  0x870, M3FH._RW,  0x4fd0, "_RW")
	m331(ts, 242, M3FG._BAS, 0x878, M3FH._BAS, 0x4fd8, "_BAS")
	m331(ts, 243, M3FG._LEN, 0x898, M3FH._LEN, 0x4ff8, "_LEN")

	m331(ts, 244, M3FI._RW,  0x43d0, M3FJ._RW,  0x8b30, "_RW")
	m331(ts, 245, M3FI._BAS, 0x43d8, M3FJ._BAS, 0x8b38, "_BAS")
	m331(ts, 246, M3FI._LEN, 0x43f8, M3FJ._LEN, 0x8b58, "_LEN")

	m331(ts, 247, M3FK._RW,  0x4640, M3FL._RW,  0x8da0, "_RW")
	m331(ts, 248, M3FK._BAS, 0x4648, M3FL._BAS, 0x8da8, "_BAS")
	m331(ts, 249, M3FK._LEN, 0x4668, M3FL._LEN, 0x8dc8, "_LEN")
}