/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <baseboard/gpio.h>
#include <baseboard/variants.h>
#include <commonlib/helpers.h>
#include <soc/gpio.h>

/* Pad configuration in ramstage */
static const struct pad_config override_gpio_table[] = {
	/* A14 : USB_OC1# ==> NC */
	PAD_NC(GPP_A14, NONE),
	/* A15 : USB_OC2# ==> NC */
	PAD_NC(GPP_A15, NONE),
	/* A19 : DDSP_HPD1 ==> NC */
	PAD_NC(GPP_A19, NONE),
	/* A20 : DDSP_HPD2 ==> NC */
	PAD_NC(GPP_A20, NONE),
	/* A21 : DDPC_CTRCLK ==> NC */
	PAD_NC(GPP_A21, NONE),
	/* A22 : DDPC_CTRLDATA ==> NC */
	PAD_NC(GPP_A22, NONE),

	/* B7  : ISH_12C1_SDA ==> PCH_I2C_MISCB_SDA */
	PAD_CFG_NF_LOCK(GPP_B7, NONE, NF2, LOCK_CONFIG),
	/* B8  : ISH_I2C1_SCL ==> PCH_I2C_MISCB_SCL */
	PAD_CFG_NF_LOCK(GPP_B8, NONE, NF2, LOCK_CONFIG),
	/* B15 : TIME_SYNC0 ==> HP_INT_L */
	PAD_CFG_GPI_INT(GPP_B15, NONE, PLTRST, EDGE_BOTH),
	/* B16 : I2C5_SDA ==> PCH_I2C_TPU_SDA */
	PAD_CFG_NF_LOCK(GPP_B16, NONE, NF2, LOCK_CONFIG),
	/* B17 : I2C5_SCL ==> PCH_I2C_TPU_SCL */
	PAD_CFG_NF_LOCK(GPP_B17, NONE, NF2, LOCK_CONFIG),

	/* C0 : SMBCLK ==> NC */
	PAD_NC(GPP_C0, NONE),
	/* C1 : SMBDATA ==> NC */
	PAD_NC(GPP_C1, NONE),
	/* C3 : SML0CLK ==> NC */
	PAD_NC(GPP_C3, NONE),
	/* C4 : SML0DATA ==> SMBUS_ISP_SCALAR */
	PAD_CFG_GPO(GPP_C4, 0, DEEP),

	/* D0  : ISH_GP0 ==> BOOT_SEL_N */
	PAD_NC(GPP_D0, NONE),
	/* D1  : ISH_GP1 ==> REC_MODE */
	PAD_NC(GPP_D1, NONE),
	/* D2  : ISH_GP2 ==> DEV_MODE_CTRL */
	PAD_NC(GPP_D2, NONE),
	/* D3  : ISH_GP3 ==> BOOT_IND */
	PAD_NC(GPP_D3, NONE),
	/* D9  : ISH_SPI_CS# ==> NC */
	PAD_NC_LOCK(GPP_D9, NONE, LOCK_CONFIG),
	/* D10 : ISH_SPI_CLK ==> GPP_D10_STRAP */
	PAD_CFG_GPI_LOCK(GPP_D10, NONE, LOCK_CONFIG),
	/* D13 : ISH_UART0_RXD ==> NC */
	PAD_NC_LOCK(GPP_D13, NONE, LOCK_CONFIG),
	/* D15 : ISH_UART0_RTS# ==> USI_RST_L */
	PAD_CFG_GPO(GPP_D15, 1, DEEP),
	/* D16 : ISH_UART0_CTS# ==> USI_INT */
	PAD_CFG_GPI_IRQ_WAKE(GPP_D16, NONE, PLTRST, LEVEL, INVERT),
	/* D17 : UART1_RXD ==> PCH_RX_TSUM_UART_TX */
	PAD_CFG_NF(GPP_D17, NONE, DEEP, NF1),
	/* D18 : UART1_TXD ==> PCH_TX_TSUM_UART_RX */
	PAD_CFG_NF(GPP_D18, NONE, DEEP, NF1),

	/* E4  : SATA_DEVSLP0 ==> M2_SSD_PE_WAKE_ODL */
	PAD_CFG_GPI_LOCK(GPP_E4, NONE, LOCK_CONFIG),
	/* E5  : SATA_DEVSLP1 ==> M2_SSD_DEVSLP_OD */
	PAD_CFG_NF(GPP_E5, NONE, PLTRST, NF1),
	/* E9  : USB_OC0# ==> USB_C0_OC_ODL */
	PAD_NC_LOCK(GPP_E9, NONE, LOCK_CONFIG),
	/* E18 : DDP1_CTRLCLK ==> NC */
	PAD_NC(GPP_E18, NONE),
	/* E19 : DDP1_CTRLDATA ==> GPP_E19_STRAP */
	PAD_CFG_GPI_LOCK(GPP_E19, NONE, LOCK_CONFIG),
	/* E20 : DDP2_CTRLCLK ==> NC */
	PAD_NC(GPP_E20, NONE),
	/* E21 : DDP2_CTRLDATA ==> GPP_E21_STRAP */
	PAD_CFG_GPI_LOCK(GPP_E21, NONE, LOCK_CONFIG),

	/* F11 : THC1_SPI2_CLK ==> MEM_CH_SEL */
	PAD_CFG_GPI_LOCK(GPP_F11, NONE, LOCK_CONFIG),
	/* F12 : GSXDOUT ==> MEM_STRAP_1 */
	PAD_CFG_GPI_LOCK(GPP_F12, NONE, LOCK_CONFIG),
	/* F13 : GSXDOUT ==> MEM_STRAP_2 */
	PAD_CFG_GPI_LOCK(GPP_F13, NONE, LOCK_CONFIG),
	/* F15 : GSXSRESET# ==> MEM_STRAP_3 */
	PAD_CFG_GPI_LOCK(GPP_F15, NONE, LOCK_CONFIG),
	/* F16 : GSXCLK ==> MEM_STRAP_0 */
	PAD_CFG_GPI_LOCK(GPP_F16, NONE, LOCK_CONFIG),

	/* H12 : I2C7_SDA ==> NC */
	PAD_NC_LOCK(GPP_H12, NONE, LOCK_CONFIG),
	/* H13 : I2C7_SCL ==> NC */
	PAD_NC_LOCK(GPP_H13, NONE, LOCK_CONFIG),
	/* H15 : DDPB_CTRLCLK ==> NC */
	PAD_NC(GPP_H15, NONE),
	/* H17 : DDPB_CTRLDATA ==> NC */
	PAD_NC(GPP_H17, NONE),
	/* H19 : SRCCLKREQ4# ==> M2_TPU1_CLKREQ_ODL */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF1),

	/* R0 : HDA_BCLK ==> NC */
	PAD_NC_LOCK(GPP_R0, NONE, LOCK_CONFIG),
	/* R1 : HDA_SYNC ==> I2S_PCH_TX_HP_RX_STRAP */
	PAD_CFG_GPI_LOCK(GPP_R1, NONE, LOCK_CONFIG),
	/* R2 : HDA_SDO ==> NC */
	PAD_NC(GPP_R2, NONE),
	/* R3 : HDA_SDIO ==> NC */
	PAD_NC(GPP_R3, NONE),
	/* R4 : HDA_RST# ==> NC */
	PAD_NC(GPP_R4, NONE),
	/* R5 : HDA_SDI1 ==> NC */
	PAD_NC(GPP_R5, NONE),
	/* R6 : I2S2_TXD ==> NC */
	PAD_NC(GPP_R6, NONE),
	/* R7 : I2S2_RXD ==> NC */
	PAD_NC(GPP_R7, NONE),

	/* S0 : SNDW0_CLK ==> PCH_I2S_SCLK_MX8M */
	PAD_CFG_NF(GPP_S0, NONE, DEEP, NF4),
	/* S1 : SNDW0_DATA ==> PCH_I2S_SFRM_MX8M */
	PAD_CFG_NF(GPP_S1, NONE, DEEP, NF4),
	/* S2 : SNDW1_CLK ==> PCH_I2S_TX_MX8M_RX */
	PAD_CFG_NF(GPP_S2, NONE, DEEP, NF4),
	/* S3 : SNDW1_DATA ==> PCH_I2S_RX_MX8M_TX */
	PAD_CFG_NF(GPP_S3, NONE, DEEP, NF4),
};

/* Early pad configuration in bootblock */
static const struct pad_config early_gpio_table[] = {
	/* A13 : PMC_I2C_SCL ==> GSC_PCH_INT_ODL */
	PAD_CFG_GPI_APIC(GPP_A13, NONE, PLTRST, LEVEL, INVERT),
	/* B4  : PROC_GP3 ==> SSD_PERST_L */
	PAD_CFG_GPO(GPP_B4, 0, DEEP),
	/* E15 : RSVD_TP ==> PCH_WP_OD */
	PAD_CFG_GPI_GPIO_DRIVER(GPP_E15, NONE, DEEP),
	/* F14 : GSXDIN ==> EN_PP3300_SSD */
	PAD_CFG_GPO(GPP_F14, 1, DEEP),
	/* F18 : THC1_SPI2_INT# ==> EC_IN_RW_OD */
	PAD_CFG_GPI(GPP_F18, NONE, DEEP),
	/* H6  : I2C1_SDA ==> PCH_I2C_TPM_SDA */
	PAD_CFG_NF(GPP_H6, NONE, DEEP, NF1),
	/* H7  : I2C1_SCL ==> PCH_I2C_TPM_SCL */
	PAD_CFG_NF(GPP_H7, NONE, DEEP, NF1),
	/* H10 : UART0_RXD ==> UART_PCH_RX_DBG_TX */
	PAD_CFG_NF(GPP_H10, NONE, DEEP, NF2),
	/* H11 : UART0_TXD ==> UART_PCH_TX_DBG_RX */
	PAD_CFG_NF(GPP_H11, NONE, DEEP, NF2),

	/* CPU PCIe VGPIO for PEG60 */
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_48, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_49, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_50, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_51, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_52, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_53, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_54, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_55, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_56, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_57, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_58, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_59, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_60, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_61, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_62, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_63, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_76, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_77, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_78, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_79, NONE, PLTRST, NF1),
};

static const struct pad_config romstage_gpio_table[] = {
	/* B4  : PROC_GP3 ==> SSD_PERST_L */
	PAD_CFG_GPO(GPP_B4, 1, DEEP),
};

const struct pad_config *variant_gpio_override_table(size_t *num)
{
	*num = ARRAY_SIZE(override_gpio_table);
	return override_gpio_table;
}

const struct pad_config *variant_early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table);
	return early_gpio_table;
}

const struct pad_config *variant_romstage_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(romstage_gpio_table);
	return romstage_gpio_table;
}
