---
title: Install Canoeboot on Lenovo ThinkPad W541 and/or W540
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](ivy_has_common.md).**

Open source BIOS/UEFI firmware
-------------------------

This document will teach you how to install Canoeboot, on your
Lenovo ThinkPad W541 and/or W540 laptop motherboard.
Canoeboot is a [Free Software](https://writefreesoftware.org/learn) project
that replaces proprietary BIOS/UEFI firmware.

NOTE: The same image for W541 also works on the W540, as the motherboards are
identical for coreboot purposes.

Splitting The Rom
-----------------

You can use `dd` to easily split your rom into the two separate portions for
external flashing.

	dd if=canoeboot.rom of=top.rom bs=1M skip=8
	dd if=canoeboot.rom of=bottom.rom bs=1M count=8

Flash the top chip with top.rom, and the bottom chip with bottom.rom.
Don't worry about knowing which chip is which on a standard setup; flashprog will let you know if the 
image size is incorrect for the chip you're flashing.

### 4MB CBFS

CBFS is 4MB on this board, so when external flashing, you can just break off
the upper 4MB part of the image and flash that. Keep this in mind if you're
flashing externally.

When externally flashing the lower 8MB part, you can optionally flash the
IFD and GbE regions if that is appropriate for your setup.

Disassembly
-----------

No disassembly pics yet. The W540/T540p hardware maintenance manual also
applies to W541:

<https://thinkpads.com/support/hmm/hmm_pdf/t540p_w540_hmm_en_sp40a26003_01.pdf>

This shows disassembly. When you disassemble, and get to flashing, please note:

MOSI/MISO lines are linked between the two flash ICs, at zero ohms. This is OK
for internal flashing and normal operation, because the PCH turns each chip on
or off as needed, by controlling each IC's own *chip select* pin, which is
pin 1.

When you wire the clip, to flash one of the ICs, the same voltage rail also
turns on the other IC and the other IC's own chip-select is in a *floating*
state, which in practise means *random logic state*; in other words, the other
flash may or may not be active, randomly.

This means that external flashing would not ordinarily work, unless you use
the following trick:

Use a *test hook* wired to VCC (+3.3v), to pull the other flash's chip-select
high. So: when flashing one of the two ICs, the other chip must have pin 1
connected to VCC. You can do this with the same 3.3v power source that you use
on pin 8 of the chip that you're flashing. Ideally you should pull the other
chip select high via 47ohm resistor, which should be enough to prevent damage
in the case of accidentally shorting the wrong pin.

Doing this means that you *disable* the chip you're not flashing. It's very
important that you ensure only the one you want to flash is active, when using
an external flasher.

**This is not required for internal flashing. It is only required for
external flashing.**

If you do it right, the chips should flash reliably. This same trick must be
used when flashing either of the chips.

You can now proceed to [flashing](/docs/install/spi.html) this machine.

thinkpad\_acpi issues {#thinkpad-acpi}
---------------------------------------

It has been reported by a user that `thinkpad_acpi` does not load correctly on
the T440p. Since the W541/W540/T540p are also Haswell machines, you may be
affected by this issue.

If you encounter this, check [this page](../../faq.md#thinkpad-acpi)
for details as to how to fix this.
