use std::collections::HashMap;

use zbus::Connection;

#[tokio::main]
async fn main() -> udisks2::Result<()> {
    gettextrs::setlocale(gettextrs::LocaleCategory::LcAll, "de_DE.UTF-8");
    gettextrs::textdomain(GETTEXT_PACKAGE).expect("Failed to set textdomain");

    let client = udisks2::Client::new().await?;
    let version = client.manager().version().await?;
    println!("Version: {}", version);
    let object = client
        .object("/org/freedesktop/UDisks2/block_devices/sda")
        .expect("No sda device found");
    let block = object.block().await?;
    let drive = client.drive_for_block(&block).await?;
    println!(
        "Size: {}",
        client.size_for_display(drive.size().await?, true, true)
    );
    println!("Block: {}", block.inner().path());
    let drive =
        client.object("/org/freedesktop/UDisks2/drives/SanDisk_SSD_PLUS_1000GB_1926FP462112")?;
    println!(
        "Drive: {:?}",
        drive.drive().await.unwrap().can_power_off().await
    );
    println!("{:?}", block.device().await);

    let swap = client.object("/org/freedesktop/UDisks2/block_devices/zram0")?;
    println!("Swap: {:?}", swap.swapspace().await?.active().await?);
    //println!(
    //    "Object: {:?}",
    //    client.object(drive.drive().await?.inner().path().to_owned())
    //);

    const GETTEXT_PACKAGE: &str = "udisks2";
    //
    println!(
        "{}",
        gettextrs::dgettext(GETTEXT_PACKAGE, "Mount a filesystem on a system device")
    );
    // println!("{:?}", client.partition_table_type_for_display("apm"));
    // println!(
    //     "{:?}",
    //     client.job_description_from_operation("md-raid-creates")
    // );
    // println!("{:?}", block.symlinks().await);

    let fs = client
        .object("/org/freedesktop/UDisks2/block_devices/sdb2")
        .expect("No sda device found")
        .filesystem()
        .await?;
    println!("MountPoints: {:?}", fs.mount_points().await?);
    let connection = zbus::Connection::session().await?;
    let job = udisks2::job::JobProxy::new(&connection).await.unwrap();
    dbg!(&job.rate().await);

    Ok(())
}
