% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{raster2uri}
\alias{raster2uri}
\title{Encode a raster object as a data URI}
\usage{
raster2uri(r, ...)
}
\arguments{
\item{r}{an object coercable to a raster object via \code{\link[=as.raster]{as.raster()}}}

\item{...}{arguments passed onto \code{\link[=as.raster]{as.raster()}}.}
}
\description{
Encode a raster object as a data URI, which is suitable for
use with \code{layout()} \href{https://plotly.com/r/reference/#layout-images}{images}.
This is especially convenient for embedding raster images on a plot in
a self-contained fashion (i.e., so they don't depend on external URL links).
}
\examples{
\dontshow{if (interactive() || !identical(.Platform$OS.type, "windows")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# a red gradient (from ?as.raster)
r <- as.raster(matrix(hcl(0, 80, seq(50, 80, 10)), nrow = 4, ncol = 5))
plot(r)

# embed the raster as an image
plot_ly(x = 1, y = 1) \%>\% 
  layout(
    images = list(list(
     source = raster2uri(r),
     xref = "paper", 
     yref = "paper", 
     x = 0, y = 0, 
     sizex = 0.5, sizey = 0.5, 
     xanchor = "left", yanchor = "bottom"
  ))
 ) 
\dontshow{\}) # examplesIf}
}
\references{
\url{https://plotly-r.com/embedding-images.html}
}
\author{
Carson Sievert
}
