
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IVtkTools_ShapeDataSource.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IVtkTools.hxx>
#include <IVtkTools_DisplayModeFilter.hxx>
#include <IVtkTools_ShapeDataSource.hxx>
#include <IVtkTools_ShapeObject.hxx>
#include <IVtkTools_ShapePicker.hxx>
#include <IVtkTools_SubPolyDataFilter.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#undef Handle
#include <vtkRenderer.h>
#include <vtkActor.h>
#include <vtkInformationObjectBaseKey.h>

// Module definiiton
void register_IVtkTools(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("IVtkTools"));
py::object klass;

//Python trampoline classes

// classes

    // Class IVtkTools_ShapeDataSource from ./opencascade/IVtkTools_ShapeDataSource.hxx
    klass = m.attr("IVtkTools_ShapeDataSource");


    // nested enums

    static_cast<py::class_<IVtkTools_ShapeDataSource , shared_ptr_nodelete<IVtkTools_ShapeDataSource>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsA",
             (vtkTypeBool (IVtkTools_ShapeDataSource::*)( const char *  ) ) static_cast<vtkTypeBool (IVtkTools_ShapeDataSource::*)( const char *  ) >(&IVtkTools_ShapeDataSource::IsA),
             R"#(None)#"  , py::arg("type")
          )
        .def("NewInstance",
             (IVtkTools_ShapeDataSource * (IVtkTools_ShapeDataSource::*)() const) static_cast<IVtkTools_ShapeDataSource * (IVtkTools_ShapeDataSource::*)() const>(&IVtkTools_ShapeDataSource::NewInstance),
             R"#(None)#" 
          )
        .def("GetNumberOfGenerationsFromBase",
             (vtkIdType (IVtkTools_ShapeDataSource::*)( const char *  ) ) static_cast<vtkIdType (IVtkTools_ShapeDataSource::*)( const char *  ) >(&IVtkTools_ShapeDataSource::GetNumberOfGenerationsFromBase),
             R"#(None)#"  , py::arg("type")
          )
        .def("SetShape",
             (void (IVtkTools_ShapeDataSource::*)(  const opencascade::handle<IVtkOCC_Shape> &  ) ) static_cast<void (IVtkTools_ShapeDataSource::*)(  const opencascade::handle<IVtkOCC_Shape> &  ) >(&IVtkTools_ShapeDataSource::SetShape),
             R"#(Set the source OCCT shape.)#"  , py::arg("theOccShape")
          )
        .def("FastTransformModeOn",
             (void (IVtkTools_ShapeDataSource::*)() ) static_cast<void (IVtkTools_ShapeDataSource::*)() >(&IVtkTools_ShapeDataSource::FastTransformModeOn),
             R"#(None)#" 
          )
        .def("FastTransformModeOff",
             (void (IVtkTools_ShapeDataSource::*)() ) static_cast<void (IVtkTools_ShapeDataSource::*)() >(&IVtkTools_ShapeDataSource::FastTransformModeOff),
             R"#(None)#" 
          )
        .def("GetId",
             (IVtk_IdType (IVtkTools_ShapeDataSource::*)() const) static_cast<IVtk_IdType (IVtkTools_ShapeDataSource::*)() const>(&IVtkTools_ShapeDataSource::GetId),
             R"#(Returns ID of the shape used as a topological input for this data source.)#" 
          )
        .def("Contains",
             (Standard_Boolean (IVtkTools_ShapeDataSource::*)(  const opencascade::handle<IVtkOCC_Shape> &  ) const) static_cast<Standard_Boolean (IVtkTools_ShapeDataSource::*)(  const opencascade::handle<IVtkOCC_Shape> &  ) const>(&IVtkTools_ShapeDataSource::Contains),
             R"#(Checks if the internal OccShape pointer is the same the argument.)#"  , py::arg("theOccShape")
          )
        .def("SubShapeIDs",
             (vtkSmartPointer<vtkIdTypeArray> (IVtkTools_ShapeDataSource::*)() ) static_cast<vtkSmartPointer<vtkIdTypeArray> (IVtkTools_ShapeDataSource::*)() >(&IVtkTools_ShapeDataSource::SubShapeIDs),
             R"#(Access to the shape's sub-shape ids array)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsTypeOf_s",
                    (vtkTypeBool (*)( const char *  ) ) static_cast<vtkTypeBool (*)( const char *  ) >(&IVtkTools_ShapeDataSource::IsTypeOf),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("SafeDownCast_s",
                    (IVtkTools_ShapeDataSource * (*)( vtkObjectBase *  ) ) static_cast<IVtkTools_ShapeDataSource * (*)( vtkObjectBase *  ) >(&IVtkTools_ShapeDataSource::SafeDownCast),
                    R"#(None)#"  , py::arg("o")
          )
        .def_static("GetNumberOfGenerationsFromBaseType_s",
                    (vtkIdType (*)( const char *  ) ) static_cast<vtkIdType (*)( const char *  ) >(&IVtkTools_ShapeDataSource::GetNumberOfGenerationsFromBaseType),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("New_s",
                    (IVtkTools_ShapeDataSource * (*)() ) static_cast<IVtkTools_ShapeDataSource * (*)() >(&IVtkTools_ShapeDataSource::New),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetShape",
             (const IVtkOCC_Shape::Handle & (IVtkTools_ShapeDataSource::*)() ) static_cast<const IVtkOCC_Shape::Handle & (IVtkTools_ShapeDataSource::*)() >(&IVtkTools_ShapeDataSource::GetShape),
             R"#(Get the source OCCT shape.)#"
             
         )
;

    // Class IVtkTools_ShapeObject from ./opencascade/IVtkTools_ShapeObject.hxx
    klass = m.attr("IVtkTools_ShapeObject");


    // nested enums

    static_cast<py::class_<IVtkTools_ShapeObject , shared_ptr_nodelete<IVtkTools_ShapeObject>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsA",
             (vtkTypeBool (IVtkTools_ShapeObject::*)( const char *  ) ) static_cast<vtkTypeBool (IVtkTools_ShapeObject::*)( const char *  ) >(&IVtkTools_ShapeObject::IsA),
             R"#(None)#"  , py::arg("type")
          )
        .def("NewInstance",
             (IVtkTools_ShapeObject * (IVtkTools_ShapeObject::*)() const) static_cast<IVtkTools_ShapeObject * (IVtkTools_ShapeObject::*)() const>(&IVtkTools_ShapeObject::NewInstance),
             R"#(None)#" 
          )
        .def("GetNumberOfGenerationsFromBase",
             (vtkIdType (IVtkTools_ShapeObject::*)( const char *  ) ) static_cast<vtkIdType (IVtkTools_ShapeObject::*)( const char *  ) >(&IVtkTools_ShapeObject::GetNumberOfGenerationsFromBase),
             R"#(None)#"  , py::arg("type")
          )
        .def("SetShapeSource",
             (void (IVtkTools_ShapeObject::*)( IVtkTools_ShapeDataSource *  ) ) static_cast<void (IVtkTools_ShapeObject::*)( IVtkTools_ShapeDataSource *  ) >(&IVtkTools_ShapeObject::SetShapeSource),
             R"#(OCC shape source setter.)#"  , py::arg("theDataSource")
          )
        .def("GetShapeSource",
             (IVtkTools_ShapeDataSource * (IVtkTools_ShapeObject::*)() const) static_cast<IVtkTools_ShapeDataSource * (IVtkTools_ShapeObject::*)() const>(&IVtkTools_ShapeObject::GetShapeSource),
             R"#(OCC shape source getter.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsTypeOf_s",
                    (vtkTypeBool (*)( const char *  ) ) static_cast<vtkTypeBool (*)( const char *  ) >(&IVtkTools_ShapeObject::IsTypeOf),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("SafeDownCast_s",
                    (IVtkTools_ShapeObject * (*)( vtkObjectBase *  ) ) static_cast<IVtkTools_ShapeObject * (*)( vtkObjectBase *  ) >(&IVtkTools_ShapeObject::SafeDownCast),
                    R"#(None)#"  , py::arg("o")
          )
        .def_static("GetNumberOfGenerationsFromBaseType_s",
                    (vtkIdType (*)( const char *  ) ) static_cast<vtkIdType (*)( const char *  ) >(&IVtkTools_ShapeObject::GetNumberOfGenerationsFromBaseType),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("New_s",
                    (IVtkTools_ShapeObject * (*)() ) static_cast<IVtkTools_ShapeObject * (*)() >(&IVtkTools_ShapeObject::New),
                    R"#(None)#" 
          )
        .def_static("GetShapeSource_s",
                    (vtkSmartPointer<IVtkTools_ShapeDataSource> (*)( vtkActor *  ) ) static_cast<vtkSmartPointer<IVtkTools_ShapeDataSource> (*)( vtkActor *  ) >(&IVtkTools_ShapeObject::GetShapeSource),
                    R"#(Get OCC shape source from VTK data from actor's information object by key.)#"  , py::arg("theActor")
          )
        .def_static("GetOccShape_s",
                    (IVtkOCC_Shape::Handle (*)( vtkActor *  ) ) static_cast<IVtkOCC_Shape::Handle (*)( vtkActor *  ) >(&IVtkTools_ShapeObject::GetOccShape),
                    R"#(Get OCC shape from VTK data from actor's information object by key.)#"  , py::arg("theActor")
          )
        .def_static("SetShapeSource_s",
                    (void (*)( IVtkTools_ShapeDataSource * ,  vtkDataSet *  ) ) static_cast<void (*)( IVtkTools_ShapeDataSource * ,  vtkDataSet *  ) >(&IVtkTools_ShapeObject::SetShapeSource),
                    R"#(Static method to set OCC shape source to VTK dataset in information object with key.)#"  , py::arg("theDataSource"),  py::arg("theData")
          )
        .def_static("SetShapeSource_s",
                    (void (*)( IVtkTools_ShapeDataSource * ,  vtkActor *  ) ) static_cast<void (*)( IVtkTools_ShapeDataSource * ,  vtkActor *  ) >(&IVtkTools_ShapeObject::SetShapeSource),
                    R"#(Static method to set OCC shape source to VTK actor in information object with key.)#"  , py::arg("theDataSource"),  py::arg("theActor")
          )
        .def_static("getKey_s",
                    (IVtkTools_ShapeObject::KeyPtr (*)() ) static_cast<IVtkTools_ShapeObject::KeyPtr (*)() >(&IVtkTools_ShapeObject::getKey),
                    R"#(Static method used by shape selection logic in order to establish a connection from vtkActor to OccShape instance.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class IVtkTools_ShapePicker from ./opencascade/IVtkTools_ShapePicker.hxx
    klass = m.attr("IVtkTools_ShapePicker");


    // nested enums

    static_cast<py::class_<IVtkTools_ShapePicker , shared_ptr_nodelete<IVtkTools_ShapePicker>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsA",
             (vtkTypeBool (IVtkTools_ShapePicker::*)( const char *  ) ) static_cast<vtkTypeBool (IVtkTools_ShapePicker::*)( const char *  ) >(&IVtkTools_ShapePicker::IsA),
             R"#(None)#"  , py::arg("type")
          )
        .def("NewInstance",
             (IVtkTools_ShapePicker * (IVtkTools_ShapePicker::*)() const) static_cast<IVtkTools_ShapePicker * (IVtkTools_ShapePicker::*)() const>(&IVtkTools_ShapePicker::NewInstance),
             R"#(None)#" 
          )
        .def("GetNumberOfGenerationsFromBase",
             (vtkIdType (IVtkTools_ShapePicker::*)( const char *  ) ) static_cast<vtkIdType (IVtkTools_ShapePicker::*)( const char *  ) >(&IVtkTools_ShapePicker::GetNumberOfGenerationsFromBase),
             R"#(None)#"  , py::arg("type")
          )
        .def("SetTolerance",
             (void (IVtkTools_ShapePicker::*)( float  ) ) static_cast<void (IVtkTools_ShapePicker::*)( float  ) >(&IVtkTools_ShapePicker::SetTolerance),
             R"#(Setter for tolerance of picking.)#"  , py::arg("theTolerance")
          )
        .def("GetTolerance",
             (float (IVtkTools_ShapePicker::*)() const) static_cast<float (IVtkTools_ShapePicker::*)() const>(&IVtkTools_ShapePicker::GetTolerance),
             R"#(Getter for tolerance of picking.)#" 
          )
        .def("SetRenderer",
             (void (IVtkTools_ShapePicker::*)( vtkRenderer *  ) ) static_cast<void (IVtkTools_ShapePicker::*)( vtkRenderer *  ) >(&IVtkTools_ShapePicker::SetRenderer),
             R"#(Sets the renderer to be used by OCCT selection algorithm)#"  , py::arg("theRenderer")
          )
        .def("SetAreaSelection",
             (void (IVtkTools_ShapePicker::*)( bool  ) ) static_cast<void (IVtkTools_ShapePicker::*)( bool  ) >(&IVtkTools_ShapePicker::SetAreaSelection),
             R"#(Sets area selection on/off)#"  , py::arg("theIsOn")
          )
        .def("GetSelectionModes",
             (IVtk_SelectionModeList (IVtkTools_ShapePicker::*)(  const opencascade::handle<IVtk_IShape> &  ) const) static_cast<IVtk_SelectionModeList (IVtkTools_ShapePicker::*)(  const opencascade::handle<IVtk_IShape> &  ) const>(&IVtkTools_ShapePicker::GetSelectionModes),
             R"#(Get activated selection modes for a shape.)#"  , py::arg("theShape")
          )
        .def("GetSelectionModes",
             (IVtk_SelectionModeList (IVtkTools_ShapePicker::*)( vtkActor *  ) const) static_cast<IVtk_SelectionModeList (IVtkTools_ShapePicker::*)( vtkActor *  ) const>(&IVtkTools_ShapePicker::GetSelectionModes),
             R"#(Get activated selection modes for a shape actor.)#"  , py::arg("theShapeActor")
          )
        .def("SetSelectionMode",
             (void (IVtkTools_ShapePicker::*)(  const opencascade::handle<IVtk_IShape> & ,  const IVtk_SelectionMode ,  const bool  ) const) static_cast<void (IVtkTools_ShapePicker::*)(  const opencascade::handle<IVtk_IShape> & ,  const IVtk_SelectionMode ,  const bool  ) const>(&IVtkTools_ShapePicker::SetSelectionMode),
             R"#(Turn on/off a selection mode for a shape actor.)#"  , py::arg("theShape"),  py::arg("theMode"),  py::arg("theIsTurnOn")=static_cast<const bool>(true)
          )
        .def("SetSelectionMode",
             (void (IVtkTools_ShapePicker::*)( vtkActor * ,  const IVtk_SelectionMode ,  const bool  ) const) static_cast<void (IVtkTools_ShapePicker::*)( vtkActor * ,  const IVtk_SelectionMode ,  const bool  ) const>(&IVtkTools_ShapePicker::SetSelectionMode),
             R"#(Turn on/off a selection mode for a shape actor.)#"  , py::arg("theShapeActor"),  py::arg("theMode"),  py::arg("theIsTurnOn")=static_cast<const bool>(true)
          )
        .def("SetSelectionMode",
             (void (IVtkTools_ShapePicker::*)( const IVtk_SelectionMode ,  const bool  ) const) static_cast<void (IVtkTools_ShapePicker::*)( const IVtk_SelectionMode ,  const bool  ) const>(&IVtkTools_ShapePicker::SetSelectionMode),
             R"#(Sets the current selection mode for all visible shape objects.)#"  , py::arg("theMode"),  py::arg("theIsTurnOn")=static_cast<const bool>(true)
          )
        .def("GetPickedShapesIds",
             (IVtk_ShapeIdList (IVtkTools_ShapePicker::*)( bool  ) const) static_cast<IVtk_ShapeIdList (IVtkTools_ShapePicker::*)( bool  ) const>(&IVtkTools_ShapePicker::GetPickedShapesIds),
             R"#(Access to the list of top-level shapes picked. If all argument is true, the picker returns the list of all OccShape objects found by the picking algorithm. e.g. all shapes under the mouse cursor. Otherwise, ID of the shape closest to the eye is returned.)#"  , py::arg("theIsAll")=static_cast<bool>(false)
          )
        .def("GetPickedSubShapesIds",
             (IVtk_ShapeIdList (IVtkTools_ShapePicker::*)( const IVtk_IdType ,  bool  ) const) static_cast<IVtk_ShapeIdList (IVtkTools_ShapePicker::*)( const IVtk_IdType ,  bool  ) const>(&IVtkTools_ShapePicker::GetPickedSubShapesIds),
             R"#(Access to the list of sub-shapes ids picked.)#"  , py::arg("theId"),  py::arg("theIsAll")=static_cast<bool>(false)
          )
        .def("GetPickedActors",
             (vtkSmartPointer<vtkActorCollection> (IVtkTools_ShapePicker::*)( bool  ) const) static_cast<vtkSmartPointer<vtkActorCollection> (IVtkTools_ShapePicker::*)( bool  ) const>(&IVtkTools_ShapePicker::GetPickedActors),
             R"#(Access to the list of actors picked.)#"  , py::arg("theIsAll")=static_cast<bool>(false)
          )
        .def("RemoveSelectableObject",
             (void (IVtkTools_ShapePicker::*)(  const opencascade::handle<IVtk_IShape> &  ) ) static_cast<void (IVtkTools_ShapePicker::*)(  const opencascade::handle<IVtk_IShape> &  ) >(&IVtkTools_ShapePicker::RemoveSelectableObject),
             R"#(Remove selectable object from the picker (from internal maps).)#"  , py::arg("theShape")
          )
        .def("RemoveSelectableActor",
             (void (IVtkTools_ShapePicker::*)( vtkActor *  ) ) static_cast<void (IVtkTools_ShapePicker::*)( vtkActor *  ) >(&IVtkTools_ShapePicker::RemoveSelectableActor),
             R"#(Remove selectable object from the picker (from internal maps).)#"  , py::arg("theShapeActor")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsTypeOf_s",
                    (vtkTypeBool (*)( const char *  ) ) static_cast<vtkTypeBool (*)( const char *  ) >(&IVtkTools_ShapePicker::IsTypeOf),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("SafeDownCast_s",
                    (IVtkTools_ShapePicker * (*)( vtkObjectBase *  ) ) static_cast<IVtkTools_ShapePicker * (*)( vtkObjectBase *  ) >(&IVtkTools_ShapePicker::SafeDownCast),
                    R"#(None)#"  , py::arg("o")
          )
        .def_static("GetNumberOfGenerationsFromBaseType_s",
                    (vtkIdType (*)( const char *  ) ) static_cast<vtkIdType (*)( const char *  ) >(&IVtkTools_ShapePicker::GetNumberOfGenerationsFromBaseType),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("New_s",
                    (IVtkTools_ShapePicker * (*)() ) static_cast<IVtkTools_ShapePicker * (*)() >(&IVtkTools_ShapePicker::New),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class IVtkTools_SubPolyDataFilter from ./opencascade/IVtkTools_SubPolyDataFilter.hxx
    klass = m.attr("IVtkTools_SubPolyDataFilter");


    // nested enums

    static_cast<py::class_<IVtkTools_SubPolyDataFilter , shared_ptr_nodelete<IVtkTools_SubPolyDataFilter>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsA",
             (vtkTypeBool (IVtkTools_SubPolyDataFilter::*)( const char *  ) ) static_cast<vtkTypeBool (IVtkTools_SubPolyDataFilter::*)( const char *  ) >(&IVtkTools_SubPolyDataFilter::IsA),
             R"#(None)#"  , py::arg("type")
          )
        .def("NewInstance",
             (IVtkTools_SubPolyDataFilter * (IVtkTools_SubPolyDataFilter::*)() const) static_cast<IVtkTools_SubPolyDataFilter * (IVtkTools_SubPolyDataFilter::*)() const>(&IVtkTools_SubPolyDataFilter::NewInstance),
             R"#(None)#" 
          )
        .def("GetNumberOfGenerationsFromBase",
             (vtkIdType (IVtkTools_SubPolyDataFilter::*)( const char *  ) ) static_cast<vtkIdType (IVtkTools_SubPolyDataFilter::*)( const char *  ) >(&IVtkTools_SubPolyDataFilter::GetNumberOfGenerationsFromBase),
             R"#(None)#"  , py::arg("type")
          )
        .def("SetData",
             (void (IVtkTools_SubPolyDataFilter::*)(  const NCollection_Map<IVtk_IdType>  ) ) static_cast<void (IVtkTools_SubPolyDataFilter::*)(  const NCollection_Map<IVtk_IdType>  ) >(&IVtkTools_SubPolyDataFilter::SetData),
             R"#(Set ids to be passed through this filter.)#"  , py::arg("theSet")
          )
        .def("AddData",
             (void (IVtkTools_SubPolyDataFilter::*)(  const NCollection_Map<IVtk_IdType>  ) ) static_cast<void (IVtkTools_SubPolyDataFilter::*)(  const NCollection_Map<IVtk_IdType>  ) >(&IVtkTools_SubPolyDataFilter::AddData),
             R"#(Add ids to be passed through this filter.)#"  , py::arg("theSet")
          )
        .def("SetData",
             (void (IVtkTools_SubPolyDataFilter::*)(  const NCollection_List<IVtk_IdType>  ) ) static_cast<void (IVtkTools_SubPolyDataFilter::*)(  const NCollection_List<IVtk_IdType>  ) >(&IVtkTools_SubPolyDataFilter::SetData),
             R"#(Set ids to be passed through this filter.)#"  , py::arg("theIds")
          )
        .def("AddData",
             (void (IVtkTools_SubPolyDataFilter::*)(  const NCollection_List<IVtk_IdType>  ) ) static_cast<void (IVtkTools_SubPolyDataFilter::*)(  const NCollection_List<IVtk_IdType>  ) >(&IVtkTools_SubPolyDataFilter::AddData),
             R"#(Add ids to be passed through this filter.)#"  , py::arg("theIds")
          )
        .def("Clear",
             (void (IVtkTools_SubPolyDataFilter::*)() ) static_cast<void (IVtkTools_SubPolyDataFilter::*)() >(&IVtkTools_SubPolyDataFilter::Clear),
             R"#(Clear ids set to be passed through this filter.)#" 
          )
        .def("SetIdsArrayName",
             (void (IVtkTools_SubPolyDataFilter::*)( const char *  ) ) static_cast<void (IVtkTools_SubPolyDataFilter::*)( const char *  ) >(&IVtkTools_SubPolyDataFilter::SetIdsArrayName),
             R"#(Set ids array name.)#"  , py::arg("theArrayName")
          )
        .def("SetDoFiltering",
             (void (IVtkTools_SubPolyDataFilter::*)( const bool  ) ) static_cast<void (IVtkTools_SubPolyDataFilter::*)( const bool  ) >(&IVtkTools_SubPolyDataFilter::SetDoFiltering),
             R"#(None)#"  , py::arg("theDoFiltering")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsTypeOf_s",
                    (vtkTypeBool (*)( const char *  ) ) static_cast<vtkTypeBool (*)( const char *  ) >(&IVtkTools_SubPolyDataFilter::IsTypeOf),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("SafeDownCast_s",
                    (IVtkTools_SubPolyDataFilter * (*)( vtkObjectBase *  ) ) static_cast<IVtkTools_SubPolyDataFilter * (*)( vtkObjectBase *  ) >(&IVtkTools_SubPolyDataFilter::SafeDownCast),
                    R"#(None)#"  , py::arg("o")
          )
        .def_static("GetNumberOfGenerationsFromBaseType_s",
                    (vtkIdType (*)( const char *  ) ) static_cast<vtkIdType (*)( const char *  ) >(&IVtkTools_SubPolyDataFilter::GetNumberOfGenerationsFromBaseType),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("New_s",
                    (IVtkTools_SubPolyDataFilter * (*)() ) static_cast<IVtkTools_SubPolyDataFilter * (*)() >(&IVtkTools_SubPolyDataFilter::New),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class IVtkTools_DisplayModeFilter from ./opencascade/IVtkTools_DisplayModeFilter.hxx
    klass = m.attr("IVtkTools_DisplayModeFilter");


    // nested enums

    static_cast<py::class_<IVtkTools_DisplayModeFilter , shared_ptr_nodelete<IVtkTools_DisplayModeFilter>  , IVtkTools_SubPolyDataFilter >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsA",
             (vtkTypeBool (IVtkTools_DisplayModeFilter::*)( const char *  ) ) static_cast<vtkTypeBool (IVtkTools_DisplayModeFilter::*)( const char *  ) >(&IVtkTools_DisplayModeFilter::IsA),
             R"#(None)#"  , py::arg("type")
          )
        .def("NewInstance",
             (IVtkTools_DisplayModeFilter * (IVtkTools_DisplayModeFilter::*)() const) static_cast<IVtkTools_DisplayModeFilter * (IVtkTools_DisplayModeFilter::*)() const>(&IVtkTools_DisplayModeFilter::NewInstance),
             R"#(None)#" 
          )
        .def("GetNumberOfGenerationsFromBase",
             (vtkIdType (IVtkTools_DisplayModeFilter::*)( const char *  ) ) static_cast<vtkIdType (IVtkTools_DisplayModeFilter::*)( const char *  ) >(&IVtkTools_DisplayModeFilter::GetNumberOfGenerationsFromBase),
             R"#(None)#"  , py::arg("type")
          )
        .def("SetDisplayMode",
             (void (IVtkTools_DisplayModeFilter::*)( const IVtk_DisplayMode  ) ) static_cast<void (IVtkTools_DisplayModeFilter::*)( const IVtk_DisplayMode  ) >(&IVtkTools_DisplayModeFilter::SetDisplayMode),
             R"#(Set display mode to define cells types to be passed through this filter.)#"  , py::arg("aMode")
          )
        .def("SetDisplaySharedVertices",
             (void (IVtkTools_DisplayModeFilter::*)( const bool  ) ) static_cast<void (IVtkTools_DisplayModeFilter::*)( const bool  ) >(&IVtkTools_DisplayModeFilter::SetDisplaySharedVertices),
             R"#(Display or not shared vertices.)#"  , py::arg("doDisplay")
          )
        .def("GetDisplayMode",
             (IVtk_DisplayMode (IVtkTools_DisplayModeFilter::*)() const) static_cast<IVtk_DisplayMode (IVtkTools_DisplayModeFilter::*)() const>(&IVtkTools_DisplayModeFilter::GetDisplayMode),
             R"#(Get current display mode.)#" 
          )
        .def("MeshTypesForMode",
             (const IVtk_IdTypeMap & (IVtkTools_DisplayModeFilter::*)( IVtk_DisplayMode  ) const) static_cast<const IVtk_IdTypeMap & (IVtkTools_DisplayModeFilter::*)( IVtk_DisplayMode  ) const>(&IVtkTools_DisplayModeFilter::MeshTypesForMode),
             R"#(Returns list of displaying mesh element types for the given display mode)#"  , py::arg("theMode")
          )
        .def("SetMeshTypesForMode",
             (void (IVtkTools_DisplayModeFilter::*)( IVtk_DisplayMode ,   const NCollection_Map<IVtk_IdType> &  ) ) static_cast<void (IVtkTools_DisplayModeFilter::*)( IVtk_DisplayMode ,   const NCollection_Map<IVtk_IdType> &  ) >(&IVtkTools_DisplayModeFilter::SetMeshTypesForMode),
             R"#(Set a list of displaying mesh element types for the given display mode)#"  , py::arg("theMode"),  py::arg("theMeshTypes")
          )
        .def("SetFaceBoundaryDraw",
             (void (IVtkTools_DisplayModeFilter::*)( bool  ) ) static_cast<void (IVtkTools_DisplayModeFilter::*)( bool  ) >(&IVtkTools_DisplayModeFilter::SetFaceBoundaryDraw),
             R"#(Draw Boundary of faces for shading mode)#"  , py::arg("theToDraw")
          )
        .def("FaceBoundaryDraw",
             (bool (IVtkTools_DisplayModeFilter::*)() const) static_cast<bool (IVtkTools_DisplayModeFilter::*)() const>(&IVtkTools_DisplayModeFilter::FaceBoundaryDraw),
             R"#(Returns True if drawing Boundary of faces for shading mode is defined.)#" 
          )
        .def("IsSmoothShading",
             (bool (IVtkTools_DisplayModeFilter::*)() const) static_cast<bool (IVtkTools_DisplayModeFilter::*)() const>(&IVtkTools_DisplayModeFilter::IsSmoothShading),
             R"#(Returns TRUE if vertex normals should be included for smooth shading within DM_Shading mode or not.)#" 
          )
        .def("SetSmoothShading",
             (void (IVtkTools_DisplayModeFilter::*)( bool  ) ) static_cast<void (IVtkTools_DisplayModeFilter::*)( bool  ) >(&IVtkTools_DisplayModeFilter::SetSmoothShading),
             R"#(Set if vertex normals should be included for smooth shading or not.)#"  , py::arg("theIsSmooth")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsTypeOf_s",
                    (vtkTypeBool (*)( const char *  ) ) static_cast<vtkTypeBool (*)( const char *  ) >(&IVtkTools_DisplayModeFilter::IsTypeOf),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("SafeDownCast_s",
                    (IVtkTools_DisplayModeFilter * (*)( vtkObjectBase *  ) ) static_cast<IVtkTools_DisplayModeFilter * (*)( vtkObjectBase *  ) >(&IVtkTools_DisplayModeFilter::SafeDownCast),
                    R"#(None)#"  , py::arg("o")
          )
        .def_static("GetNumberOfGenerationsFromBaseType_s",
                    (vtkIdType (*)( const char *  ) ) static_cast<vtkIdType (*)( const char *  ) >(&IVtkTools_DisplayModeFilter::GetNumberOfGenerationsFromBaseType),
                    R"#(None)#"  , py::arg("type")
          )
        .def_static("New_s",
                    (IVtkTools_DisplayModeFilter * (*)() ) static_cast<IVtkTools_DisplayModeFilter * (*)() >(&IVtkTools_DisplayModeFilter::New),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/IVtkTools.hxx
// ./opencascade/IVtkTools_DisplayModeFilter.hxx
// ./opencascade/IVtkTools_ShapeDataSource.hxx
// ./opencascade/IVtkTools_ShapeObject.hxx
// ./opencascade/IVtkTools_ShapePicker.hxx
// ./opencascade/IVtkTools_SubPolyDataFilter.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
