/* The file "parallel_cells.h" collects prototypes of those functions
 * common to mpi2cell_s and mpi2cell_d, the respective static and dynamic
 * distribution of mixed cells in the polyhedral continuation. */

void retrieve_dimensions ( int myid, int *nspt, int *dim );
/*
 * DESCRIPTION :
 *   The user is prompted for a mixed cell configuration,
 *   whose dimensions are broadcasted.
 *
 * ON ENTRY :
 *   myid     identification number of the node.
 *
 * ON RETURN :
 *   nspt     number of different supports;
 *   dim      dimension of the ambient space. */

void supports_broadcast ( int myid, int nspt, int dim );
/*
 * DESCRIPTION :
 *   The supports at the root node are broadcasted.
 *
 * ON ENTRY :
 *   myid     identification number of the node;
 *   nspt     number of different supports;
 *   dim      dimension of the lifted points. */

void system_broadcast ( int myid, int n );
/*
 * DESCRIPTION :
 *   The random coefficient system is generated by the root node
 *   and broadcasted to all nodes. 
 *
 * ON ENTRY :
 *   myid     identification number of the node;
 *   n        number of polynomials in the system. */
