            "#\n"
            "#  Copyright 2021 Northern.tech AS\n"
            "#\n"
            "#  This file is part of CFEngine 3 - written and maintained by Northern.tech AS.\n"
            "#\n"
            "#  This program is free software; you can redistribute it and/or modify it\n"
            "#  under the terms of the GNU General Public License as published by the\n"
            "#  Free Software Foundation; version 3.\n"
            "#\n"
            "#  This program is distributed in the hope that it will be useful,\n"
            "#  but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
            "#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
            "#  GNU General Public License for more details.\n"
            "#\n"
            "# You should have received a copy of the GNU General Public License\n"
            "# along with this program; if not, write to the Free Software\n"
            "# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA\n"
            "#\n"
            "# To the extent this program is licensed as part of the Enterprise\n"
            "# versions of CFEngine, the applicable Commercial Open Source License\n"
            "# (COSL) may apply to this file if you as a licensee so wish it. See\n"
            "# included file COSL.txt.\n"
            "\n"
            "########## CFEngine Bootstrap / Failsafe Policy ##############################\n"
            "# This file (failsafe.cf) is re-generated inside \"inputs\" directory every time\n"
            "# you bootstrap. This means that custom changes will be overwritten.\n"
            "#\n"
            "# The role of this standalone policy file is to fetch the main promises from\n"
            "# the policy hub for the first time when bootstrapping, and to recover the\n"
            "# system by fetching policies in case the standard agent run fails.\n"
            "##############################################################################\n"
            "\n"
            "body agent control\n"
            "{\n"
            "      # Bootstrapping can't continue without keys\n"
            "      abortclasses => { \"no_ppkeys_ABORT_kept\" };\n"
            "      # Make sure that running failsafe many times in a row does not\n"
            "      # change functionality\n"
            "      ifelapsed => \"0\";\n"
            "}\n"
            "\n"
            "################################################################################\n"
            "\n"
            "bundle agent main\n"
            "{\n"
            "  meta:\n"
            "\n"
            "      \"description\"\n"
            "        string => \"Perform bootstrap or failsafe recovery operations.\";\n"
            "\n"
            "  vars:\n"
            "      # In order to preserve the log level used during bootstrap we build the\n"
            "      # string to set log level on any direct sub-agent calls based on classes\n"
            "      # that are defined when the options are set.\n"
            "\n"
            "      #  --log-level, -g value - Specify how detailed logs should be.\n"
            "      # Possible values: 'error', 'warning', 'notice', 'info', 'verbose', 'debug'\n"
            "\n"
            "      \"log_level\"\n"
            "        string => ifelse(\"debug_mode\",   \"--log-level=debug\",\n"
            "                         \"verbose_mode\", \"--log-level=verbose\",\n"
            "                         \"info_mode\",    \"--log-level=info\",\n"
            "                         # CFE-4121 - Not yet implemented\n"
            "                         # \"notice_mode\",  \"--log-level=notice\",\n"
            "                         # \"warning_mode\", \"--log-level=warning\",\n"
            "                         # \"error_mode\",   \"--log-level=error\",\n"
            "                         \"\");\n"
            "\n"
            "  methods:\n"
            "\n"
            "      \"Check Keys\"\n"
            "        usebundle => failsafe_cfe_internal_checkkeys,\n"
            "        comment => \"Without a valid keypair we aren't going to be able\n"
            "                    to establish trust\";\n"
            "\n"
            "      \"Fetch Inputs\"\n"
            "        usebundle => failsafe_cfe_internal_update,\n"
            "        comment => \"We need to fetch policy from upstream if we are\n"
            "                    bootstrapping or if we are performing failsafe\n"
            "                    recovery.\";\n"
            "\n"
            "      \"Actuate Update Policy\"\n"
            "        usebundle => failsafe_cfe_internal_call_update,\n"
            "        comment => \"In order to speed up convergence and reporting we\n"
            "                    trigger the update policy right after initial\n"
            "                    bootstrap. This allows the first scheduled run to\n"
            "                    happen with the most up to date and complete\n"
            "                    information.\";\n"
            "\n"
            "      \"Trigger Policy\"\n"
            "        usebundle => failsafe_cfe_internal_trigger_policy,\n"
            "        comment => \"In order to speed up convergence and reporting we\n"
            "                    trigger the whole policy right after initial\n"
            "                    bootstrap. This allows the first report to provide\n"
            "                    more complete data.\";\n"
            "\n"
            "      \"Report\"\n"
            "        usebundle => failsafe_cfe_internal_report,\n"
            "        comment => \"It's important to let the user know what happened\n"
            "                    as the result of the bootstrap or failsafe\n"
            "                    operation.\";\n"
            "}\n"
            "\n"
            "bundle agent failsafe_cfe_internal_checkkeys\n"
            "{\n"
            "  classes:\n"
            "      \"have_ppkeys\"\n"
            "        expression => fileexists(\"$(sys.workdir)/ppkeys/localhost.pub\"),\n"
            "        handle     => \"failsafe_cfe_internal_bootstrap_checkkeys_classes_have_ppkeys\";\n"
            "\n"
            "  reports:\n"
            "    !have_ppkeys::\n"
            "      \"No public/private key pair is loaded, please create one by running \\\"cf-key\\\"\"\n"
            "        classes => failsafe_results(\"namespace\", \"no_ppkeys_ABORT\");\n"
            "}\n"
            "\n"
            "################################################################################\n"
            "\n"
            "bundle agent failsafe_cfe_internal_update\n"
            "{\n"
            "  vars:\n"
            "\n"
            "      # A policy server cannot use the shortcut feature to resolve\n"
            "      # masterfiles since cf-serverd is potentially not yet up and\n"
            "      # running.\n"
            "\n"
            "      # The unqualified path is used for non policy servers so that\n"
            "      # the policy server can use a shortcut to decide on behalf of\n"
            "      # the client which policy to serve by default. This is useful\n"
            "      # when running binaires from mixed sources (for example CFEngine\n"
            "      # produced binaries vs packages from the debian repository).\n"
            "\n"
            "      \"masterfiles_dir_remote\"\n"
            "        string => ifelse( \"policy_server\", $(sys.masterdir),\n"
            "                          \"masterfiles\" );\n"
            "\n"
            "  files:\n"
            "\n"
            "      \"$(sys.inputdir)\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_files_sys_workdir_inputs_shortcut\",\n"
            "        copy_from => failsafe_scp(\"$(masterfiles_dir_remote)\"),\n"
            "        depth_search => failsafe_u_infinite_client_policy,\n"
            "        file_select => failsafe_exclude_vcs_files,\n"
            "        classes => failsafe_results(\"namespace\", \"inputdir_update\");\n"
            "\n"
            "    !policy_server::\n"
            "\n"
            "      \"$(sys.workdir)/modules\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_files_sys_workdir_modules_shortcut\",\n"
            "        copy_from => failsafe_scp(\"modules\"),\n"
            "        depth_search => failsafe_recurse(\"inf\"),\n"
            "        file_select => failsafe_exclude_vcs_files,\n"
            "        classes => failsafe_results(\"namespace\", \"modulesdir_update\");\n"
            "\n"
            "    !windows.inputdir_update_error::\n"
            "\n"
            "      # When running on a *nix platform with homogeneous packages\n"
            "      # $(sys.masterdir) is a good guess. This is never the case for\n"
            "      # windows, and might be a poor guess if mixing packages from\n"
            "      # different sources (for example debian repositories and\n"
            "      # CFEngine produced packages).\n"
            "      \"$(sys.inputdir)\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_files_sys_workdir_inputs_not_windows\",\n"
            "        copy_from => failsafe_scp(\"$(sys.masterdir)\"),\n"
            "        depth_search => failsafe_recurse(\"inf\"),\n"
            "        file_select => failsafe_exclude_vcs_files,\n"
            "        classes => failsafe_results(\"namespace\", \"inputdir_update\"),\n"
            "        comment => \"If we failed to fetch policy we try again using\n"
            "                    the legacy default in case we are fetching policy\n"
            "                    from a hub that is not serving mastefiles via a\n"
            "                    shortcut.\";\n"
            "\n"
            "    windows.inputdir_update_error::\n"
            "\n"
            "      # Note: Windows can't use $(sys.masterdir) because no one runs a\n"
            "      # hub on windows and the copy_from needs the remote path.\n"
            "      \"$(sys.inputdir)\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_files_sys_workdir_inputs_windows\",\n"
            "        copy_from => failsafe_scp(\"/var/cfengine/masterfiles\"),\n"
            "        depth_search => failsafe_recurse(\"inf\"),\n"
            "        file_select => failsafe_exclude_vcs_files,\n"
            "        classes => failsafe_results(\"namespace\", \"inputdir_update\"),\n"
            "        comment => \"If we failed to fetch policy we try again using\n"
            "                    the legacy default in case we are fetching policy\n"
            "                    from a hub that is not serving mastefiles via a\n"
            "                    shortcut.\";\n"
            "\n"
            "    windows::\n"
            "\n"
            "      # TODO: Remove the use of bin-twin ref: Redmine #7364\n"
            "      \"$(sys.workdir)\\\\bin-twin\\\\.\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_files_sys_workdir_bin_twin_windows\",\n"
            "        copy_from => failsafe_cp(\"$(sys.workdir)\\\\bin\\\\.\"),\n"
            "        depth_search => failsafe_recurse(\"1\"),\n"
            "        file_select => failsafe_exclude_vcs_files,\n"
            "        comment => \"Make sure we maintain a clone of the binaries and\n"
            "                    libraries for updating\";\n"
            "\n"
            "\n"
            "  processes:\n"
            "\n"
            "      # TODO: Decide if this class guard is appropriate. Should we\n"
            "      # guard checking of cf-execd process running to when inputs are\n"
            "      # repaired\n"
            "    !windows.inputdir_update_repaired::\n"
            "\n"
            "      # We need to know when cf-execd is not running so that we can\n"
            "      # start it when necessary. Windows and systemd hosts uses the service\n"
            "      # manager instead of keying on individual processes.\n"
            "\n"
            "      \"cf-execd\" restart_class => \"cf_execd_not_running\",\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_processes_start_cf_execd\";\n"
            "\n"
            "    any::\n"
            "\n"
            "      # We need to know if cf-serverd isn't running so that we can\n"
            "      # start it when necessary.\n"
            "\n"
            "      \"cf-serverd\" restart_class => \"cf_serverd_not_running\",\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_processes_start_cf_serverd\";\n"
            "\n"
            "  commands:\n"
            "\n"
            "    cf_execd_not_running.!(windows|systemd|bootstrap_skip_services)::\n"
            "\n"
            "      # Windows and systemd do not launch cf-execd directly and are\n"
            "      # handeled separately.\n"
            "\n"
            "      \"$(sys.cf_execd)\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_commands_check_sys_cf_execd_start\",\n"
            "        classes => failsafe_results(\"namespace\", \"cf_execd_running\");\n"
            "\n"
            "    cf_serverd_not_running.!(windows|systemd|bootstrap_skip_services)::\n"
            "\n"
            "      # cf-serverd is not launched directly on Windows and systemd and is\n"
            "      # handled separately.\n"
            "\n"
            "      \"$(sys.cf_serverd)\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_commands_check_sys_cf_serverd_start\",\n"
            "        action => failsafe_ifwin_bg,\n"
            "        classes => failsafe_results(\"namespace\", \"cf_serverd_running\"),\n"
            "        comment => \"cf-serverd is needed on policy hubs or remote\n"
            "                    clients will not be able to get policy. Clients do\n"
            "                    not have a strong dependency on cf-serverd and if\n"
            "                    the component is necessay it is expected to be\n"
            "                    started by a separate policy.\";\n"
            "\n"
            "    cf_execd_not_running.systemd.!bootstrap_skip_services::\n"
            "\n"
            "      # We explicitly use \"restart\", because it is possible that cf-serverd\n"
            "      # is running, even if cf-execd isn't, for example. Here we want to be\n"
            "      # sure we relaunch everything.\n"
            "\n"
            "      \"/bin/systemctl restart cfengine3\" -> { \"CFE-1459\" }\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_commands_systemd_cfe_start\",\n"
            "        contain => bootstrap_command_silent,\n"
            "        classes => failsafe_results(\"namespace\", \"systemctl_restart_cfengine3\");\n"
            "\n"
            "  services:\n"
            "\n"
            "      # TODO: Is this restriction to only promise the service running\n"
            "      # when inputs are repaired appropriate? Perhaps it should always\n"
            "      # be checked.\n"
            "    windows.inputdir_update_repaired.!bootstrap_skip_services::\n"
            "\n"
            "      \"CfengineNovaExec\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_services_windows_executor\",\n"
            "        service_policy => \"start\",\n"
            "        service_method => failsafe_bootstart,\n"
            "        classes => failsafe_results(\"namespace\", \"cf_execd_running\");\n"
            "}\n"
            "\n"
            "################################################################################\n"
            "\n"
            "bundle agent failsafe_cfe_internal_report\n"
            "{\n"
            "  meta:\n"
            "\n"
            "      \"description\"\n"
            "        string => \"Report the outcome of the embedded\n"
            "                   bootstrap/failsafe operation.\";\n"
            "\n"
            "  classes:\n"
            "\n"
            "      # TODO: Determine if this is necessary and/or useful.  Pre-eval\n"
            "      # might resolve this before policy update occurs, and this is\n"
            "      # probably most useful after policy update has been attempted.\n"
            "\n"
            "      \"have_promises_cf\"\n"
            "        scope => \"bundle\",\n"
            "        expression => fileexists(\"$(sys.inputdir)/promises.cf\"),\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_classes_have_promises_cf\",\n"
            "        comment => \"We expect to find promises.cf after policy has\n"
            "                    been successfully copied from the policy\n"
            "                    server. If promises.cf is missing, then the\n"
            "                    bootstrap or failsafe recovery has likely\n"
            "                    failed.\";\n"
            "\n"
            "  reports:\n"
            "\n"
            "    !bootstrap_mode::\n"
            "\n"
            "      \"Built-in failsafe policy triggered\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_reports_failsafe_notification\",\n"
            "        comment => \"Be sure to inform the user that the failsafe policy has\n"
            "                    been triggered. This typically indicates that the agent has\n"
            "                    received broken policy. It may also indicate legacy\n"
            "                    configuration in body executor control.\";\n"
            "\n"
            "    bootstrap_mode::\n"
            "\n"
            "      \"Bootstrapping from host '$(sys.policy_hub)' via built-in policy '$(this.promise_filename)'\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_update_reports_bootstrap_notification\",\n"
            "        comment => \"Be sure to inform the user that they have triggerd a bootstrap.\";\n"
            "\n"
            "    bootstrap_mode.policy_server::\n"
            "\n"
            "      \"This host assumes the role of policy server\"\n"
            "      handle => \"failsafe_cfe_internal_bootstrap_update_reports_assume_policy_hub\";\n"
            "\n"
            "    bootstrap_mode.!policy_server::\n"
            "\n"
            "      \"This autonomous node assumes the role of voluntary client\"\n"
            "      handle => \"failsafe_cfe_internal_bootstrap_update_reports_assume_voluntary_client\";\n"
            "\n"
            "    inputdir_update_repaired::\n"
            "\n"
            "      \"Updated local policy from policy server\"\n"
            "      handle => \"failsafe_cfe_internal_bootstrap_update_reports_inputdir_update_repaired\";\n"
            "\n"
            "\n"
            "    inputdir_update_repaired.!have_promises_cf::\n"
            "\n"
            "      # We used to display this report when we have fetched new\n"
            "      # policy, but still can not find promises.cf in\n"
            "      # sys.inputdir. However if the hub being bootstrapped to is down\n"
            "      # we may never repair inputs and this may not be triggered\n"
            "      #\n"
            "      # TODO: Come up with better conditions. These seem weak.\n"
            "      #  - Potentially use returnszero() with cf-promises?\n"
            "\n"
            "      \"Failed to copy policy from policy server at $(sys.policy_hub):$(sys.masterdir)\n"
            "       Please check\n"
            "       * cf-serverd is running on $(sys.policy_hub)\n"
            "       * CFEngine version on the policy hub is 3.6.0 or latest - otherwise you need to tweak the protocol_version setting\n"
            "       * network connectivity to $(sys.policy_hub) on port $(sys.policy_hub_port)\n"
            "       * masterfiles 'body server control' - in particular allowconnects, trustkeysfrom and skipverify\n"
            "       * masterfiles 'bundle server' -> access: -> masterfiles -> admit/deny\n"
            "       It is often useful to restart cf-serverd in verbose mode (cf-serverd -v) on $(sys.policy_hub) to diagnose connection issues.\n"
            "       When updating masterfiles, wait (usually 5 minutes) for files to propagate to inputs on $(sys.policy_hub) before retrying.\"\n"
            "      handle => \"failsafe_cfe_internal_bootstrap_update_reports_did_not_get_policy\";\n"
            "\n"
            "    trigger_policy_repaired::\n"
            "      \"Triggered an initial run of the policy\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_trigger_policy_passed\";\n"
            "\n"
            "    trigger_policy_failed::\n"
            "      \"Initial run of the policy failed\"\n"
            "        handle => \"failsafe_cfe_internal_bootstrap_trigger_policy_failed\";\n"
            "\n"
            "    systemctl_restart_cfengine3_repaired::\n"
            "\n"
            "      \"Restarted systemd unit cfengine3\"\n"
            "        handle => \"failsafe_cfe_intrnal_bootstrap_update_reports_systemd_unit_restarted\";\n"
            "\n"
            "    systemctl_restart_cfengine3_error::\n"
            "\n"
            "      \"Error restarting systemd unit cfengine3\"\n"
            "        handle => \"failsafe_cfe_intrnal_bootstrap_update_reports_systemd_unit_restarted\";\n"
            "\n"
            "    cf_serverd_running_repaired::\n"
            "\n"
            "      \"Started the server\"\n"
            "      handle => \"failsafe_cfe_internal_bootstrap_update_reports_started_serverd\";\n"
            "\n"
            "    cf_serverd_running_failed::\n"
            "\n"
            "      \"Failed to start the server\"\n"
            "      handle => \"failsafe_cfe_internal_bootstrap_update_reports_failed_to_start_serverd\";\n"
            "\n"
            "    cf_execd_running_repaired::\n"
            "\n"
            "      \"Started the scheduler\"\n"
            "      handle => \"failsafe_cfe_internal_bootstrap_update_reports_started_execd\";\n"
            "\n"
            "    cf_execd_running_failed::\n"
            "\n"
            "      \"Failed to start the scheduler\"\n"
            "      handle => \"failsafe_cfe_internal_bootstrap_update_reports_failed_to_start_execd\";\n"
            "}\n"
            "\n"
            "################################################################################\n"
            "\n"
            "bundle agent failsafe_cfe_internal_call_update\n"
            "{\n"
            "  vars:\n"
            "\n"
            "    \"mode\" string => ifelse(\"bootstrap_mode\", \"bootstrap_mode\", \"failsafe_mode\");\n"
            "\n"
            "  commands:\n"
            "\n"
            "    # On Windows we need cf-execd to call update.cf, otherwise the daemons will\n"
            "    # not run under the SYSTEM account.\n"
            "    !windows.!skip_policy_on_bootstrap::\n"
            "      \"$(sys.cf_agent) -f $(sys.update_policy_path) --define $(mode) $(main.log_level)\"\n"
            "        handle => \"failsafe_cfe_internal_call_update_commands_call_update_cf\",\n"
            "        if => fileexists( $(sys.update_policy_path) ),\n"
            "        comment => \"We run update.cf in order to prepare system information for\n"
            "                    collection into CFEngine Enterprise more quickly.\";\n"
            "}\n"
            "\n"
            "################################################################################\n"
            "\n"
            "bundle agent failsafe_cfe_internal_trigger_policy\n"
            "{\n"
            "  commands:\n"
            "\n"
            "    bootstrap_mode.!skip_policy_on_bootstrap::\n"
            "      \"$(sys.cf_agent) --define bootstrap_mode $(main.log_level)\"\n"
            "        handle => \"failsafe_cfe_internal_trigger_policy_commands_call_promises_cf\",\n"
            "        if => fileexists( $(sys.default_policy_path) ),\n"
            "        classes => failsafe_results(\"namespace\", \"trigger_policy\"),\n"
            "        comment => \"We run promises.cf in order to prepare system information for\n"
            "                    collection into CFEngine Enterprise more quickly.\";\n"
            "}\n"
            "\n"
            "############################################\n"
            "body copy_from failsafe_scp(from)\n"
            "{\n"
            "      source      => \"$(from)\";\n"
            "      compare     => \"digest\";\n"
            "    # This class is always set when bootstrapping. You can deactivate\n"
            "    # this class with --trust-server=no when bootstrapping\n"
            "    trust_server::\n"
            "      trustkey    => \"true\";\n"
            "    !policy_server::\n"
            "      servers => { \"$(sys.policy_hub)\" };\n"
            "      portnumber => \"$(sys.policy_hub_port)\";\n"
            "}\n"
            "############################################\n"
            "body depth_search failsafe_u_infinite_client_policy\n"
            "# @brief Search recursively for files excluding vcs related files and .no-distrib directories\n"
            "# @param d Maximum depth to search recursively\n"
            "# Duplicated in update policy\n"
            "{\n"
            "        depth => \"inf\";\n"
            "        exclude_dirs => { \"\\.svn\", \"\\.git\", \"git-core\", \"\\.no-distrib\" };\n"
            "}\n"
            "############################################\n"
            "body depth_search failsafe_recurse(d)\n"
            "{\n"
            "      depth => \"$(d)\";\n"
            "      exclude_dirs => { \"\\.svn\", \"\\.git\" };\n"
            "}\n"
            "############################################\n"
            "body file_select failsafe_exclude_vcs_files\n"
            "{\n"
            "      leaf_name => { \"\\.git.*\", \"\\.mailmap\" };\n"
            "      file_result => \"!leaf_name\";\n"
            "}\n"
            "############################################\n"
            "body service_method failsafe_bootstart\n"
            "{\n"
            "      service_autostart_policy => \"boot_time\";\n"
            "}\n"
            "############################################\n"
            "body action failsafe_ifwin_bg\n"
            "{\n"
            "    windows::\n"
            "      background => \"true\";\n"
            "}\n"
            "############################################\n"
            "body copy_from failsafe_cp(from)\n"
            "{\n"
            "      source          => \"$(from)\";\n"
            "      compare         => \"digest\";\n"
            "      copy_backup     => \"false\";\n"
            "}\n"
            "\n"
            "############################################\n"
            "body classes failsafe_results(scope, class_prefix)\n"
            "# @brief Define classes prefixed with `class_prefix` and suffixed with\n"
            "# appropriate outcomes: _kept, _repaired, _not_kept, _error, _failed,\n"
            "# _denied, _timeout, _reached\n"
            "#\n"
            "# @param scope The scope in which the class should be defined (`bundle` or `namespace`)\n"
            "# @param class_prefix The prefix for the classes defined\n"
            "{\n"
            "  scope => \"$(scope)\";\n"
            "\n"
            "  promise_kept => { \"$(class_prefix)_reached\",\n"
            "                    \"$(class_prefix)_kept\" };\n"
            "\n"
            "  promise_repaired => { \"$(class_prefix)_reached\",\n"
            "                        \"$(class_prefix)_repaired\" };\n"
            "\n"
            "  repair_failed => { \"$(class_prefix)_reached\",\n"
            "                     \"$(class_prefix)_error\",\n"
            "                     \"$(class_prefix)_not_kept\",\n"
            "                     \"$(class_prefix)_failed\" };\n"
            "\n"
            "  repair_denied => { \"$(class_prefix)_reached\",\n"
            "                     \"$(class_prefix)_error\",\n"
            "                     \"$(class_prefix)_not_kept\",\n"
            "                     \"$(class_prefix)_denied\" };\n"
            "\n"
            "  repair_timeout => { \"$(class_prefix)_reached\",\n"
            "                      \"$(class_prefix)_error\",\n"
            "                      \"$(class_prefix)_not_kept\",\n"
            "                      \"$(class_prefix)_timeout\" };\n"
            "}\n"
            "\n"
            "body contain bootstrap_command_silent\n"
            "# @brief Suppress command output\n"
            "{\n"
            "      no_output => \"true\";\n"
            "}\n"
