require_relative '../../spec_helper'
require 'strscan'

describe "StringScanner#initialize" do
  before :each do
    @s = StringScanner.new("This is a test")
  end

  it "is a private method" do
    StringScanner.should have_private_instance_method(:initialize)
  end

  it "returns an instance of StringScanner" do
    @s.should be_kind_of(StringScanner)
    @s.eos?.should be_false
  end

  it "converts the argument into a string using #to_str" do
    m = mock(:str)

    s = "test"
    m.should_receive(:to_str).and_return(s)

    scan = StringScanner.new(m)
    scan.string.should == s
  end

  it "accepts a fixed_anchor keyword argument" do
    s = StringScanner.new("foo", fixed_anchor: true)
    s.should.fixed_anchor?
  end
end
