#!/bin/bash

domain=mysql-dba
for s in agency biz club co eu info life live me net online org rocks site space tech uk website world work xyz; do
	cat ss-static.tmpl | sed -e "s/#dom#/$domain.$s/g" > $domain.$s.conf
	certbot certonly --rsa-key-size 4096 --webroot --webroot-path /var/www/pki --keep-until-expiring -d $domain.$s
done

domain=mysql-expert
for s in agency biz club co co.uk guru info live me net online org pro shop site store today xyz; do
	cat ss-static.tmpl | sed -e "s/#dom#/$domain.$s/g" > $domain.$s.conf
	certbot certonly --rsa-key-size 4096 --webroot --webroot-path /var/www/pki --keep-until-expiring -d $domain.$s
done

domain=mysql-tuning
for s in agency biz club co com info life live me net online org site xyz; do
	cat ss-static.tmpl | sed -e "s/#dom#/$domain.$s/g" > $domain.$s.conf
	certbot certonly --rsa-key-size 4096 --webroot --webroot-path /var/www/pki --keep-until-expiring -d $domain.$s
done

# DO NOT add .net and .co.uk!
domain=shatteredsilicon
for s in agency biz cloud club co com info life live ltd me online org shop site today website work world xyz; do
	cat ss-static.tmpl | sed -e "s/#dom#/$domain.$s/g" > $domain.$s.conf
	certbot certonly --rsa-key-size 4096 --webroot --webroot-path /var/www/pki --keep-until-expiring -d $domain.$s
done

