/*
   This file is part of TALER
   Copyright (C) 2023 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file auditordb/pg_select_pending_deposits.h
 * @brief implementation of the select_pending_deposits function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_SELECT_PENDING_DEPOSITS_H
#define PG_SELECT_PENDING_DEPOSITS_H

#include "taler/taler_util.h"
#include "taler/taler_json_lib.h"
#include "taler/taler_auditordb_plugin.h"


/**
 * Return (batch) deposits for which we have not yet
 * seen the required wire transfer.
 *
 * @param cls closure
 * @param deadline only return up to this deadline
 * @param limit number of rows to return, negative to iterate backwards
 * @param offset starting offset, exclusive
 * @param return_suppressed true to also return suppressed events
 * @param cb function to call on each entry
 * @param cb_cls closure for @a cb
 * @return transaction status code
 */
enum GNUNET_DB_QueryStatus
TAH_PG_select_pending_deposits (
  void *cls,
  struct GNUNET_TIME_Absolute deadline,
  int64_t limit,
  uint64_t offset,
  bool return_suppressed,
  TALER_AUDITORDB_WireMissingCallback cb,
  void *cb_cls);

#endif
