/************************************************************************
 *
 * Copyright (C) 2009-2023 IRCAD France
 * Copyright (C) 2012-2015 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#pragma once

#include <data/transfer_function.hpp>

#include <cppunit/extensions/HelperMacros.h>

namespace sight::io::vtk::ut
{

/**
 * @brief Test few methods to create transfer function for VTK.
 */
class transfer_function_test : public CPPUNIT_NS::TestFixture
{
CPPUNIT_TEST_SUITE(transfer_function_test);
CPPUNIT_TEST(to_vtk_lookup_table_test);
CPPUNIT_TEST(to_bw_vtk_lookup_table_test);
CPPUNIT_TEST_SUITE_END();

public:

    // interface
    void setUp() override;
    void tearDown() override;

    void to_vtk_lookup_table_test();
    static void to_bw_vtk_lookup_table_test();

private:

    static data::transfer_function::sptr create_tf_color();
};

} // namespace sight::io::vtk::ut
