% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-constructor.R
\name{make_constructor}
\alias{make_constructor}
\alias{make_constructor.Geom}
\alias{make_constructor.Stat}
\title{Produce boilerplate constructors}
\usage{
make_constructor(x, ...)

\method{make_constructor}{Geom}(
  x,
  ...,
  checks = exprs(),
  omit = character(),
  env = caller_env()
)

\method{make_constructor}{Stat}(
  x,
  ...,
  checks = exprs(),
  omit = character(),
  env = caller_env()
)
}
\arguments{
\item{x}{An object to setup a constructor for.}

\item{...}{Name-value pairs to use as additional arguments in the
constructor. For layers, these are passed on to \code{\link[=layer]{layer(params)}}.}

\item{checks}{A list of calls to be evaluated before construction of the
object, such as one constructed with \code{\link[rlang:defusing-advanced]{exprs()}}.}

\item{omit}{A character vector of automatically retrieved argument names
that should not be converted to user-facing arguments. Useful for
internally computed variables.}

\item{env}{An environment to search for the object.}
}
\value{
A function
}
\description{
The \code{make_constructor()} functions sets up a user-facing constructor for
ggproto classes. Currently, \code{make_constructor()} is implemented for
\code{Geom} classes.
}
\examples{
# For testing purposes, a geom that returns grobs
GeomTest <- ggproto(
  "GeomTest", Geom,
  draw_group = function(..., grob = grid::pointsGrob()) {
    return(grob)
  }
)
# Creating a constructor
geom_test <- make_constructor(GeomTest)

# Note that `grob` is automatically an argument to the function
names(formals(geom_test))

# Use in a plot
set.seed(1234)
p <- ggplot(mtcars, aes(disp, mpg))
p + geom_test()
p + geom_test(grob = grid::circleGrob())

# The `checks` argument can be used to evaluate arbitrary expressions in
# the constructor before building the layer.
geom_path2 <- make_constructor(
  GeomPath, checks = rlang::exprs(
    match.arg(lineend, c("butt", "round", "square")),
    match.arg(linejoin, c("round", "mitre", "bevel"))
  )
)

# Note the inclusion of the expressions
print(geom_path2)

# Argument mismatch is detected
try(geom_path2(linejoin = "foo"))
}
\keyword{internal}
