# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=wrong-import-position

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ._patch import *  # pylint: disable=unused-wildcard-import


from ._models import (  # type: ignore
    DetectedLanguage,
    ErrorDetails,
    ErrorResponse,
    GetSupportedLanguagesResult,
    InputTextItem,
    LanguageScript,
    ReferenceTextPair,
    TranslateBody,
    TranslateInputItem,
    TranslatedTextItem,
    TranslationLanguage,
    TranslationResult,
    TranslationTarget,
    TranslationText,
    TransliterableScript,
    TransliterateBody,
    TransliterateResult,
    TransliteratedText,
    TransliterationLanguage,
)

from ._enums import (  # type: ignore
    LanguageDirectionality,
    ProfanityAction,
    ProfanityMarker,
    TextType,
)
from ._patch import __all__ as _patch_all
from ._patch import *
from ._patch import patch_sdk as _patch_sdk

__all__ = [
    "DetectedLanguage",
    "ErrorDetails",
    "ErrorResponse",
    "GetSupportedLanguagesResult",
    "InputTextItem",
    "LanguageScript",
    "ReferenceTextPair",
    "TranslateBody",
    "TranslateInputItem",
    "TranslatedTextItem",
    "TranslationLanguage",
    "TranslationResult",
    "TranslationTarget",
    "TranslationText",
    "TransliterableScript",
    "TransliterateBody",
    "TransliterateResult",
    "TransliteratedText",
    "TransliterationLanguage",
    "LanguageDirectionality",
    "ProfanityAction",
    "ProfanityMarker",
    "TextType",
]
__all__.extend([p for p in _patch_all if p not in __all__])  # pyright: ignore
_patch_sdk()
