# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import ResourcePredictionsProfileType

if TYPE_CHECKING:
    from .. import models as _models


class AgentProfile(_model_base.Model):
    """The agent profile of the machines in the pool.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Stateful, StatelessAgentProfile


    :ivar kind: Discriminator property for AgentProfile. Required. Default value is None.
    :vartype kind: str
    :ivar resource_predictions: Defines pool buffer/stand-by agents.
    :vartype resource_predictions: ~azure.mgmt.devopsinfrastructure.models.ResourcePredictions
    :ivar resource_predictions_profile: Defines how the pool buffer/stand-by agents is provided.
    :vartype resource_predictions_profile:
     ~azure.mgmt.devopsinfrastructure.models.ResourcePredictionsProfile
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Discriminator property for AgentProfile. Required. Default value is None."""
    resource_predictions: Optional["_models.ResourcePredictions"] = rest_field(name="resourcePredictions")
    """Defines pool buffer/stand-by agents."""
    resource_predictions_profile: Optional["_models.ResourcePredictionsProfile"] = rest_field(
        name="resourcePredictionsProfile"
    )
    """Defines how the pool buffer/stand-by agents is provided."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        resource_predictions: Optional["_models.ResourcePredictions"] = None,
        resource_predictions_profile: Optional["_models.ResourcePredictionsProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourcePredictionsProfile(_model_base.Model):
    """Determines how the stand-by scheme should be provided.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutomaticResourcePredictionsProfile, ManualResourcePredictionsProfile


    :ivar kind: Determines how the stand-by scheme should be provided. Required. Known values are:
     "Manual" and "Automatic".
    :vartype kind: str or ~azure.mgmt.devopsinfrastructure.models.ResourcePredictionsProfileType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Determines how the stand-by scheme should be provided. Required. Known values are: \"Manual\"
     and \"Automatic\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AutomaticResourcePredictionsProfile(ResourcePredictionsProfile, discriminator="Automatic"):
    """The stand-by agent scheme is determined based on historical demand.


    :ivar kind: The stand-by agent scheme is determined based on historical demand. Required. The
     stand-by agent scheme is determined based on historical demand.
    :vartype kind: str or ~azure.mgmt.devopsinfrastructure.models.AUTOMATIC
    :ivar prediction_preference: Determines the balance between cost and performance. Known values
     are: "Balanced", "MostCostEffective", "MoreCostEffective", "MorePerformance", and
     "BestPerformance".
    :vartype prediction_preference: str or
     ~azure.mgmt.devopsinfrastructure.models.PredictionPreference
    """

    kind: Literal[ResourcePredictionsProfileType.AUTOMATIC] = rest_discriminator(name="kind")  # type: ignore
    """The stand-by agent scheme is determined based on historical demand. Required. The stand-by
     agent scheme is determined based on historical demand."""
    prediction_preference: Optional[Union[str, "_models.PredictionPreference"]] = rest_field(
        name="predictionPreference"
    )
    """Determines the balance between cost and performance. Known values are: \"Balanced\",
     \"MostCostEffective\", \"MoreCostEffective\", \"MorePerformance\", and \"BestPerformance\"."""

    @overload
    def __init__(
        self,
        *,
        prediction_preference: Optional[Union[str, "_models.PredictionPreference"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=ResourcePredictionsProfileType.AUTOMATIC, **kwargs)


class OrganizationProfile(_model_base.Model):
    """Defines the organization in which the pool will be used.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureDevOpsOrganizationProfile, GitHubOrganizationProfile


    :ivar kind: Discriminator property for OrganizationProfile. Required. Default value is None.
    :vartype kind: str
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Discriminator property for OrganizationProfile. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AzureDevOpsOrganizationProfile(OrganizationProfile, discriminator="AzureDevOps"):
    """Azure DevOps organization profile.


    :ivar kind: Azure DevOps organization profile. Required. Default value is "AzureDevOps".
    :vartype kind: str
    :ivar organizations: The list of Azure DevOps organizations the pool should be present in.
     Required.
    :vartype organizations: list[~azure.mgmt.devopsinfrastructure.models.Organization]
    :ivar permission_profile: The type of permission which determines which accounts are admins on
     the Azure DevOps pool.
    :vartype permission_profile:
     ~azure.mgmt.devopsinfrastructure.models.AzureDevOpsPermissionProfile
    """

    kind: Literal["AzureDevOps"] = rest_discriminator(name="kind")  # type: ignore
    """Azure DevOps organization profile. Required. Default value is \"AzureDevOps\"."""
    organizations: List["_models.Organization"] = rest_field()
    """The list of Azure DevOps organizations the pool should be present in. Required."""
    permission_profile: Optional["_models.AzureDevOpsPermissionProfile"] = rest_field(name="permissionProfile")
    """The type of permission which determines which accounts are admins on the Azure DevOps pool."""

    @overload
    def __init__(
        self,
        *,
        organizations: List["_models.Organization"],
        permission_profile: Optional["_models.AzureDevOpsPermissionProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind="AzureDevOps", **kwargs)


class AzureDevOpsPermissionProfile(_model_base.Model):
    """Defines the type of Azure DevOps pool permission.


    :ivar kind: Determines who has admin permissions to the Azure DevOps pool. Required. Known
     values are: "Inherit", "CreatorOnly", and "SpecificAccounts".
    :vartype kind: str or ~azure.mgmt.devopsinfrastructure.models.AzureDevOpsPermissionType
    :ivar users: User email addresses.
    :vartype users: list[str]
    :ivar groups: Group email addresses.
    :vartype groups: list[str]
    """

    kind: Union[str, "_models.AzureDevOpsPermissionType"] = rest_field()
    """Determines who has admin permissions to the Azure DevOps pool. Required. Known values are:
     \"Inherit\", \"CreatorOnly\", and \"SpecificAccounts\"."""
    users: Optional[List[str]] = rest_field()
    """User email addresses."""
    groups: Optional[List[str]] = rest_field()
    """Group email addresses."""

    @overload
    def __init__(
        self,
        *,
        kind: Union[str, "_models.AzureDevOpsPermissionType"],
        users: Optional[List[str]] = None,
        groups: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DataDisk(_model_base.Model):
    """The data disk of the VMSS.

    :ivar caching: The type of caching to be enabled for the data disks. The default value for
     caching is readwrite. For information about the caching options see:
     https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.devopsinfrastructure.models.CachingType
    :ivar disk_size_gi_b: The initial disk size in gigabytes.
    :vartype disk_size_gi_b: int
    :ivar storage_account_type: The storage Account type to be used for the data disk. If omitted,
     the default is "standard_lrs". Known values are: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS", "Premium_ZRS", and "StandardSSD_ZRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.devopsinfrastructure.models.StorageAccountType
    :ivar drive_letter: The drive letter for the empty data disk. If not specified, it will be the
     first available letter.
    :vartype drive_letter: str
    """

    caching: Optional[Union[str, "_models.CachingType"]] = rest_field()
    """The type of caching to be enabled for the data disks. The default value for caching is
     readwrite. For information about the caching options see:
     https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     Known values are: \"None\", \"ReadOnly\", and \"ReadWrite\"."""
    disk_size_gi_b: Optional[int] = rest_field(name="diskSizeGiB")
    """The initial disk size in gigabytes."""
    storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = rest_field(name="storageAccountType")
    """The storage Account type to be used for the data disk. If omitted, the default is
     \"standard_lrs\". Known values are: \"Standard_LRS\", \"Premium_LRS\", \"StandardSSD_LRS\",
     \"Premium_ZRS\", and \"StandardSSD_ZRS\"."""
    drive_letter: Optional[str] = rest_field(name="driveLetter")
    """The drive letter for the empty data disk. If not specified, it will be the first available
     letter."""

    @overload
    def __init__(
        self,
        *,
        caching: Optional[Union[str, "_models.CachingType"]] = None,
        disk_size_gi_b: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        drive_letter: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DevOpsAzureSku(_model_base.Model):
    """The Azure SKU of the machines in the pool.


    :ivar name: The Azure SKU name of the machines in the pool. Required.
    :vartype name: str
    """

    name: str = rest_field()
    """The Azure SKU name of the machines in the pool. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.devopsinfrastructure.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.devopsinfrastructure.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.devopsinfrastructure.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FabricProfile(_model_base.Model):
    """Defines the type of fabric the agent will run on.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VmssFabricProfile


    :ivar kind: Discriminator property for FabricProfile. Required. Default value is None.
    :vartype kind: str
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Discriminator property for FabricProfile. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GitHubOrganization(_model_base.Model):
    """Defines a GitHub organization.


    :ivar url: The GitHub organization URL in which the pool should be created. Required.
    :vartype url: str
    :ivar repositories: Optional list of repositories in which the pool should be created.
    :vartype repositories: list[str]
    """

    url: str = rest_field()
    """The GitHub organization URL in which the pool should be created. Required."""
    repositories: Optional[List[str]] = rest_field()
    """Optional list of repositories in which the pool should be created."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        repositories: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GitHubOrganizationProfile(OrganizationProfile, discriminator="GitHub"):
    """GitHub organization profile.


    :ivar kind: GitHub organization profile. Required. Default value is "GitHub".
    :vartype kind: str
    :ivar organizations: The list of GitHub organizations/repositories the pool should be present
     in. Required.
    :vartype organizations: list[~azure.mgmt.devopsinfrastructure.models.GitHubOrganization]
    """

    kind: Literal["GitHub"] = rest_discriminator(name="kind")  # type: ignore
    """GitHub organization profile. Required. Default value is \"GitHub\"."""
    organizations: List["_models.GitHubOrganization"] = rest_field()
    """The list of GitHub organizations/repositories the pool should be present in. Required."""

    @overload
    def __init__(
        self,
        *,
        organizations: List["_models.GitHubOrganization"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind="GitHub", **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devopsinfrastructure.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devopsinfrastructure.models.SystemData
    """


class ImageVersion(ProxyResource):
    """An image version object.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devopsinfrastructure.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.devopsinfrastructure.models.ImageVersionProperties
    """

    properties: Optional["_models.ImageVersionProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ImageVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ImageVersionProperties(_model_base.Model):
    """Details of the ImageVersionProperties.


    :ivar version: Version of the image. Required.
    :vartype version: str
    """

    version: str = rest_field()
    """Version of the image. Required."""

    @overload
    def __init__(
        self,
        *,
        version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_model_base.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.devopsinfrastructure.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.devopsinfrastructure.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field()
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities"
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ManualResourcePredictionsProfile(ResourcePredictionsProfile, discriminator="Manual"):
    """Customer provides the stand-by agent scheme.


    :ivar kind: Customer provides the stand-by agent scheme. Required. Customer provides the
     stand-by agent scheme.
    :vartype kind: str or ~azure.mgmt.devopsinfrastructure.models.MANUAL
    """

    kind: Literal[ResourcePredictionsProfileType.MANUAL] = rest_discriminator(name="kind")  # type: ignore
    """Customer provides the stand-by agent scheme. Required. Customer provides the stand-by agent
     scheme."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=ResourcePredictionsProfileType.MANUAL, **kwargs)


class NetworkProfile(_model_base.Model):
    """The network profile of the machines in the pool.


    :ivar subnet_id: The subnet id on which to put all machines created in the pool. Required.
    :vartype subnet_id: str
    """

    subnet_id: str = rest_field(name="subnetId")
    """The subnet id on which to put all machines created in the pool. Required."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.devopsinfrastructure.models._models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.devopsinfrastructure.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.devopsinfrastructure.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models._models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models._enums.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models._enums.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class Organization(_model_base.Model):
    """Defines an Azure DevOps organization.


    :ivar url: The Azure DevOps organization URL in which the pool should be created. Required.
    :vartype url: str
    :ivar projects: Optional list of projects in which the pool should be created.
    :vartype projects: list[str]
    :ivar parallelism: How many machines can be created at maximum in this organization out of the
     maximumConcurrency of the pool.
    :vartype parallelism: int
    """

    url: str = rest_field()
    """The Azure DevOps organization URL in which the pool should be created. Required."""
    projects: Optional[List[str]] = rest_field()
    """Optional list of projects in which the pool should be created."""
    parallelism: Optional[int] = rest_field()
    """How many machines can be created at maximum in this organization out of the maximumConcurrency
     of the pool."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        projects: Optional[List[str]] = None,
        parallelism: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OsProfile(_model_base.Model):
    """The OS profile of the machines in the pool.

    :ivar secrets_management_settings: The secret management settings of the machines in the pool.
    :vartype secrets_management_settings:
     ~azure.mgmt.devopsinfrastructure.models.SecretsManagementSettings
    :ivar logon_type: Determines how the service should be run. By default, this will be set to
     Service. Known values are: "Service" and "Interactive".
    :vartype logon_type: str or ~azure.mgmt.devopsinfrastructure.models.LogonType
    """

    secrets_management_settings: Optional["_models.SecretsManagementSettings"] = rest_field(
        name="secretsManagementSettings"
    )
    """The secret management settings of the machines in the pool."""
    logon_type: Optional[Union[str, "_models.LogonType"]] = rest_field(name="logonType")
    """Determines how the service should be run. By default, this will be set to Service. Known values
     are: \"Service\" and \"Interactive\"."""

    @overload
    def __init__(
        self,
        *,
        secrets_management_settings: Optional["_models.SecretsManagementSettings"] = None,
        logon_type: Optional[Union[str, "_models.LogonType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devopsinfrastructure.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Pool(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devopsinfrastructure.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.devopsinfrastructure.models.PoolProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.devopsinfrastructure.models.ManagedServiceIdentity
    """

    properties: Optional["_models.PoolProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field()
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.PoolProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PoolImage(_model_base.Model):
    """The VM image of the machines in the pool.

    :ivar resource_id: The resource id of the image.
    :vartype resource_id: str
    :ivar well_known_image_name: The image to use from a well-known set of images made available to
     customers.
    :vartype well_known_image_name: str
    :ivar aliases: List of aliases to reference the image by.
    :vartype aliases: list[str]
    :ivar buffer: The percentage of the buffer to be allocated to this image.
    :vartype buffer: str
    """

    resource_id: Optional[str] = rest_field(name="resourceId")
    """The resource id of the image."""
    well_known_image_name: Optional[str] = rest_field(name="wellKnownImageName")
    """The image to use from a well-known set of images made available to customers."""
    aliases: Optional[List[str]] = rest_field()
    """List of aliases to reference the image by."""
    buffer: Optional[str] = rest_field()
    """The percentage of the buffer to be allocated to this image."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        well_known_image_name: Optional[str] = None,
        aliases: Optional[List[str]] = None,
        buffer: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PoolProperties(_model_base.Model):
    """Pool properties.


    :ivar provisioning_state: The status of the current operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.devopsinfrastructure.models.ProvisioningState
    :ivar maximum_concurrency: Defines how many resources can there be created at any given time.
     Required.
    :vartype maximum_concurrency: int
    :ivar organization_profile: Defines the organization in which the pool will be used. Required.
    :vartype organization_profile: ~azure.mgmt.devopsinfrastructure.models.OrganizationProfile
    :ivar agent_profile: Defines how the machine will be handled once it executed a job. Required.
    :vartype agent_profile: ~azure.mgmt.devopsinfrastructure.models.AgentProfile
    :ivar fabric_profile: Defines the type of fabric the agent will run on. Required.
    :vartype fabric_profile: ~azure.mgmt.devopsinfrastructure.models.FabricProfile
    :ivar dev_center_project_resource_id: The resource id of the DevCenter Project the pool belongs
     to. Required.
    :vartype dev_center_project_resource_id: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(name="provisioningState")
    """The status of the current operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""
    maximum_concurrency: int = rest_field(name="maximumConcurrency")
    """Defines how many resources can there be created at any given time. Required."""
    organization_profile: "_models.OrganizationProfile" = rest_field(name="organizationProfile")
    """Defines the organization in which the pool will be used. Required."""
    agent_profile: "_models.AgentProfile" = rest_field(name="agentProfile")
    """Defines how the machine will be handled once it executed a job. Required."""
    fabric_profile: "_models.FabricProfile" = rest_field(name="fabricProfile")
    """Defines the type of fabric the agent will run on. Required."""
    dev_center_project_resource_id: str = rest_field(name="devCenterProjectResourceId")
    """The resource id of the DevCenter Project the pool belongs to. Required."""

    @overload
    def __init__(
        self,
        *,
        maximum_concurrency: int,
        organization_profile: "_models.OrganizationProfile",
        agent_profile: "_models.AgentProfile",
        fabric_profile: "_models.FabricProfile",
        dev_center_project_resource_id: str,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PoolUpdate(_model_base.Model):
    """The type used for update operations of the Pool.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.devopsinfrastructure.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.devopsinfrastructure.models.PoolUpdateProperties
    """

    identity: Optional["_models.ManagedServiceIdentity"] = rest_field()
    """The managed service identities assigned to this resource."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    properties: Optional["_models.PoolUpdateProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.PoolUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PoolUpdateProperties(_model_base.Model):
    """The updatable properties of the Pool.

    :ivar provisioning_state: The status of the current operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.devopsinfrastructure.models.ProvisioningState
    :ivar maximum_concurrency: Defines how many resources can there be created at any given time.
    :vartype maximum_concurrency: int
    :ivar organization_profile: Defines the organization in which the pool will be used.
    :vartype organization_profile: ~azure.mgmt.devopsinfrastructure.models.OrganizationProfile
    :ivar agent_profile: Defines how the machine will be handled once it executed a job.
    :vartype agent_profile: ~azure.mgmt.devopsinfrastructure.models.AgentProfile
    :ivar fabric_profile: Defines the type of fabric the agent will run on.
    :vartype fabric_profile: ~azure.mgmt.devopsinfrastructure.models.FabricProfile
    :ivar dev_center_project_resource_id: The resource id of the DevCenter Project the pool belongs
     to.
    :vartype dev_center_project_resource_id: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(name="provisioningState")
    """The status of the current operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""
    maximum_concurrency: Optional[int] = rest_field(name="maximumConcurrency")
    """Defines how many resources can there be created at any given time."""
    organization_profile: Optional["_models.OrganizationProfile"] = rest_field(name="organizationProfile")
    """Defines the organization in which the pool will be used."""
    agent_profile: Optional["_models.AgentProfile"] = rest_field(name="agentProfile")
    """Defines how the machine will be handled once it executed a job."""
    fabric_profile: Optional["_models.FabricProfile"] = rest_field(name="fabricProfile")
    """Defines the type of fabric the agent will run on."""
    dev_center_project_resource_id: Optional[str] = rest_field(name="devCenterProjectResourceId")
    """The resource id of the DevCenter Project the pool belongs to."""

    @overload
    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        maximum_concurrency: Optional[int] = None,
        organization_profile: Optional["_models.OrganizationProfile"] = None,
        agent_profile: Optional["_models.AgentProfile"] = None,
        fabric_profile: Optional["_models.FabricProfile"] = None,
        dev_center_project_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Quota(_model_base.Model):
    """Describes Resource Quota.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: The name of the quota.
    :vartype name: ~azure.mgmt.devopsinfrastructure.models.QuotaName
    :ivar id: Fully qualified ARM resource id. Required.
    :vartype id: str
    :ivar unit: The unit of usage measurement. Required.
    :vartype unit: str
    :ivar current_value: The current usage of the resource. Required.
    :vartype current_value: int
    :ivar limit: The maximum permitted usage of the resource. Required.
    :vartype limit: int
    """

    name: Optional["_models.QuotaName"] = rest_field(visibility=["read"])
    """The name of the quota."""
    id: str = rest_field()
    """Fully qualified ARM resource id. Required."""
    unit: str = rest_field()
    """The unit of usage measurement. Required."""
    current_value: int = rest_field(name="currentValue")
    """The current usage of the resource. Required."""
    limit: int = rest_field()
    """The maximum permitted usage of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        unit: str,
        current_value: int,
        limit: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class QuotaName(_model_base.Model):
    """The Quota Names.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field()
    """The name of the resource."""
    localized_value: Optional[str] = rest_field(name="localizedValue")
    """The localized name of the resource."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceDetailsObject(ProxyResource):
    """A ResourceDetailsObject.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devopsinfrastructure.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.devopsinfrastructure.models.ResourceDetailsObjectProperties
    """

    properties: Optional["_models.ResourceDetailsObjectProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ResourceDetailsObjectProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceDetailsObjectProperties(_model_base.Model):
    """Details of the ResourceDetailsObject.


    :ivar status: The status of the resource. Required. Known values are: "Ready", "NotReady",
     "Allocated", "PendingReturn", "Returned", "Leased", "Provisioning", "Updating", "Starting",
     "PendingReimage", and "Reimaging".
    :vartype status: str or ~azure.mgmt.devopsinfrastructure.models.ResourceStatus
    :ivar image: The image name of the resource. Required.
    :vartype image: str
    :ivar image_version: The version of the image running on the resource. Required.
    :vartype image_version: str
    """

    status: Union[str, "_models.ResourceStatus"] = rest_field()
    """The status of the resource. Required. Known values are: \"Ready\", \"NotReady\", \"Allocated\",
     \"PendingReturn\", \"Returned\", \"Leased\", \"Provisioning\", \"Updating\", \"Starting\",
     \"PendingReimage\", and \"Reimaging\"."""
    image: str = rest_field()
    """The image name of the resource. Required."""
    image_version: str = rest_field(name="imageVersion")
    """The version of the image running on the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.ResourceStatus"],
        image: str,
        image_version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourcePredictions(_model_base.Model):
    """Defines pool buffer."""


class ResourceSku(ProxyResource):
    """A ResourceSku.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devopsinfrastructure.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.devopsinfrastructure.models.ResourceSkuProperties
    """

    properties: Optional["_models.ResourceSkuProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ResourceSkuProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceSkuCapabilities(_model_base.Model):
    """Describes The SKU capabilities object.


    :ivar name: The name of the SKU capability. Required.
    :vartype name: str
    :ivar value: The value of the SKU capability. Required.
    :vartype value: str
    """

    name: str = rest_field()
    """The name of the SKU capability. Required."""
    value: str = rest_field()
    """The value of the SKU capability. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceSkuLocationInfo(_model_base.Model):
    """Describes an available Compute SKU Location Information.


    :ivar location: Location of the SKU. Required.
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported. Required.
    :vartype zones: list[str]
    :ivar zone_details: Gets details of capabilities available to a SKU in specific zones.
     Required.
    :vartype zone_details: list[~azure.mgmt.devopsinfrastructure.models.ResourceSkuZoneDetails]
    """

    location: str = rest_field()
    """Location of the SKU. Required."""
    zones: List[str] = rest_field()
    """List of availability zones where the SKU is supported. Required."""
    zone_details: List["_models.ResourceSkuZoneDetails"] = rest_field(name="zoneDetails")
    """Gets details of capabilities available to a SKU in specific zones. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        zones: List[str],
        zone_details: List["_models.ResourceSkuZoneDetails"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceSkuProperties(_model_base.Model):
    """Properties of a ResourceSku.


    :ivar resource_type: The type of resource the SKU applies to. Required.
    :vartype resource_type: str
    :ivar tier: The tier of virtual machines in a scale set. Required.
    :vartype tier: str
    :ivar size: The size of the SKU. Required.
    :vartype size: str
    :ivar family: The family of the SKU. Required.
    :vartype family: str
    :ivar locations: The set of locations that the SKU is available. Required.
    :vartype locations: list[str]
    :ivar location_info: A list of locations and availability zones in those locations where the
     SKU is available. Required.
    :vartype location_info: list[~azure.mgmt.devopsinfrastructure.models.ResourceSkuLocationInfo]
    :ivar capabilities: Name value pairs to describe the capability. Required.
    :vartype capabilities: list[~azure.mgmt.devopsinfrastructure.models.ResourceSkuCapabilities]
    :ivar restrictions: The restrictions of the SKU. Required.
    :vartype restrictions: list[~azure.mgmt.devopsinfrastructure.models.ResourceSkuRestrictions]
    """

    resource_type: str = rest_field(name="resourceType")
    """The type of resource the SKU applies to. Required."""
    tier: str = rest_field()
    """The tier of virtual machines in a scale set. Required."""
    size: str = rest_field()
    """The size of the SKU. Required."""
    family: str = rest_field()
    """The family of the SKU. Required."""
    locations: List[str] = rest_field()
    """The set of locations that the SKU is available. Required."""
    location_info: List["_models.ResourceSkuLocationInfo"] = rest_field(name="locationInfo")
    """A list of locations and availability zones in those locations where the SKU is available.
     Required."""
    capabilities: List["_models.ResourceSkuCapabilities"] = rest_field()
    """Name value pairs to describe the capability. Required."""
    restrictions: List["_models.ResourceSkuRestrictions"] = rest_field()
    """The restrictions of the SKU. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_type: str,
        tier: str,
        size: str,
        family: str,
        locations: List[str],
        location_info: List["_models.ResourceSkuLocationInfo"],
        capabilities: List["_models.ResourceSkuCapabilities"],
        restrictions: List["_models.ResourceSkuRestrictions"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceSkuRestrictionInfo(_model_base.Model):
    """Describes an available Compute SKU Restriction Information.

    :ivar locations: Locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: List of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    locations: Optional[List[str]] = rest_field()
    """Locations where the SKU is restricted."""
    zones: Optional[List[str]] = rest_field()
    """List of availability zones where the SKU is restricted."""

    @overload
    def __init__(
        self,
        *,
        locations: Optional[List[str]] = None,
        zones: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceSkuRestrictions(_model_base.Model):
    """The restrictions of the SKU.


    :ivar type: the type of restrictions. Known values are: "Location" and "Zone".
    :vartype type: str or ~azure.mgmt.devopsinfrastructure.models.ResourceSkuRestrictionsType
    :ivar values_property: The value of restrictions. If the restriction type is set to location.
     This would be different locations where the SKU is restricted. Required.
    :vartype values_property: list[str]
    :ivar restriction_info: The information about the restriction where the SKU cannot be used.
     Required.
    :vartype restriction_info: ~azure.mgmt.devopsinfrastructure.models.ResourceSkuRestrictionInfo
    :ivar reason_code: the reason for restriction. Known values are: "QuotaId" and
     "NotAvailableForSubscription".
    :vartype reason_code: str or
     ~azure.mgmt.devopsinfrastructure.models.ResourceSkuRestrictionsReasonCode
    """

    type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = rest_field()
    """the type of restrictions. Known values are: \"Location\" and \"Zone\"."""
    values_property: List[str] = rest_field(name="values")
    """The value of restrictions. If the restriction type is set to location. This would be different
     locations where the SKU is restricted. Required."""
    restriction_info: "_models.ResourceSkuRestrictionInfo" = rest_field(name="restrictionInfo")
    """The information about the restriction where the SKU cannot be used. Required."""
    reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = rest_field(name="reasonCode")
    """the reason for restriction. Known values are: \"QuotaId\" and \"NotAvailableForSubscription\"."""

    @overload
    def __init__(
        self,
        *,
        values_property: List[str],
        restriction_info: "_models.ResourceSkuRestrictionInfo",
        type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = None,
        reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceSkuZoneDetails(_model_base.Model):
    """Describes The zonal capabilities of a SKU.


    :ivar name: Gets the set of zones that the SKU is available in with the specified capabilities.
     Required.
    :vartype name: list[str]
    :ivar capabilities: A list of capabilities that are available for the SKU in the specified list
     of zones. Required.
    :vartype capabilities: list[~azure.mgmt.devopsinfrastructure.models.ResourceSkuCapabilities]
    """

    name: List[str] = rest_field()
    """Gets the set of zones that the SKU is available in with the specified capabilities. Required."""
    capabilities: List["_models.ResourceSkuCapabilities"] = rest_field()
    """A list of capabilities that are available for the SKU in the specified list of zones. Required."""

    @overload
    def __init__(
        self,
        *,
        name: List[str],
        capabilities: List["_models.ResourceSkuCapabilities"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SecretsManagementSettings(_model_base.Model):
    """The secret management settings of the machines in the pool.


    :ivar certificate_store_location: Where to store certificates on the machine.
    :vartype certificate_store_location: str
    :ivar observed_certificates: The list of certificates to install on all machines in the pool.
     Required.
    :vartype observed_certificates: list[str]
    :ivar key_exportable: Defines if the key of the certificates should be exportable. Required.
    :vartype key_exportable: bool
    """

    certificate_store_location: Optional[str] = rest_field(name="certificateStoreLocation")
    """Where to store certificates on the machine."""
    observed_certificates: List[str] = rest_field(name="observedCertificates")
    """The list of certificates to install on all machines in the pool. Required."""
    key_exportable: bool = rest_field(name="keyExportable")
    """Defines if the key of the certificates should be exportable. Required."""

    @overload
    def __init__(
        self,
        *,
        observed_certificates: List[str],
        key_exportable: bool,
        certificate_store_location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Stateful(AgentProfile, discriminator="Stateful"):
    """Stateful profile meaning that the machines will be returned to the pool after running a job.


    :ivar resource_predictions: Defines pool buffer/stand-by agents.
    :vartype resource_predictions: ~azure.mgmt.devopsinfrastructure.models.ResourcePredictions
    :ivar resource_predictions_profile: Defines how the pool buffer/stand-by agents is provided.
    :vartype resource_predictions_profile:
     ~azure.mgmt.devopsinfrastructure.models.ResourcePredictionsProfile
    :ivar kind: Stateful profile meaning that the machines will be returned to the pool after
     running a job. Required. Default value is "Stateful".
    :vartype kind: str
    :ivar max_agent_lifetime: How long should stateful machines be kept around. The maximum is one
     week.
    :vartype max_agent_lifetime: str
    :ivar grace_period_time_span: How long should the machine be kept around after it ran a
     workload when there are no stand-by agents. The maximum is one week.
    :vartype grace_period_time_span: str
    """

    kind: Literal["Stateful"] = rest_discriminator(name="kind")  # type: ignore
    """Stateful profile meaning that the machines will be returned to the pool after running a job.
     Required. Default value is \"Stateful\"."""
    max_agent_lifetime: Optional[str] = rest_field(name="maxAgentLifetime")
    """How long should stateful machines be kept around. The maximum is one week."""
    grace_period_time_span: Optional[str] = rest_field(name="gracePeriodTimeSpan")
    """How long should the machine be kept around after it ran a workload when there are no stand-by
     agents. The maximum is one week."""

    @overload
    def __init__(
        self,
        *,
        resource_predictions: Optional["_models.ResourcePredictions"] = None,
        resource_predictions_profile: Optional["_models.ResourcePredictionsProfile"] = None,
        max_agent_lifetime: Optional[str] = None,
        grace_period_time_span: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind="Stateful", **kwargs)


class StatelessAgentProfile(AgentProfile, discriminator="Stateless"):
    """Stateless profile meaning that the machines will be cleaned up after running a job.


    :ivar resource_predictions: Defines pool buffer/stand-by agents.
    :vartype resource_predictions: ~azure.mgmt.devopsinfrastructure.models.ResourcePredictions
    :ivar resource_predictions_profile: Defines how the pool buffer/stand-by agents is provided.
    :vartype resource_predictions_profile:
     ~azure.mgmt.devopsinfrastructure.models.ResourcePredictionsProfile
    :ivar kind: Stateless profile meaning that the machines will be cleaned up after running a job.
     Required. Default value is "Stateless".
    :vartype kind: str
    """

    kind: Literal["Stateless"] = rest_discriminator(name="kind")  # type: ignore
    """Stateless profile meaning that the machines will be cleaned up after running a job. Required.
     Default value is \"Stateless\"."""

    @overload
    def __init__(
        self,
        *,
        resource_predictions: Optional["_models.ResourcePredictions"] = None,
        resource_predictions_profile: Optional["_models.ResourcePredictionsProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind="Stateless", **kwargs)


class StorageProfile(_model_base.Model):
    """The storage profile of the VMSS.

    :ivar os_disk_storage_account_type: The Azure SKU name of the machines in the pool. Known
     values are: "Standard", "Premium", and "StandardSSD".
    :vartype os_disk_storage_account_type: str or
     ~azure.mgmt.devopsinfrastructure.models.OsDiskStorageAccountType
    :ivar data_disks: A list of empty data disks to attach.
    :vartype data_disks: list[~azure.mgmt.devopsinfrastructure.models.DataDisk]
    """

    os_disk_storage_account_type: Optional[Union[str, "_models.OsDiskStorageAccountType"]] = rest_field(
        name="osDiskStorageAccountType"
    )
    """The Azure SKU name of the machines in the pool. Known values are: \"Standard\", \"Premium\",
     and \"StandardSSD\"."""
    data_disks: Optional[List["_models.DataDisk"]] = rest_field(name="dataDisks")
    """A list of empty data disks to attach."""

    @overload
    def __init__(
        self,
        *,
        os_disk_storage_account_type: Optional[Union[str, "_models.OsDiskStorageAccountType"]] = None,
        data_disks: Optional[List["_models.DataDisk"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.devopsinfrastructure.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.devopsinfrastructure.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_model_base.Model):
    """User assigned identity properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class VmssFabricProfile(FabricProfile, discriminator="Vmss"):
    """The agents will run on Virtual Machine Scale Sets.


    :ivar kind: Virtual Machine Scale Sets. Required. Default value is "Vmss".
    :vartype kind: str
    :ivar sku: The Azure SKU of the machines in the pool. Required.
    :vartype sku: ~azure.mgmt.devopsinfrastructure.models.DevOpsAzureSku
    :ivar images: The VM images of the machines in the pool. Required.
    :vartype images: list[~azure.mgmt.devopsinfrastructure.models.PoolImage]
    :ivar os_profile: The OS profile of the machines in the pool.
    :vartype os_profile: ~azure.mgmt.devopsinfrastructure.models.OsProfile
    :ivar storage_profile: The storage profile of the machines in the pool.
    :vartype storage_profile: ~azure.mgmt.devopsinfrastructure.models.StorageProfile
    :ivar network_profile: The network profile of the machines in the pool.
    :vartype network_profile: ~azure.mgmt.devopsinfrastructure.models.NetworkProfile
    """

    kind: Literal["Vmss"] = rest_discriminator(name="kind")  # type: ignore
    """Virtual Machine Scale Sets. Required. Default value is \"Vmss\"."""
    sku: "_models.DevOpsAzureSku" = rest_field()
    """The Azure SKU of the machines in the pool. Required."""
    images: List["_models.PoolImage"] = rest_field()
    """The VM images of the machines in the pool. Required."""
    os_profile: Optional["_models.OsProfile"] = rest_field(name="osProfile")
    """The OS profile of the machines in the pool."""
    storage_profile: Optional["_models.StorageProfile"] = rest_field(name="storageProfile")
    """The storage profile of the machines in the pool."""
    network_profile: Optional["_models.NetworkProfile"] = rest_field(name="networkProfile")
    """The network profile of the machines in the pool."""

    @overload
    def __init__(
        self,
        *,
        sku: "_models.DevOpsAzureSku",
        images: List["_models.PoolImage"],
        os_profile: Optional["_models.OsProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind="Vmss", **kwargs)
