# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.servicefabricmanagedclusters import ServiceFabricManagedClustersManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-servicefabricmanagedclusters
# USAGE
    python service_put_operation_example_max.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ServiceFabricManagedClustersManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.services.begin_create_or_update(
        resource_group_name="resRg",
        cluster_name="myCluster",
        application_name="myApp",
        service_name="myService",
        parameters={
            "location": "eastus",
            "properties": {
                "correlationScheme": [
                    {
                        "scheme": "AlignedAffinity",
                        "serviceName": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applications/myApp/services/myService1",
                    }
                ],
                "defaultMoveCost": "Medium",
                "instanceCount": 5,
                "minInstanceCount": 3,
                "minInstancePercentage": 30,
                "partitionDescription": {"partitionScheme": "Singleton"},
                "placementConstraints": "NodeType==frontend",
                "scalingPolicies": [
                    {
                        "scalingMechanism": {
                            "kind": "ScalePartitionInstanceCount",
                            "maxInstanceCount": 9,
                            "minInstanceCount": 3,
                            "scaleIncrement": 2,
                        },
                        "scalingTrigger": {
                            "kind": "AveragePartitionLoadTrigger",
                            "lowerLoadThreshold": 2,
                            "metricName": "metricName",
                            "scaleInterval": "00:01:00",
                            "upperLoadThreshold": 8,
                        },
                    }
                ],
                "serviceDnsName": "myservicednsname.myApp",
                "serviceKind": "Stateless",
                "serviceLoadMetrics": [{"defaultLoad": 3, "name": "metric1", "weight": "Low"}],
                "servicePackageActivationMode": "SharedProcess",
                "servicePlacementPolicies": [{"type": "NonPartiallyPlaceService"}],
                "serviceTypeName": "myServiceType",
            },
            "tags": {"a": "b"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/servicefabricmanagedclusters/resource-manager/Microsoft.ServiceFabric/preview/2024-09-01-preview/examples/ServicePutOperation_example_max.json
if __name__ == "__main__":
    main()
