# Demos {#demos}

\defgroup demos Demos
\ingroup demos
@{

- [Rigid body planning](RigidBodyPlanning_8cpp_source.html) [[Python version]](RigidBodyPlanning_8py_source.html). This demo is essentially the same example described in the first tutorial. It illustrates how to use the main classes.
- [State sampling](StateSampling_8cpp_source.html) [[Python version]](StateSampling_8py_source.html). This is the demo program used in the last beginner tutorial.
- [Analyze and visualize planner data in Python.](PlannerData_8py_source.html) This demo relies on the [graph-tool](https://graph-tool.skewed.de) package.
- [Rigid body planning with controls](RigidBodyPlanningWithControls_8cpp_source.html) [[Python version]](RigidBodyPlanningWithControls_8py_source.html). This demo shows how to perform planning under differential constraints for a simple car-like vehicle.
- [Rigid body planning with integration and controls.](RigidBodyPlanningWithIntegrationAndControls_8cpp_source.html) This example extends the previous example by showing how one can plan for systems of ordinary differential equations in a generic way. This example uses simple Euler integration. For higher accuracy it is recommended to use the ODESolver class described in the next demo.
- [Rigid body planning with ODESolver and controls.](RigidBodyPlanningWithODESolverAndControls_8cpp_source.html)  [[Python version]](RigidBodyPlanningWithODESolverAndControls_8py_source.html) This example compares and contrasts the previous demo of planning with integration and planning using the ODESolver class, which wraps around [Boost.Numeric.Odeint](https://www.boost.org/libs/numeric/odeint).  Code showing the same model being planned with a user-implemented numerical integration technique as well as the ODESolver is presented.
- [Koules](Koules_8cpp_source.html) This is a very elaborate demo to illustrate planning for underactuated kinodynamic systems with drift. It based on an old Unix game called [Koules](http://www.ucw.cz/~hubicka/koules/English/). The physics have been made significantly harder compared to the original game. The demo can solve just one level of Koules, all levels, or run a number of planners on one level as a benchmarking run. The demo prints out a path that can be turned into a movie using KoulesPlayback.py. Example usage:

        > ./demo_Koules --planall --planner kpiece --numkoules 7 --maxtime 600 --output koules7.log
        > /path/to/ompl/demos/KoulesPlaypack.py koules7.log

  This will create a movie called koules7.mp4. See [the gallery](gallery.html) for an example of what this might look like.

  This demo illustrates also many advanced OMPL concepts, such as classes for a custom state space, a control sampler, a projection, a state propagator, and a goal class. It also demonstrates how one could put a simple bang-bang controller inside the StatePropagator. In this demo the (Directed)ControlSampler simply samples a target velocity vector and inside the StatePropagator the control is chosen to drive the ship to attain this velocity.
- [Planning for a simple hybrid system.](HybridSystemPlanning_8cpp_source.html) This demo shows how one could plan for a car with gears. The gear is a discrete state variable, while its pose is continuous. The car needs to make a sharp turn and is forced to change gears. This is not the best way to plan for hybrid systems, since this approach ignores completely the structure that exist in the system. Nevertheless, it demonstrates that the planners in OMPL are state space agnostic and can plan in discrete or hybrid state spaces.
- [Rigid body planning with an Inverse Kinematics solver generating goal states in a separate thread.](RigidBodyPlanningWithIK_8cpp_source.html) This demo shows off two neat features of OMPL: a genetic algorithm-based Inverse Kinematics solver and a lazy goal state sampler. In a separate thread goal states are computed by the IK solver. While solving a motion planning problem, the planning algorithms select a random goal state from the ones computed so far.
- [Rigid body planning using the Open Dynamics Engine (ODE).](OpenDERigidBodyPlanning_8cpp_source.html) When ODE is installed, OMPL will compile an extension that makes is easier to use ODE for forward propagation of models of motion. In this example, a box is pushed around in the plane from a start position to a goal position.
- [Random walk planner.](RandomWalkPlanner_8py_source.html) A simple demo illustrating how to create a new planning algorithm in Python. This particular planner simply performs a random walk until it gets close to the goal.
- [Planning for Dubins and Reeds-Shepp cars.](GeometricCarPlanning_8cpp_source.html) This demo illustrates the use of the ompl::base::DubinsStateSpace and ompl::base::ReedsSheppStateSpace. The demo can solve two simple planning problems, print trajectories from the origin to a user-specified state, or print a discretized distance field.
- [Optimal planning for a 2D point robot.](OptimalPlanning_8cpp_source.html) [[Python version]](OptimalPlanning_8py_source.html). This demo illustrates the use of `ompl::base::OptimizationObjective` to construct optimization objectives for optimal motion planning.
- [Hypercube benchmark.](HypercubeBenchmark_8cpp_source.html) A simple benchmark where the configuration space consists of a hypercube in R<sup>n</sup> and the free space is a narrow corridor along edges of the hypercube. The exploration progress of a planner is therefore hard to capture in a low-dimensional projection.
- [Kinematic chain benchmark.](KinematicChainBenchmark_8cpp_source.html) A benchmark for an _n_-link kinematic chain to get out of a narrow passage. It requires the chain to fold up and expand again. As in the previous benchmark, the free space is hard to capture by a low-dimensional projection of the configuration space.
- [2D point planning using a PPM image as a map](Point2DPlanning_8cpp_source.html) [[Python version](Point2DPlanning_8py_source.html)]
- [Circle Grid benchmark](CForestCircleGridBenchmark_8cpp_source.html). Implements a configurable 2D circle grid benchmark problem, where the user can specify state space, size of the grid and circles, so that the problem can be as hard as desired.
- [LTLWithTriangulation](LTLWithTriangulation_8cpp_source.html). A demo for ompl::control::LTLPlanner, a planner that find solutions for kinodynamic motion planning problems where the goal is specified by a Linear Temporal Logic (LTL) specification.
- Constrained Planning Demos. These are a set of demos that illustrate [how to use OMPL to plan for robot motion under constraints](constrainedPlanning.html). Each of these demos supports planning for an individual planner as well as benchmarking, and complete configurability of the hyperparameters of the constrained space. See the help with the `-h` flag on each program..
  - [ConstrainedPlanningSphere](ConstrainedPlanningSphere_8cpp_source.html) [[Python version]](ConstrainedPlanningSphere_8py_source.html). Plan for a point in R<sup>3</sup> constrained to the surface of a sphere, with narrow obstacles it must traverse. The results for this program are visualizable with the [Blender](https://www.blender.org/) file `ConstrainedPlanningSphere.blend`. Use the `-o` flag to enable output, and run the script linked inside the blender file.
  - [ConstrainedPlanningTorus](ConstrainedPlanningTorus_8cpp_source.html) [[Python version]](ConstrainedPlanningTorus_8py_source.html). Plan for a point in R<sup>3</sup> constrained to the surface of a torus. A "maze" image is loaded (some examples are provided in `ompl/demos/constraint/mazes`) to use as the set of obstacles to traverse. The start and goal point are red and green pixels in the images respectively. The results for this program are visualizable with the [Blender](https://www.blender.org/) file `ConstrainedPlanningTorus.blend`. Use the `-o` flag to enable output, and run the script linked inside the blender file.
  - [ConstrainedPlanningImplicitChain](ConstrainedPlanningImplicitChain_8cpp_source.html) [[Python version]](ConstrainedPlanningImplicitChain_8py_source.html). Plan for a set of balls, each in R<sup>3</sup>, constrained to be a unit distance apart. This imposes spherical kinematics on the balls, implicitly defining a kinematic chain. The results for this program are visualizable with the [Blender](https://www.blender.org/) file `ConstrainedPlanningImplicitChain.blend`. Use the `-o` flag to enable output, and run the script linked inside the blender file.
  - [ConstrainedPlanningImplicitParallel](ConstrainedPlanningImplicitParallel_8cpp_source.html). Plan for a parallel robot made of many implicit chains. The results for this program are visualizable with the [Blender](https://www.blender.org/) file `ConstrainedPlanningImplicitParallel.blend`. Use the `-o` flag to enable output, and run the script linked inside the blender file.
  - [ConstrainedPlanningKinematicChain](ConstrainedPlanningKinematicChain_8cpp_source.html). Similar to the kinematic chain benchmark above, but with a constraint that only allows the tip of the manipulator to move along a line.

- QuotientSpace Planning Demos. Planning on different abstraction levels. For more information refer to the [QuotientSpace Planning Guide](quotientSpacePlanning.html) and the [QuotientSpace Planning Tutorial](quotientSpacePlanningTutorial.html)
  - [Quotient Space Rigid Body in 2D](QuotientSpacePlanningRigidBody2D_8cpp_source.html). Two-level planning for a rigid body in \f$SE(2)\f$ with quotient space \f$\mathbb{R}^2\f$.
  - [Quotient Space Rigid Body in 3D](QuotientSpacePlanningRigidBody3D_8cpp_source.html). Two-level planning for a rigid body in \f$SE(3)\f$ with quotient space \f$\mathbb{R}^3\f$.
  - [Quotient Space HyperCube](QuotientSpacePlanningHyperCube_8cpp_source.html). N-level hypercube benchmark using a point robot moving in a cube \f$\mathbb{R}^N\f$. We use QuotientSpaces \f$\{\mathbb{R}^2,\mathbb{R}^4,\cdots,\mathbb{R}^N\f$ (This is a modified version of the [Hypercube benchmark](HypercubeBenchmark_8cpp_source.html)).
  - [Quotient Space Kinematic Chain](QuotientSpacePlanningKinematicChain_8cpp_source.html). Planning benchmark of different QuotientSpace seuqences for a kinematic chain in \f$\mathbb{R}^N\f$ (This is a modified version of the [Kinematic chain benchmark.](KinematicChainBenchmark_8cpp_source.html)).
@}
