/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.trace;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.common.export.ProxyOptions;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import io.opentelemetry.sdk.internal.StandardComponentId;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpHttpSpanExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/traces";
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.REUSABLE_DATA;
    private final HttpExporterBuilder<Marshaler> delegate;
    private MemoryMode memoryMode;

    OtlpHttpSpanExporterBuilder(HttpExporterBuilder<Marshaler> delegate, MemoryMode memoryMode) {
        this.delegate = delegate;
        this.memoryMode = memoryMode;
        OtlpUserAgent.addUserAgentHeader((arg_0, arg_1) -> delegate.addConstantHeaders(arg_0, arg_1));
    }

    OtlpHttpSpanExporterBuilder() {
        this((HttpExporterBuilder<Marshaler>)new HttpExporterBuilder(StandardComponentId.ExporterType.OTLP_HTTP_SPAN_EXPORTER, DEFAULT_ENDPOINT), DEFAULT_MEMORY_MODE);
    }

    public OtlpHttpSpanExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpSpanExporterBuilder setConnectTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout, unit);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setConnectTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setConnectTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpHttpSpanExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeaders(key, value);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setProxy(ProxyOptions proxyOptions) {
        Objects.requireNonNull(proxyOptions, "proxyOptions");
        this.delegate.setProxyOptions(proxyOptions);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.setMeterProvider(() -> meterProvider);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        Objects.requireNonNull(meterProviderSupplier, "meterProviderSupplier");
        this.delegate.setMeterProvider(meterProviderSupplier);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setInternalTelemetryVersion(InternalTelemetryVersion schemaVersion) {
        Objects.requireNonNull(schemaVersion, "schemaVersion");
        this.delegate.setInternalTelemetryVersion(schemaVersion);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    public OtlpHttpSpanExporterBuilder setServiceClassLoader(ClassLoader serviceClassLoader) {
        Objects.requireNonNull(serviceClassLoader, "serviceClassLoader");
        return this.setComponentLoader(ComponentLoader.forClassLoader((ClassLoader)serviceClassLoader));
    }

    public OtlpHttpSpanExporterBuilder setComponentLoader(ComponentLoader componentLoader) {
        Objects.requireNonNull(componentLoader, "componentLoader");
        this.delegate.setComponentLoader(componentLoader);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setExecutorService(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService");
        this.delegate.setExecutorService(executorService);
        return this;
    }

    public OtlpHttpSpanExporter build() {
        return new OtlpHttpSpanExporter(this.delegate, (HttpExporter<Marshaler>)this.delegate.build(), this.memoryMode);
    }
}

