/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.semver4j.Range;
import org.semver4j.internal.Tokenizers;
import org.semver4j.processor.Processor;
import org.semver4j.processor.RangesUtils;

@NullMarked
public class HyphenProcessor
implements Processor {
    private static final Pattern pattern = Pattern.compile(Tokenizers.HYPHEN);

    @Override
    public @Nullable String process(String range, boolean includePrerelease) {
        Matcher matcher = pattern.matcher(range);
        if (!matcher.matches()) {
            return null;
        }
        String rangeFrom = this.getRangeFrom(matcher, includePrerelease);
        String rangeTo = this.getRangeTo(matcher, includePrerelease);
        return String.format(Locale.ROOT, "%s %s", rangeFrom, rangeTo);
    }

    private String getRangeFrom(Matcher matcher, boolean includePrerelease) {
        String from = matcher.group(1);
        int fromMajor = RangesUtils.parseIntWithXSupport(matcher.group(2));
        int fromMinor = RangesUtils.parseIntWithXSupport(matcher.group(3));
        int fromPatch = RangesUtils.parseIntWithXSupport(matcher.group(4));
        String prerelease = includePrerelease ? "-0" : "";
        boolean minorIsX = RangesUtils.isX(fromMinor);
        boolean patchIsX = RangesUtils.isX(fromPatch);
        if (minorIsX) {
            return String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.GTE.asString(), fromMajor, prerelease);
        }
        if (patchIsX) {
            return String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, prerelease);
        }
        return String.format(Locale.ROOT, "%s%s", Range.RangeOperator.GTE.asString(), from);
    }

    private String getRangeTo(Matcher matcher, boolean includePrerelease) {
        int toMajor = RangesUtils.parseIntWithXSupport(matcher.group(8));
        int toMinor = RangesUtils.parseIntWithXSupport(matcher.group(9));
        int toPatch = RangesUtils.parseIntWithXSupport(matcher.group(10));
        @Nullable String preRelease = matcher.group(11);
        String prerelease = includePrerelease ? "-0" : "";
        boolean minorIsX = RangesUtils.isX(toMinor);
        boolean patchIsX = RangesUtils.isX(toPatch);
        if (minorIsX) {
            return String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.LT.asString(), toMajor + 1, prerelease);
        }
        if (patchIsX) {
            return String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.LT.asString(), toMajor, toMinor + 1, prerelease);
        }
        if (RangesUtils.isNotBlank(preRelease)) {
            return String.format(Locale.ROOT, "%s%d.%d.%d%s", Range.RangeOperator.LTE.asString(), toMajor, toMinor, toPatch, "-" + preRelease);
        }
        return String.format(Locale.ROOT, "%s%d.%d.%d%s", Range.RangeOperator.LT.asString(), toMajor, toMinor, toPatch + 1, prerelease);
    }
}

