/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelData;
import org.apache.sis.internal.storage.io.DataTransfer;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class ChannelDataInput
extends ChannelData {
    private static final int SEEK_THRESHOLD = 8;
    public final ReadableByteChannel channel;

    public ChannelDataInput(String string, ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, boolean bl) throws IOException {
        super(string, readableByteChannel, byteBuffer);
        this.channel = readableByteChannel;
        if (!bl) {
            byteBuffer.clear();
            readableByteChannel.read(byteBuffer);
            byteBuffer.flip();
        }
    }

    public final long length() throws IOException {
        if (this.channel instanceof SeekableByteChannel) {
            return Math.subtractExact(((SeekableByteChannel)this.channel).size(), this.channelOffset);
        }
        return -1L;
    }

    public final int prefetch() throws IOException {
        int n;
        int n2 = this.buffer.limit();
        if (n2 == (n = this.buffer.capacity())) {
            return -2;
        }
        int n3 = this.buffer.position();
        this.buffer.limit(n).position(n2);
        int n4 = this.channel.read(this.buffer);
        while (n4 == 0) {
            this.onEmptyTransfer();
            n4 = this.channel.read(this.buffer);
        }
        this.buffer.limit(this.buffer.position()).position(n3);
        return n4;
    }

    public final boolean hasRemaining() throws IOException {
        if (this.buffer.hasRemaining()) {
            return true;
        }
        this.bufferOffset += (long)this.buffer.limit();
        this.buffer.clear();
        int n = this.channel.read(this.buffer);
        while (n == 0) {
            this.onEmptyTransfer();
            n = this.channel.read(this.buffer);
        }
        this.buffer.flip();
        return n >= 0;
    }

    public final void ensureBufferContains(int n) throws EOFException, IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int n2;
            this.bufferOffset += (long)this.buffer.position();
            this.buffer.compact();
            do {
                if ((n2 = this.channel.read(this.buffer)) > 0) continue;
                if (n2 != 0) {
                    throw new EOFException(this.eof());
                }
                this.onEmptyTransfer();
            } while ((n -= n2) > 0);
            this.buffer.flip();
        }
    }

    private void ensureNonEmpty() throws IOException {
        if (!this.hasRemaining()) {
            throw new EOFException(this.eof());
        }
    }

    private String eof() {
        return Errors.format((short)137, this.filename);
    }

    final void pushBack() {
        this.buffer.position(this.buffer.position() - 1);
    }

    public final int readBit() throws IOException {
        this.ensureBufferContains(1);
        return this.readBitFromBuffer();
    }

    public final long readBits(int n) throws IOException {
        ArgumentChecks.ensureBetween("numBits", 0, 64, n);
        if (n == 0) {
            return 0L;
        }
        int n2 = this.getBitOffset();
        long l = this.readByte() & 255 >>> n2;
        n -= 8 - n2;
        while (n > 0) {
            l = l << 8 | (long)this.readUnsignedByte();
            n -= 8;
        }
        if (n != 0) {
            l >>>= -n;
            n += 8;
            this.pushBack();
        }
        this.setBitOffset(n);
        return l;
    }

    public final byte readByte() throws IOException {
        this.ensureBufferContains(1);
        return this.buffer.get();
    }

    public final int readUnsignedByte() throws IOException {
        return Byte.toUnsignedInt(this.readByte());
    }

    public final short readShort() throws IOException {
        this.ensureBufferContains(2);
        return this.buffer.getShort();
    }

    public final int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(this.readShort());
    }

    public final char readChar() throws IOException {
        this.ensureBufferContains(2);
        return this.buffer.getChar();
    }

    public final int readInt() throws IOException {
        this.ensureBufferContains(4);
        return this.buffer.getInt();
    }

    public final long readUnsignedInt() throws IOException {
        return Integer.toUnsignedLong(this.readInt());
    }

    public final long readLong() throws IOException {
        this.ensureBufferContains(8);
        return this.buffer.getLong();
    }

    public final float readFloat() throws IOException {
        this.ensureBufferContains(4);
        return this.buffer.getFloat();
    }

    public final double readDouble() throws IOException {
        this.ensureBufferContains(8);
        return this.buffer.getDouble();
    }

    public final byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public final char[] readChars(int n) throws IOException {
        char[] cArray = new char[n];
        this.readFully(cArray, 0, n);
        return cArray;
    }

    public final short[] readShorts(int n) throws IOException {
        short[] sArray = new short[n];
        this.readFully(sArray, 0, n);
        return sArray;
    }

    public final int[] readInts(int n) throws IOException {
        int[] nArray = new int[n];
        this.readFully(nArray, 0, n);
        return nArray;
    }

    public final long[] readLongs(int n) throws IOException {
        long[] lArray = new long[n];
        this.readFully(lArray, 0, n);
        return lArray;
    }

    public final float[] readFloats(int n) throws IOException {
        float[] fArray = new float[n];
        this.readFully(fArray, 0, n);
        return fArray;
    }

    public final double[] readDoubles(int n) throws IOException {
        double[] dArray = new double[n];
        this.readFully(dArray, 0, n);
        return dArray;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 != 0) {
            this.ensureNonEmpty();
            int n3 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public final void readFully(char[] cArray, int n, int n2) throws IOException {
        new CharsReader(cArray).readFully(null, n, n2);
    }

    public final void readFully(short[] sArray, int n, int n2) throws IOException {
        new ShortsReader(sArray).readFully(null, n, n2);
    }

    public final void readFully(int[] nArray, int n, int n2) throws IOException {
        new IntsReader(nArray).readFully(null, n, n2);
    }

    public final void readFully(long[] lArray, int n, int n2) throws IOException {
        new LongsReader(lArray).readFully(null, n, n2);
    }

    public final void readFully(float[] fArray, int n, int n2) throws IOException {
        new FloatsReader(fArray).readFully(null, n, n2);
    }

    public final void readFully(double[] dArray, int n, int n2) throws IOException {
        new DoublesReader(dArray).readFully(null, n, n2);
    }

    public final String readString(int n, Charset charset) throws IOException {
        byte[] byArray;
        int n2;
        if (this.buffer.hasArray() && n <= this.buffer.capacity()) {
            this.ensureBufferContains(n);
            n2 = this.buffer.position();
            this.buffer.position(n2 + n);
            byArray = this.buffer.array();
            n2 += this.buffer.arrayOffset();
        } else {
            byArray = this.readBytes(n);
            n2 = 0;
        }
        while (n > 0 && byArray[n2 + (n - 1)] == 0) {
            --n;
        }
        return new String(byArray, n2, n, charset);
    }

    @Override
    public final void seek(long l) throws IOException {
        long l2 = Math.subtractExact(l, this.bufferOffset);
        if (l2 >= 0L && l2 <= (long)this.buffer.limit()) {
            this.buffer.position((int)l2);
        } else if ((l2 < 0L || l2 - (long)this.buffer.limit() >= 8L) && this.channel instanceof SeekableByteChannel) {
            ((SeekableByteChannel)this.channel).position(Math.addExact(this.channelOffset, l));
            this.bufferOffset = l;
            this.buffer.clear().limit(0);
        } else if (l2 >= 0L) {
            do {
                this.bufferOffset += (long)this.buffer.limit();
                l2 -= (long)this.buffer.limit();
                this.buffer.clear();
                int n = this.channel.read(this.buffer);
                if (n <= 0) {
                    if (n != 0) {
                        throw new EOFException(this.eof());
                    }
                    this.onEmptyTransfer();
                }
                this.buffer.flip();
            } while (l2 > (long)this.buffer.limit());
            this.buffer.position((int)l2);
        } else {
            throw new InvalidSeekException(Resources.format((short)13, this.filename));
        }
        this.clearBitOffset();
    }

    public final boolean rewind() throws IOException {
        if (this.channel instanceof SeekableByteChannel) {
            ((SeekableByteChannel)this.channel).position(this.channelOffset);
            this.buffer.clear().limit(0);
            this.bufferOffset = 0L;
            this.clearBitOffset();
            return true;
        }
        return false;
    }

    final class CharsReader
    extends ArrayReader {
        private CharBuffer view;
        private char[] dest;

        CharsReader(CharBuffer charBuffer) {
            this.view = charBuffer;
        }

        CharsReader(char[] cArray) {
            this.dest = cArray;
        }

        @Override
        public int dataSizeShift() {
            return 1;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return CharBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asCharBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new char[n];
        }

        @Override
        void transfer(int n, int n2) {
            this.view.get(this.dest, n, n2);
        }

        @Override
        public void setDest(Object object) {
            this.dest = (char[])object;
        }
    }

    final class ShortsReader
    extends ArrayReader {
        private ShortBuffer view;
        private short[] dest;

        ShortsReader(ShortBuffer shortBuffer) {
            this.view = shortBuffer;
        }

        ShortsReader(short[] sArray) {
            this.dest = sArray;
        }

        @Override
        public int dataSizeShift() {
            return 1;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return ShortBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asShortBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new short[n];
        }

        @Override
        void transfer(int n, int n2) {
            this.view.get(this.dest, n, n2);
        }

        @Override
        public void setDest(Object object) {
            this.dest = (short[])object;
        }
    }

    final class IntsReader
    extends ArrayReader {
        private IntBuffer view;
        private int[] dest;

        IntsReader(IntBuffer intBuffer) {
            this.view = intBuffer;
        }

        IntsReader(int[] nArray) {
            this.dest = nArray;
        }

        @Override
        public int dataSizeShift() {
            return 2;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return IntBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asIntBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new int[n];
        }

        @Override
        void transfer(int n, int n2) {
            this.view.get(this.dest, n, n2);
        }

        @Override
        public void setDest(Object object) {
            this.dest = (int[])object;
        }
    }

    final class LongsReader
    extends ArrayReader {
        private LongBuffer view;
        private long[] dest;

        LongsReader(LongBuffer longBuffer) {
            this.view = longBuffer;
        }

        LongsReader(long[] lArray) {
            this.dest = lArray;
        }

        @Override
        public int dataSizeShift() {
            return 3;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return LongBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asLongBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new long[n];
        }

        @Override
        void transfer(int n, int n2) {
            this.view.get(this.dest, n, n2);
        }

        @Override
        public void setDest(Object object) {
            this.dest = (long[])object;
        }
    }

    final class FloatsReader
    extends ArrayReader {
        private FloatBuffer view;
        private float[] dest;

        FloatsReader(FloatBuffer floatBuffer) {
            this.view = floatBuffer;
        }

        FloatsReader(float[] fArray) {
            this.dest = fArray;
        }

        @Override
        public int dataSizeShift() {
            return 2;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return FloatBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asFloatBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new float[n];
        }

        @Override
        void transfer(int n, int n2) {
            this.view.get(this.dest, n, n2);
        }

        @Override
        public void setDest(Object object) {
            this.dest = (float[])object;
        }
    }

    final class DoublesReader
    extends ArrayReader {
        private DoubleBuffer view;
        private double[] dest;

        DoublesReader(DoubleBuffer doubleBuffer) {
            this.view = doubleBuffer;
        }

        DoublesReader(double[] dArray) {
            this.dest = dArray;
        }

        @Override
        public int dataSizeShift() {
            return 3;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return DoubleBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asDoubleBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new double[n];
        }

        @Override
        void transfer(int n, int n2) {
            this.view.get(this.dest, n, n2);
        }

        @Override
        public void setDest(Object object) {
            this.dest = (double[])object;
        }
    }

    final class BytesReader
    extends ArrayReader {
        private byte[] dest;

        BytesReader(byte[] byArray) {
            this.dest = byArray;
        }

        @Override
        public int dataSizeShift() {
            return 0;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return ByteBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return ChannelDataInput.this.buffer;
        }

        @Override
        public Buffer createView() {
            return ChannelDataInput.this.buffer;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new byte[n];
        }

        @Override
        void transfer(int n, int n2) {
            ChannelDataInput.this.buffer.get(this.dest, n, n2);
        }

        @Override
        public void setDest(Object object) {
            this.dest = (byte[])object;
        }

        @Override
        public void readFully(Buffer buffer, int n, int n2) throws IOException {
            ChannelDataInput.this.readFully(this.dest, n, n2);
        }
    }

    abstract class ArrayReader
    implements DataTransfer {
        ArrayReader() {
        }

        @Override
        public final String filename() {
            return ChannelDataInput.this.filename;
        }

        abstract void transfer(int var1, int var2);

        private void skipInBuffer(int n) {
            ChannelDataInput.this.buffer.position(ChannelDataInput.this.buffer.position() + n);
        }

        @Override
        public final void seek(long l) throws IOException {
            ChannelDataInput.this.seek(l);
        }

        @Override
        public void readFully(Buffer buffer, int n, int n2) throws IOException {
            int n3 = this.dataSizeShift();
            ChannelDataInput.this.ensureBufferContains(Math.min(n2 << n3, ChannelDataInput.this.buffer.capacity()));
            if (buffer == null) {
                buffer = this.createView();
            } else {
                if ((ChannelDataInput.this.buffer.position() & (1 << n3) - 1) != 0) {
                    ChannelDataInput.this.bufferOffset += (long)ChannelDataInput.this.buffer.position();
                    ChannelDataInput.this.buffer.compact().flip();
                }
                buffer.limit(ChannelDataInput.this.buffer.limit() >> n3).position(ChannelDataInput.this.buffer.position() >> n3);
            }
            int n4 = Math.min(buffer.remaining(), n2);
            this.transfer(n, n4);
            this.skipInBuffer(n4 << n3);
            while ((n2 -= n4) != 0) {
                ChannelDataInput.this.ensureBufferContains(1 << n3);
                buffer.rewind().limit(ChannelDataInput.this.buffer.remaining() >> n3);
                n4 = Math.min(buffer.remaining(), n2);
                this.transfer(n += n4, n4);
                this.skipInBuffer(n4 << n3);
            }
        }
    }
}

