\name{GeodesicActiveContourLevelSetImageFilter}
\alias{GeodesicActiveContourLevelSetImageFilter}
\title{GeodesicActiveContourLevelSetImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Segments structures in images based on a user supplied edge potential
map.
GeodesicActiveContourLevelSetImageFilter}
\details{
IMPORTANT
The SegmentationLevelSetImageFilter class and the GeodesicActiveContourLevelSetFunction class contain additional information necessary to gain full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. An initial
contour is propagated outwards (or inwards) until it ''sticks'' to the
shape boundaries. This is done by using a level set speed function
based on a user supplied edge potential map.
INPUTS
This filter requires two inputs. The first input is a initial level
set. The initial level set is a real image which contains the initial
contour/surface as the zero level set. For example, a signed distance
function from the initial contour/surface is typically used. Unlike
the simpler ShapeDetectionLevelSetImageFilter the initial contour does not have to lie wholly within the shape to
be segmented. The initial contour is allow to overlap the shape
boundary. The extra advection term in the update equation behaves like
a doublet and attracts the contour to the boundary. This approach for
segmentation follows that of Caselles et al (1997).
The second input is the feature image. For this filter, this is the
edge potential map. General characteristics of an edge potential map
is that it has values close to zero in regions near the edges and
values close to one inside the shape itself. Typically, the edge
potential map is compute from the image gradient, for example:
 \deqn{ g(I) = 1 / ( 1 + | (\nabla * G)(I)| ) } \deqn{ g(I) = \exp^{-|(\nabla * G)(I)|} }
where \eqn{ I } is image intensity and \eqn{ (\nabla * G) } is the derivative of Gaussian operator.
See SegmentationLevelSetImageFilter and SparseFieldLevelSetImageFilter for more information on Inputs.
PARAMETERS
The PropagationScaling parameter can be used to switch from
propagation outwards (POSITIVE scaling parameter) versus propagating
inwards (NEGATIVE scaling parameter).
 This implementation allows the user to set the weights between the
propagation, advection and curvature term using methods SetPropagationScaling() , SetAdvectionScaling() , SetCurvatureScaling() . In general, the larger the CurvatureScaling, the smoother the
resulting contour. To follow the implementation in Caselles et al
paper, set the PropagationScaling to \eqn{ c } (the inflation or balloon force) and AdvectionScaling and
CurvatureScaling both to 1.0.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Negative
values in the output image represent the inside of the segmented
region and positive values in the image represent the outside of the
segmented region. The zero crossings of the image correspond to the
position of the propagating front.
See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
REFERENCES
"Geodesic Active Contours", V. Caselles, R. Kimmel and G. Sapiro.
International Journal on Computer Vision, Vol 22, No. 1, pp 61-97,
1997
See:
SegmentationLevelSetImageFilter
GeodesicActiveContourLevelSetFunction
SparseFieldLevelSetImageFilter
GeodesicActiveContourLevelSet for the procedural interface
itk::GeodesicActiveContourLevelSetImageFilter for the Doxygen on the original ITK class.
GeodesicActiveContourLevelSetImageFilter}
%C++ includes: sitkGeodesicActiveContourLevelSetImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &initialImage, const Image &featureImage):}{}
\item{Image Execute(Image &&initialImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{ GeodesicActiveContourLevelSetImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{double GetAdvectionScaling() const:}{}
\item{double GetCurvatureScaling() const:}{}
\item{uint32_t GetElapsedIterations() const:}{
Number of iterations run.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMaximumRMSError() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetPropagationScaling() const:}{}
\item{bool GetReverseExpansionDirection() const:}{}
\item{double GetRMSChange() const:}{
The Root Mean Square of the levelset upon termination.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self ReverseExpansionDirectionOff():}{}
\item{Self ReverseExpansionDirectionOn():}{
Set the value of ReverseExpansionDirection to true or false
respectfully.
}
\item{Self SetAdvectionScaling(double AdvectionScaling):}{}
\item{Self SetCurvatureScaling(double CurvatureScaling):}{}
\item{Self SetMaximumRMSError(double MaximumRMSError):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetPropagationScaling(double PropagationScaling):}{}
\item{Self SetReverseExpansionDirection(bool ReverseExpansionDirection):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GeodesicActiveContourLevelSetImageFilter():}{
Destructor
}
}
}
