/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.AbstractTriStatePredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.KeyNameCriterion;
import org.slf4j.Logger;

public class EvaluableKeyNameCredentialCriterion
extends AbstractTriStatePredicate<Credential>
implements EvaluableCredentialCriterion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyNameCredentialCriterion.class);
    @Nonnull
    private final String keyName;

    public EvaluableKeyNameCredentialCriterion(@Nonnull KeyNameCriterion criteria) {
        this.keyName = Constraint.isNotNull(criteria, "Criterion instance cannot be null").getKeyName();
    }

    public EvaluableKeyNameCredentialCriterion(@Nonnull String newKeyName) {
        String trimmed = StringSupport.trimOrNull(newKeyName);
        this.keyName = Constraint.isNotNull(trimmed, "Key name cannot be null or empty");
    }

    @Override
    public boolean test(@Nullable Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return this.isNullInputSatisfies();
        }
        if (target.getKeyNames().isEmpty()) {
            this.log.info("Could not evaluate criteria, credential contained no key names");
            return this.isUnevaluableSatisfies();
        }
        return target.getKeyNames().contains(this.keyName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvaluableKeyNameCredentialCriterion [keyName=");
        builder.append(this.keyName);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.keyName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EvaluableKeyNameCredentialCriterion) {
            EvaluableKeyNameCredentialCriterion other = (EvaluableKeyNameCredentialCriterion)obj;
            return this.keyName.equals(other.keyName);
        }
        return false;
    }
}

