/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.index;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetails;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetailsSearchResults;
import org.opensearch.reportsscheduler.settings.PluginSettings;
import org.opensearch.reportsscheduler.util.HelpersKt;
import org.opensearch.reportsscheduler.util.SecureIndexClient;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u000bJ,\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u0016\u0010$\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000bR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/opensearch/reportsscheduler/index/ReportDefinitionsIndex;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "REPORT_DEFINITIONS_INDEX_NAME", "", "REPORT_DEFINITIONS_MAPPING_FILE_NAME", "REPORT_DEFINITIONS_SETTINGS_FILE_NAME", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "initialize", "", "createIndex", "isIndexExists", "", "createReportDefinition", "reportDefinitionDetails", "Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;", "getReportDefinition", "id", "getAllReportDefinitions", "Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetailsSearchResults;", "tenant", "access", "", "from", "", "maxItems", "updateReportDefinition", "deleteReportDefinition", "opensearch-reports-scheduler"})
public final class ReportDefinitionsIndex {
    @NotNull
    public static final ReportDefinitionsIndex INSTANCE = new ReportDefinitionsIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ReportDefinitionsIndex.class);
    @NotNull
    public static final String REPORT_DEFINITIONS_INDEX_NAME = ".opendistro-reports-definitions";
    @NotNull
    private static final String REPORT_DEFINITIONS_MAPPING_FILE_NAME = "report-definitions-mapping.yml";
    @NotNull
    private static final String REPORT_DEFINITIONS_SETTINGS_FILE_NAME = "report-definitions-settings.yml";
    private static Client client;
    private static ClusterService clusterService;

    private ReportDefinitionsIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ReportDefinitionsIndex.client = new SecureIndexClient(client);
        ReportDefinitionsIndex.clusterService = clusterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createIndex() {
        block16: {
            if (!this.isIndexExists()) {
                String string;
                Object object;
                String string2;
                Object object2;
                Object object3;
                ClassLoader classLoader = ReportDefinitionsIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(REPORT_DEFINITIONS_MAPPING_FILE_NAME);
                if (uRL != null) {
                    URL uRL2 = uRL;
                    object3 = Charsets.UTF_8;
                    object2 = TextStreamsKt.readBytes((URL)uRL2);
                    string2 = new String((byte[])object2, (Charset)object3);
                } else {
                    string2 = null;
                }
                Intrinsics.checkNotNull(string2);
                String indexMappingSource = string2;
                URL uRL3 = classLoader.getResource(REPORT_DEFINITIONS_SETTINGS_FILE_NAME);
                if (uRL3 != null) {
                    object3 = uRL3;
                    object2 = Charsets.UTF_8;
                    object = TextStreamsKt.readBytes((URL)object3);
                    string = new String((byte[])object, (Charset)object2);
                } else {
                    string = null;
                }
                Intrinsics.checkNotNull(string);
                String indexSettingsSource = string;
                CreateIndexRequest request = new CreateIndexRequest(REPORT_DEFINITIONS_INDEX_NAME).mapping(indexMappingSource, XContentType.YAML).settings(indexSettingsSource, XContentType.YAML);
                try {
                    Client client = ReportDefinitionsIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    object3 = (AutoCloseable)client.threadPool().getThreadContext().stashContext();
                    object2 = null;
                    try {
                        ActionFuture actionFuture;
                        CreateIndexResponse response;
                        ThreadContext.StoredContext it = (ThreadContext.StoredContext)object3;
                        boolean bl = false;
                        Client client2 = ReportDefinitionsIndex.client;
                        if (client2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            client2 = null;
                        }
                        if (!(response = (CreateIndexResponse)(actionFuture = client2.admin().indices().create(request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                            Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
                            throw new IllegalStateException("reports:Index .opendistro-reports-definitions creation not Acknowledged".toString());
                        }
                        INSTANCE.getLog().info("reports:Index .opendistro-reports-definitions creation Acknowledged");
                        object = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object3, (Throwable)object2);
                    }
                }
                catch (ResourceAlreadyExistsException exception) {
                    this.getLog().warn("message: " + exception.getMessage());
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof ResourceAlreadyExistsException) break block16;
                    Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
                    throw exception;
                }
            }
        }
    }

    private final boolean isIndexExists() {
        ClusterService clusterService = ReportDefinitionsIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        ClusterState clusterState = clusterService.state();
        return clusterState.getRoutingTable().hasIndex(REPORT_DEFINITIONS_INDEX_NAME);
    }

    @Nullable
    public final String createReportDefinition(@NotNull ReportDefinitionDetails reportDefinitionDetails) {
        String string;
        ActionFuture actionFuture;
        IndexResponse response;
        Intrinsics.checkNotNullParameter((Object)reportDefinitionDetails, (String)"reportDefinitionDetails");
        this.createIndex();
        IndexRequest indexRequest = new IndexRequest(REPORT_DEFINITIONS_INDEX_NAME).source(ReportDefinitionDetails.toXContent$default(reportDefinitionDetails, null, 1, null)).create(true);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (IndexResponse)(actionFuture = client.index(indexRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.CREATED) {
            Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:createReportDefinition - response:" + response);
            string = null;
        } else {
            string = response.getId();
        }
        return string;
    }

    @Nullable
    public final ReportDefinitionDetails getReportDefinition(@NotNull String id) {
        ReportDefinitionDetails reportDefinitionDetails;
        ActionFuture actionFuture;
        GetResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        GetRequest getRequest = new GetRequest(REPORT_DEFINITIONS_INDEX_NAME).id(id);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (GetResponse)(actionFuture = client.get(getRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getSourceAsString() == null) {
            this.getLog().warn("reports:getReportDefinition - " + id + " not found; response:" + response);
            reportDefinitionDetails = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            Intrinsics.checkNotNull((Object)parser);
            reportDefinitionDetails = ReportDefinitionDetails.Companion.parse(parser, id);
        }
        return reportDefinitionDetails;
    }

    @NotNull
    public final ReportDefinitionDetailsSearchResults getAllReportDefinitions(@NotNull String tenant, @NotNull List<String> access, int from, int maxItems) {
        String[] query;
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.createIndex();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).sort("lastUpdatedTimeMs").size(maxItems).from(from);
        String[] stringArray = new String[]{tenant};
        TermsQueryBuilder tenantQuery = QueryBuilders.termsQuery((String)"tenant", (String[])stringArray);
        if (!((Collection)access).isEmpty()) {
            TermsQueryBuilder accessQuery = QueryBuilders.termsQuery((String)"access", (Collection)access);
            query = QueryBuilders.boolQuery();
            query.filter((QueryBuilder)tenantQuery);
            query.filter((QueryBuilder)accessQuery);
            v0 = sourceBuilder.query((QueryBuilder)query);
        } else {
            v0 = sourceBuilder.query((QueryBuilder)tenantQuery);
        }
        query = new String[]{REPORT_DEFINITIONS_INDEX_NAME};
        SearchRequest searchRequest = new SearchRequest().indices(query).source(sourceBuilder);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        long l = from;
        Intrinsics.checkNotNull((Object)response);
        ReportDefinitionDetailsSearchResults result = new ReportDefinitionDetailsSearchResults(l, response);
        this.getLog().info("reports:getAllReportDefinitions from:" + from + ", maxItems:" + maxItems + ", retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
        return result;
    }

    public final boolean updateReportDefinition(@NotNull String id, @NotNull ReportDefinitionDetails reportDefinitionDetails) {
        ActionFuture actionFuture;
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)reportDefinitionDetails, (String)"reportDefinitionDetails");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(REPORT_DEFINITIONS_INDEX_NAME)).id(id).doc(ReportDefinitionDetails.toXContent$default(reportDefinitionDetails, null, 1, null)).fetchSource(true);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (UpdateResponse)(actionFuture = client.update(updateRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.UPDATED) {
            Metrics.REPORT_DEFINITION_UPDATE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:updateReportDefinition failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean deleteReportDefinition(@NotNull String id) {
        ActionFuture actionFuture;
        DeleteResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(REPORT_DEFINITIONS_INDEX_NAME)).id(id);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (DeleteResponse)(actionFuture = client.delete(deleteRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.DELETED) {
            Metrics.REPORT_DEFINITION_DELETE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:deleteReportDefinition failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.DELETED;
    }
}

