function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { useState } from 'react';
import { OuiI18n } from '../i18n';
import { OuiPopover } from '../popover';
import { OuiButtonEmpty, OuiButtonGroup } from '../button';
export var startingStyles = {
  cellPadding: 'm',
  fontSize: 'm',
  border: 'all',
  stripes: false,
  rowHover: 'highlight',
  header: 'shade',
  footer: 'overline',
  stickyFooter: true
};
var densityStyles = {
  expanded: {
    fontSize: 'l',
    cellPadding: 'l'
  },
  normal: {
    fontSize: 'm',
    cellPadding: 'm'
  },
  compact: {
    fontSize: 's',
    cellPadding: 's'
  }
};
export var useDataGridStyleSelector = function useDataGridStyleSelector(initialStyles) {
  // track styles specified by the user at run time
  var _useState = useState({}),
    _useState2 = _slicedToArray(_useState, 2),
    userGridStyles = _useState2[0],
    setUserGridStyles = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isOpen = _useState4[0],
    setIsOpen = _useState4[1]; // These are the available options. They power the gridDensity hook and also the options in the render
  var densityOptions = ['expanded', 'normal', 'compact'];

  // Normal is the default density
  var _useState5 = useState(densityOptions[1]),
    _useState6 = _slicedToArray(_useState5, 2),
    gridDensity = _useState6[0],
    _setGridDensity = _useState6[1];
  var setGridDensity = function setGridDensity(density) {
    _setGridDensity(density);
    setUserGridStyles(densityStyles[density]);
  };

  // merge the developer-specified styles with any user overrides
  var gridStyles = _objectSpread(_objectSpread({}, initialStyles), userGridStyles);
  var styleSelector = /*#__PURE__*/React.createElement(OuiPopover, {
    "data-test-subj": "dataGridStyleSelectorPopover",
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    anchorPosition: "downCenter",
    panelPaddingSize: "s",
    panelClassName: "ouiDataGridColumnSelectorPopover",
    button: /*#__PURE__*/React.createElement(OuiButtonEmpty, {
      size: "xs",
      iconType: "tableDensityExpanded",
      className: "ouiDataGrid__controlBtn",
      color: "text",
      "data-test-subj": "dataGridStyleSelectorButton",
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      }
    }, /*#__PURE__*/React.createElement(OuiI18n, {
      token: "ouiStyleSelector.buttonText",
      default: "Density"
    }))
  }, /*#__PURE__*/React.createElement(OuiI18n, {
    tokens: ['ouiStyleSelector.buttonLegend', 'ouiStyleSelector.labelExpanded', 'ouiStyleSelector.labelNormal', 'ouiStyleSelector.labelCompact'],
    defaults: ['Select the display density for the data grid', 'Expanded density', 'Normal density', 'Compact density']
  }, function (_ref) {
    var _ref2 = _slicedToArray(_ref, 4),
      buttonLegend = _ref2[0],
      labelExpanded = _ref2[1],
      labelNormal = _ref2[2],
      labelCompact = _ref2[3];
    return /*#__PURE__*/React.createElement(OuiButtonGroup, {
      legend: buttonLegend,
      name: "density",
      className: "oui-displayInlineBlock",
      buttonSize: "compressed",
      options: [{
        id: densityOptions[0],
        label: labelExpanded,
        iconType: 'tableDensityExpanded'
      }, {
        id: densityOptions[1],
        label: labelNormal,
        iconType: 'tableDensityNormal'
      }, {
        id: densityOptions[2],
        label: labelCompact,
        iconType: 'tableDensityCompact'
      }],
      onChange: setGridDensity,
      idSelected: gridDensity,
      isIconOnly: true
    });
  }));
  return [styleSelector, gridStyles];
};