/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.rule.RulePersistenceService;
import org.opensearch.rule.autotagging.FeatureType;

public class RulePersistenceServiceRegistry {
    private final Map<String, RulePersistenceService> rulePersistenceServices = new ConcurrentHashMap<String, RulePersistenceService>();

    public void register(FeatureType featureType, RulePersistenceService rulePersistenceService) {
        if (this.rulePersistenceServices.put(featureType.getName(), rulePersistenceService) != null) {
            throw new IllegalArgumentException("Duplicate rule persistence service: " + featureType.getName());
        }
    }

    public RulePersistenceService getRulePersistenceService(FeatureType featureType) {
        if (!this.rulePersistenceServices.containsKey(featureType.getName())) {
            throw new IllegalArgumentException("Unknown feature type for persistence service: " + featureType.getName());
        }
        return this.rulePersistenceServices.get(featureType.getName());
    }
}

