/*
 *     Copyright (c) 2017, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 *
 */

#ifndef _DEF_PGI_ACCEL
#define _DEF_PGI_ACCEL

#ifndef _DEF_OPENACC
#include <openacc.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int acc_copyins(void);
extern void acc_set_device(acc_device_t devtype);
extern void acc_sync(acc_device_t devtype);
extern __PGI_ULLONG acc_get_memory();
extern __PGI_ULLONG acc_get_free_memory();
extern unsigned int acc_regions(void);
extern unsigned int acc_kernels(void);
extern unsigned int acc_allocs(void);
extern unsigned int acc_frees(void);
extern unsigned int acc_copyouts(void);
extern __PGI_ULLONG acc_bytesalloc(void);
extern __PGI_ULLONG acc_bytesin(void);
extern __PGI_ULLONG acc_bytesout(void);
extern int acc_active(acc_device_t);
extern __PGI_ULLONG acc_total_time(acc_device_t);
extern __PGI_ULLONG acc_exec_time(acc_device_t);
extern void acc_enable_time(acc_device_t);
extern void acc_disable_time(acc_device_t);
/* device name as a string */
extern void acc_get_device_name(char *, int, int);
extern void acc_get_current_device_name(char *, int);
/* clock rate in KHz */
extern int acc_get_device_clock(int);
extern int acc_get_current_device_clock(void);
/* number of processors */
extern int acc_get_device_processors(int);
extern int acc_get_current_device_processors(void);
/* major/minor version */
extern int acc_get_device_version_major(int);
extern int acc_get_current_device_version_major(void);
extern int acc_get_device_version_minor(int);
extern int acc_get_current_device_version_minor(void);
/* OpenACC vendor as a string */
extern void acc_get_vendor(char *, int);
/* set error handler routine */
typedef void (*error_routine)(char *);
extern void acc_set_error_routine(error_routine);
extern void acc_clear_freelists();
/* dump present table for current device and for all devices */
extern void acc_present_dump(void);
extern void acc_present_dump_all(void);
extern void acc_present_check_for_overlap(void);
#ifdef __cplusplus
}
#endif
#endif
