from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker, Session

from .config import Config, get_config, get_database_url


class SessionProvider:
    SessionLocal = None
    engine = None

    def set_up_database(self):
        config: Config = get_config()
        database_url: str = get_database_url()

        if config.database_provider == 'sqlite':
            self.engine = create_engine(database_url, connect_args={"check_same_thread": False}, pool_size=30, max_overflow=-1)
        elif config.database_provider == 'postgresql':
            self.engine = create_engine(database_url)
        else:
            raise ValueError(f"Unsupported database provider: {config.database_provider}")

        self.SessionLocal = sessionmaker(autocommit=False, autoflush=False, bind=self.engine)

    def close_database(self):
        if self.engine is not None:
            self.engine.dispose()

    def get_session(self) -> Session:
        if self.SessionLocal is None:
            raise RuntimeError("Database not set up")
        db: Session = self.SessionLocal()
        try:
            yield db
        finally:
            db.close()


session_provider = SessionProvider()
