/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RenameObjectResponse
extends BmcResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String eTag;
    private Date lastModified;
    private String versionId;

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getVersionId() {
        return this.versionId;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcClientRequestId", "opcRequestId", "eTag", "lastModified", "versionId"})
    private RenameObjectResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcClientRequestId, String opcRequestId, String eTag, Date lastModified, String versionId) {
        super(__httpStatusCode__, headers);
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.versionId = versionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",eTag=").append(String.valueOf(this.eTag));
        sb.append(",lastModified=").append(String.valueOf(this.lastModified));
        sb.append(",versionId=").append(String.valueOf(this.versionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenameObjectResponse)) {
            return false;
        }
        RenameObjectResponse other = (RenameObjectResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.eTag, other.eTag) && Objects.equals(this.lastModified, other.lastModified) && Objects.equals(this.versionId, other.versionId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.eTag == null ? 43 : this.eTag.hashCode());
        result = result * 59 + (this.lastModified == null ? 43 : this.lastModified.hashCode());
        result = result * 59 + (this.versionId == null ? 43 : this.versionId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<RenameObjectResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcClientRequestId;
        private String opcRequestId;
        private String eTag;
        private Date lastModified;
        private String versionId;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public Builder copy(RenameObjectResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.lastModified(o.getLastModified());
            this.versionId(o.getVersionId());
            return this;
        }

        public RenameObjectResponse build() {
            return new RenameObjectResponse(this.__httpStatusCode__, this.headers, this.opcClientRequestId, this.opcRequestId, this.eTag, this.lastModified, this.versionId);
        }
    }
}

