/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.serialization.jackson.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.oracle.bmc.http.client.InternalSdk;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalSdk
public class ExplicitlySetFilter
extends SimpleBeanPropertyFilter {
    public static final ExplicitlySetFilter INSTANCE = new ExplicitlySetFilter();
    private static final Logger LOG = LoggerFactory.getLogger(ExplicitlySetFilter.class);

    private ExplicitlySetFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        if (this.include(writer)) {
            Field field = ExplicitlySetFilter.getMatchingDeclaredField(pojo.getClass(), writer.getName());
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                Object fieldValue = field.get(pojo);
                if (fieldValue != null) {
                    writer.serializeAsField(pojo, jgen, provider);
                    return;
                }
                if (pojo instanceof ExplicitlySetBmcModel) {
                    if (!((ExplicitlySetBmcModel)pojo).wasPropertyExplicitlySet(writer.getName())) return;
                    writer.serializeAsField(pojo, jgen, provider);
                    return;
                }
                if (!this.hasExplicitlySetInAField(pojo, writer)) return;
                writer.serializeAsField(pojo, jgen, provider);
                return;
            }
            finally {
                field.setAccessible(accessible);
            }
        } else {
            if (jgen.canOmitFields()) return;
            writer.serializeAsOmittedField(pojo, jgen, provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private boolean hasExplicitlySetInAField(Object pojo, PropertyWriter writer) throws Exception {
        Field explicitField = pojo.getClass().getDeclaredField("explicitlySetFilter");
        boolean explicitAccessible = explicitField.isAccessible();
        try {
            explicitField.setAccessible(true);
            Set explicitlySet = (Set)explicitField.get(pojo);
            if (explicitlySet.contains(writer.getName())) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            explicitField.setAccessible(explicitAccessible);
        }
        return false;
    }

    private static Field getDeclaredField(Class<?> pojoClass, String fieldName) throws NoSuchFieldException {
        try {
            return pojoClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            Class<?> superclass = pojoClass.getSuperclass();
            if (superclass != null) {
                return ExplicitlySetFilter.getDeclaredField(superclass, fieldName);
            }
            throw nsfe;
        }
    }

    private static Field getMatchingDeclaredField(Class<?> pojoClass, String fieldName) throws NoSuchFieldException {
        try {
            return ExplicitlySetFilter.getDeclaredField(pojoClass, fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            LOG.debug("Exact field name match failed for {}", (Object)fieldName);
            String lowerCamelCased = ExplicitlySetFilter.lowerUnderscoreToLowerCamel(fieldName);
            try {
                return ExplicitlySetFilter.getDeclaredField(pojoClass, lowerCamelCased);
            }
            catch (NoSuchFieldException nsfe2) {
                LOG.debug("Exact field name match failed for %s, lower camel-case %s didn't work either", (Object)fieldName, (Object)lowerCamelCased);
                for (Field f : pojoClass.getDeclaredFields()) {
                    for (JsonProperty a : (JsonProperty[])f.getAnnotationsByType(JsonProperty.class)) {
                        if (!fieldName.equals(a.value())) continue;
                        return f;
                    }
                }
                throw nsfe2;
            }
        }
    }

    protected boolean include(BeanPropertyWriter writer) {
        return this.include((PropertyWriter)writer);
    }

    protected boolean include(PropertyWriter writer) {
        return !"__explicitlySet__".equals(writer.getName());
    }

    private static String lowerUnderscoreToLowerCamel(String s) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '_') continue;
            sb.deleteCharAt(i);
            sb.replace(i, i + 1, String.valueOf(Character.toUpperCase(sb.charAt(i))));
        }
        return sb.toString();
    }
}

