/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner.actions;

import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;
import org.openide.util.NbBundle;

public class RemoveGapsAction
extends AbstractGridAction {
    private String name = NbBundle.getMessage(RemoveGapsAction.class, (String)"RemoveGapsAction_Name");

    @Override
    public Object getValue(String key) {
        return key.equals("Name") ? this.name : null;
    }

    @Override
    public boolean isEnabled(DesignerContext context) {
        return context.getGridInfo().hasGaps();
    }

    @Override
    public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
        GridInfoProvider gridInfo = gridManager.getGridInfo();
        int[] originalColumnBounds = gridInfo.getColumnBounds();
        int[] originalRowBounds = gridInfo.getRowBounds();
        int columnCount = Math.max(originalColumnBounds.length / 2, 1);
        int rowCount = Math.max(originalRowBounds.length / 2, 1);
        GridUtils.removePaddingComponents(gridManager);
        gridManager.removeGaps();
        GridUtils.addPaddingComponents(gridManager, columnCount, rowCount);
        GridUtils.revalidateGrid(gridManager);
        int[] newColumnBounds = gridInfo.getColumnBounds();
        int[] newRowBounds = gridInfo.getRowBounds();
        int[] columnBounds = new int[originalColumnBounds.length];
        columnBounds[0] = newColumnBounds[0];
        for (int i = 1; i < newColumnBounds.length - 1; ++i) {
            int n = newColumnBounds[i];
            columnBounds[2 * i - 1] = n;
            columnBounds[2 * i] = n;
        }
        columnBounds[originalColumnBounds.length - 1] = newColumnBounds[newColumnBounds.length - 1];
        int[] rowBounds = new int[originalRowBounds.length];
        rowBounds[0] = newRowBounds[0];
        for (int j = 1; j < newRowBounds.length - 1; ++j) {
            int n = newRowBounds[j];
            rowBounds[2 * j - 1] = n;
            rowBounds[2 * j] = n;
        }
        rowBounds[originalRowBounds.length - 1] = newRowBounds[newRowBounds.length - 1];
        return new GridBoundsChange(originalColumnBounds, originalRowBounds, columnBounds, rowBounds);
    }
}

