/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateCrossConnectDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateCrossConnectRequest
extends BmcRequest<UpdateCrossConnectDetails> {
    private String crossConnectId;
    private UpdateCrossConnectDetails updateCrossConnectDetails;
    private String ifMatch;

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public UpdateCrossConnectDetails getUpdateCrossConnectDetails() {
        return this.updateCrossConnectDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateCrossConnectDetails getBody$() {
        return this.updateCrossConnectDetails;
    }

    public Builder toBuilder() {
        return new Builder().crossConnectId(this.crossConnectId).updateCrossConnectDetails(this.updateCrossConnectDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",crossConnectId=").append(String.valueOf(this.crossConnectId));
        sb.append(",updateCrossConnectDetails=").append(String.valueOf((Object)this.updateCrossConnectDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCrossConnectRequest)) {
            return false;
        }
        UpdateCrossConnectRequest other = (UpdateCrossConnectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.crossConnectId, other.crossConnectId) && Objects.equals((Object)this.updateCrossConnectDetails, (Object)other.updateCrossConnectDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.crossConnectId == null ? 43 : this.crossConnectId.hashCode());
        result = result * 59 + (this.updateCrossConnectDetails == null ? 43 : this.updateCrossConnectDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateCrossConnectRequest, UpdateCrossConnectDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String crossConnectId = null;
        private UpdateCrossConnectDetails updateCrossConnectDetails = null;
        private String ifMatch = null;

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            return this;
        }

        public Builder updateCrossConnectDetails(UpdateCrossConnectDetails updateCrossConnectDetails) {
            this.updateCrossConnectDetails = updateCrossConnectDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCrossConnectRequest o) {
            this.crossConnectId(o.getCrossConnectId());
            this.updateCrossConnectDetails(o.getUpdateCrossConnectDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCrossConnectRequest build() {
            UpdateCrossConnectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateCrossConnectDetails body) {
            this.updateCrossConnectDetails(body);
            return this;
        }

        public UpdateCrossConnectRequest buildWithoutInvocationCallback() {
            UpdateCrossConnectRequest request = new UpdateCrossConnectRequest();
            request.crossConnectId = this.crossConnectId;
            request.updateCrossConnectDetails = this.updateCrossConnectDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

