/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListRemotePeeringConnectionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String drgId;
    private Integer limit;
    private String page;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDrgId() {
        return this.drgId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).drgId(this.drgId).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",drgId=").append(String.valueOf(this.drgId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRemotePeeringConnectionsRequest)) {
            return false;
        }
        ListRemotePeeringConnectionsRequest other = (ListRemotePeeringConnectionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.drgId, other.drgId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.drgId == null ? 43 : this.drgId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRemotePeeringConnectionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String drgId = null;
        private Integer limit = null;
        private String page = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRemotePeeringConnectionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.drgId(o.getDrgId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRemotePeeringConnectionsRequest build() {
            ListRemotePeeringConnectionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListRemotePeeringConnectionsRequest buildWithoutInvocationCallback() {
            ListRemotePeeringConnectionsRequest request = new ListRemotePeeringConnectionsRequest();
            request.compartmentId = this.compartmentId;
            request.drgId = this.drgId;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }
}

