/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceSourceImageFilterDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTagsFilter")
    private final Map<String, Map<String, Object>> definedTagsFilter;
    @JsonProperty(value="operatingSystem")
    private final String operatingSystem;
    @JsonProperty(value="operatingSystemVersion")
    private final String operatingSystemVersion;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTagsFilter", "operatingSystem", "operatingSystemVersion"})
    public InstanceSourceImageFilterDetails(String compartmentId, Map<String, Map<String, Object>> definedTagsFilter, String operatingSystem, String operatingSystemVersion) {
        this.compartmentId = compartmentId;
        this.definedTagsFilter = definedTagsFilter;
        this.operatingSystem = operatingSystem;
        this.operatingSystemVersion = operatingSystemVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTagsFilter() {
        return this.definedTagsFilter;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceSourceImageFilterDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTagsFilter=").append(String.valueOf(this.definedTagsFilter));
        sb.append(", operatingSystem=").append(String.valueOf(this.operatingSystem));
        sb.append(", operatingSystemVersion=").append(String.valueOf(this.operatingSystemVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceSourceImageFilterDetails)) {
            return false;
        }
        InstanceSourceImageFilterDetails other = (InstanceSourceImageFilterDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTagsFilter, other.definedTagsFilter) && Objects.equals(this.operatingSystem, other.operatingSystem) && Objects.equals(this.operatingSystemVersion, other.operatingSystemVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTagsFilter == null ? 43 : this.definedTagsFilter.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.operatingSystemVersion == null ? 43 : this.operatingSystemVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTagsFilter")
        private Map<String, Map<String, Object>> definedTagsFilter;
        @JsonProperty(value="operatingSystem")
        private String operatingSystem;
        @JsonProperty(value="operatingSystemVersion")
        private String operatingSystemVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTagsFilter(Map<String, Map<String, Object>> definedTagsFilter) {
            this.definedTagsFilter = definedTagsFilter;
            this.__explicitlySet__.add("definedTagsFilter");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            this.__explicitlySet__.add("operatingSystemVersion");
            return this;
        }

        public InstanceSourceImageFilterDetails build() {
            InstanceSourceImageFilterDetails model = new InstanceSourceImageFilterDetails(this.compartmentId, this.definedTagsFilter, this.operatingSystem, this.operatingSystemVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceSourceImageFilterDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTagsFilter")) {
                this.definedTagsFilter(model.getDefinedTagsFilter());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("operatingSystemVersion")) {
                this.operatingSystemVersion(model.getOperatingSystemVersion());
            }
            return this;
        }
    }
}

