/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.templates;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.Parameters;

public final class FileBuilder {
    public static final String ATTR_TEMPLATE_HANDLER = "template.createTemplateHandler";
    public static final String ATTR_TEMPLATE_MERGE_FOLDERS = "template.mergeFolders";
    public static final String ATTR_TEMPLATE_OPEN_FILE = "template.openFile";
    private final CreateDescriptor descriptor;
    Mode defaultMode;
    Format format;

    @NonNull
    public static FileBuilder fromDescriptor(@NonNull CreateDescriptor desc) {
        Parameters.notNull((CharSequence)"desc", (Object)desc);
        return new FileBuilder(desc.getTemplate(), desc.getTarget()).name(desc.getProposedName()).useLocale(desc.getLocale()).withParameters(desc.getParameters());
    }

    public FileBuilder(@NonNull FileObject template, @NonNull FileObject target) {
        this.descriptor = new CreateDescriptor(template, target);
    }

    public FileBuilder useLookup(Lookup contextLookup) {
        this.descriptor.setLookup(contextLookup);
        return this;
    }

    public FileBuilder useLocale(@NonNull Locale l) {
        this.descriptor.locale = l;
        return this;
    }

    public FileBuilder name(String n) {
        this.descriptor.name = n;
        return this;
    }

    public FileBuilder withParameters(@NullAllowed Map<String, ?> params) {
        if (this.descriptor.parameters != null) {
            this.descriptor.parameters.putAll(params);
        } else {
            HashMap hashMap = this.descriptor.parameters = params == null ? null : new HashMap(params);
        }
        if (params != null) {
            boolean val;
            Object v = params.get("freeFileExtension");
            if (v instanceof Boolean) {
                this.descriptor.freeExtension = val = Boolean.TRUE.equals(v);
            }
            if ((v = params.get("org-netbeans-modules-java-preformattedSource")) instanceof Boolean) {
                this.descriptor.preformatted = val = Boolean.TRUE.equals(v);
            }
        }
        return this;
    }

    public FileBuilder param(@NonNull String n, Object v) {
        if (this.descriptor.parameters == null) {
            this.descriptor.parameters = new HashMap<String, Object>();
        }
        this.descriptor.parameters.put(n, v);
        if (v instanceof Boolean) {
            boolean val;
            if ("freeFileExtension".equals(n)) {
                this.descriptor.freeExtension = val = Boolean.TRUE.equals(v);
            }
            if ("org-netbeans-modules-java-preformattedSource".equals(n)) {
                this.descriptor.preformatted = val = Boolean.TRUE.equals(v);
            }
        }
        return this;
    }

    public FileBuilder defaultMode(@NonNull Mode m) {
        this.defaultMode = m;
        return this;
    }

    public FileBuilder useFormat(@NonNull Format def) {
        this.format = def;
        return this.defaultMode(Mode.FORMAT);
    }

    @CheckForNull
    public List<FileObject> build() throws IOException {
        return CreateFromTemplateImpl.build(this);
    }

    CreateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NonNull
    public CreateDescriptor createDescriptor(boolean collectAttributes) {
        if (collectAttributes) {
            CreateFromTemplateImpl.collectAttributes(this);
        }
        CreateFromTemplateImpl.computeEffectiveName(this.descriptor);
        return this.descriptor;
    }

    @CheckForNull
    public static FileObject createFromTemplate(@NonNull FileObject f, @NonNull FileObject folder, @NullAllowed String name, @NullAllowed Map<String, ?> attributes, Mode defaultMode) throws IOException {
        Format frm = null;
        switch (defaultMode.ordinal()) {
            case 0: {
                MapFormat mf = new MapFormat(new HashMap());
                mf.setExactMatch(false);
                mf.setLeftBrace("__");
                mf.setRightBrace("__");
                frm = mf;
                break;
            }
            case 1: {
                frm = new Format(){

                    @Override
                    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                        toAppendTo.append(obj);
                        return toAppendTo;
                    }

                    @Override
                    public Object parseObject(String source, ParsePosition pos) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        }
        FileBuilder fb = new FileBuilder(f, folder).name(name).withParameters(attributes).useFormat(frm).defaultMode(defaultMode);
        List<FileObject> fos = fb.build();
        if (fos == null || fos.isEmpty()) {
            return null;
        }
        return fos.iterator().next();
    }

    public static enum Mode {
        FORMAT,
        COPY,
        FAIL;

    }
}

